/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.GenericChatMsg;
import com.zarkonnen.airships.StrategicPlayerInfo;
import org.joda.time.DateTime;

public strictfp class StrategicChatMsg
implements GenericChatMsg {
    public final StrategicPlayerInfo pi;
    public final String msg;
    public final DateTime timestamp;

    public StrategicChatMsg(StrategicPlayerInfo pi, String msg, DateTime timestamp) {
        this.pi = pi;
        this.msg = msg;
        this.timestamp = timestamp;
    }

    @Override
    public String playerName() {
        if (this.pi.claimedEmpireIndex != -1 && this.pi.empireName != null && !this.pi.empireName.equals(this.pi.name)) {
            return AGame.makeFileSafe(this.pi.empireName) + " (" + AGame.makeFileSafe(this.pi.name) + ")";
        }
        return AGame.makeFileSafe(this.pi.name);
    }

    @Override
    public String msg() {
        return this.msg;
    }

    @Override
    public DateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public CoatOfArms arms() {
        return this.pi.claimedEmpireIndex == -1 ? CoatOfArms.spectatorArms() : this.pi.getArms();
    }

    public String toString() {
        return AGame.makeFileSafe(this.pi.empireName) + " (" + AGame.makeFileSafe(this.pi.name) + "): " + AGame.makeFileSafe(this.msg);
    }
}

