/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;

public strictfp class StrategicAI {
    public static final int NUM_TARGETS = 5;

    public static ArrayList<Airship> inBudget(ArrayList<Airship> ships, int minCost, int budget, int maintenanceBudget, boolean allowBonusConstructions) {
        ArrayList<Airship> av = new ArrayList<Airship>();
        for (Airship a : ships) {
            int cost;
            if (!allowBonusConstructions && a.isBonusConstruction || (cost = a.getCost()) < minCost || cost > budget || a.maintenanceCost() > maintenanceBudget) continue;
            av.add(a);
        }
        return av;
    }

    public static int mostExpensiveShip(ArrayList<Airship> ships) {
        int c = 0;
        for (int i = 0; i < ships.size(); ++i) {
            c = StrictMath.max(c, ships.get(i).getCost());
        }
        return c;
    }

    public static void attackFailed(Empire e, MapLocation loc, int attackerValue, int defenderValue) {
        if (loc == null) {
            AirshipGame.report("attackFailed with null loc");
            return;
        }
        double actualAggression = (double)defenderValue * 1.0 / (double)attackerValue;
        double newAggressiveness = 0.4 * StrictMath.min(StrategicAI.getAggressivenessFor(e, loc), actualAggression);
        e.locAggressiveness.put(loc, newAggressiveness);
    }

    public static void doScience(WorldMap m, Empire e) {
        if (e.research != null) {
            return;
        }
        e.research = StrategicAI.getScienceOption(e, e.constructionStrategy.techs);
    }

    public static Tech.Choice getScienceOption(Empire e, ArrayList<Tech.Choice> targetTechs) {
        ArrayList<Tech.Choice> targetTree = new ArrayList<Tech.Choice>();
        int ttsz = targetTechs.size();
        for (int tti = 0; tti < ttsz; ++tti) {
            if (e.techs.contains(targetTechs.get(tti))) continue;
            targetTree.clear();
            targetTree.add(targetTechs.get(tti));
            Tech.Choice target = null;
            for (int i = 0; i < targetTree.size(); ++i) {
                Tech.Choice c = (Tech.Choice)targetTree.get(i);
                if (!e.techs.contains(c) && c.tech.available(e) && (target == null || target.tech.tier > c.tech.tier)) {
                    target = c;
                }
                int dsz = c.tech.dependencies.size();
                for (int di = 0; di < dsz; ++di) {
                    Tech dep = c.tech.dependencies.get(di);
                    int csz = dep.choices.size();
                    boolean containsAnyChoice = false;
                    for (int ci = 0; ci < csz; ++ci) {
                        Tech.Choice dc = dep.choices.get(ci);
                        if (!e.techs.contains(dc)) continue;
                        containsAnyChoice = true;
                    }
                    if (containsAnyChoice) continue;
                    targetTree.add(dep.choices.get(0));
                }
            }
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private static void updateDesigns(Empire e) {
        boolean updateExpensiveness = false;
        BonusSet bonuses = e.bonuses();
        if (e.aiAvailableBuildingsBonuses == null || !e.aiAvailableBuildingsBonuses.equals(bonuses)) {
            e.aiAvailableBuildingsBonuses = bonuses;
            e.aiAvailableBuildings = e.constructionStrategy.getBestAvailableDesignTier(ShipType.BUILDING, bonuses);
            updateExpensiveness = true;
        }
        if (e.aiAvailableShipsBonuses == null || !e.aiAvailableShipsBonuses.equals(bonuses)) {
            e.aiAvailableShipsBonuses = bonuses;
            e.aiAvailableShips = e.constructionStrategy.getBestAvailableDesignTier(ShipType.AIRSHIP, bonuses);
            updateExpensiveness = true;
        }
        if (e.aiAvailableLandships == null || !e.aiAvailableLandshipsBonuses.equals(bonuses)) {
            e.aiAvailableLandshipsBonuses = bonuses;
            e.aiAvailableLandships = e.constructionStrategy.getBestAvailableDesignTier(ShipType.LANDSHIP, bonuses);
            updateExpensiveness = true;
        }
        if (updateExpensiveness) {
            e.aiMostExpensiveConstructionCost = StrictMath.max(StrategicAI.mostExpensiveShip(e.aiAvailableBuildings), StrictMath.max(StrategicAI.mostExpensiveShip(e.aiAvailableShips), StrategicAI.mostExpensiveShip(e.aiAvailableLandships)));
        }
    }

    public static void tick(CampaignWorld w, WorldMap m, Empire e, int smartMs) {
        int nonConstructionIncomeBalance;
        for (Map.Entry<MapLocation, Double> entry : e.locAggressiveness.entrySet()) {
            entry.setValue(e.aggressiveness + (entry.getValue() - e.aggressiveness) * 0.99995);
        }
        e.messages.clear();
        e.smartAccum += smartMs;
        boolean smart = false;
        while (e.smartAccum >= 16) {
            e.smartAccum -= 16;
            smart = true;
        }
        if (!smart) {
            int fsz = e.getFleets().size();
            for (int fi = 0; fi < fsz; ++fi) {
                Fleet f = e.getFleets().get(fi);
                if (!StrategicAI.simpleTick(w, m, e, f)) continue;
                e.getFleets().remove(fi);
                --fi;
                --fsz;
                f.broadcastDestroyed(m);
            }
            return;
        }
        StrategicAI.updateDesigns(e);
        StrategicAI.doScience(m, e);
        m.calcRoadDistancesToEnemy(e);
        ArrayList<MapLocation> targets = StrategicAI.targets(w, m, e);
        ArrayList<City> allCities = new ArrayList<City>(m.cities());
        Collections.shuffle(allCities, m.r);
        for (City c : allCities) {
            Spy s;
            if (e.cities.contains(c)) continue;
            if (targets.contains(c)) {
                s = e.getSpyFor(c);
                if (s != null) continue;
                e.spies.add(new Spy(c));
                continue;
            }
            s = e.getSpyFor(c);
            if (s == null) continue;
            e.spies.remove(s);
        }
        ArrayList<City> myCities = new ArrayList<City>(e.cities);
        Collections.sort(myCities, new CitySorter());
        int perCityDefenceMaintenanceBudget = nonConstructionIncomeBalance = e.nonConstructionIncomeBalance(m);
        int numCities = 0;
        boolean hasUndefendedCities = false;
        for (City c : myCities) {
            hasUndefendedCities |= c.getDefences().isEmpty() && c.constructing.isEmpty();
            if (c.isTown) {
                if (c.getDefences().isEmpty()) continue;
                perCityDefenceMaintenanceBudget -= c.getDefences().get(0).maintenanceCost();
                continue;
            }
            ++numCities;
        }
        perCityDefenceMaintenanceBudget /= numCities * 2 + 1;
        int costBase = 500;
        for (Fleet f : e.getFleets()) {
            for (Airship s : f.actives) {
                costBase += s.getCost();
            }
            for (Airship s : f.reserve) {
                costBase += s.getCost();
            }
        }
        for (City c2 : e.cities) {
            for (Airship b : c2.getDefences()) {
                costBase += b.getCost() / 2;
            }
        }
        costBase = StrictMath.min(costBase / 2, e.aiMostExpensiveConstructionCost + 100);
        int incomeBalance = e.incomeBalance(m);
        for (City c : myCities) {
            StrategicAI.tick(w, m, e, c, hasUndefendedCities, costBase, incomeBalance, perCityDefenceMaintenanceBudget);
        }
        int fsz = e.getFleets().size();
        if (e.money == 0 && incomeBalance <= 0) {
            Fleet f;
            int fi;
            boolean scrapped = false;
            for (fi = 0; fi < fsz; ++fi) {
                f = e.getFleets().get(fi);
                if (f.location == null || !(f.location instanceof City) || !e.cities.contains(f.location)) continue;
                Airship toScrap = null;
                for (Airship s : f.actives) {
                    if (toScrap != null && s.getCost() >= toScrap.getCost()) continue;
                    toScrap = s;
                }
                for (Airship s : f.reserve) {
                    if (toScrap != null && s.getCost() >= toScrap.getCost()) continue;
                    toScrap = s;
                }
                if (toScrap == null) continue;
                f.actives.remove(toScrap);
                f.reserve.remove(toScrap);
                e.money += toScrap.getCost() / 8;
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    e.getFleets().remove(fi);
                    f.broadcastDestroyed(m);
                }
                scrapped = true;
                break;
            }
            if (!scrapped) {
                for (fi = 0; fi < fsz; ++fi) {
                    f = e.getFleets().get(fi);
                    Airship toScuttle = null;
                    for (Airship s : f.actives) {
                        if (toScuttle != null && s.getCost() >= toScuttle.getCost()) continue;
                        toScuttle = s;
                    }
                    for (Airship s : f.reserve) {
                        if (toScuttle != null && s.getCost() >= toScuttle.getCost()) continue;
                        toScuttle = s;
                    }
                    if (toScuttle == null) continue;
                    f.actives.remove(toScuttle);
                    f.reserve.remove(toScuttle);
                    if (!f.actives.isEmpty() || !f.reserve.isEmpty()) break;
                    e.getFleets().remove(fi);
                    f.broadcastDestroyed(m);
                    break;
                }
            }
        }
        fsz = e.getFleets().size();
        for (int fi = 0; fi < fsz; ++fi) {
            Fleet f = e.getFleets().get(fi);
            if (!StrategicAI.tick(w, m, e, f, targets, costBase)) continue;
            e.getFleets().remove(fi);
            --fi;
            --fsz;
            f.broadcastDestroyed(m);
        }
        for (MapLocation loc : targets) {
            if (!(loc instanceof City)) continue;
            StrategicAI.espionage(w, m, e, (City)loc);
        }
    }

    static void espionage(CampaignWorld w, WorldMap m, Empire e, City target) {
        if (e.money == 0) {
            return;
        }
        if (m.owner((City)target).timeSinceSpiedUpon < 120000) {
            return;
        }
        Spy spy = e.getSpyFor(target);
        if (spy == null || spy.infiltrationTimeout > 0) {
            return;
        }
        if ((!target.isTown || m.owner((City)target).cities.size() > 10) && m.r.nextDouble() < 0.1 && target.alertAmount <= 0 && Spy.CitySpyAction.INCITE_REVOLT.available(spy, target, m) && Spy.CitySpyAction.INCITE_REVOLT.cost(spy, e, target, m) <= e.money && Spy.CitySpyAction.INCITE_REVOLT.successChance(spy, e, target, m) >= 30) {
            m.owner((City)target).timeSinceSpiedUpon = 0;
            StrategicAI.doSpyAction(Spy.CitySpyAction.INCITE_REVOLT, spy, w, m, e, target);
            return;
        }
        boolean invading = false;
        for (Fleet fl : e.getFleets()) {
            if (fl.destination != target) continue;
            invading = true;
            break;
        }
        if (invading || m.r.nextDouble() < 0.001) {
            for (Airship ship : target.getDefences()) {
                if (!(m.r.nextDouble() < 0.25) || !Spy.ShipSpyAction.DESTROY.available(ship, spy, target, m) || Spy.ShipSpyAction.DESTROY.cost(ship, spy, e, target, m) > e.money || Spy.ShipSpyAction.DESTROY.successChance(ship, spy, e, target, m) <= 30) continue;
                m.owner((City)target).timeSinceSpiedUpon = 0;
                StrategicAI.doSpyAction(Spy.ShipSpyAction.DESTROY, ship, spy, w, m, e, target);
                return;
            }
        }
        if (m.r.nextDouble() < 0.001 && target.alertAmount <= 0 && Spy.CitySpyAction.SABOTAGE_PRODUCTION.available(spy, target, m) && Spy.CitySpyAction.SABOTAGE_PRODUCTION.cost(spy, e, target, m) <= e.money && target.constructionProgress > 100) {
            m.owner((City)target).timeSinceSpiedUpon = 0;
            StrategicAI.doSpyAction(Spy.CitySpyAction.SABOTAGE_PRODUCTION, spy, w, m, e, target);
        }
    }

    static void doSpyAction(Spy.CitySpyAction a, Spy spy, CampaignWorld w, WorldMap m, Empire e, City target) {
        ++e.spyActionsDone;
        m.doCitySpyAction(a, e, target);
    }

    static void doSpyAction(Spy.ShipSpyAction a, Airship ship, Spy spy, CampaignWorld w, WorldMap m, Empire e, City target) {
        m.doShipSpyAction(a, e, target, ship);
    }

    static int numBonusConstructions(Empire e) {
        int plannedN = 0;
        int n = 0;
        for (int fi = 0; fi < e.getFleets().size(); ++fi) {
            int si;
            Fleet f = e.getFleets().get(fi);
            for (si = 0; si < f.actives.size(); ++si) {
                if (!f.actives.get((int)si).isBonusConstruction) continue;
                ++n;
            }
            for (si = 0; si < f.reserve.size(); ++si) {
                if (!f.reserve.get((int)si).isBonusConstruction) continue;
                ++n;
            }
        }
        for (int ci = 0; ci < e.cities.size(); ++ci) {
            City c = e.cities.get(ci);
            for (int di = 0; di < c.defences.size(); ++di) {
                if (!((Airship)c.defences.get((int)di)).isBonusConstruction) continue;
                ++n;
            }
            if (c.constructionTarget != null && c.constructionTarget.isBonusConstruction) {
                ++plannedN;
            }
            for (int i = 0; i < c.constructing.size(); ++i) {
                if (!((MapLocation.ConstructionEntry)c.constructing.get((int)i)).ship.isBonusConstruction) continue;
                ++n;
            }
        }
        if (plannedN > 0) {
            --plannedN;
        }
        return n + plannedN;
    }

    static void tick(CampaignWorld w, WorldMap m, Empire e, City c, boolean hasUndefendedCities, int costBase, int incomeBalance, int perCityDefenceMaintenanceBudget) {
        Airship newTarget;
        if (c.takeoverNeeded) {
            c.takeoverMethod = e.takeoverMethod;
            c.takeoverNeeded = false;
        }
        if (incomeBalance <= 0) {
            return;
        }
        int minCost = StrictMath.min(c.isTown ? 800 : 1600, costBase / (c.isTown ? 6 : 2));
        int maxCost = StrictMath.max(c.isTown ? 300 : 600, costBase / (c.isTown ? 3 : 1));
        if (c.constructing.isEmpty() && e.money > 0) {
            for (Airship toUpgrade : c.getDefences()) {
                if (!StrategicAI.canUpgrade(toUpgrade, e)) continue;
                StrategicAI.upgradeBuilding(toUpgrade, c, e, m);
                break;
            }
        }
        if (c.constructing.isEmpty() && e.money > 0) {
            for (Airship toRepair : c.getDefences()) {
                if (toRepair.getOriginalDesign() == null || toRepair.getOriginalDesign().modules.size() == toRepair.modules.size() || toRepair.getOriginalDesign().getRefitCostFrom(toRepair) > e.money) continue;
                StrategicAI.repairBuilding(toRepair, c, e, m);
                break;
            }
        }
        if (!(c.constructionTarget == null || c.constructionTargetOutOfCostGamut || c.constructionTargetCost <= maxCost && c.constructionTargetCost >= minCost)) {
            c.constructionTarget = null;
        }
        if (c.constructionTarget != null && !c.constructionTargetForcedToBeShip && c.constructionTarget.type != ShipType.BUILDING && c.getDefences().isEmpty()) {
            c.constructionTarget = null;
        }
        if (c.constructionTarget != null && c.constructionTarget.type == ShipType.LANDSHIP && c.roadDistanceToEnemy == 10000) {
            c.constructionTarget = null;
        }
        if (c.constructionTarget != null && (newTarget = StrategicAI.upgradeTarget(c.constructionTarget, e)) != null && (newTarget.type.mobile || StrategicAI.positionDefense(newTarget, c, e, m))) {
            c.constructionTarget = newTarget.clone();
        }
        if (c.isTown && !c.getDefences().isEmpty()) {
            c.constructionTarget = null;
        } else if (c.constructionTarget == null) {
            c.constructionTargetOutOfCostGamut = false;
            c.constructionTargetForcedToBeShip = false;
            Fleet gar = m.getGarrison(c);
            int availableDefencesMaintenanceBudget = perCityDefenceMaintenanceBudget;
            for (Airship s : c.defences) {
                availableDefencesMaintenanceBudget -= s.maintenanceCost();
            }
            boolean allowBonusConstructions = StrategicAI.numBonusConstructions(e) < w.map.difficulty.maxAIBonusConstructions;
            boolean doBuilding = c.defences.isEmpty() || c.defences.size() < 4 && w.map.r.nextInt(3) == 1 || c.isTown;
            boolean constructionTargetOutOfCostGamut = false;
            boolean constructionTargetForcedToBeShip = false;
            if (doBuilding) {
                ArrayList<Airship> bs = StrategicAI.inBudget(e.aiAvailableBuildings, minCost, maxCost, availableDefencesMaintenanceBudget, allowBonusConstructions);
                if (bs.isEmpty()) {
                    bs = StrategicAI.inBudget(e.aiAvailableBuildings, 0, 100000, availableDefencesMaintenanceBudget, allowBonusConstructions);
                    constructionTargetOutOfCostGamut = true;
                }
                if (!bs.isEmpty()) {
                    int attempt = 0;
                    while (attempt++ < 10) {
                        Collections.shuffle(bs, w.map.r);
                        Airship b = bs.get(0);
                        if (!StrategicAI.positionDefense(b, c, e, m)) continue;
                        c.constructionTarget = b.clone();
                        c.constructionTarget.constructionBonuses.clear();
                        c.constructionTarget.constructionBonuses.addAll(e.bonuses());
                        c.constructionTarget.currentBonuses.clear();
                        c.constructionTarget.currentBonuses.addAll(e.bonuses());
                        c.constructionTargetCost = b.getCost();
                        c.constructionTargetOutOfCostGamut = constructionTargetOutOfCostGamut;
                        break;
                    }
                    if (c.constructionTarget == null) {
                        doBuilding = false;
                        constructionTargetForcedToBeShip = true;
                    }
                } else {
                    doBuilding = false;
                    constructionTargetForcedToBeShip = true;
                }
            }
            if (!doBuilding) {
                boolean noLandships;
                boolean bl = noLandships = c.roadDistanceToEnemy == 10000;
                if (gar != null) {
                    for (Airship ship : gar.reserve) {
                        if (ship.type != ShipType.LANDSHIP) continue;
                        noLandships = true;
                        break;
                    }
                }
                ArrayList<Airship> as = StrategicAI.inBudget(e.aiAvailableShips, minCost, maxCost, 10000, allowBonusConstructions);
                if (!noLandships) {
                    as.addAll(StrategicAI.inBudget(e.aiAvailableLandships, minCost, maxCost, 10000, allowBonusConstructions));
                }
                if (as.isEmpty()) {
                    as = StrategicAI.inBudget(e.aiAvailableShips, 0, 100000, 10000, allowBonusConstructions);
                    constructionTargetOutOfCostGamut = true;
                    if (!noLandships) {
                        as.addAll(StrategicAI.inBudget(e.aiAvailableLandships, 0, 100000, 10000, allowBonusConstructions));
                    }
                }
                if (!as.isEmpty()) {
                    Collections.shuffle(as, w.map.r);
                    c.constructionTarget = as.get(0).clone();
                    c.constructionTarget.constructionBonuses.clear();
                    c.constructionTarget.constructionBonuses.addAll(e.bonuses());
                    c.constructionTarget.currentBonuses.clear();
                    c.constructionTarget.currentBonuses.addAll(e.bonuses());
                    c.constructionTarget.setFlipped(true, null);
                    c.constructionTarget.flipTo = true;
                    c.constructionTarget.initWheelsLegsAndTentacles(c.ground, c.floaters, c.shipList(m));
                    c.constructionTargetOutOfCostGamut = constructionTargetOutOfCostGamut;
                    c.constructionTargetForcedToBeShip = constructionTargetForcedToBeShip;
                    c.constructionTargetCost = c.constructionTarget.getCost();
                }
            }
        }
        if (c.constructionTarget != null && c.constructing.isEmpty() && c.constructionTargetCost <= e.money && (!hasUndefendedCities || c.getDefences().isEmpty())) {
            c.constructionTarget.networkID = e.getNextShipID();
            c.constructing.add(new MapLocation.ConstructionEntry(c.constructionTarget, c.constructionTarget.getCost(), c.constructionEntryIDCounter++));
            c.constructionTargetOutOfCostGamut = false;
            e.money -= c.constructionTarget.getCost();
            if (c.constructionTarget.type.mobile) {
                c.constructionTarget.setName(AGame.getAIShipName(m.lang, m.r));
            } else {
                c.constructionTarget.setName(AGame.getBuildingName(m.lang, m.r));
            }
            c.constructionTarget.updateOriginalDesign();
            c.constructionTarget.initWheelsLegsAndTentacles(c.ground, c.floaters, c.shipList(m));
            c.constructionTarget = null;
        }
    }

    static ArrayList<MapLocation> targets(CampaignWorld w, WorldMap m, Empire e) {
        ArrayList<MapLocation> l;
        if (e.aiTargets != null && e.cities.containsAll(e.citiesForAITargets) && e.citiesForAITargets.containsAll(e.cities)) {
            int tsz = e.aiTargets.size();
            boolean outdated = false;
            for (int ti = 0; ti < tsz; ++ti) {
                MapLocation t = e.aiTargets.get(ti);
                if (!(t instanceof MonsterNest) || ((MonsterNest)t).type != null) continue;
                outdated = true;
            }
            if (!outdated) {
                return StrategicAI.withoutMostDamaged(e.aiTargets);
            }
        }
        ArrayList<MapLocation> adj = new ArrayList<MapLocation>();
        ArrayList seaAdj = new ArrayList();
        ArrayList<MapLocation> nonAdj = new ArrayList<MapLocation>();
        for (City c : m.cities()) {
            if (e.cities.contains(c)) continue;
            l = nonAdj;
            for (City c2 : e.cities) {
                if (m.connected(c, c2)) {
                    l = seaAdj;
                }
                if (!m.connectedByLand(c, c2)) continue;
                l = adj;
                break;
            }
            l.add(c);
        }
        for (MonsterNest n : m.nests) {
            if (n.type == null) continue;
            l = nonAdj;
            for (City c2 : e.cities) {
                if (!m.connectedByLand(n, c2)) continue;
                l = adj;
            }
            l.add(n);
        }
        Collections.sort(adj, new DistCmp(e));
        Collections.sort(seaAdj, new DistCmp(e));
        Collections.sort(nonAdj, new DistCmp(e));
        for (MapLocation loc : seaAdj) {
            if (adj.size() >= 5) continue;
            adj.add(loc);
        }
        for (MapLocation loc : nonAdj) {
            if (adj.size() >= 5) continue;
            adj.add(loc);
        }
        e.aiTargets = adj;
        e.citiesForAITargets = new ArrayList<City>(e.cities);
        return StrategicAI.withoutMostDamaged(adj);
    }

    private static ArrayList<MapLocation> withoutMostDamaged(ArrayList<MapLocation> adj) {
        ArrayList<MapLocation> adj2 = new ArrayList<MapLocation>(adj);
        City mostDamaged = null;
        for (MapLocation loc : adj2) {
            if (!(loc instanceof City)) continue;
            City c = (City)loc;
            if (c.economicDamage <= 0 || mostDamaged != null && c.economicDamage <= mostDamaged.economicDamage) continue;
            mostDamaged = c;
        }
        adj2.remove(mostDamaged);
        return adj2;
    }

    static double getAggressivenessFor(Empire e, MapLocation loc) {
        return e.locAggressiveness.containsKey(loc) ? e.locAggressiveness.get(loc) : e.aggressiveness;
    }

    public static int getValue(Fleet f) {
        int v = 0;
        for (Airship s : f.actives) {
            v += s.getCost();
        }
        for (Airship s : f.reserve) {
            v += s.getCost();
        }
        return v;
    }

    public static int getValue(MapLocation loc, WorldMap m) {
        int defenceValue = 700;
        for (Airship b : loc.getDefences()) {
            defenceValue = (int)((double)defenceValue + (double)b.getCost() * 0.6);
        }
        Fleet df = m.getGarrison(loc);
        if (df != null) {
            for (Airship s : df.actives) {
                defenceValue += s.getCost();
            }
            for (Airship s : df.reserve) {
                defenceValue += s.getCost();
            }
        }
        return defenceValue;
    }

    static boolean simpleTick(CampaignWorld w, WorldMap m, Empire e, Fleet f) {
        if (f.fleeDestinationNeeded) {
            double bestDist = 0.0;
            City best = null;
            for (City c : e.cities) {
                if (!f.canTravelTo(c, m, e)) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best != null) {
                f.travelTo(best, m);
                f.fleeDestinationNeeded = false;
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean tick(CampaignWorld w, WorldMap m, Empire e, Fleet f, ArrayList<MapLocation> targets, int costBase) {
        if (f.fleeDestinationNeeded) {
            double bestDist = 0.0;
            City best = null;
            for (City c : e.cities) {
                if (!f.canTravelTo(c, m, e)) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best == null) return true;
            f.travelTo(best, m);
            f.fleeDestinationNeeded = false;
            return false;
        } else {
            if (f.location == null && f.destination != null && m.defender(f.destination) != e && (double)StrategicAI.getValue(f.destination, m) > (double)StrategicAI.getValue(f) * StrategicAI.getAggressivenessFor(e, f.destination) * 1.7) {
                double newAggressiveness = StrategicAI.getAggressivenessFor(e, f.destination) * 0.3;
                e.locAggressiveness.put(f.destination, newAggressiveness);
                City closest = null;
                double bestDistSq = 0.0;
                for (City myCity : e.cities) {
                    double dsq = ((double)myCity.x - f.realX()) * ((double)myCity.x - f.realX()) + ((double)myCity.y - f.realY()) * ((double)myCity.y - f.realY());
                    if (closest != null && !(dsq < bestDistSq)) continue;
                    bestDistSq = dsq;
                    closest = myCity;
                }
                f.travelTo(closest, m);
                return false;
            }
            if (f.location != null && w.map.defender(f.location) == e && f.location instanceof City && !((City)f.location).isTown) {
                if (f.location.constructing.isEmpty() && e.money > 0) {
                    for (Airship toUpgrade : new ArrayList<Airship>(f.actives)) {
                        if (!StrategicAI.canUpgrade(toUpgrade, e)) continue;
                        StrategicAI.upgrade(toUpgrade, f, (City)f.location, e);
                        break;
                    }
                }
                if (f.location.constructing.isEmpty() && e.money > 0) {
                    for (Airship toUpgrade : new ArrayList<Airship>(f.reserve)) {
                        if (!StrategicAI.canUpgrade(toUpgrade, e)) continue;
                        StrategicAI.upgrade(toUpgrade, f, (City)f.location, e);
                        break;
                    }
                }
                if (f.location.constructing.isEmpty() && e.money > 0) {
                    for (Airship toRepair : new ArrayList<Airship>(f.actives)) {
                        if (toRepair.getOriginalDesign() == null || toRepair.getOriginalDesign().modules.size() == toRepair.modules.size() || toRepair.getOriginalDesign().getRefitCostFrom(toRepair) > e.money) continue;
                        StrategicAI.repair(toRepair, f, (City)f.location, e);
                        break;
                    }
                }
                if (f.location.constructing.isEmpty() && e.money > 0) {
                    for (Airship toRepair : new ArrayList<Airship>(f.reserve)) {
                        if (toRepair.getOriginalDesign() == null || toRepair.getOriginalDesign().modules.size() == toRepair.modules.size() || toRepair.getOriginalDesign().getRefitCostFrom(toRepair) > e.money) continue;
                        StrategicAI.repair(toRepair, f, (City)f.location, e);
                        break;
                    }
                }
                for (Airship toScrap : new ArrayList<Airship>(f.actives)) {
                    if (toScrap.isArmedOrHasTroops() && toScrap.getCost() >= costBase / 16) continue;
                    f.actives.remove(toScrap);
                    e.money += toScrap.getCost() / 8;
                }
                for (Airship toScrap : new ArrayList<Airship>(f.reserve)) {
                    if (toScrap.isArmedOrHasTroops() && toScrap.getCost() >= costBase / 16) continue;
                    f.reserve.remove(toScrap);
                    e.money += toScrap.getCost() / 8;
                }
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    return true;
                }
            }
            boolean beingInvaded = false;
            if (f.location != null) {
                block8: for (Empire enemy : m.empires) {
                    if (enemy == e) continue;
                    for (Fleet fl : enemy.getFleets()) {
                        if (fl.destination != f.location) continue;
                        beingInvaded = true;
                        break block8;
                    }
                }
            }
            if (!beingInvaded) {
                for (City c : e.cities) {
                    if (!f.canTravelTo(c, m, e)) continue;
                    for (Empire e2 : m.empires) {
                        if (e2 == e) continue;
                        for (Fleet f2 : e2.getFleets()) {
                            if (f2.destination != c || StrategicAI.getValue(f2) < StrategicAI.getValue(c, m)) continue;
                            double f2RemainingProgress = f2.transitDistance() - f2.progress;
                            double f2RemainingTime = f2RemainingProgress / f2.speed();
                            double fDistance = f.distanceTo(c, m);
                            double fTravelTime = fDistance / f.speed();
                            if (f.destination != null && m.defender(f.destination) == e2 || !(fTravelTime < f2RemainingTime)) continue;
                            if (f.destination == c) return false;
                            f.travelTo(c, m);
                            return false;
                        }
                    }
                }
            }
            if (e.money == 0) {
                return false;
            }
            boolean beingReinforced = false;
            if (f.location != null) {
                for (Fleet f2 : e.getFleets()) {
                    if (f == f2 || f2.destination != f.location) continue;
                    beingReinforced = true;
                    break;
                }
            }
            if (!(beingReinforced || beingInvaded || f.location == null || f.location.getDefences().isEmpty() || f.location instanceof MonsterNest || e.warConsiderDelay > 0)) {
                int attackValue = StrategicAI.getValue(f);
                double bestDist = 0.0;
                MapLocation best = null;
                boolean bestIsPlayerControlledCity = false;
                for (MapLocation loc : targets) {
                    double ratio;
                    int waitTime;
                    boolean playerControlledCity;
                    Spy spy;
                    if (loc instanceof City && ((spy = e.getSpyFor((City)loc)) == null || spy.infiltrationTimeout > 0)) continue;
                    int defenceValue = StrategicAI.getValue(loc, m);
                    if (loc instanceof City && !loc.constructing.isEmpty()) {
                        defenceValue = (int)((double)defenceValue + (double)(loc.constructing.get((int)0).cost * loc.constructionProgress / (((City)loc).constructionTimeCost() + 1)) * (loc.constructing.get((int)0).ship.type == ShipType.BUILDING ? 0.6 : 1.0));
                    }
                    if ((double)defenceValue > (double)attackValue * StrategicAI.getAggressivenessFor(e, loc)) continue;
                    boolean bl = playerControlledCity = loc instanceof City && w.map.owner((City)((City)loc)).playerControlled;
                    if (w.isMultiplayer() && playerControlledCity && w.map.timeSinceAIAttackVsHuman < (waitTime = m.difficulty.playerAttackInterval + (int)((double)m.difficulty.playerAttackInterval / (ratio = (double)attackValue * 1.0 / (double)defenceValue)))) continue;
                    double d = ((double)loc.x - f.realX()) * ((double)loc.x - f.realX()) + ((double)loc.y - f.realY()) * ((double)loc.y - f.realY());
                    if (best != null && !(d < bestDist)) continue;
                    best = loc;
                    bestDist = d;
                    bestIsPlayerControlledCity = playerControlledCity;
                }
                if (best != null && f.canTravelTo(best, m, e)) {
                    if (bestIsPlayerControlledCity) {
                        w.map.timeSinceAIAttackVsHuman = 0;
                        System.out.println("invading player, attack " + attackValue + " vs " + StrategicAI.getValue(best, m) + " agg " + StrategicAI.getAggressivenessFor(e, best));
                    }
                    f.travelTo(best, m);
                    e.warConsiderDelay = m.difficulty.attackInterval / 4 + m.r.nextInt(m.difficulty.attackInterval * 3 / 4 + 1);
                    return false;
                }
                if (f.canFly()) {
                    Fleet mergeTarget = null;
                    int closest = 0;
                    for (Fleet cand : e.getFleets()) {
                        if (cand.actives.size() + cand.reserve.size() + f.actives.size() + f.reserve.size() > 16 || cand.location == null || cand == f) continue;
                        int dist = (f.location.x - cand.location.x) * (f.location.x - cand.location.x) + (f.location.y - cand.location.y) * (f.location.y - cand.location.y);
                        if (mergeTarget != null && dist >= closest) continue;
                        mergeTarget = cand;
                        closest = dist;
                    }
                    if (mergeTarget != null) {
                        f.travelTo(mergeTarget.location, m);
                        return false;
                    }
                } else {
                    int rsz = m.roads.size();
                    MapLocation travelTo = null;
                    int distanceToEnemy = 10000;
                    for (Fleet cand : e.getFleets()) {
                        if (cand.actives.size() + cand.reserve.size() + f.actives.size() + f.reserve.size() > 16 || cand.location == null || cand == f || !m.connectedByLand(cand.location, f.location) || cand.location.roadDistanceToEnemy > f.location.roadDistanceToEnemy || cand.location.roadDistanceToEnemy >= distanceToEnemy) continue;
                        travelTo = cand.location;
                        distanceToEnemy = cand.location.roadDistanceToEnemy;
                    }
                    if (travelTo == null) {
                        for (int ri = 0; ri < rsz; ++ri) {
                            Road r = m.roads.get(ri);
                            MapLocation farEnd = null;
                            if (r.src == f.location) {
                                farEnd = r.dst;
                            } else if (r.dst == f.location) {
                                farEnd = r.src;
                            }
                            if (farEnd == null || farEnd instanceof City && m.owner((City)farEnd) != e || farEnd instanceof MonsterNest && ((MonsterNest)farEnd).type != null || farEnd.roadDistanceToEnemy >= f.location.roadDistanceToEnemy || farEnd.roadDistanceToEnemy >= distanceToEnemy) continue;
                            travelTo = farEnd;
                            distanceToEnemy = farEnd.roadDistanceToEnemy;
                        }
                        if (travelTo != null) {
                            System.out.println("found another adjacent loc to travel to with roaddist " + distanceToEnemy + ": " + travelTo.getDisplayName());
                        }
                    } else {
                        System.out.println("found another adjacent fleet to travel to with roaddist " + distanceToEnemy + ": " + travelTo.getDisplayName());
                    }
                    if (travelTo != null) {
                        f.travelTo(travelTo, m);
                        return false;
                    }
                }
                ArrayList<Airship> airships = new ArrayList<Airship>();
                attackValue = 0;
                for (Airship ship : f.actives) {
                    if (ship.type != ShipType.AIRSHIP) continue;
                    airships.add(ship);
                    attackValue += ship.getCost();
                }
                for (Airship ship : f.reserve) {
                    if (ship.type != ShipType.AIRSHIP) continue;
                    airships.add(ship);
                    attackValue += ship.getCost();
                }
                if (attackValue == 0 || airships.size() == f.actives.size() + f.reserve.size()) {
                    return false;
                }
                bestDist = 0.0;
                best = null;
                for (MapLocation loc : targets) {
                    Spy spy;
                    if (loc instanceof City && ((spy = e.getSpyFor((City)loc)) == null || spy.infiltrationTimeout > 0)) continue;
                    int defenceValue = StrategicAI.getValue(loc, m);
                    if (!loc.constructing.isEmpty()) {
                        defenceValue = (int)((double)defenceValue + (double)loc.constructing.get((int)0).cost * (loc.constructing.get((int)0).ship.type == ShipType.BUILDING ? 0.6 : 1.0));
                    }
                    if ((double)defenceValue > (double)attackValue * StrategicAI.getAggressivenessFor(e, loc)) continue;
                    double d = ((double)loc.x - f.realX()) * ((double)loc.x - f.realX()) + ((double)loc.y - f.realY()) * ((double)loc.y - f.realY());
                    if (best != null && !(d < bestDist)) continue;
                    best = loc;
                    bestDist = d;
                }
                if (best != null) {
                    Fleet f2 = new Fleet(f, m);
                    e.getFleets().add(f2);
                    f.actives.removeAll(airships);
                    f.reserve.removeAll(airships);
                    f2.actives.retainAll(airships);
                    f2.reserve.retainAll(airships);
                    f2.travelTo(best, m);
                    return false;
                }
            }
            if (f.location == null || !(f.location instanceof MonsterNest)) return false;
            City best = null;
            double bestDist = 0.0;
            for (City c : e.cities) {
                if (!f.canFly() && !m.connected(f.location, c)) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best == null) return false;
            System.out.println("Going home post-monstering.");
            f.travelTo(best, m);
        }
        return false;
    }

    private static boolean canUpgrade(Airship s, Empire e) {
        return StrategicAI.upgradeTarget(s, e) != null;
    }

    private static Airship upgradeTarget(Airship s, Empire e) {
        if (s.designName == null) {
            return null;
        }
        StrategicAI.updateDesigns(e);
        ArrayList<ArrayList<String>> seqs = null;
        ArrayList<Airship> designs = null;
        switch (s.type) {
            case AIRSHIP: {
                seqs = e.constructionStrategy.shipUpgradeSequences;
                designs = e.aiAvailableShips;
                break;
            }
            case LANDSHIP: {
                seqs = e.constructionStrategy.landshipUpgradeSequences;
                designs = e.aiAvailableLandships;
                break;
            }
            case BUILDING: {
                seqs = e.constructionStrategy.buildingUpgradeSequences;
                designs = e.aiAvailableBuildings;
            }
        }
        if (seqs == null || designs == null) {
            return null;
        }
        for (ArrayList<String> seq : seqs) {
            int currentIndex = seq.indexOf(s.designName);
            if (currentIndex == -1) continue;
            for (Airship design : designs) {
                if (seq.indexOf(design.designName) <= currentIndex || design.getRefitCostFrom(s) < e.money) continue;
                return design;
            }
        }
        return null;
    }

    private static void upgrade(Airship toUpgrade, Fleet f, City c, Empire e) {
        Airship ship = StrategicAI.upgradeTarget(toUpgrade, e).clone();
        f.actives.remove(toUpgrade);
        f.reserve.remove(toUpgrade);
        int cost = ship.getRefitCostFrom(toUpgrade);
        e.money -= cost;
        ship.setName(toUpgrade.getName());
        ship.updateOriginalDesign();
        ship.networkID = toUpgrade.networkID;
        ship.constructionBonuses.clear();
        ship.constructionBonuses.addAll(e.bonuses());
        ship.currentBonuses.clear();
        ship.currentBonuses.addAll(e.bonuses());
        c.constructing.add(new MapLocation.ConstructionEntry(ship, toUpgrade, cost, MapLocation.ConstructionEntry.Type.REFIT, c.constructionEntryIDCounter++));
    }

    private static void repair(Airship toRepair, Fleet f, City c, Empire e) {
        f.actives.remove(toRepair);
        f.reserve.remove(toRepair);
        int cost = toRepair.getOriginalDesign().getRefitCostFrom(toRepair);
        e.money -= cost;
        Airship ship = toRepair.getOriginalDesign();
        ship.updateOriginalDesign();
        ship.networkID = toRepair.networkID;
        c.constructing.add(new MapLocation.ConstructionEntry(ship, toRepair, cost, MapLocation.ConstructionEntry.Type.REPAIR, c.constructionEntryIDCounter++));
    }

    public static void upgradeBuilding(Airship toUpgrade, City c, Empire e, WorldMap wm) {
        Airship building = StrategicAI.upgradeTarget(toUpgrade, e).clone();
        c.removeDefence(toUpgrade);
        if (!StrategicAI.positionDefense(building, c, e, wm)) {
            c.addDefence(toUpgrade);
            return;
        }
        int cost = building.getRefitCostFrom(toUpgrade);
        e.money -= cost;
        building.setName(toUpgrade.getName());
        building.updateOriginalDesign();
        building.networkID = toUpgrade.networkID;
        building.constructionBonuses.clear();
        building.constructionBonuses.addAll(e.bonuses());
        building.currentBonuses.clear();
        building.currentBonuses.addAll(e.bonuses());
        c.constructing.add(new MapLocation.ConstructionEntry(building, toUpgrade, cost, MapLocation.ConstructionEntry.Type.REFIT, c.constructionEntryIDCounter++));
    }

    public static void repairBuilding(Airship toRepair, City c, Empire e, WorldMap wm) {
        Airship building = toRepair.getOriginalDesign();
        c.removeDefence(toRepair);
        if (!StrategicAI.positionDefense(building, c, e, wm)) {
            c.addDefence(toRepair);
            return;
        }
        int cost = building.getRefitCostFrom(toRepair);
        e.money -= cost;
        building.updateOriginalDesign();
        building.networkID = toRepair.networkID;
        c.constructing.add(new MapLocation.ConstructionEntry(building, toRepair, cost, MapLocation.ConstructionEntry.Type.REPAIR, c.constructionEntryIDCounter++));
    }

    public static void setup(WorldMap m, Empire e, Random r, boolean guaranteeShip) {
        int cost = 0;
        for (City c : e.cities) {
            cost += StrategicAI.setup(m, e, c, r, guaranteeShip && !c.isTown, false);
        }
        e.money -= cost;
    }

    static int setup(WorldMap m, Empire e, City c, Random r, boolean guaranteeShip, boolean addMoreShips) {
        StrategicAI.updateDesigns(e);
        int numCities = 0;
        int numTowns = 0;
        for (City c2 : e.cities) {
            if (c2.isTown) {
                ++numTowns;
                continue;
            }
            ++numCities;
        }
        int budget = e.money / (numTowns + numCities * 5) * (c.isTown ? 1 : 5);
        int totalCost = 0;
        ArrayList<Airship> as = StrategicAI.inBudget(e.aiAvailableShips, 0, budget, 10000, false);
        if (guaranteeShip && !as.isEmpty()) {
            Airship def = null;
            while (def == null) {
                Collections.sort(as, new MostExpensiveCmp());
                Collections.shuffle(as.subList(0, StrictMath.min(as.size(), 2)), r);
                try {
                    def = as.get(0).clone();
                    def.repair();
                }
                catch (Exception ex) {
                    as.remove(def);
                    def = null;
                }
            }
            def.setFlipped(true, null);
            def.setName(Airship.getRandomName(ShipType.AIRSHIP, m.lang, m.r));
            def.networkID = e.getNextShipID();
            def.constructionBonuses.clear();
            def.constructionBonuses.addAll(e.bonuses());
            def.currentBonuses.clear();
            def.currentBonuses.addAll(e.bonuses());
            def.updateOriginalDesign();
            e.addShipAt(def, c, m);
            budget -= def.getCost();
            totalCost += def.getCost();
            def.initWheelsLegsAndTentacles(c.ground, c.floaters, c.shipList(m));
        }
        boolean buildingPlaced = false;
        for (int i = 0; i < 100; ++i) {
            Airship def;
            ArrayList<Airship> bs = StrategicAI.inBudget(e.aiAvailableBuildings, 0, budget, 10000, false);
            if (bs.isEmpty()) {
                if (buildingPlaced) break;
                bs.addAll(e.aiAvailableBuildings);
                if (bs.isEmpty()) break;
                Collections.sort(bs, new LeastExpensiveCmp());
            } else {
                Collections.sort(bs, new MostExpensiveCmp());
                Collections.shuffle(bs.subList(0, StrictMath.min(bs.size(), 2)), r);
            }
            try {
                def = bs.get(0).clone();
                def.repair();
            }
            catch (Exception ex) {
                continue;
            }
            def.setName(AGame.getBuildingName(m.lang, m.r));
            def.networkID = e.getNextShipID();
            def.constructionBonuses.clear();
            def.constructionBonuses.addAll(e.bonuses());
            def.currentBonuses.clear();
            def.currentBonuses.addAll(e.bonuses());
            def.updateOriginalDesign();
            if (!StrategicAI.positionDefense(def, c, e, m)) continue;
            c.addDefence(def);
            budget -= def.getCost();
            totalCost += def.getCost();
            buildingPlaced = true;
            if (!addMoreShips) continue;
            as = StrategicAI.inBudget(e.aiAvailableShips, 0, budget, 10000, false);
            if (as.isEmpty()) break;
            Collections.sort(as, new MostExpensiveCmp());
            Collections.shuffle(as.subList(0, StrictMath.min(as.size(), 2)), r);
            try {
                def = as.get(0).clone();
                def.constructionBonuses.clear();
                def.constructionBonuses.addAll(e.bonuses());
                def.currentBonuses.clear();
                def.currentBonuses.addAll(e.bonuses());
                def.repair();
            }
            catch (Exception ex) {
                continue;
            }
            def.setFlipped(true, null);
            def.setName(Airship.getRandomName(ShipType.AIRSHIP, m.lang, m.r));
            def.networkID = e.getNextShipID();
            def.constructionBonuses.clear();
            def.constructionBonuses.addAll(e.bonuses());
            def.currentBonuses.clear();
            def.currentBonuses.addAll(e.bonuses());
            def.updateOriginalDesign();
            e.addShipAt(def, c, m);
            def.initWheelsLegsAndTentacles(c.ground, c.floaters, c.shipList(m));
            budget -= def.getCost();
            totalCost += def.getCost();
        }
        return totalCost;
    }

    static boolean positionDefense(Airship building, City c, Empire e, WorldMap wm) {
        if (building.type != ShipType.BUILDING) {
            AirshipGame.instance.reportError("Nonbuilding defense positioning.", null, building.getName(), false, true);
            return false;
        }
        int endX = 112;
        for (int x = 2800 - building.getWidth() * 16 - 64; x >= endX; x -= 32) {
            int y = c.ground.getVerticalPosition(building, x, building.flipped, false);
            PlaceShipTool.Placement pl = PlaceShipTool.getPlacement(building, x, y, building.flipped, c.ground, new ShipArrayList(c.getDefences()), false, 1);
            if (!pl.succeeded || e.money < pl.landscapeCost || !c.canPlace(building, x, (int)pl.y, 32, wm.getGarrison(c), pl.landscapeTarget)) continue;
            if (pl.landscapeGY < 0) {
                AirshipGame.instance.reportError("Bad landscape gy = " + pl.landscapeGY, null, building.getName(), false, true);
                return false;
            }
            building.setX(x);
            building.setY(pl.y);
            e.money -= pl.landscapeCost;
            c.ground.doLandscapingForBuilding(building, pl.x, pl.landscapeGY, pl.flipped);
            return true;
        }
        return false;
    }

    private strictfp static class LeastExpensiveCmp
    implements Comparator<Airship> {
        private LeastExpensiveCmp() {
        }

        @Override
        public int compare(Airship o1, Airship o2) {
            return o1.getCost() - o2.getCost();
        }
    }

    private strictfp static class MostExpensiveCmp
    implements Comparator<Airship> {
        private MostExpensiveCmp() {
        }

        @Override
        public int compare(Airship o1, Airship o2) {
            return o2.getCost() - o1.getCost();
        }
    }

    strictfp static class DistCmp
    implements Comparator<MapLocation> {
        public final Empire e;

        public DistCmp(Empire e) {
            this.e = e;
        }

        public int distSq(MapLocation c) {
            City c2 = this.e.cities.get(0);
            return (c.x - c2.x) * (c.x - c2.x) + (c.y - c2.y) * (c.y - c2.y);
        }

        @Override
        public int compare(MapLocation o1, MapLocation o2) {
            return this.distSq(o1) - this.distSq(o2);
        }
    }

    private strictfp static class CitySorter
    implements Comparator<City> {
        private CitySorter() {
        }

        @Override
        public int compare(City t, City t1) {
            if (t.shipyardLevel == t1.shipyardLevel) {
                return t1.getDefences().size() - t1.getDefences().size();
            }
            return t1.shipyardLevel - t.shipyardLevel;
        }
    }
}

