/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DesignFromDefencesIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class StartDesignFromDefencesButton
extends UniScreen.Button {
    public ShipType type;

    public StartDesignFromDefencesButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        if (us.city != null && us.city.isTown && this.type != ShipType.BUILDING) {
            return false;
        }
        return us.intent instanceof DefencesIntent && !((DefencesIntent)us.intent).ss.w.isMultiplayer();
    }

    @Override
    public boolean enabled(UniScreen us) {
        return true;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Design_" + this.type.name(), new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        Airship editShip = new Airship(this.type, us.wm.lang, us.wm.r);
        editShip.constructionBonuses = us.wm.owner(us.city).bonuses();
        editShip.currentBonuses = us.wm.owner(us.city).bonuses();
        editShip.setX(100.0);
        if (!this.type.mobile) {
            us.city.addDefence(editShip);
        } else {
            Empire owner = us.wm.owner(us.city);
            boolean added = false;
            for (Fleet f : owner.getFleets()) {
                if (f.location != us.city) continue;
                f.actives.add(editShip);
                added = true;
                break;
            }
            if (!added) {
                Fleet f = new Fleet(us.city, us.wm);
                f.actives.add(editShip);
                owner.getFleets().add(f);
            }
        }
        us.intent = new DesignFromDefencesIntent((DefencesIntent)us.intent, editShip);
    }
}

