/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class SoundEffect {
    public final ArrayList<Layer> layers = new ArrayList();
    public final int loopFadeInMs;
    public final int loopFadeOutMs;
    public static final String[] IN_NAMES = new String[]{"distance", "xSpeed", "ySpeed", "onViewingSide", "relativeStrength"};
    public static final int IN_DISTANCE = 0;
    public static final int IN_XSPEED = 1;
    public static final int IN_YSPEED = 2;
    public static final int IN_ON_VIEWING_SIDE = 3;
    public static final int IN_RELATIVE_STRENGTH = 4;
    public static final int N_INS = IN_NAMES.length;

    public SoundEffect(JSONObject o) {
        this(o, false);
    }

    public SoundEffect(JSONObject o, boolean isLoop) {
        JSONArray layersA = o.getJSONArray("layers");
        for (int i = 0; i < layersA.length(); ++i) {
            this.layers.add(new Layer(layersA.getJSONObject(i), isLoop));
        }
        this.loopFadeInMs = o.optInt("loopFadeInMs", 200);
        this.loopFadeOutMs = o.optInt("loopFadeOutMs", 200);
    }

    public SoundEffect(String name, int nVariations, double volume) {
        this.layers.add(new Layer(name, nVariations, volume));
        this.loopFadeInMs = 200;
        this.loopFadeOutMs = 200;
    }

    public SoundEffect(String name, int nVariations) {
        this.layers.add(new Layer(name, nVariations, 1.0));
        this.loopFadeInMs = 200;
        this.loopFadeOutMs = 200;
    }

    public SoundEffect(String name, double volume) {
        this.layers.add(new Layer(name, volume));
        this.loopFadeInMs = 200;
        this.loopFadeOutMs = 200;
    }

    public SoundEffect(String name) {
        this.layers.add(new Layer(name));
        this.loopFadeInMs = 200;
        this.loopFadeOutMs = 200;
    }

    public void emit(ArrayList<Sound> l, double x, double y, double volume, double dist, double xSpeed, double ySpeed, boolean onViewingSide, double relativeStrength) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).emit(l, x, y, volume, dist, xSpeed, ySpeed, onViewingSide, relativeStrength);
        }
    }

    public static class FromJSON
    implements BonusableValue.FromJSON<SoundEffect> {
        public final boolean loop;

        public FromJSON(boolean loop) {
            this.loop = loop;
        }

        @Override
        public SoundEffect construct(JSONObject o, BonusSet b) {
            return new SoundEffect(o, this.loop);
        }
    }

    public static class Property {
        public final double min;
        public final double max;
        public final double[][] curve = new double[N_INS][0];

        public Property(JSONObject o, boolean isLoop) {
            if (o.has("value")) {
                this.min = o.getDouble("value");
                this.max = o.getDouble("value");
            } else if (isLoop) {
                this.max = this.min = o.optDouble("min", 1.0) * 0.5 + o.optDouble("max", 1.0) * 0.5;
            } else {
                this.min = o.optDouble("min", 1.0);
                this.max = o.optDouble("max", 1.0);
            }
            for (int i = 0; i < N_INS; ++i) {
                if (!o.has(IN_NAMES[i])) continue;
                JSONArray curveA = o.getJSONArray(IN_NAMES[i]);
                this.curve[i] = new double[curveA.length()];
                for (int j = 0; j < curveA.length(); ++j) {
                    this.curve[i][j] = curveA.getDouble(j);
                }
            }
        }

        public Property() {
            this.min = 1.0;
            this.max = 1.0;
        }

        public Property(double value) {
            this.min = value;
            this.max = value;
        }

        public double eval(double dist, double xSpeed, double ySpeed, boolean onViewingSide, double relativeStrength) {
            double value = this.min + AGame.ANIM_R.nextDouble() * (this.max - this.min);
            value *= this.doCurve(0, dist);
            value *= this.doCurve(1, xSpeed);
            value *= this.doCurve(2, ySpeed);
            value *= this.doCurve(3, onViewingSide ? 1.0 : 0.0);
            return value *= this.doCurve(4, relativeStrength);
        }

        public double doCurve(int i, double in) {
            double[] c = this.curve[i];
            if (c.length == 0) {
                return 1.0;
            }
            int inIsBelowThis = 0;
            while (inIsBelowThis * 2 < c.length && in > c[inIsBelowThis * 2]) {
                ++inIsBelowThis;
            }
            if (inIsBelowThis == 0) {
                return c[1];
            }
            if (inIsBelowThis * 2 >= c.length) {
                return c[c.length - 1];
            }
            double inIsBelowThisIn = c[inIsBelowThis * 2];
            double inIsBelowThisOut = c[inIsBelowThis * 2 + 1];
            int inIsAboveThis = inIsBelowThis - 1;
            double inIsAboveThisIn = c[inIsAboveThis * 2];
            double inIsAboveThisOut = c[inIsAboveThis * 2 + 1];
            return inIsAboveThisOut + (in - inIsAboveThisIn) * (inIsBelowThisOut - inIsAboveThisOut) / (inIsBelowThisIn - inIsAboveThisIn);
        }
    }

    public static class Layer {
        public final ArrayList<String> variations = new ArrayList();
        public transient String lastVariation;
        public final Property volume;
        public final Property pitch;

        public Layer(String name, int nVariations, double vol) {
            for (int i = 0; i < nVariations; ++i) {
                this.variations.add(name + i);
            }
            this.volume = new Property(vol);
            this.pitch = new Property();
        }

        public Layer(String name, double vol) {
            this.variations.add(name);
            this.volume = new Property(vol);
            this.pitch = new Property();
        }

        public Layer(String name) {
            this.variations.add(name);
            this.volume = new Property();
            this.pitch = new Property();
        }

        public Layer(JSONObject o, boolean isLoop) {
            JSONArray variationsA = o.getJSONArray("variations");
            for (int i = 0; i < variationsA.length(); ++i) {
                this.variations.add(variationsA.getString(i));
            }
            Property v = new Property();
            if (o.has("volume")) {
                try {
                    v = new Property(o.getDouble("volume"));
                }
                catch (Exception e) {
                    v = new Property(o.getJSONObject("volume"), isLoop);
                }
            }
            this.volume = v;
            Property p = new Property();
            if (o.has("pitch")) {
                try {
                    p = new Property(o.getDouble("pitch"));
                }
                catch (Exception e) {
                    p = new Property(o.getJSONObject("pitch"), isLoop);
                }
            }
            this.pitch = p;
        }

        public void emit(ArrayList<Sound> l, double x, double y, double vol, double dist, double xSpeed, double ySpeed, boolean onViewingSide, double relativeStrength) {
            double v = vol * this.volume.eval(dist, xSpeed, ySpeed, onViewingSide, relativeStrength);
            if (v <= 0.001) {
                return;
            }
            double p = this.pitch.eval(dist, xSpeed, ySpeed, onViewingSide, relativeStrength);
            String variation = null;
            if (this.variations.size() < 2) {
                variation = this.variations.get(0);
            } else {
                while (variation == null || variation.equals(this.lastVariation)) {
                    variation = this.variations.get(AGame.ANIM_R.nextInt(this.variations.size()));
                }
                this.lastVariation = variation;
            }
            l.add(new Sound(variation, v, p, x, y, dist, xSpeed, ySpeed, onViewingSide, relativeStrength));
        }
    }

    public static class Sound {
        public final String name;
        public final double volume;
        public final double pitch;
        public final double x;
        public final double y;
        public final double dist;
        public final double xSpeed;
        public final double ySpeed;
        public final double relativeStrength;
        public final boolean onViewingSide;

        public Sound(String name, double volume, double pitch, double x, double y, double dist, double xSpeed, double ySpeed, boolean onViewingSide, double relativeStrength) {
            this.name = name;
            this.volume = volume;
            this.pitch = pitch;
            this.x = x;
            this.y = y;
            this.dist = dist;
            this.xSpeed = xSpeed;
            this.ySpeed = ySpeed;
            this.onViewingSide = onViewingSide;
            this.relativeStrength = relativeStrength;
        }
    }
}

