/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.CombatSettingsIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class SingleCombatSettingsChooser
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (!(us.intent instanceof CombatSettingsIntent)) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        final CombatSettingsIntent csi = (CombatSettingsIntent)((Object)us.intent);
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + 16 + MyDraw.UI_SPACING;
        int w = Math.max(80, d.tw(Lang._t("Rapid_Commands", new Object[0])));
        for (AIQuality aiq : AIQuality.values()) {
            w = StrictMath.max(w, d.tw(aiq.getName()));
        }
        for (TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
            w = StrictMath.max(w, d.tw(tod.getName()));
        }
        int x = sm.width - w - MyDraw.SIDE_CLEARANCE;
        for (final AIQuality aiq : AIQuality.values()) {
            d.toggle(x, y, w, aiq.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    csi.setAIQuality(aiq);
                    if (us.intent instanceof EditMissionIntent) {
                        ((EditMissionIntent)us.intent).modified();
                    }
                }
            }, aiq == csi.getAIQuality(), true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
        for (final TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
            d.toggle(x, y, w, tod.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    us.setTimeOfDay(tod);
                    if (us.intent instanceof EditMissionIntent) {
                        ((EditMissionIntent)us.intent).modified();
                    }
                }
            }, tod == us.getTimeOfDay(), true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.toggle(x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING, w, Lang._t("Rapid_Commands", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                us.combat.instantCommandRegeneration = !us.combat.instantCommandRegeneration;
            }
        }, us.combat.instantCommandRegeneration, true);
        d.tooltip((double)x, (double)y, (double)w, (double)MyDraw.BUTTON_H, Lang._t("Rapid_Commands_tooltip", new Object[0]));
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

