/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class ShoutOverlay
implements UniScreen.InfoPanel {
    public static Img SHOUT_BUBBLE_LEFT = new Img("ui", 105, 890, 4, 14, false);
    public static Img SHOUT_BUBBLE_RIGHT = new Img("ui", 109, 890, 4, 14, false);
    public static Img SMALL_SHOUT_BUBBLE_LEFT = new Img("ui", 105, 890, 4, 14, false);
    public static Img SMALL_SHOUT_BUBBLE_RIGHT = new Img("ui", 109, 890, 4, 14, false);
    public static Img MEDIUM_SHOUT_BUBBLE_LEFT = new Img("ui", 105, 890, 4, 14, false);
    public static Img MEDIUM_SHOUT_BUBBLE_RIGHT = new Img("ui", 109, 890, 4, 14, false);
    public static Img LARGE_SHOUT_BUBBLE_LEFT = new Img("ui", 105, 890, 4, 14, false);
    public static Img LARGE_SHOUT_BUBBLE_RIGHT = new Img("ui", 109, 890, 4, 14, false);
    public static Clr SHOUT_BUBBLE_C = Clr.fromHex((String)"f5edb5");
    public static String SHOUT_TEXT_C = "[333333]";

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (us.hideUI || us.combat == null) {
            return;
        }
        int sidesz = us.combat.sides.size();
        for (int sidei = 0; sidei < sidesz; ++sidei) {
            Combat.Side side = us.combat.sides.get(sidei);
            if (side != us.mySide) continue;
            int ssz = side.ships.size();
            for (int si = 0; si < ssz; ++si) {
                Airship ship = side.ships.get(si);
                int csz = ship.crew.size();
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman cm = ship.crew.get(ci);
                    if (cm.shout == null || !cm.alive()) continue;
                    this.draw(d, sm, us, cm);
                }
                int bsz = ship.boarders.size();
                for (int bi = 0; bi < bsz; ++bi) {
                    Crewman cm = ship.boarders.get(bi);
                    if (cm.shout == null || !cm.alive()) continue;
                    this.draw(d, sm, us, cm);
                }
            }
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman cm = side.troops.get(ti);
                if (cm.shout == null || !cm.alive()) continue;
                this.draw(d, sm, us, cm);
            }
        }
    }

    private void draw(MyDraw d, ScreenMode sm, UniScreen us, Crewman cm) {
        cm.shoutX = (int)us.worldToScreenX(cm.shoutOriginX);
        cm.shoutY = (int)us.worldToScreenY((double)cm.shoutOriginY - (double)(1800 - cm.shoutMs) * 0.05);
        if (cm.shoutW < 0) {
            ++cm.shoutW;
            return;
        }
        if (cm.shoutW == 0) {
            cm.shoutW = (int)d.textSize((String)cm.shout, (Fount)AGame.FOUNT).x;
            cm.shoutH = ShoutOverlay.SHOUT_BUBBLE_LEFT.srcHeight;
        }
        int sidesz = us.combat.sides.size();
        for (int sidei = 0; sidei < sidesz; ++sidei) {
            Combat.Side side = us.combat.sides.get(sidei);
            int ssz = side.ships.size();
            for (int si = 0; si < ssz; ++si) {
                Airship ship = side.ships.get(si);
                int csz = ship.crew.size();
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman cm2 = ship.crew.get(ci);
                    if (cm == cm2 || cm2.shoutW <= 0 || !Rect2D.intersects(cm.shoutX, cm.shoutY, cm.shoutW, cm.shoutH, cm2.shoutX, cm2.shoutY, cm2.shoutW, cm2.shoutH)) continue;
                    cm.shoutW = -100;
                    return;
                }
                int bsz = ship.boarders.size();
                for (int bi = 0; bi < bsz; ++bi) {
                    Crewman cm2 = ship.boarders.get(bi);
                    if (cm == cm2 || cm2.shoutW <= 0 || !Rect2D.intersects(cm.shoutX, cm.shoutY, cm.shoutW, cm.shoutH, cm2.shoutX, cm2.shoutY, cm2.shoutW, cm2.shoutH)) continue;
                    cm.shoutW = -100;
                    return;
                }
            }
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman cm2 = side.troops.get(ti);
                if (cm == cm2 || cm2.shoutW <= 0 || !Rect2D.intersects(cm.shoutX, cm.shoutY, cm.shoutW, cm.shoutH, cm2.shoutX, cm2.shoutY, cm2.shoutW, cm2.shoutH)) continue;
                cm.shoutW = -100;
                return;
            }
        }
        d.blit(SHOUT_BUBBLE_LEFT, cm.shoutX - ShoutOverlay.SHOUT_BUBBLE_LEFT.srcWidth, cm.shoutY);
        d.blit(SHOUT_BUBBLE_RIGHT, cm.shoutX + cm.shoutW, cm.shoutY);
        d.rect(SHOUT_BUBBLE_C, cm.shoutX, cm.shoutY, cm.shoutW, cm.shoutH);
        d.text(SHOUT_TEXT_C + cm.shout, AGame.FOUNT, cm.shoutX, cm.shoutY + 1);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

