/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.Tentacle;
import com.zarkonnen.airships.Tether;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Img;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Shot {
    public static final int MIN_DMG = 1;
    public Airship target;
    public Crewman targetTroop;
    public double tX;
    public double tY;
    public double sX;
    public double sY;
    public int time;
    public int travelTime;
    public boolean internal;
    public boolean vsBoarders;
    public CrewType shooterType;
    public ModuleType weaponType;
    public BonusSet weaponBonuses = BonusSet.empty();
    public Tentacle tentacle;
    public Module weapon;
    public transient boolean done;

    public JSONObject toJSON(Combat c) {
        Combat.Side weaponSide;
        Combat.Side targetSide;
        JSONObject o = new JSONObject().put("tX", this.tX).put("tY", this.tY).put("sX", this.sX).put("sY", this.sY).put("time", this.time).put("travelTime", this.travelTime).put("internal", this.internal).put("vsBoarders", this.vsBoarders);
        if (this.target != null && (targetSide = c.sideOf(this.target)) != null) {
            o.put("targetSideIndex", c.sides.indexOf(targetSide));
            o.put("targetShipIndex", targetSide.ships.indexOf(this.target));
        }
        if (this.targetTroop != null) {
            for (int si = 0; si < c.sides.size(); ++si) {
                Combat.Side side = c.sides.get(si);
                int ti = side.troops.indexOf(this.targetTroop);
                if (ti == -1) continue;
                o.put("targetTroopSideIndex", si);
                o.put("targetTroopIndex", ti);
            }
        }
        if (this.weapon != null && (weaponSide = c.sideOf(this.weapon.ship)) != null) {
            o.put("weaponSideIndex", c.sides.indexOf(weaponSide));
            o.put("weaponShipIndex", weaponSide.ships.indexOf(this.weapon.ship));
            o.put("weaponIndex", this.weapon.ship.modules.indexOf(this.weapon));
        }
        if (this.weaponType != null) {
            o.put("weaponType", this.weaponType.name);
        }
        if (this.weaponBonuses != null) {
            JSONArray a = new JSONArray();
            o.put("weaponBonuses", a);
            for (Bonus b : this.weaponBonuses.list()) {
                a.put(b.name());
            }
        }
        if (this.shooterType != null) {
            o.put("shooterType", this.shooterType.name);
        }
        return o;
    }

    public Shot(JSONObject o, Combat c) {
        this.tX = o.getDouble("tX");
        this.tY = o.getDouble("tY");
        this.sX = o.getDouble("sX");
        this.sY = o.getDouble("sY");
        this.time = o.getInt("time");
        this.travelTime = o.getInt("travelTime");
        this.internal = o.getBoolean("internal");
        this.vsBoarders = o.getBoolean("vsBoarders");
        if (o.has("targetSideIndex")) {
            this.target = c.sides.get((int)o.getInt((String)"targetSideIndex")).ships.get(o.getInt("targetShipIndex"));
        }
        if (o.has("targetTroopIndex")) {
            this.targetTroop = c.sides.get((int)o.getInt((String)"targetTroopSideIndex")).troops.get(o.getInt("targetTroopIndex"));
        }
        if (o.has("weaponType")) {
            this.weaponType = ModuleType.ofName(o.getString("weaponType"));
        }
        if (o.has("weaponSideIndex")) {
            this.weapon = c.sides.get((int)o.getInt((String)"weaponSideIndex")).ships.get((int)o.getInt((String)"weaponShipIndex")).modules.get(o.getInt("weaponIndex"));
        }
        if (o.has("weaponBonuses")) {
            this.weaponBonuses = new BonusSet();
            JSONArray a = o.getJSONArray("weaponBonuses");
            for (int i = 0; i < a.length(); ++i) {
                this.weaponBonuses.add(Bonus.ofName(a.getString(i)));
            }
        }
        if (o.has("shooterType")) {
            this.shooterType = CrewType.ofName(o.getString("shooterType"));
        }
    }

    public Shot(Airship target, double tX, double tY, Airship source, Tentacle tentacle) {
        this.target = target;
        this.tX = tX;
        this.tY = tY;
        this.tentacle = tentacle;
        this.sX = tentacle.segments.get((int)0).centerX;
        this.sY = tentacle.segments.get((int)0).centerY;
        this.travelTime = 1;
    }

    public Shot(Airship target, double tX, double tY, Airship source, double sX, double sY, Module weapon, double shotSpeedMult) {
        this.target = target;
        this.tX = tX;
        this.tY = tY;
        this.weaponBonuses = source.currentBonuses;
        this.sX = sX;
        this.sY = sY;
        this.weapon = weapon;
        this.weaponType = weapon.type;
        double dist = StrictMath.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / weapon.type.getShotSpeed(source.currentBonuses) / shotSpeedMult);
    }

    public Shot(Airship target, double tX, double tY, CrewType shooterType, double sX, double sY, boolean internal, boolean vsBoarders) {
        this.target = target;
        this.tX = tX;
        this.tY = tY;
        this.shooterType = shooterType;
        this.sX = sX;
        this.sY = sY;
        this.internal = internal;
        this.vsBoarders = vsBoarders;
        double dist = StrictMath.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / shooterType.shotSpeed);
    }

    public Shot(Crewman targetTroop, double tX, double tY, CrewType shooterType, double sX, double sY) {
        this.targetTroop = targetTroop;
        this.tX = tX;
        this.tY = tY;
        this.shooterType = shooterType;
        this.sX = sX;
        this.sY = sY;
        double dist = StrictMath.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / shooterType.shotSpeed);
    }

    public Shot(Crewman targetTroop, double tX, double tY, Airship source, double sX, double sY, Module weapon, double shotSpeedMult) {
        this.targetTroop = targetTroop;
        this.tX = tX;
        this.tY = tY;
        this.weaponBonuses = source.currentBonuses;
        this.sX = sX;
        this.sY = sY;
        this.weapon = weapon;
        this.weaponType = weapon.type;
        double dist = StrictMath.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / weapon.type.getShotSpeed(source.currentBonuses) / shotSpeedMult);
    }

    public boolean tick(int ms, Combat c, boolean onViewingSide) {
        WeaponAppearance wapp;
        if (this.target != null && c.sideOf(this.target) == null) {
            this.done = true;
            return true;
        }
        Particle.Emitter em = null;
        WeaponAppearance weaponAppearance = wapp = this.weaponType == null ? null : this.weaponType.weaponAppearance(this.weaponBonuses);
        if (wapp != null) {
            em = wapp.shotEmitter;
        }
        if (this.shooterType != null) {
            em = this.shooterType.shotEmitter;
        }
        if (em != null && AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms) {
            double px = this.sX + (this.tX - this.sX) * (double)this.time / (double)this.travelTime;
            double py = this.sY + (this.tY - this.sY) * (double)this.time / (double)this.travelTime;
            double xSpeed = (this.tX - this.sX) / (double)this.travelTime;
            double ySpeed = (this.tY - this.sY) / (double)this.travelTime;
            for (int i = 0; i < em.numParticles; ++i) {
                c.particles.add(new Particle(em.t, px, py));
            }
            if (em.soundEffect != null) {
                c.play(em.soundEffect, px, py, xSpeed, ySpeed, onViewingSide);
            }
        }
        WeaponAppearance.ShotExhaustEmitter ex = null;
        if (wapp != null) {
            ex = wapp.exhaust;
        }
        if (this.shooterType != null) {
            ex = this.shooterType.exhaust;
        }
        if (ex != null) {
            ex.emit(this, ms, c.particles);
        }
        this.time += ms;
        if (this.time >= this.travelTime) {
            Tile hitTile = this.target == null ? null : this.target.hit(this, c, !onViewingSide);
            Combat.Side immuneCrewSide = null;
            if (this.target != null) {
                immuneCrewSide = c.otherSide(c.sideOf(this.target));
            }
            if (this.getBlastSplashRadius() > 0) {
                c.doSplashDmg(this.tX, this.tY, this.getBlastDmg(), this.getBlastSplashRadius(), this, null, immuneCrewSide);
            }
            Crewman hitCrewman = this.targetTroop == null ? null : this.targetTroop.hit(this, c, !onViewingSide);
            double explosionSize = 0.0;
            int nonExplodeParticles = 0;
            int dmg = this.getBlastDmg() + this.getPenDmg() + this.getDirectDmg();
            if ((hitTile != null || hitCrewman != null) && this.getBlastDmg() > 0) {
                nonExplodeParticles = dmg / 3 + 3;
            }
            int explodeX = (int)this.tX;
            int explodeY = (int)this.tY;
            if (this.weaponType != null) {
                explosionSize = wapp.missExplosionSize;
                if (hitTile != null) {
                    Tile srcTile;
                    c.boringTicks = 0;
                    if (this.weapon != null && c.sideOf(this.weapon.ship) != null && (srcTile = this.weapon.ship.tileAt(this.weapon.x, this.weapon.y)) != null && this.weapon.type.getTetherSpec(this.weaponBonuses) != null) {
                        double sAngle = StrictMath.atan2(this.tY - this.sY, this.tX - this.sX);
                        Img[] imgs = wapp.shot;
                        Img img = imgs == null ? null : imgs[this.time / wapp.shotAnimationInterval % imgs.length];
                        this.weapon.tether = new Tether(this.weapon.type.getTetherSpec(this.weaponBonuses), srcTile, hitTile, img, sAngle);
                    }
                    explosionSize = wapp.hitExplosionSize;
                }
                if ((hitTile != null || hitCrewman != null) && this.weaponType.getHitSound(this.weaponBonuses) != null) {
                    double xSpeed = (this.tX - this.sX) / (double)this.travelTime;
                    double ySpeed = (this.tY - this.sY) / (double)this.travelTime;
                    c.play(this.weaponType.getHitSound(this.weaponBonuses), this.tX, this.tY, xSpeed, ySpeed, onViewingSide);
                }
            } else if (this.shooterType != null) {
                double d = explosionSize = hitTile == null ? this.shooterType.missExplosionSize : this.shooterType.hitExplosionSize;
            }
            if (explosionSize != 0.0) {
                int i;
                int n = (int)(12.0 * explosionSize);
                c.blasts.add(new Blast(explodeX, explodeY, explosionSize * 15.0, explosionSize * 10.0));
                int parts = 8;
                for (i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(ParticleType.ofName("explode_backs"), explodeX, explodeY, explosionSize));
                }
                parts = explosionSize > 0.5 ? 1 : 0;
                for (i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(ParticleType.ofName("shockwave"), explodeX, explodeY, explosionSize));
                }
                parts = n;
                for (i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(ParticleType.ofName("small_soot"), explodeX, explodeY));
                    c.particles.add(new Particle(ParticleType.ofName("large_soot"), explodeX, explodeY));
                }
                if (!SimplePref.REDUCED_FLASHING.get()) {
                    parts = 1;
                    for (i = 0; i < parts; ++i) {
                        c.particles.add(new Particle(ParticleType.ofName("explode"), explodeX, explodeY, explosionSize));
                    }
                }
                parts = 12;
                for (i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(ParticleType.ofName("explode_bits"), explodeX, explodeY, explosionSize));
                }
                if (explosionSize <= 0.5) {
                    c.play(MiscCombatSound.SMALL_SHOT_EXPLOSION, explodeX, explodeY, 0.0, 0.0, onViewingSide);
                } else if (explosionSize <= 1.2) {
                    c.play(MiscCombatSound.SHOT_EXPLOSION, explodeX, explodeY, 0.0, 0.0, onViewingSide);
                } else {
                    c.play(MiscCombatSound.MODULE_EXPLOSION, explodeX, explodeY, 0.0, 0.0, onViewingSide);
                }
            }
            if (hitTile != null || hitCrewman != null) {
                ParticleType pt;
                if (wapp != null) {
                    pt = wapp.impactParticle;
                    if (wapp.numImpactParticles != 0) {
                        nonExplodeParticles = wapp.numImpactParticles;
                    }
                } else {
                    pt = ParticleType.ofName("impact");
                }
                for (int i = 0; i < nonExplodeParticles; ++i) {
                    c.particles.add(new Particle(pt, explodeX, explodeY));
                }
            }
            this.done = true;
            return true;
        }
        return false;
    }

    public double getX() {
        return this.sX + (this.tX - this.sX) * (double)this.time / (double)this.travelTime;
    }

    public double getY() {
        return this.sY + (this.tY - this.sY) * (double)this.time / (double)this.travelTime;
    }

    public int getPenDmg() {
        return this.weaponType == null ? (this.tentacle == null ? (this.shooterType == null ? 0 : this.shooterType.penDmg) : this.tentacle.spec.attackPenDmg) : this.weaponType.getPenDmg(this.weaponBonuses);
    }

    public int getBlastDmg() {
        return this.weaponType == null ? (this.tentacle == null ? (this.shooterType == null ? 0 : this.shooterType.blastDmg) : this.tentacle.spec.attackBlastDmg) : this.weaponType.getBlastDmg(this.weaponBonuses);
    }

    public int getBlastSplashRadius() {
        return this.weaponType != null ? this.weaponType.getBlastSplashRadius(this.weaponBonuses) : (this.shooterType != null ? this.shooterType.blastSplashRadius : 0);
    }

    public int getDirectDmg() {
        return this.weaponType == null ? (this.tentacle == null ? (this.shooterType == null ? 0 : this.shooterType.directDmg) : this.tentacle.spec.attackDirectDmg) : this.weaponType.getDirectDmg(this.weaponBonuses);
    }

    public boolean harmsCrew() {
        return !this.internal || !this.vsBoarders;
    }

    public boolean harmsBoarders() {
        return !this.internal || this.vsBoarders;
    }
}

