/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class ShipSpyButton
extends UniScreen.ShipButton {
    public final Spy.ShipSpyAction action;

    public ShipSpyButton(Spy.ShipSpyAction action) {
        this.action = action;
    }

    public int successChance(Airship ship, UniScreen us, StrategicScreen ss) {
        return this.action.successChance(ship, ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    public int cost(Airship ship, UniScreen us, StrategicScreen ss) {
        return this.action.cost(ship, ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    @Override
    public boolean enabled(Airship ship, Combat.Side side, UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        if (ss.w.combatInfo != null) {
            return false;
        }
        if (ss.w.player == null || ss.w.player.getSpyFor(us.city) == null) {
            return false;
        }
        return this.successChance(ship, us, ss) > 0 && this.cost(ship, us, ss) <= ss.w.player.money;
    }

    @Override
    public void click(Input in, Airship ship, Combat.Side side, UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        ss.w.giveCommand(ss.w.shipMsg("shipSpyAction", ship).put("empire", ss.w.player.id).put("city", us.city.id).put("action", this.action.name()));
    }

    @Override
    public boolean visible(Airship ship, Combat.Side side, UniScreen us) {
        if (!(us.intent instanceof EspionageIntent)) {
            return false;
        }
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        Spy spy = ss.w.player.getSpyFor(us.city);
        if (spy == null) {
            return false;
        }
        return this.action.available(ship, spy, us.city, ss.w.map);
    }

    @Override
    public String text(Airship ship, Combat.Side side, UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.action.getName() + " ($" + this.cost(ship, us, ss) + ", " + this.successChance(ship, us, ss) + "%)";
    }
}

