/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.EditorAttractIntent;
import com.zarkonnen.airships.JobBoard;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class ShipProfilePanel
implements UniScreen.InfoPanel {
    static final Clr OVERLAY = new Clr(0, 0, 0, 200);
    final ModuleType[] interesting = new ModuleType[]{ModuleType.ofName("LARGE_KEEL"), ModuleType.ofName("TARGETING_COMPUTER"), ModuleType.ofName("TELESCOPE")};

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (us.followShip == null) {
            return;
        }
        Airship ship = us.followShip;
        CoatOfArms coa = CoatEditor.getMyStrategicArms();
        if (us.combat != null && us.combat.sideOf(ship) != null) {
            coa = us.combat.sideOf((Airship)ship).arms;
        }
        if (us.intent instanceof EditorAttractIntent) {
            EditorAttractIntent eai = (EditorAttractIntent)us.intent;
            coa = eai.coa;
            if (eai.typeToAdd < Loadable.all(ModuleType.class).size()) {
                return;
            }
        }
        int coaScale = 4;
        int x = MyDraw.SIDE_CLEARANCE;
        int y = sm.height - MyDraw.SIDE_CLEARANCE - 41 * coaScale;
        d.rect(OVERLAY, 0.0, y - MyDraw.UI_SPACING, sm.width, sm.height);
        coa.layout.drawShield(coa, d, x, y, coaScale, Clr.WHITE);
        d.text(ship.getName(), AGame.HUGE_FOUNT, x += 39 * coaScale + MyDraw.UI_SPACING, y);
        y += AGame.HUGE_FOUNT.height;
        int in = 20;
        ArrayList<String> stats = new ArrayList<String>();
        stats.add(JobBoard.indent(Lang._t("Cost_", new Object[0]), in) + ship.getCost());
        stats.add(JobBoard.indent(Lang._t("Weight_", new Object[0]), in) + ship.getWeight());
        stats.add(JobBoard.indent(Lang._t("Speed_", new Object[0]), in) + (int)(ship.getMainMapSpeed() * 3600.0 / 7.0));
        stats.add(JobBoard.indent(Lang._t("Service_ceiling_", new Object[0]), in) + ship.realServiceCeiling() / 8);
        for (CrewType ct : Loadable.all(CrewType.class)) {
            if (ship.getQuartered(ct) <= 0) continue;
            stats.add(JobBoard.indent(ct.getPlural() + ": ", in) + ship.getQuartered(ct));
        }
        for (ModuleType mt : ModuleCategory.ofName("WEAPONS").getContents()) {
            int n = 0;
            for (Module m : ship.modules) {
                if (m.type != mt) continue;
                ++n;
            }
            if (n <= 0) continue;
            stats.add(JobBoard.indent(mt.getName() + ": ", in) + n);
        }
        for (ModuleType mt : this.interesting) {
            boolean has = false;
            for (Module m : ship.modules) {
                if (m.type != mt) continue;
                has = true;
                break;
            }
            if (!has) continue;
            stats.add(mt.getName());
        }
        int y2 = y;
        int x2 = x;
        for (String stat : stats) {
            d.text(stat, AGame.FOUNT, x2, y2);
            if ((y2 += AGame.FOUNT.lineHeight) + AGame.FOUNT.lineHeight <= sm.height - MyDraw.SIDE_CLEARANCE) continue;
            y2 = y;
            x2 += AGame.FOUNT.displayWidth * 30;
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

