/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourPlate;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.FlagSpec;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.Splinter;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tentacle;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class ShipLayers {
    public static final Clr BAR_BG = Clr.fromHex((String)"141414");
    public static final Clr BAR_BORDER = Clr.fromHex((String)"726534");
    public static final Clr MILD_DMG = Clr.fromHex((String)"d9cbb1");
    public static final Clr MED_DMG = Clr.fromHex((String)"d59b7f");
    public static final Clr HV_DMG = Clr.fromHex((String)"bb421d");
    public static final Clr RELOAD = Clr.fromHex((String)"c8b84f");
    public static final Clr READY = Clr.fromHex((String)"6e9511");
    public static final Clr AMMO_RELOAD = Clr.fromHex((String)"7b421b");
    public static final ArrayList<UniScreen.ShipLayer> ALL = new ArrayList<UniScreen.ShipLayer>(Arrays.asList(new TracksAndLegs(true), new DamagedBackExternals(2, 2), new BackExternals(2, 2), new Decals1(1, 0, 0), new DamagedBackExternals(0, 1), new BackExternals(0, 1), new Splinters(), new BackArmour(), new ModuleBacks(), new Barrels(false), new Modules(), new DamagedModules(), new DetailedCrew(), new HPBars(), new Armour(), new Paint(), new Externals(0), new DamagedExternals(0), new Decals1(-1, -1, 1), new Decals2(), new Decals3(), new Barrels(true), new Externals(1), new DamagedExternals(1), new Flags(), new Pennants(), new Tentacles(), new Externals(2), new DamagedExternals(2), new Shells(), new TracksAndLegs(false)));

    static ArrayList<?> getTrackSegments(Airship ship, Module m) {
        int wi;
        ArrayList<Object> segs = new ArrayList<Object>();
        segs.add(ShipLayers.getLeftmostCurvedSegment(m.wheels.get(0), m.wheels.get(1)));
        for (wi = 0; wi < m.wheels.size() - 1; ++wi) {
            segs.add(ShipLayers.getStraightSegment(m.wheels.get(wi), m.wheels.get(wi + 1)));
            if (wi >= m.wheels.size() - 2) continue;
            segs.add(ShipLayers.getCurvedSegment(m.wheels.get(wi), m.wheels.get(wi + 1), m.wheels.get(wi + 2)));
        }
        segs.add(ShipLayers.getRightmostCurvedSegment(m.wheels.get(m.wheels.size() - 2), m.wheels.get(m.wheels.size() - 1)));
        for (wi = m.wheels.size() - 1; wi >= 1; --wi) {
            segs.add(ShipLayers.getStraightSegment(m.wheels.get(wi), m.wheels.get(wi - 1)));
            if (wi < 2) continue;
            segs.add(ShipLayers.getCurvedSegment(m.wheels.get(wi), m.wheels.get(wi - 1), m.wheels.get(wi - 2)));
        }
        for (int si = 0; si < segs.size() - 2; ++si) {
            double iSectY;
            double iSectX;
            if (!(segs.get(si) instanceof StraightSegment) || !(segs.get(si + 1) instanceof CurvedSegment) || ((CurvedSegment)segs.get((int)(si + 1))).endSegment || !(segs.get(si + 2) instanceof StraightSegment)) continue;
            StraightSegment seg1 = (StraightSegment)segs.get(si);
            StraightSegment seg2 = (StraightSegment)segs.get(si + 2);
            if (seg2.endX > seg1.endX) {
                if (!(seg1.endX > seg2.startX)) continue;
                iSectX = (seg1.endX + seg2.startX) / 2.0;
                iSectY = (seg1.endY + seg2.startY) / 2.0;
                seg1.endX = iSectX;
                seg1.endY = iSectY;
                seg2.startX = iSectX;
                seg2.startY = iSectY;
                continue;
            }
            if (!(seg2.endX > seg1.startX)) continue;
            iSectX = (seg2.endX + seg1.startX) / 2.0;
            iSectY = (seg2.endY + seg1.startY) / 2.0;
            seg2.endX = iSectX;
            seg2.endY = iSectY;
            seg1.startX = iSectX;
            seg1.startY = iSectY;
        }
        return segs;
    }

    static CurvedSegment getLeftmostCurvedSegment(Wheel w, Wheel to) {
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double wToToAngle = Direction.radiansFromTo(wx, wy, tox, toy);
        double startAngle = Direction.normalizeRadians(wToToAngle + 1.5707963267948966);
        return new CurvedSegment(w, startAngle, startAngle + Math.PI, true);
    }

    static CurvedSegment getCurvedSegment(Wheel from, Wheel w, Wheel to) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double fromToWAngle = Direction.radiansFromTo(fromx, fromy, wx, wy);
        double wToToAngle = Direction.radiansFromTo(wx, wy, tox, toy);
        double startAngle = Direction.normalizeRadians(fromToWAngle + 4.71238898038469);
        double endAngle = Direction.normalizeRadians(wToToAngle + 4.71238898038469);
        return new CurvedSegment(w, startAngle, endAngle, false);
    }

    static CurvedSegment getRightmostCurvedSegment(Wheel from, Wheel w) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double fromToWAngle = Direction.radiansFromTo(fromx, fromy, wx, wy);
        double startAngle = Direction.normalizeRadians(fromToWAngle + 4.71238898038469);
        return new CurvedSegment(w, startAngle, startAngle + Math.PI, true);
    }

    static StraightSegment getStraightSegment(Wheel from, Wheel to) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double fromToToAngle = Direction.radiansFromTo(fromx, fromy, tox, toy);
        double startAngle = fromToToAngle + 4.71238898038469;
        double endAngle = fromToToAngle + 4.71238898038469;
        return new StraightSegment(fromx + StrictMath.cos(startAngle) * from.spec.radius, fromy + StrictMath.sin(startAngle) * from.spec.radius, tox + StrictMath.cos(endAngle) * to.spec.radius, toy + StrictMath.sin(endAngle) * to.spec.radius);
    }

    public strictfp static final class Shells
    implements UniScreen.ShipLayer {
        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp <= 0 || !m.type.isWeapon()) continue;
                WeaponAppearance wa = m.type.weaponAppearance(ship.currentBonuses);
                for (int si = 0; si < wa.shells.size(); ++si) {
                    WeaponAppearance.Shell shell = wa.shells.get(si);
                    if (ship.flipped) {
                        shell = shell.flipped(m.type.getW());
                    }
                    if (!shell.img.src.equals(ssb.name)) {
                        if (additionalSSBs == null || !Loadable.hasOfName(SpritesheetBundle.class, shell.img.src)) continue;
                        additionalSSBs.add(SpritesheetBundle.ofName(shell.img.src));
                        continue;
                    }
                    if (shell.img.machineImgCache != null) {
                        ((Image)shell.img.machineImgCache).setFilter(9728);
                    }
                    double openness = shell.getOpenness(m);
                    double shellA = openness * shell.openAngle;
                    double shellX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + (double)shell.x + openness * shell.openShiftX;
                    double shellY = y + (double)(m.y * 16) + (double)shell.y + openness * shell.openShiftY;
                    double pivotOffsetX = shell.pivotX - shell.img.srcWidth / 2;
                    double pivotOffsetY = shell.pivotY - shell.img.srcHeight / 2;
                    shellX -= Math.cos(shellA) * pivotOffsetX - Math.sin(shellA) * pivotOffsetY;
                    shellY -= Math.sin(shellA) * pivotOffsetX + Math.cos(shellA) * pivotOffsetY;
                    RotatingShader.draw(shell.img, d, shellX += pivotOffsetX, shellY += pivotOffsetY, shellA, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return true;
        }
    }

    public strictfp static final class TentacleInfo
    implements UniScreen.ShipLayer {
        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            for (Module m : ship.modules) {
                if (m.hp <= 0) continue;
                for (Tentacle t : m.tentacles) {
                    d.rect(Clr.RED, t.goalX - 2.0, t.goalY - 2.0, 5.0, 5.0);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return true;
        }
    }

    public strictfp static final class Tentacles
    implements UniScreen.ShipLayer {
        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp <= 0 && !m.type.tentacleDeathSpasms()) continue;
                int tsz = m.tentacles.size();
                for (int ti = 0; ti < tsz; ++ti) {
                    Tentacle t = m.tentacles.get(ti);
                    int ssz = t.segments.size();
                    for (int si = 0; si < ssz; ++si) {
                        Img segImg;
                        Tentacle.Segment seg = t.segments.get(si);
                        Img img = segImg = t.flipped ? t.spec.segmentImgVerticallyFlipped : t.spec.segmentImg;
                        if (t.spec.segmentImgOverride[si] != null) {
                            Img img2 = segImg = t.flipped ? t.spec.segmentImgOverrideVerticallyFlipped[si] : t.spec.segmentImgOverride[si];
                        }
                        if (!segImg.src.equals(ssb.name)) {
                            if (additionalSSBs == null || !Loadable.hasOfName(SpritesheetBundle.class, segImg.src)) continue;
                            additionalSSBs.add(SpritesheetBundle.ofName(segImg.src));
                            continue;
                        }
                        if (segImg.machineImgCache != null) {
                            ((Image)segImg.machineImgCache).setFilter(9728);
                        }
                        double xScale = seg.getLength() * 1.0 / t.spec.imgLength;
                        double yScale = seg.getWidth() * 1.0 / (double)segImg.srcHeight;
                        double tentScale = xScale / 2.0 + yScale / 2.0;
                        RotatingShader.draw(segImg, d, seg.centerX + seg.xOffset - (double)segImg.srcWidth * tentScale * 0.5, seg.centerY + seg.yOffset - (double)segImg.srcHeight * tentScale * 0.5, seg.angle, tentScale, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                    }
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("monsters");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return true;
        }
    }

    public strictfp static final class TracksAndLegs
    implements UniScreen.ShipLayer {
        public final boolean backLegs;

        public TracksAndLegs(boolean backLegs) {
            this.backLegs = backLegs;
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (this.backLegs) {
                lightStrength *= 0.75f;
                ambient = new Color(ambientClr.r * 3 / 4, ambientClr.g * 3 / 4, ambientClr.b * 3 / 4, ambientClr.a);
                ambientClr = new Clr(ambientClr.r * 3 / 4, ambientClr.g * 3 / 4, ambientClr.b * 3 / 4, ambientClr.a);
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                double mx = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
                double my = y + (double)(m.y * 16) + (double)(m.type.getH() * 16);
                if (m.hp > 0 && !this.backLegs) {
                    int wsz = m.wheels.size();
                    for (int wi = 0; wi < wsz; ++wi) {
                        Wheel w = m.wheels.get(wi);
                        if (!w.spec.wheel.src.equals(ssb.name)) {
                            if (additionalSSBs == null || !Loadable.hasOfName(SpritesheetBundle.class, w.spec.wheel.src)) continue;
                            additionalSSBs.add(SpritesheetBundle.ofName(w.spec.wheel.src));
                            continue;
                        }
                        if (w.spec.wheel.machineImgCache != null) {
                            ((Image)w.spec.wheel.machineImgCache).setFilter(9728);
                        }
                        RotatingShader.draw(ssb, w.spec.wheel, d, mx + w.spec.xOffset * 16.0 - (double)(w.spec.wheel.srcWidth / 2), my + w.yOffset - (double)(w.spec.wheel.srcHeight / 2), w.phase, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                    }
                    if (!m.wheels.isEmpty()) {
                        Wheel.Spec ws = m.wheels.get((int)0).spec;
                        if (!ws.upperLink.src.equals(ssb.name)) {
                            if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, ws.upperLink.src)) {
                                additionalSSBs.add(SpritesheetBundle.ofName(ws.upperLink.src));
                            }
                        } else {
                            double segmentStride = ws.segmentStride;
                            double strideRadians = segmentStride / m.wheels.get((int)0).spec.radius;
                            ArrayList<?> segs = ShipLayers.getTrackSegments(ship, m);
                            for (int pass = 0; pass < 2; ++pass) {
                                double value = m.wheels.get((int)0).phase * segmentStride / strideRadians;
                                if (value < 0.0) {
                                    value += StrictMath.ceil(-value / segmentStride / 2.0) * segmentStride * 2.0;
                                }
                                boolean flipAlt = (value %= segmentStride * 2.0) >= segmentStride;
                                value %= segmentStride;
                                boolean second = pass == 1;
                                boolean alternation = second ^ flipAlt;
                                int segsS = segs.size();
                                for (int segI = 0; segI < segsS; ++segI) {
                                    Object seg = segs.get(segI);
                                    if (seg instanceof StraightSegment) {
                                        StraightSegment ss = (StraightSegment)seg;
                                        double dist = StrictMath.sqrt((ss.startX - ss.endX) * (ss.startX - ss.endX) + (ss.startY - ss.endY) * (ss.startY - ss.endY));
                                        double angle = Direction.radiansFromTo(ss.startX, ss.startY, ss.endX, ss.endY);
                                        while (value < dist) {
                                            boolean bl = alternation = !alternation;
                                            if (!alternation) {
                                                Img lnk;
                                                Img img = lnk = second ? ws.upperLink : ws.lowerLink;
                                                if (lnk.machineImgCache != null) {
                                                    ((Image)lnk.machineImgCache).setFilter(9728);
                                                }
                                                RotatingShader.draw(ssb, lnk, d, mx + ss.startX + (ss.endX - ss.startX) * value / dist - (double)(lnk.srcWidth / 2), my + ss.startY + (ss.endY - ss.startY) * value / dist - (double)(lnk.srcHeight / 2), angle + Math.PI, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                                            }
                                            value += segmentStride;
                                        }
                                        value -= dist;
                                    }
                                    if (!(seg instanceof CurvedSegment)) continue;
                                    CurvedSegment cs = (CurvedSegment)seg;
                                    if (cs.startAngle >= cs.endAngle) continue;
                                    Wheel w = cs.w;
                                    for (value = cs.startAngle + value * strideRadians / segmentStride; value < cs.endAngle; value += strideRadians) {
                                        Img lnk;
                                        boolean bl = alternation = !alternation;
                                        if (alternation) continue;
                                        Img img = lnk = second ? ws.upperLink : ws.lowerLink;
                                        if (lnk.machineImgCache != null) {
                                            ((Image)lnk.machineImgCache).setFilter(9728);
                                        }
                                        RotatingShader.draw(ssb, lnk, d, mx + w.spec.xOffset * 16.0 + StrictMath.cos(value) * w.spec.radius - (double)(lnk.srcWidth / 2), my + w.yOffset + StrictMath.sin(value) * w.spec.radius - (double)(lnk.srcHeight / 2), value + 4.71238898038469, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                                    }
                                    value = (value - cs.endAngle) * segmentStride / strideRadians;
                                }
                            }
                        }
                    }
                }
                int lsz = m.legs.size();
                for (int li = 0; li < lsz; ++li) {
                    double hipX;
                    Leg l = m.legs.get(li);
                    if (l.spec.back != this.backLegs) continue;
                    double d2 = hipX = ship.flipped ? mx + ((double)m.type.getW() - l.spec.xOffset) * 16.0 : mx + l.spec.xOffset * 16.0;
                    if (l.spec.upperLeg != null) {
                        if (!l.spec.upperLeg.src.equals(ssb.name)) {
                            if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, l.spec.upperLeg.src)) {
                                additionalSSBs.add(SpritesheetBundle.ofName(l.spec.upperLeg.src));
                            }
                        } else {
                            if (l.spec.upperLeg.machineImgCache != null) {
                                ((Image)l.spec.upperLeg.machineImgCache).setFilter(9728);
                            }
                            RotatingShader.draw(ssb, l.spec.upperLeg, d, hipX - (double)(l.spec.upperLeg.srcWidth / 2), my + l.spec.yOffset * 16.0 - (double)(l.spec.upperLeg.srcHeight / 2), l.upperRotation, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                        }
                        if (l.spec.middleLeg != null) {
                            if (!l.spec.middleLeg.src.equals(ssb.name)) {
                                if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, l.spec.middleLeg.src)) {
                                    additionalSSBs.add(SpritesheetBundle.ofName(l.spec.middleLeg.src));
                                }
                            } else {
                                if (l.spec.middleLeg.machineImgCache != null) {
                                    ((Image)l.spec.middleLeg.machineImgCache).setFilter(9728);
                                }
                                RotatingShader.draw(ssb, l.spec.middleLeg, d, hipX + StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength - (ship.flipped ^ l.spec.bendForwards ? (double)(l.spec.middleLeg.srcWidth / 2) - l.spec.middleLimbLength / 2.0 : l.spec.middleLimbLength / 2.0 + (double)(l.spec.middleLeg.srcWidth / 2)), my + l.spec.yOffset * 16.0 + StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength - (double)(l.spec.middleLeg.srcHeight / 2), ship.flipped ^ l.spec.bendForwards ? 0.0 : Math.PI, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                            }
                        }
                        if (!l.spec.lowerLeg.src.equals(ssb.name)) {
                            if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, l.spec.lowerLeg.src)) {
                                additionalSSBs.add(SpritesheetBundle.ofName(l.spec.lowerLeg.src));
                            }
                        } else {
                            if (l.spec.lowerLeg.machineImgCache != null) {
                                ((Image)l.spec.lowerLeg.machineImgCache).setFilter(9728);
                            }
                            RotatingShader.draw(ssb, l.spec.lowerLeg, d, hipX + StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength + (ship.flipped ^ l.spec.bendForwards ? l.spec.middleLimbLength : -l.spec.middleLimbLength) - (double)(l.spec.lowerLeg.srcWidth / 2), my + l.spec.yOffset * 16.0 + StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength - (double)(l.spec.lowerLeg.srcHeight / 2), l.lowerRotation, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                        }
                        if (!l.spec.foot.src.equals(ssb.name)) {
                            if (additionalSSBs == null || !Loadable.hasOfName(SpritesheetBundle.class, l.spec.foot.src)) continue;
                            additionalSSBs.add(SpritesheetBundle.ofName(l.spec.foot.src));
                            continue;
                        }
                        if (l.spec.foot.machineImgCache != null) {
                            ((Image)l.spec.foot.machineImgCache).setFilter(9728);
                        }
                        RotatingShader.draw(ssb, l.spec.foot, d, hipX + StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength + (ship.flipped ^ l.spec.bendForwards ? l.spec.middleLimbLength : -l.spec.middleLimbLength) + StrictMath.cos(l.lowerRotation) * l.spec.lowerLimbLength - (double)(l.spec.foot.srcWidth / 2), my + l.spec.yOffset * 16.0 + StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength + StrictMath.sin(l.lowerRotation) * l.spec.lowerLimbLength - (double)(l.spec.foot.srcHeight / 2), 1.5707963267948966, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                        continue;
                    }
                    d.shift(mx + l.spec.xOffset * 16.0, my + l.spec.yOffset * 16.0);
                    d.rotate(l.upperRotation * 180.0 / Math.PI);
                    d.rect(Clr.RED, -l.spec.upperLimbLength / 8.0, -l.spec.upperLimbLength / 8.0, l.spec.upperLimbLength, l.spec.upperLimbLength / 4.0);
                    d.rotate(-l.upperRotation * 180.0 / Math.PI);
                    d.shift(StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength, StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength);
                    d.rotate(l.lowerRotation * 180.0 / Math.PI);
                    d.rect(Clr.RED, -l.spec.lowerLimbLength / 8.0, -l.spec.lowerLimbLength / 8.0, l.spec.lowerLimbLength, l.spec.lowerLimbLength / 4.0);
                    d.rotate(-l.lowerRotation * 180.0 / Math.PI);
                    d.shift(-StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength, -StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength);
                    d.shift(-mx - l.spec.xOffset * 16.0, -my - l.spec.yOffset * 16.0);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("wheels_and_legs");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return true;
        }
    }

    strictfp static class StraightSegment {
        double startX;
        double startY;
        double endX;
        double endY;

        public StraightSegment(double startX, double startY, double endX, double endY) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
        }
    }

    strictfp static class CurvedSegment {
        Wheel w;
        double startAngle;
        double endAngle;
        boolean endSegment;

        public CurvedSegment(Wheel w, double startAngle, double endAngle, boolean endSegment) {
            this.w = w;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.endSegment = endSegment;
        }
    }

    public strictfp static class Pennants
    implements UniScreen.ShipLayer {
        private static boolean pennantShaderLoadFailed = false;
        private static ShaderProgram sp;
        private static ShaderProgram lsp;
        private boolean shaderLocked = false;

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            this.shaderLocked = false;
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || pennantShaderLoadFailed) {
                return;
            }
            if (light != null) {
                if (lsp == null) {
                    try {
                        lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/pennant.vert"), (String)AGame.getStaticGameDirectoryPath("data/litpennant.frag"));
                    }
                    catch (Exception e) {
                        AirshipGame.instance.reportError("Pennant shader load failed", e, null, false, true);
                        pennantShaderLoadFailed = true;
                        return;
                    }
                }
                lsp.bind();
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                lsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                lsp.setUniform1i("lightFromRight", 3);
                lsp.enableVertexAttribute("flagSize");
                lsp.enableVertexAttribute("acoord");
                lsp.enableVertexAttribute("awind");
                lsp.enableVertexAttribute("at");
                lsp.enableVertexAttribute("ayShift");
                lsp.setUniform1f("strength", lightStrength);
                lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                lsp.setUniform4f("ambient", ambient);
                lsp.setUniform1f("ambientSaturation", ambientSaturation);
                GL11.glBegin((int)7);
            } else {
                if (sp == null) {
                    try {
                        sp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/pennant.vert"), (String)AGame.getStaticGameDirectoryPath("data/pennant.frag"));
                    }
                    catch (Exception e) {
                        AirshipGame.instance.reportError("Flag shader load failed", e, null, false, true);
                        pennantShaderLoadFailed = true;
                        return;
                    }
                }
                sp.bind();
                sp.setUniform4f("ambient", ambient);
                sp.enableVertexAttribute("flagSize");
                sp.enableVertexAttribute("acoord");
                sp.enableVertexAttribute("awind");
                sp.enableVertexAttribute("at");
                sp.enableVertexAttribute("ayShift");
                GL11.glBegin((int)7);
            }
            this.shaderLocked = true;
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || pennantShaderLoadFailed) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal m = ship.decals.get(di);
                    if (!m.enabled || m.type.flag == null || m.type.flag.type != FlagSpec.Type.PENNANT) continue;
                    FlagSpec f = m.type.flag;
                    double flagX = x + (double)(ship.gridXToWorldX(m.x, m.type.w) * 16) + (double)(ship.flipped ? m.type.w * 16 - f.x : f.x);
                    double flagY = y + (double)(m.y * 16) + (double)f.y;
                    d.rect(coa.getFirstColour().tint, flagX, flagY, f.size, f.size);
                }
                return;
            }
            double wind = (weather == null ? 0.0 : weather.wind) - ship.smoothedXSpeed;
            wind += StrictMath.abs(ship.smoothedYSpeed) * StrictMath.signum(wind) * 0.5;
            if (StrictMath.abs(wind *= 50.0) < 1.0) {
                double sig = StrictMath.signum(ship.flagFlipAccum);
                ship.flagFlipAccum += wind * (double)ms * 0.001;
                if (StrictMath.signum(ship.flagFlipAccum) != sig) {
                    ship.flagFlipAccum = StrictMath.signum(ship.flagFlipAccum);
                }
                wind = ship.flagFlipAccum > 0.0 ? 1.0 : -1.0;
            } else {
                ship.flagFlipAccum = StrictMath.signum(wind);
                if (wind > 0.0) {
                    wind = StrictMath.min(20.0, StrictMath.max(1.0, wind));
                } else if (wind < 0.0) {
                    wind = StrictMath.max(-20.0, StrictMath.min(-1.0, wind));
                }
            }
            double yShift = StrictMath.max(-0.5, StrictMath.min(0.5, -ship.getySpeed() * 5.0));
            ShaderProgram p = light == null ? sp : lsp;
            Color tint = coa.getFirstColour().tintColor;
            int dsz = ship.decals.size();
            for (int di = 0; di < dsz; ++di) {
                Decal m = ship.decals.get(di);
                if (!m.enabled || m.type.flag == null || m.type.flag.type != FlagSpec.Type.PENNANT) continue;
                FlagSpec f = m.type.flag;
                double flagX = x + (double)(ship.gridXToWorldX(m.x, m.type.w) * 16) + (double)(ship.flipped ? m.type.w * 16 - f.x : f.x);
                double flagY = y + (double)(m.y * 16) + (double)f.y;
                GL20.glVertexAttrib4f((int)p.getAttributeID("tint"), (float)tint.r, (float)tint.g, (float)tint.b, (float)tint.a);
                GL20.glVertexAttrib1f((int)p.getAttributeID("flagSize"), (float)f.size);
                GL20.glVertexAttrib1f((int)p.getAttributeID("awind"), (float)((float)wind));
                GL20.glVertexAttrib1f((int)p.getAttributeID("at"), (float)((float)(m.animOffset + ms) * -0.01f * StrictMath.signum((float)wind)));
                GL20.glVertexAttrib1f((int)p.getAttributeID("ayShift"), (float)((float)yShift));
                GL20.glVertexAttrib2f((int)p.getAttributeID("acoord"), (float)(-f.size), (float)f.size);
                GL11.glVertex2d((double)(flagX - (double)(f.size * 4)), (double)(flagY - (double)f.size));
                GL20.glVertexAttrib2f((int)p.getAttributeID("acoord"), (float)(-f.size), (float)(-2 * f.size));
                GL11.glVertex2d((double)(flagX - (double)(f.size * 4)), (double)(flagY + (double)(2 * f.size)));
                GL20.glVertexAttrib2f((int)p.getAttributeID("acoord"), (float)f.size, (float)(-2 * f.size));
                GL11.glVertex2d((double)(flagX + (double)(f.size * 4)), (double)(flagY + (double)(2 * f.size)));
                GL20.glVertexAttrib2f((int)p.getAttributeID("acoord"), (float)f.size, (float)f.size);
                GL11.glVertex2d((double)(flagX + (double)(f.size * 4)), (double)(flagY - (double)f.size));
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || !this.shaderLocked) {
                return;
            }
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            (light == null ? sp : lsp).unbind();
            TextureImpl.bindNone();
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Flags
    implements UniScreen.ShipLayer {
        private static boolean flagShaderLoadFailed = false;
        private static ShaderProgram sp;
        private static ShaderProgram lsp;
        private static boolean flagsDrawn;
        private static boolean flagsDrawnFailed;
        private static Image flagsImg;
        private static CoatOfArms currentCOA0;
        private static CoatOfArms currentCOA1;
        private boolean shaderLocked = false;

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            this.shaderLocked = false;
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || flagShaderLoadFailed || !flagsDrawn) {
                return;
            }
            if (light != null) {
                if (lsp == null) {
                    try {
                        lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/flag.vert"), (String)AGame.getStaticGameDirectoryPath("data/litflag.frag"));
                    }
                    catch (Exception e) {
                        AirshipGame.instance.reportError("Flag shader load failed", e, null, false, true);
                        flagShaderLoadFailed = true;
                        return;
                    }
                }
                lsp.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)flagsImg.getTexture().getTextureID());
                lsp.setUniform1i("tex", 0);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                lsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                lsp.setUniform1i("lightFromRight", 3);
                lsp.enableVertexAttribute("flagSize");
                lsp.enableVertexAttribute("texOffset");
                lsp.enableVertexAttribute("awind");
                lsp.enableVertexAttribute("at");
                lsp.enableVertexAttribute("ayShift");
                lsp.setUniform1f("strength", lightStrength);
                lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                lsp.setUniform4f("ambient", ambient);
                lsp.setUniform1f("ambientSaturation", ambientSaturation);
                GL11.glBegin((int)7);
            } else {
                if (sp == null) {
                    try {
                        sp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/flag.vert"), (String)AGame.getStaticGameDirectoryPath("data/flag.frag"));
                    }
                    catch (Exception e) {
                        AirshipGame.instance.reportError("Flag shader load failed", e, null, false, true);
                        flagShaderLoadFailed = true;
                        return;
                    }
                }
                sp.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)flagsImg.getTexture().getTextureID());
                sp.setUniform1i("tex", 0);
                sp.enableVertexAttribute("flagSize");
                sp.enableVertexAttribute("texOffset");
                sp.enableVertexAttribute("awind");
                sp.enableVertexAttribute("at");
                sp.enableVertexAttribute("ayShift");
                GL11.glBegin((int)7);
            }
            this.shaderLocked = true;
        }

        public static void updateFlags(MyDraw d, CoatOfArms coa0, CoatOfArms coa1) {
            if (coa0 != null && !coa0.equals(currentCOA0) || coa1 != null && !coa1.equals(currentCOA1)) {
                if (flagsImg == null) {
                    try {
                        flagsImg = new Image(64, 64);
                    }
                    catch (SlickException e) {
                        flagsDrawnFailed = true;
                        AirshipGame.instance.reportError("Flags image could not be created.", (Exception)((Object)e), null, false, true);
                        return;
                    }
                }
                if (coa0 == null) {
                    return;
                }
                if (coa1 == null) {
                    coa1 = coa0;
                }
                d.resetTransforms();
                coa0.draw(d, 0.0, 0.0, 32);
                coa1.draw(d, 32.0, 0.0, 32);
                ((Graphics)d.frame().nativeRenderer()).copyArea(flagsImg, 0, 0);
                currentCOA0 = coa0;
                currentCOA1 = coa1;
                flagsDrawn = true;
            }
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || flagShaderLoadFailed || flagsDrawnFailed || !this.shaderLocked || !flagsDrawn) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal m = ship.decals.get(di);
                    if (!m.enabled || m.type.flag == null || m.type.flag.type != FlagSpec.Type.ARMS) continue;
                    FlagSpec f = m.type.flag;
                    double flagX = x + (double)(ship.gridXToWorldX(m.x, m.type.w) * 16) + (double)(ship.flipped ? m.type.w * 16 - f.x : f.x);
                    double flagY = y + (double)(m.y * 16) + (double)f.y;
                    coa.draw(d, flagX, flagY, f.size);
                }
                return;
            }
            double wind = (weather == null ? 0.0 : weather.wind) - ship.smoothedXSpeed;
            wind += StrictMath.abs(ship.smoothedYSpeed) * StrictMath.signum(wind) * 0.5;
            if (StrictMath.abs(wind *= 50.0) < 1.0) {
                double sig = StrictMath.signum(ship.flagFlipAccum);
                ship.flagFlipAccum += wind * (double)ms * 0.001;
                if (StrictMath.signum(ship.flagFlipAccum) != sig) {
                    ship.flagFlipAccum = StrictMath.signum(ship.flagFlipAccum);
                }
                wind = ship.flagFlipAccum > 0.0 ? 1.0 : -1.0;
            } else {
                ship.flagFlipAccum = StrictMath.signum(wind);
                if (wind > 0.0) {
                    wind = StrictMath.min(20.0, StrictMath.max(1.0, wind));
                } else if (wind < 0.0) {
                    wind = StrictMath.max(-20.0, StrictMath.min(-1.0, wind));
                }
            }
            double yShift = StrictMath.max(-0.5, StrictMath.min(0.5, -ship.getySpeed() * 5.0));
            ShaderProgram p = light == null ? sp : lsp;
            int dsz = ship.decals.size();
            for (int di = 0; di < dsz; ++di) {
                Decal m = ship.decals.get(di);
                if (!m.enabled || m.type.flag == null || m.type.flag.type != FlagSpec.Type.ARMS) continue;
                FlagSpec f = m.type.flag;
                double flagX = x + (double)(ship.gridXToWorldX(m.x, m.type.w) * 16) + (double)(ship.flipped ? m.type.w * 16 - f.x : f.x);
                double flagY = y + (double)(m.y * 16) + (double)f.y;
                GL20.glVertexAttrib1f((int)p.getAttributeID("flagSize"), (float)f.size);
                GL20.glVertexAttrib2f((int)p.getAttributeID("texOffset"), (float)((float)side * 0.5f), (float)0.0f);
                GL20.glVertexAttrib1f((int)p.getAttributeID("awind"), (float)((float)wind));
                GL20.glVertexAttrib1f((int)p.getAttributeID("at"), (float)((float)(m.animOffset + ms) * -0.01f * StrictMath.signum((float)wind)));
                GL20.glVertexAttrib1f((int)p.getAttributeID("ayShift"), (float)((float)yShift));
                GL11.glTexCoord2d((double)(-f.size), (double)f.size);
                GL11.glVertex2d((double)(flagX - (double)f.size), (double)(flagY - (double)f.size));
                GL11.glTexCoord2d((double)(-f.size), (double)(-2 * f.size));
                GL11.glVertex2d((double)(flagX - (double)f.size), (double)(flagY + (double)(2 * f.size)));
                GL11.glTexCoord2d((double)f.size, (double)(-2 * f.size));
                GL11.glVertex2d((double)(flagX + (double)f.size), (double)(flagY + (double)(2 * f.size)));
                GL11.glTexCoord2d((double)f.size, (double)f.size);
                GL11.glVertex2d((double)(flagX + (double)f.size), (double)(flagY - (double)f.size));
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            if (Appearance.useSimpleGraphics || Appearance.shaderLoadFailed || !this.shaderLocked) {
                return;
            }
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            (light == null ? sp : lsp).unbind();
            TextureImpl.bindNone();
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }

        static {
            flagsDrawn = false;
            flagsDrawnFailed = false;
        }
    }

    public strictfp static class DamagedExternals
    implements UniScreen.ShipLayer {
        private final int drawPriority;

        public DamagedExternals(int drawPriority) {
            this.drawPriority = drawPriority;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            if (ssb.getDamagedVersion() != null) {
                Appearance.lockSubShader(ssb.getDamagedVersion(), d, light, lightStrength, ambient, ambientSaturation);
            } else {
                Appearance.lockSubShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
            }
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp > 0 || m.type.getExternalDrawPriority() != this.drawPriority || m.type.hasSpecificDestroyedExternalAppearances()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, false, false, m.externalPaint == null ? null : m.externalPaint.getPaintType(coa));
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockSubShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Externals
    implements UniScreen.ShipLayer {
        private final int drawPriority;

        public Externals(int drawPriority) {
            this.drawPriority = drawPriority;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockSubShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp <= 0 && !m.type.hasSpecificDestroyedExternalAppearances() || m.type.getExternalDrawPriority() != this.drawPriority || !outside && !m.type.drawExternalsWhenInside()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, m.hp < m.maxHP / 2, m.hp <= 0, m.externalPaint == null ? null : m.externalPaint.getPaintType(coa));
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockSubShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Decals3
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                return;
            }
            if (showDecals) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal dec = ship.decals.get(di);
                    if (!dec.enabled) continue;
                    dec.type.drawUnlitCharges(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa);
                    dec.type.drawNonShader(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.getName(), ambientClr);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Decals2
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                return;
            }
            if (showDecals) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal dec = ship.decals.get(di);
                    if (!dec.enabled) continue;
                    dec.type.drawCharges(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.getName(), light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Decals1
    implements UniScreen.ShipLayer {
        private final int insideDrawPriorityFirst;
        private final int insideDrawPrioritySecond;
        private final int outsideDrawPriority;

        public Decals1(int insideDrawPriorityFirst, int insideDrawPrioritySecond, int outsideDrawPriority) {
            this.insideDrawPriorityFirst = insideDrawPriorityFirst;
            this.insideDrawPrioritySecond = insideDrawPrioritySecond;
            this.outsideDrawPriority = outsideDrawPriority;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockSubShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (showDecals) {
                Decal dec;
                int di;
                int dp = outside ? this.outsideDrawPriority : this.insideDrawPriorityFirst;
                int dsz = ship.decals.size();
                for (di = 0; di < dsz; ++di) {
                    dec = ship.decals.get(di);
                    if (!dec.enabled || dec.layer != dp) continue;
                    dec.type.drawBase(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.imgW) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.getName(), light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, dec.paint == null ? null : dec.paint.getPaintType(coa));
                }
                if (!outside) {
                    dp = this.insideDrawPrioritySecond;
                    for (di = 0; di < dsz; ++di) {
                        dec = ship.decals.get(di);
                        if (!dec.enabled || dec.layer != dp) continue;
                        dec.type.drawBase(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.imgW) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.getName(), light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, dec.paint == null ? null : dec.paint.getPaintType(coa));
                    }
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockSubShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Paint
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                return;
            }
            if (light != null) {
                return;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.paint == null || t.armour.type == ArmourType.ofName("NONE") || t.module.type.getTileMasks(ship.currentBonuses)[t.y - t.module.y][t.x - t.module.x] != TileMask.FULL) continue;
                d.rect(t.armour.paint.getTint(coa), x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return Appearance.useSimpleGraphics || Appearance.shaderLoadFailed;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Armour
    implements UniScreen.ShipLayer {
        final int[][] patch9 = new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockBevelledShader(ssb, ssb2, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                return;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.type.hidden || t.armour.type == ArmourType.ofName("NONE")) continue;
                Appearance app = outside ? (t.armour.type.damagedApps.get(ship.currentBonuses).isEmpty() ? ArmourPlate.noApp : t.armour.type.damagedApps.get(ship.currentBonuses).get(0)) : t.armour.getApp();
                TileMask tileMask = t.module.type.getTileMasks(ship.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
                if (tileMask == TileMask.EMPTY) continue;
                Appearance moduleApp = t.module.type.getApp(ship.currentBonuses);
                if (app.spritesheetBundle != ssb || moduleApp.spritesheetBundle != ssb2) {
                    if (additionalSSBPairs == null) continue;
                    additionalSSBPairs.add((Utils.Pair<SpritesheetBundle, SpritesheetBundle>)new Utils.Pair((Object)app.spritesheetBundle, (Object)moduleApp.spritesheetBundle));
                    continue;
                }
                this.patch9[0][0] = 1;
                this.patch9[0][1] = 1;
                this.patch9[0][2] = 1;
                this.patch9[1][0] = 1;
                this.patch9[1][1] = 1;
                this.patch9[1][2] = 1;
                this.patch9[2][0] = 1;
                this.patch9[2][1] = 1;
                this.patch9[2][2] = 1;
                if (t.armour.hp == 0) {
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dx = -1; dx < 2; ++dx) {
                            if (dx == 0 || dy == 0) {
                                if (!t.adjacent[dy + 1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)(t.y + dy)).armour.hp != 0) continue;
                                this.patch9[dy + 1][dx + 1] = 0;
                                continue;
                            }
                            if (!t.adjacent[dy + 1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)(t.y + dy)).armour.hp != 0 || (!t.adjacent[dy + 1][1] || ship.tileAt((int)t.x, (int)(t.y + dy)).armour.hp != 0) && (!t.adjacent[1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)t.y).armour.hp != 0)) continue;
                            this.patch9[dy + 1][dx + 1] = 0;
                        }
                    }
                }
                Img mask = t.module.type.getArmourMask(ship.currentBonuses);
                TileMask useTileMask = null;
                int maskX = 0;
                int maskY = 0;
                if (mask != null) {
                    if (Appearance.useSimpleGraphics) {
                        useTileMask = tileMask;
                        if (ship.flipped) {
                            useTileMask = useTileMask.flipped;
                        }
                    }
                    maskX = t.module.type.isFlipped() ? mask.srcX + (t.module.type.getW() - (t.x - t.module.x) - 1) * 16 : mask.srcX + (t.x - t.module.x) * 16;
                    maskY = mask.srcY + (t.y - t.module.y) * 16;
                }
                t.armour.getApp().drawBevelled(d, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0, ms, null, ship.flipped ^ t.module.type.isFlipped(), light, lightStrength, ambient, ambientSaturation, t.adjacent[0][1] ? 0 : 1, t.adjacent[2][1] ? 0 : 1, t.adjacent[1][t.module.type.isFlipped() ? 2 : 0] ? 0 : 1, t.adjacent[1][t.module.type.isFlipped() ? 0 : 2] ? 0 : 1, false, this.patch9, t.armour.paint == null ? null : t.armour.paint.getTint(coa), t.armour.paint == null ? 0.36f : t.armour.paint.getPaintType(coa).shiny(), mask != null, maskX, maskY, useTileMask, ssb2);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockBevelledShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class HPBars
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            double px = 1.0 / scale;
            if (!outside && showHPBarsAndDoors) {
                int msz = ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    Clr c;
                    double barX;
                    Module m = ship.modules.get(mi);
                    if (displayStatusIcons && m.hp < m.getMaxHP() / 2 && m.hp > 0) {
                        barX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + 3.0 * px;
                        double barW = (double)(m.type.getW() * 16) - 6.0 * px;
                        double barH = (double)(scale > 2.5 ? 6 : 2) * px;
                        double barY = y + (double)((m.y + m.type.getH()) * 16) - barH - 3.0 * px - 1.0;
                        d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                        d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                        c = MILD_DMG;
                        if (m.hp < m.getMaxHP() / 2) {
                            c = MED_DMG;
                        }
                        if (m.hp < m.getMaxHP() / 4) {
                            c = HV_DMG;
                        }
                        d.rect(c, barX + barW * (double)m.getMaxRepairToHP() / (double)m.getMaxHP() - px, barY, px, barH);
                        d.rect(c, barX, barY, barW * (double)m.hp / (double)m.getMaxHP(), barH);
                    }
                    barX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + 3.0 * px;
                    double barH = (double)(m.type.getH() * 16) - (double)(scale > 2.5 ? 6 : 2) * px - 1.0 - 11.0 * px;
                    double barY = y + (double)(m.y * 16) + 3.0 * px;
                    double barW = (double)(scale > 2.5 ? 6 : 2) * px;
                    if (displayStatusIcons && m.type.getCoal(ship.currentBonuses) > 0) {
                        d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                        d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                        d.rect(Airship.COAL_FG, barX, barY + barH - barH * (double)m.getResource(Resource.COAL) / (double)m.type.getCoal(ship.currentBonuses), barW, barH * (double)m.getResource(Resource.COAL) / (double)m.type.getCoal(ship.currentBonuses));
                    }
                    if (displayStatusIcons && m.type.getWater(ship.currentBonuses) > 0) {
                        d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                        d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                        d.rect(Airship.WATER_FG, barX, barY + barH - barH * (double)m.getResource(Resource.WATER) / (double)m.type.getWater(ship.currentBonuses), barW, barH * (double)m.getResource(Resource.WATER) / (double)m.type.getWater(ship.currentBonuses));
                    }
                    if (displayStatusIcons && m.type.getRepair(ship.currentBonuses) > 0) {
                        d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                        d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                        d.rect(Airship.REPAIR_FG, barX, barY + barH - barH * (double)m.getResource(Resource.REPAIR) / (double)m.type.getRepair(ship.currentBonuses), barW, barH * (double)m.getResource(Resource.REPAIR) / (double)m.type.getRepair(ship.currentBonuses));
                    }
                    if (displayStatusIcons && m.type.getAmmo(ship.currentBonuses) > 0) {
                        d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                        d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                        d.rect(Airship.AMMO_FG, barX, barY + barH - barH * (double)m.getResource(Resource.AMMO) / (double)m.type.getAmmo(ship.currentBonuses), barW, barH * (double)m.getResource(Resource.AMMO) / (double)m.type.getAmmo(ship.currentBonuses));
                    }
                    if (!displayStatusIcons || m.type.getReload(ship.currentBonuses) == 0 || m.hp <= 0) continue;
                    barW = 4.0;
                    barX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + (!(m.type.isFlipped() ^ ship.flipped) ? (double)(m.type.getW() * 16) - barW - px * 3.0 : px * 3.0);
                    barH = (double)(scale > 2.5 ? 6 : 2) * px;
                    d.rect(BAR_BORDER, barX - 2.0 * px, barY - 2.0 * px, barW + 4.0 * px, barH + 4.0 * px);
                    d.rect(BAR_BG, barX - 1.0 * px, barY - 1.0 * px, barW + 2.0 * px, barH + 2.0 * px);
                    c = m.shootAccumulator >= m.type.getReload(ship.currentBonuses) && m.hp > 0 && m.somewhatStaffed() ? READY : RELOAD;
                    double amt = barW * (double)StrictMath.min(m.shootAccumulator, m.type.getReload(ship.currentBonuses)) / (double)m.type.getReload(ship.currentBonuses);
                    if (m.clipReloadCooldown > 0) {
                        c = AMMO_RELOAD;
                        amt = barW * (double)(m.type.getClipReloadTime(ship.currentBonuses) - m.clipReloadCooldown) / (double)m.type.getClipReloadTime(ship.currentBonuses);
                    }
                    d.rect(c, barX, barY, amt, barH);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class DetailedCrew
    implements UniScreen.ShipLayer {
        private final float[][] coaColors = new float[5][3];

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingColoringShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            this.coaColors[0] = coa.getTincture((int)0).replacementValue;
            this.coaColors[1] = coa.getTincture((int)1).replacementValue;
            this.coaColors[2] = coa.getTincture((int)2).replacementValue;
            this.coaColors[3] = coa.getFirstColour().replacementValue;
            this.coaColors[4] = coa.getFirstMetal().replacementValue;
            int csz = ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = ship.crew.get(ci);
                if (scale >= 1.0) {
                    c.draw(d, x + (double)(ship.gridXToWorldX(c.currentTile.x, 1) * 16), y + (double)(c.currentTile.y * 16), ms, light, lightStrength, ambient, ambientSaturation, ambientClr, ssb, additionalSSBs, this.coaColors);
                    continue;
                }
                if (outside && !(scale >= 0.75) && !c.currentTile.module.type.isExternal()) continue;
                c.simpleDraw(d, x + (double)(ship.gridXToWorldX(c.currentTile.x, 1) * 16), y + (double)(c.currentTile.y * 16), ms, light, lightStrength, ambient, ambientSaturation, ambientClr, ssb, additionalSSBs, this.coaColors);
            }
            this.coaColors[0] = enemyCOA.getTincture((int)0).replacementValue;
            this.coaColors[1] = enemyCOA.getTincture((int)1).replacementValue;
            this.coaColors[2] = enemyCOA.getTincture((int)2).replacementValue;
            this.coaColors[3] = enemyCOA.getFirstColour().replacementValue;
            this.coaColors[4] = enemyCOA.getFirstMetal().replacementValue;
            int bsz = ship.boarders.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Crewman b = ship.boarders.get(bi);
                if (scale >= 1.0) {
                    b.draw(d, x + (double)(ship.gridXToWorldX(b.currentTile.x, 1) * 16), y + (double)(b.currentTile.y * 16), ms, light, lightStrength, ambient, ambientSaturation, ambientClr, ssb, additionalSSBs, this.coaColors);
                    continue;
                }
                if (outside && !(scale >= 0.75) && !b.currentTile.module.type.isExternal()) continue;
                b.simpleDraw(d, x + (double)(ship.gridXToWorldX(b.currentTile.x, 1) * 16), y + (double)(b.currentTile.y * 16), ms, light, lightStrength, ambient, ambientSaturation, ambientClr, ssb, additionalSSBs, this.coaColors);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingColoringShader.unlockShader();
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class DamagedModules
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            if (ssb.getDamagedVersion() != null) {
                Appearance.lockShader(ssb.getDamagedVersion(), d, light, lightStrength, ambient, ambientSaturation);
            } else {
                Appearance.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
            }
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (outside && scale <= 0.75) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (!outside && !m.type.drawAppearanceInside() || !displayStatusIcons || m.hp > 0) continue;
                float brightnessMult = m.burntOut ? 0.5f : 1.0f;
                Appearance app = m.type.getApp(ship.currentBonuses);
                if (app.spritesheetBundle != ssb) {
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(app.spritesheetBundle);
                    continue;
                }
                m.type.draw(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, (Clr)(m.burntOut ? Clr.GREY : null), ship.flipped, m.variant, ship.currentBonuses, light, lightStrength * brightnessMult, ambient, ambientSaturation * brightnessMult);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Modules
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (outside && scale <= 0.75) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (!outside && !m.type.drawAppearanceInside() || displayStatusIcons && m.hp <= 0) continue;
                if (m.type.getApp((BonusSet)ship.currentBonuses).spritesheetBundle != ssb) {
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(m.type.getApp((BonusSet)ship.currentBonuses).spritesheetBundle);
                    continue;
                }
                m.type.draw(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Barrels
    implements UniScreen.ShipLayer {
        public final boolean external;

        public Barrels(boolean external) {
            this.external = external;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (this.external && !outside) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                WeaponAppearance.BarrelAnimation ba;
                Img barrel;
                Module m = ship.modules.get(mi);
                WeaponAppearance wa = m.type.weaponAppearance(ship.currentBonuses);
                if (wa == null) continue;
                Img img = this.external ? (ship.flipped ? wa.externalFlippedbarrel : wa.externalBarrel) : (barrel = ship.flipped ? wa.flippedbarrel : wa.barrel);
                if (this.external) {
                    if (wa.externalBarrelAnimation != null) {
                        ba = ship.flipped ? wa.externalFlippedBarrelAnimation : wa.externalBarrelAnimation;
                        barrel = ba.frames.get(m.barrelAnimationOffset / ba.interval % ba.frames.size());
                    }
                } else if (wa.barrelAnimation != null) {
                    ba = ship.flipped ? wa.flippedBarrelAnimation : wa.barrelAnimation;
                    barrel = ba.frames.get(m.barrelAnimationOffset / ba.interval % ba.frames.size());
                }
                if (barrel == null) continue;
                if (!barrel.src.equals(ssb.name)) {
                    if (additionalSSBs == null || !Loadable.hasOfName(SpritesheetBundle.class, barrel.src)) continue;
                    additionalSSBs.add(SpritesheetBundle.ofName(barrel.src));
                    continue;
                }
                Pt offset = ship.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                double angle = ship.flipped != m.type.isFlipped() ? m.weaponAngle + Math.PI : m.weaponAngle;
                double recoilX = StrictMath.cos(m.weaponAngle) * m.recoil;
                double recoilY = StrictMath.sin(m.weaponAngle) * m.recoil;
                if (m.hp <= 0) continue;
                double bx = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + offset.x - recoilX;
                double by = y + (double)(m.y * 16) + offset.y - recoilY;
                RotatingShader.draw(barrel, d, bx, by, angle, ship.flipped ^ m.type.isFlipped(), light, lightStrength, ambient, ambientSaturation, ambientClr);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class ModuleBacks
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                Appearance back = m.type.getBack(ship.currentBonuses);
                if (back == null) continue;
                if (back.spritesheetBundle != ssb) {
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(back.spritesheetBundle);
                    continue;
                }
                m.type.drawBack(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, null, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class BackArmour
    implements UniScreen.ShipLayer {
        final int[][] patch9 = new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockBevelledShader(ssb, ssb2, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            float armourBackFalloff = outside ? 0.1f : 0.25f;
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.type.hidden || t.armour.type == ArmourType.ofName("NONE") || outside && !t.armour.window && t.armour.hp == t.armour.getMaxHP()) continue;
                Appearance app = outside ? (t.armour.type.damagedApps.get(ship.currentBonuses).isEmpty() ? ArmourPlate.noApp : t.armour.type.damagedApps.get(ship.currentBonuses).get(0)) : t.armour.getApp();
                TileMask tileMask = t.module.type.getTileMasks(ship.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
                if (tileMask == TileMask.EMPTY) continue;
                Appearance moduleApp = t.module.type.getApp(ship.currentBonuses);
                if (app.spritesheetBundle != ssb || moduleApp.spritesheetBundle != ssb2) {
                    if (additionalSSBPairs == null) continue;
                    additionalSSBPairs.add((Utils.Pair<SpritesheetBundle, SpritesheetBundle>)new Utils.Pair((Object)app.spritesheetBundle, (Object)moduleApp.spritesheetBundle));
                    continue;
                }
                float brightnessMult = !outside && t.module.burntOut ? 0.2f : 1.0f;
                this.patch9[0][0] = 1;
                this.patch9[0][1] = 1;
                this.patch9[0][2] = 1;
                this.patch9[1][0] = 1;
                this.patch9[1][1] = 1;
                this.patch9[1][2] = 1;
                this.patch9[2][0] = 1;
                this.patch9[2][1] = 1;
                this.patch9[2][2] = 1;
                if (!outside && t.armour.hp == 0) {
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dx = -1; dx < 2; ++dx) {
                            if (dx == 0 || dy == 0) {
                                if (!t.adjacent[dy + 1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)(t.y + dy)).armour.hp != 0) continue;
                                this.patch9[dy + 1][dx + 1] = 0;
                                continue;
                            }
                            if (!t.adjacent[dy + 1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)(t.y + dy)).armour.hp != 0 || (!t.adjacent[dy + 1][1] || ship.tileAt((int)t.x, (int)(t.y + dy)).armour.hp != 0) && (!t.adjacent[1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)t.y).armour.hp != 0)) continue;
                            this.patch9[dy + 1][dx + 1] = 0;
                        }
                    }
                }
                Img mask = t.module.type.getArmourMask(ship.currentBonuses);
                TileMask useTileMask = null;
                int maskX = 0;
                int maskY = 0;
                if (mask != null) {
                    if (Appearance.useSimpleGraphics) {
                        useTileMask = tileMask;
                        if (ship.flipped) {
                            useTileMask = useTileMask.flipped;
                        }
                    }
                    maskX = t.module.type.isFlipped() ? mask.srcX + (t.module.type.getW() - (t.x - t.module.x) - 1) * 16 : mask.srcX + (t.x - t.module.x) * 16;
                    maskY = mask.srcY + (t.y - t.module.y) * 16;
                }
                app.drawBevelled(d, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0, ms, Clr.DARK_GREY, ship.flipped ^ t.module.type.isFlipped(), light, lightStrength * armourBackFalloff * brightnessMult, ambient, ambientSaturation, t.adjacent[0][1] ? 0 : 1, t.adjacent[2][1] ? 0 : 1, t.adjacent[1][t.module.type.isFlipped() ? 2 : 0] ? 0 : 1, t.adjacent[1][t.module.type.isFlipped() ? 0 : 2] ? 0 : 1, true, this.patch9, null, 0.36f, mask != null, maskX, maskY, useTileMask, ssb2);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockBevelledShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class Splinters
    implements UniScreen.ShipLayer {
        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            RotatingShader.lockShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.module.type.isExternal() || !t.module.type.hasGenericDestructionFragments()) continue;
                double tx = x + (double)(ship.gridXToWorldX(t.x, 1) * 16);
                double ty = y + (double)(t.y * 16);
                if (t.splinters == null) {
                    t.splinters = new Img[4];
                    ArrayList<Splinter> splinters = Loadable.all(Splinter.class);
                    t.splinters[0] = splinters.get((int)AGame.ANIM_R.nextInt((int)splinters.size())).img;
                    t.splinters[1] = splinters.get((int)AGame.ANIM_R.nextInt((int)splinters.size())).img;
                    t.splinters[2] = splinters.get((int)AGame.ANIM_R.nextInt((int)splinters.size())).img;
                    t.splinters[3] = splinters.get((int)AGame.ANIM_R.nextInt((int)splinters.size())).img;
                }
                if (!t.adjacent[0][1] && t.hadAdjacentOccupableTile[0][1]) {
                    RotatingShader.draw(ssb, t.splinters[0], d, tx, ty - (double)t.splinters[0].srcHeight, 0.0, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                }
                if (!t.adjacent[2][1] && t.hadAdjacentOccupableTile[2][1]) {
                    RotatingShader.draw(ssb, t.splinters[0], d, tx, ty + 16.0, Math.PI, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                }
                if (!t.adjacent[1][ship.flipped ? 2 : 0] && t.hadAdjacentOccupableTile[1][ship.flipped ? 2 : 0]) {
                    RotatingShader.draw(ssb, t.splinters[0], d, tx - (double)t.splinters[0].srcWidth, ty, 4.71238898038469, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
                }
                if (t.adjacent[1][ship.flipped ? 0 : 2] || !t.hadAdjacentOccupableTile[1][ship.flipped ? 0 : 2]) continue;
                RotatingShader.draw(ssb, t.splinters[0], d, tx + 16.0, ty, 1.5707963267948966, false, light, lightStrength, ambient, ambientSaturation, ambientClr);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class BackExternals
    implements UniScreen.ShipLayer {
        private final int drawPriority;
        private final int drawPriority2;

        public BackExternals(int drawPriority, int drawPriority2) {
            this.drawPriority = drawPriority;
            this.drawPriority2 = drawPriority2;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            Appearance.lockSubShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            if (!outside) {
                int msz = ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = ship.modules.get(mi);
                    if (m.hp <= 0 && !m.type.hasSpecificDestroyedExternalAppearances() || m.type.getExternalDrawPriority() != this.drawPriority && m.type.getExternalDrawPriority() != this.drawPriority2) continue;
                    m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, m.hp < m.maxHP / 2, m.hp <= 0, m.externalPaint == null ? null : m.externalPaint.getPaintType(coa));
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockSubShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }

    public strictfp static class DamagedBackExternals
    implements UniScreen.ShipLayer {
        private final int drawPriority;
        private final int drawPriority2;

        public DamagedBackExternals(int drawPriority, int drawPriority2) {
            this.drawPriority = drawPriority;
            this.drawPriority2 = drawPriority2;
        }

        @Override
        public void lockShader(SpritesheetBundle ssb, SpritesheetBundle ssb2, MyDraw d, double scale, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
            if (ssb.getDamagedVersion() != null) {
                Appearance.lockSubShader(ssb.getDamagedVersion(), d, light, lightStrength, ambient, ambientSaturation);
            } else {
                Appearance.lockSubShader(ssb, d, light, lightStrength, ambient, ambientSaturation);
            }
        }

        @Override
        public void draw(Airship ship, WeatherEffect weather, int side, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, CoatOfArms enemyCOA, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientClr, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
            ship.showingOutside = outside;
            if (outside) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp > 0 || m.type.hasSpecificDestroyedExternalAppearances() || m.type.getExternalDrawPriority() != this.drawPriority && m.type.getExternalDrawPriority() != this.drawPriority2) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, ship.currentBonuses, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs, false, false, m.externalPaint == null ? null : m.externalPaint.getPaintType(coa));
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockSubShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public SpritesheetBundle getBaseSSB() {
            return SpritesheetBundle.ofName("spritesheet");
        }

        @Override
        public SpritesheetBundle getBaseSSB2() {
            return null;
        }

        @Override
        public boolean drawEvenIfShipOutsideCropRect() {
            return false;
        }
    }
}

