/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.DownloadShipsProcess;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UnknownDirectoryException;
import com.zarkonnen.airships.UploadShipProcess;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;

public strictfp class ShipHelperWidget
implements FileScreen.HelperWidget,
ScrollBar.ScrollElementAdapter<String> {
    public final ShipType st;
    private CoatOfArms arms;
    public BonusSet bonuses;
    private Airship refitFrom;
    private final HashMap<String, ShipInfo> ___ships = new HashMap();
    private final LinkedList<String> ___loadQueue = new LinkedList();
    private ArrayList<String> ___loadDirPath;
    private String selection;
    private Airship shipHardRef;
    private int budget;
    private Airship publishShip = null;
    private ArrayList<PublishedItemsManager.Entry> downloadList = null;
    private DownloadShipsProcess dsp = null;
    private DownloadShipsProcess.Progress dspp = null;
    private UploadShipProcess usp = null;
    private UploadShipProcess.Progress uspp = null;
    private boolean needsManualWLA = false;
    private int completeWait = 0;
    private boolean askForDescription = false;
    private PublishedItemsManager.Entry doUpdate = null;
    private final TextField descF = new TextField();
    private final ArrayList<String> selectedTags = new ArrayList();
    private final ScrollBar tagsSB = new ScrollBar();
    private final CoatEditor.IntRect tagsSBRect = new CoatEditor.IntRect();
    private boolean fileScreenUpdateNeeded = false;
    private String dialogMessage = null;
    public ConstructionBackend backend = null;
    private final ShipLoadThread shipLoadThread = new ShipLoadThread();
    public static final ArrayList<String> TAGS = new ArrayList();
    public static final int[] COST_TIERS;
    private static final HashMap<ShipType, ShipHelperWidget> forShipDir;

    private static ArrayList<String> calcTags(Airship ship) {
        ArrayList<String> tags = new ArrayList<String>();
        switch (ship.type) {
            case AIRSHIP: {
                tags.add("Airships");
                break;
            }
            case LANDSHIP: {
                tags.add("Landships");
                break;
            }
            case BUILDING: {
                tags.add("Buildings");
            }
        }
        if (ship.getUsedMods().isEmpty()) {
            tags.add("Vanilla");
        } else {
            tags.add("Modded");
        }
        if (ship.getCost() <= 200) {
            tags.add("$200");
        } else if (ship.getCost() <= 500) {
            tags.add("$500");
        } else if (ship.getCost() <= 1000) {
            tags.add("$1000");
        } else if (ship.getCost() <= 2000) {
            tags.add("$2000");
        } else if (ship.getCost() < 10000) {
            tags.add("$4000+");
        } else {
            tags.add("$10000+");
        }
        return tags;
    }

    private static String listTags(ArrayList<String> tags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            sb.append(tags.get(i));
            if (i == tags.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public int getHeight(String t, MyDraw d, int availableWidth) {
        return MyDraw.BUTTON_H + MyDraw.SCROLL_EL_SPACING;
    }

    @Override
    public void draw(final String t, MyDraw d, int x, int y, int width) {
        d.toggle(x, y, width, t, null, new InputRunnable(){

            @Override
            public void run(Input in) {
                if (ShipHelperWidget.this.selectedTags.contains(t)) {
                    ShipHelperWidget.this.selectedTags.remove(t);
                } else {
                    ShipHelperWidget.this.selectedTags.add(t);
                }
            }
        }, this.selectedTags.contains(t), true);
    }

    public static final void clearAllCaches() {
        for (ShipHelperWidget shw : forShipDir.values()) {
            shw.shipLoadThread.kill = true;
        }
        forShipDir.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShipHelperWidget get(ShipType st, CoatOfArms arms, BonusSet bonuses, Airship refitFrom, int budget) {
        if (forShipDir.containsKey((Object)st)) {
            ShipHelperWidget shw;
            ShipHelperWidget shipHelperWidget = shw = forShipDir.get((Object)st);
            synchronized (shipHelperWidget) {
                if (!shw.bonuses.equals(bonuses) || refitFrom != null && shw.refitFrom != refitFrom) {
                    shw.___ships.clear();
                }
                shw.arms = arms;
                shw.bonuses = bonuses.clone();
                shw.refitFrom = refitFrom;
                shw.budget = budget;
            }
            return shw;
        }
        ShipHelperWidget shw = new ShipHelperWidget(st, arms, bonuses, budget);
        shw.refitFrom = refitFrom;
        forShipDir.put(st, shw);
        Thread t = new Thread(shw.shipLoadThread);
        t.setDaemon(true);
        t.start();
        return shw;
    }

    private ShipHelperWidget(ShipType st, CoatOfArms arms, BonusSet bonuses, int budget) {
        this.st = st;
        this.arms = arms;
        this.bonuses = bonuses.clone();
        this.budget = budget;
        this.descF.multiLine = true;
    }

    @Override
    public boolean popUpdateNeeded() {
        boolean un = this.fileScreenUpdateNeeded;
        this.fileScreenUpdateNeeded = false;
        return un;
    }

    public synchronized ShipInfo getInfo(String shipName) {
        return this.___ships.get(shipName);
    }

    private ShipInfo getShip() {
        if (this.selection == null) {
            return null;
        }
        return this.getShip(this.selection);
    }

    private synchronized ShipInfo getShip(String shipName) {
        ShipInfo si = this.___ships.get(shipName);
        if (si == null) {
            this.___loadQueue.remove(shipName);
            this.___loadQueue.add(0, shipName);
            return null;
        }
        if (!si.loadable) {
            return si;
        }
        Airship ship = (Airship)si.ship.get();
        if (ship == null) {
            ship = this.loadShip(shipName);
            si = this.___ships.get(shipName);
            if (!si.loadable) {
                return si;
            }
            if (ship == null) {
                return null;
            }
            this.shipHardRef = ship;
        }
        return si;
    }

    @Override
    public boolean blocking() {
        return this.askForDescription || this.usp != null;
    }

    @Override
    public void setSelectedFile(List<String> path) {
        this.selection = FileScreen.joinPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms, ArrayList<String> dirPath) {
        this.setLoadDirPath(dirPath);
        ShipHelperWidget shipHelperWidget = this;
        synchronized (shipHelperWidget) {
            this.notifyAll();
        }
        if (this.askForDescription) {
            this.descF.input(in, drawState, cursor, click, ms);
            this.tagsSB.tick(in, this.tagsSBRect.x, this.tagsSBRect.y, this.tagsSBRect.w, this.tagsSBRect.h);
            if (in.keyPressed("ESCAPE")) {
                this.askForDescription = false;
            }
        } else if (this.usp != null) {
            if (this.uspp != null && this.uspp.done) {
                if (this.completeWait == 0) {
                    Analytics.shipUpload(this.st, !this.uspp.failed);
                }
                this.completeWait += ms;
                if (!this.uspp.failed && !this.usp.needsWLA && this.completeWait > 1000) {
                    this.usp = null;
                }
            } else {
                this.uspp = this.usp.tick();
            }
        } else if (this.dsp != null) {
            if (this.dspp != null && this.dspp.done) {
                if (this.dsp.errors.isEmpty()) {
                    this.dsp = null;
                    this.dspp = null;
                    for (PublishedItemsManager.Entry e : this.downloadList) {
                        this.clearCacheFor(FileScreen.splitPath(this.selection));
                    }
                    this.fileScreenUpdateNeeded = true;
                }
            } else {
                this.dspp = this.dsp.tick();
            }
        }
    }

    private ArrayList<String> getTags() {
        ArrayList<String> ts = ShipHelperWidget.calcTags(this.publishShip);
        ts.addAll(this.selectedTags);
        return ts;
    }

    private void startPublishing() {
        this.askForDescription = false;
        this.usp = new UploadShipProcess(this.publishShip, this.descF.getText() + "\n" + this.getUsedModsInfo(true), this.getTags(), this.doUpdate);
        this.uspp = null;
        this.completeWait = 0;
    }

    private void doImportShip(Input in) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_" + (Object)((Object)this.st) + "_to_import", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Import", new Object[0]));
        jfc.setFileFilter(new FF());
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
        }
        if (jfc.showOpenDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            try {
                File dst;
                JSONObject shipJSON = new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8"));
                ShipType shipType = ShipType.valueOf(shipJSON.getString("type"));
                String shipName = shipJSON.getString("name");
                if (shipType != this.st) {
                    this.dialogMessage = Lang._t("different_type_message_" + shipType.name(), new Object[0]);
                }
                if ((dst = new File(new File(AGame.getGameDirectory(), shipType.dirName), shipName + ".json")).exists() && JOptionPane.showConfirmDialog(null, Lang._t("confirm_overwrite_x", shipName), Lang._t("confirm_overwrite", new Object[0]), 0) == 1) {
                    return;
                }
                FileUtils.copyFile((File)f, (File)dst);
                this.fileScreenUpdateNeeded = true;
            }
            catch (Exception e) {
                this.dialogMessage = Lang._t("File_is_not_a_construction", new Object[0]);
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportShip(Input in, Airship ship) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_file_to_export_to", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Export", new Object[0]));
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
            jfc.setSelectedFile(new File(desktopF, ship.getName() + ".json"));
        }
        if (jfc.showSaveDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            BufferedWriter w = null;
            try {
                ship = ship.clone();
                if (f.getName().contains(".")) {
                    ship.setName(f.getName().substring(0, f.getName().lastIndexOf(".")));
                } else {
                    ship.setName(f.getName());
                }
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                w.write(ship.toJSON(null).toString(4));
                w.flush();
            }
            catch (Exception e) {
                this.dialogMessage = Lang._t("Unable_to_save_construction", new Object[0]) + "\n" + e.getMessage();
            }
            finally {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private void syncCurrentShip() {
        PublishedItemsManager.Entry e = PublishedItemsManager.get(this.st.publishedItemType, this.selection.split("[.]json")[0]);
        this.downloadList = new ArrayList();
        this.downloadList.add(e);
        this.dsp = new DownloadShipsProcess(this.downloadList);
    }

    private boolean missingPublisheds() {
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            File f;
            if (e.type != this.st.publishedItemType || (f = this.backend.getFile(FileScreen.splitPath("Steam:/" + e.title))) != null && f.exists()) continue;
            return true;
        }
        return false;
    }

    private void downloadMissingPublisheds() {
        this.downloadList = new ArrayList();
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            if (e.type != this.st.publishedItemType) continue;
            File f = this.backend.getFile(FileScreen.splitPath("Steam:/" + e.title));
            this.downloadList.add(e);
        }
        if (this.downloadList.isEmpty()) {
            return;
        }
        this.dsp = new DownloadShipsProcess(this.downloadList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsedModsInfo(boolean en) {
        JSONArray shipUsedMods;
        if (this.selection == null) {
            return "";
        }
        ShipHelperWidget shipHelperWidget = this;
        synchronized (shipHelperWidget) {
            if (this.___ships.get(this.selection) == null) {
                return "";
            }
            shipUsedMods = this.___ships.get((Object)this.selection).usedMods;
        }
        if (shipUsedMods == null || shipUsedMods.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(en ? "Used mods" : Lang._t("Used_mods", new Object[0])).append(": ");
        for (int i = 0; i < shipUsedMods.length(); ++i) {
            String id = shipUsedMods.getJSONObject(i).getString("id");
            String name = shipUsedMods.getJSONObject(i).getString("en");
            Mod modIfPossible = Mod.getById(id);
            if (modIfPossible != null) {
                name = modIfPossible.getName();
            }
            sb.append(name);
            if (i >= shipUsedMods.length() - 1) continue;
            sb.append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
        Airship ship;
        int oldX = x;
        int oldY = y;
        int oldH = h;
        d.drawPanel(x, y, w, h);
        x += MyDraw.PANEL_INSET;
        y += MyDraw.PANEL_INSET;
        w -= MyDraw.PANEL_INSET * 2;
        h -= MyDraw.PANEL_INSET * 2;
        if (this.usp != null) {
            this.usp.d = d;
        }
        if (this.selection == null) {
            return;
        }
        if (this.backend.isDirectory(FileScreen.splitPath(this.selection))) {
            return;
        }
        ShipInfo si = this.getShip();
        if (si == null) {
            return;
        }
        Airship airship = ship = si.loadable && si.ship != null ? (Airship)si.ship.get() : null;
        if (ship == null) {
            List<String> p = FileScreen.splitPath(this.selection);
            String bestName = p.get(p.size() - 1);
            if (p.get(0).equals("Steam")) {
                bestName = bestName + " [65c0f9]Steam";
            } else if (p.get(0).contains(":")) {
                String modID = p.get(0).substring(0, p.get(0).length() - 1);
                Mod m = Mod.getById(modID);
                String modName = m == null ? modID : m.getName();
                bestName = bestName + " [65c0f9]" + modName;
            }
            d.text(bestName, AGame.BIG_FOUNT, x, y);
            d.text(Lang._t("Unable_to_load_" + this.st.name(), new Object[0]) + "\n" + this.getUsedModsInfo(false), AGame.FOUNT, x, y += AGame.BIG_FOUNT.height, w);
            return;
        }
        StringBuilder info = new StringBuilder();
        for (String s : ShipEditorUtils.shipErrors(ship, false, true, this.budget, this.bonuses, this.refitFrom, null)) {
            info.append("\n").append(s);
        }
        for (String s : ShipEditorUtils.shipWarnings(ship)) {
            info.append("\n").append(s);
        }
        String infoText = this.getUsedModsInfo(false) + info.toString();
        d.text(ship.getName(), AGame.BIG_FOUNT, x, y);
        h -= AGame.BIG_FOUNT.height;
        Rect infoR = d.textSize(infoText, AGame.FOUNT, x, y += AGame.BIG_FOUNT.height, w);
        d.text(infoText, AGame.FOUNT, x, y, w);
        y = (int)((double)y + infoR.height);
        h = (int)((double)h - infoR.height);
        ArrayList<Utils.Pair<String, String>> l = ShipEditorUtils.getStats(ship, this.budget, this.refitFrom);
        int col1W = 0;
        int col2W = 0;
        for (Utils.Pair<String, String> s : l) {
            col1W = StrictMath.max(col1W, (int)d.textSize((String)Lang._t((String)((String)s.a), (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            col2W = StrictMath.max(col2W, (int)d.textSize((String)((String)s.b), (Fount)AGame.FOUNT).x);
        }
        for (Utils.Pair<String, String> s : l) {
            d.text(Lang._t((String)s.a, new Object[0]), AGame.FOUNT, x, y);
            d.text((String)s.b, AGame.FOUNT, x + col1W + col2W - (int)d.textSize((String)((String)s.b), (Fount)AGame.FOUNT).x, y);
            y += AGame.FOUNT.height;
            h -= AGame.FOUNT.height;
        }
        if (AGame.isDebug()) {
            for (Bonus b : ship.getRequiredBonuses().list()) {
                d.text(b.name, AGame.FOUNT, x, y);
                y += AGame.FOUNT.height;
            }
        }
        h -= MyDraw.UI_SPACING;
        int bw = d.bw(Lang._t("Export_to_file", new Object[0]));
        d.button(x, y += MyDraw.UI_SPACING, bw, Lang._t("Export_to_file", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ShipHelperWidget.this.doExportShip(in, ship);
            }
        });
        int x2 = x + bw + MyDraw.BUTTON_SPACING;
        if (SteamBackend.isEnabled() && !this.selection.startsWith("Steam:")) {
            final PublishedItemsManager.Entry e = PublishedItemsManager.get(this.st.publishedItemType, this.selection.split("[.]json")[0]);
            String myT = "Constructions";
            switch (ship.type) {
                case AIRSHIP: {
                    myT = "Airships";
                    break;
                }
                case LANDSHIP: {
                    myT = "Landships";
                    break;
                }
                case BUILDING: {
                    myT = "Buildings";
                }
            }
            if (e == null) {
                bw = d.bw(Lang._t("Publish_to_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Publish_to_Steam", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.descF.setText("");
                        ((ShipHelperWidget)ShipHelperWidget.this).descF.focus = true;
                        ShipHelperWidget.this.selectedTags.clear();
                        ShipHelperWidget.this.askForDescription = true;
                        ShipHelperWidget.this.publishShip = ship;
                        ShipHelperWidget.this.doUpdate = null;
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
            } else {
                bw = d.bw(Lang._t("Update_on_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Update_on_Steam", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.descF.setText(e.description.split("\nUsed mods:")[0]);
                        if (ShipHelperWidget.this.descF.getText().endsWith("\n")) {
                            ShipHelperWidget.this.descF.setText(ShipHelperWidget.this.descF.getText().substring(0, ShipHelperWidget.this.descF.getText().length() - 1));
                        }
                        ((ShipHelperWidget)ShipHelperWidget.this).descF.focus = true;
                        ShipHelperWidget.this.selectedTags.clear();
                        for (int i = 0; i < e.tags.size(); ++i) {
                            if (!TAGS.contains(e.tags.get(i))) continue;
                            ShipHelperWidget.this.selectedTags.add(e.tags.get(i));
                        }
                        ShipHelperWidget.this.askForDescription = true;
                        ShipHelperWidget.this.publishShip = ship;
                        ShipHelperWidget.this.doUpdate = e;
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
                bw = d.bw(Lang._t("Sync_from_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Sync_from_Steam", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.syncCurrentShip();
                    }
                });
            }
        }
        y += MyDraw.BUTTON_H + MyDraw.UI_SPACING;
        h -= MyDraw.BUTTON_H + MyDraw.UI_SPACING;
        if ((h -= MyDraw.PANEL_INSET) < 80) {
            y = oldY + MyDraw.PANEL_INSET + AGame.BIG_FOUNT.height + (int)infoR.height;
            x += col1W + col2W + MyDraw.UI_SPACING;
            h = w -= col1W + col2W + MyDraw.UI_SPACING;
        } else if (w < h) {
            h = w;
        } else {
            x += (w - h) / 2;
            w = h;
        }
        d.drawPanel(x, y, w, h);
        h -= MyDraw.PANEL_INSET * 2;
        d.rect(AGame.SKY, x += MyDraw.PANEL_INSET, y += MyDraw.PANEL_INSET, w -= MyDraw.PANEL_INSET * 2, w);
        double shipW = (double)w * 0.8 * 1.0;
        double scale = StrictMath.min(shipW / (double)ship.getWidth() / 16.0, shipW / (double)ship.getHeight() / 16.0);
        d.shift((double)x + (double)w * 0.1, (double)y + (double)w * 0.1);
        d.scale(scale, scale);
        ship.draw(d, shipW / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), shipW / scale / 2.0 - (double)(ship.getHeight() * 16 / 2), 0, false, false, true, this.arms, true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
        d.resetTransforms();
        double shipX = ((double)x + (double)w * 0.1) / scale + (shipW / scale / 2.0 - (double)(ship.getWidth() * 16 / 2));
        double shipY = ((double)y + (double)w * 0.1) / scale + (shipW / scale / 2.0 - (double)(ship.getHeight() * 16 / 2));
        ship.hookModuleTooltips(d, shipX, shipY, scale);
        bw = d.bw(Lang._t("Import_from_file", new Object[0]));
        d.button(oldX, oldY + oldH + MyDraw.BUTTON_SPACING, bw, Lang._t("Import_from_file", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ShipHelperWidget.this.doImportShip(in);
            }
        });
        if (SteamBackend.isEnabled() && this.missingPublisheds()) {
            d.button(oldX + bw + MyDraw.BUTTON_SPACING, oldY + oldH + MyDraw.BUTTON_SPACING, d.bw(Lang._t("Download_published_items", new Object[0])), Lang._t("Download_published_items", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ShipHelperWidget.this.downloadMissingPublisheds();
                }
            });
        }
        if (this.askForDescription) {
            hs.list.clear();
            w = AGame.FOUNT.displayWidth * 40 + MyDraw.WINDOW_INSET * 2;
            h = sm.height * 3 / 4;
            x = sm.width / 2 - w / 2;
            int origY = y = sm.height / 2 - h / 2;
            int descFH = AGame.FOUNT.lineHeight * 5 + MyDraw.PANEL_INSET * 2;
            d.drawShadowedWindow(x, y, w, h);
            d.text(Lang._t("Enter_a_description", new Object[0]), AGame.BIG_FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET);
            this.descF.render(x, y += AGame.BIG_FOUNT.height + MyDraw.UI_SPACING, w -= MyDraw.WINDOW_INSET * 2, descFH, d, sm, hs, cursor);
            d.text(ShipHelperWidget.listTags(ShipHelperWidget.calcTags(ship)), AGame.FOUNT, x, y += descFH + MyDraw.UI_SPACING, w);
            y = (int)((double)y + (d.textSize((String)ShipHelperWidget.listTags(ShipHelperWidget.calcTags((Airship)ship)), (Fount)AGame.FOUNT, (double)((double)x), (double)((double)y), (int)w).height + (double)MyDraw.UI_SPACING));
            int scrollH = origY + h - y - MyDraw.WINDOW_INSET - MyDraw.BUTTON_H - MyDraw.UI_SPACING;
            this.tagsSBRect.x = x;
            this.tagsSBRect.y = y;
            this.tagsSBRect.w = w;
            this.tagsSBRect.h = scrollH;
            this.tagsSB.draw(d, x, y, w, scrollH, TAGS, this);
            bw = d.bw(Lang._t("OK", new Object[0]));
            d.button((x += w) - bw, y += scrollH + MyDraw.UI_SPACING, bw, Lang._t("OK", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    ShipHelperWidget.this.startPublishing();
                }
            }, !this.descF.getText().isEmpty());
            x -= bw + MyDraw.BUTTON_SPACING;
            bw = d.bw(Lang._t("Cancel", new Object[0]));
            d.button(x - bw, y, bw, Lang._t("Cancel", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    ShipHelperWidget.this.askForDescription = false;
                }
            });
        } else if (this.usp != null) {
            hs.list.clear();
            w = 300 + MyDraw.WINDOW_INSET * 2;
            h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - w / 2;
            y = sm.height / 2 - h / 2;
            d.drawShadowedWindow(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            if (this.uspp != null) {
                d.text(this.uspp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.uspp == null ? 0.0 : 1.0 * (double)this.uspp.progress / (double)StrictMath.max(1, this.uspp.total));
            if (this.uspp != null && this.uspp.failed) {
                d.messageDialog(x, y, 300, this.uspp.desc, new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.usp = null;
                        ShipHelperWidget.this.uspp = null;
                    }
                });
            }
            if (this.uspp != null && this.usp.needsWLA) {
                d.messageDialog(sm.width / 2 - 150, sm.height / 3, 300, Lang._t("Sign_WLA_message", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.usp = null;
                        ShipHelperWidget.this.uspp = null;
                        try {
                            SteamBackend.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + ((ShipHelperWidget)ShipHelperWidget.this).usp.needsWLAId);
                        }
                        catch (Throwable t) {
                            ShipHelperWidget.this.needsManualWLA = true;
                        }
                    }
                });
            }
        } else if (this.needsManualWLA) {
            d.messageDialog(sm.width / 2 - 250, sm.height / 3, 500, Lang._t("Manual_WLA_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ShipHelperWidget.this.needsManualWLA = false;
                }
            });
        } else if (this.dsp != null) {
            hs.list.clear();
            w = Math.max(300, (int)d.textSize((String)this.dspp.desc, (Fount)AGame.FOUNT).x) + MyDraw.WINDOW_INSET * 2;
            h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - w / 2;
            y = sm.height / 2 - h / 2;
            d.drawShadowedWindow(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            w -= MyDraw.WINDOW_INSET * 2;
            if (this.dspp != null) {
                d.text(this.dspp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, w, this.dspp == null ? 0.0 : 1.0 * (double)this.dspp.progress / (double)StrictMath.max(1, this.dspp.total));
            if (this.dspp != null && this.dspp.done && !this.dsp.errors.isEmpty()) {
                d.messageDialog(x, y, w, this.dsp.errors, new Runnable(){

                    @Override
                    public void run() {
                        ShipHelperWidget.this.dsp = null;
                        ShipHelperWidget.this.dspp = null;
                        for (PublishedItemsManager.Entry e : ShipHelperWidget.this.downloadList) {
                            ShipHelperWidget.this.clearCacheFor(FileScreen.splitPath("Steam:/" + e.title));
                        }
                        ShipHelperWidget.this.fileScreenUpdateNeeded = true;
                    }
                });
            }
        } else if (this.dialogMessage != null) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - 150, sm.height / 2 - 100, 300, this.dialogMessage, new Runnable(){

                @Override
                public void run() {
                    ShipHelperWidget.this.dialogMessage = null;
                }
            });
        }
    }

    @Override
    public void close() {
    }

    private synchronized ShipHelperWidget shw() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTick() {
        ArrayList<String> ldp;
        String toLoad = null;
        ShipHelperWidget shipHelperWidget = this;
        synchronized (shipHelperWidget) {
            if (!this.___loadQueue.isEmpty()) {
                toLoad = this.___loadQueue.getFirst();
            }
            ldp = this.___loadDirPath;
        }
        if (this.backend != null && toLoad == null && ldp != null) {
            try {
                List<String> l = this.backend.list(ldp);
                ShipHelperWidget shipHelperWidget2 = this;
                synchronized (shipHelperWidget2) {
                    for (String s : l) {
                        if (this.___ships.containsKey(s)) continue;
                        toLoad = s;
                        break;
                    }
                }
            }
            catch (UnknownDirectoryException unknownDirectoryException) {
                // empty catch block
            }
        }
        if (toLoad != null) {
            this.loadShip(toLoad);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Airship loadShip(String shipPath) {
        Airship ship = null;
        ShipInfo si = new ShipInfo();
        si.filename = shipPath;
        si.loadable = false;
        try {
            File f = this.backend.getFile(FileScreen.splitPath(shipPath));
            JSONObject shipO = new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8"));
            if (shipO.has("usedMods")) {
                si.usedMods = shipO.getJSONArray("usedMods");
            }
            try {
                ship = new Airship(shipO);
                ship.constructionBonuses.clear();
                ship.constructionBonuses.addAll(this.bonuses);
                ship.currentBonuses.clear();
                ship.currentBonuses.addAll(this.bonuses);
                ship.repair();
                si.usedMods = new JSONArray();
                for (Mod m : ship.getUsedMods()) {
                    si.usedMods.put(new JSONObject().put("id", m.id).put("en", m.getIdeallyEnglishName()));
                }
                si.loadable = true;
                si.cost = ship.getCost();
                Airship crf = this.refitFrom;
                if (crf != null) {
                    si.refitCostFrom = crf;
                    si.refitCost = ship.getRefitCostFrom(crf);
                }
                si.buildable = ShipEditorUtils.shipErrors(ship, false, true, 0, this.bonuses, null, null).isEmpty();
                for (Module m : ship.modules) {
                    si.moduleTypes.add(m.type);
                }
                for (Tile t : ship.tiles) {
                    si.armourTypes.add(t.armour.type);
                }
                si.ship = new SoftReference<Airship>(ship);
            }
            catch (Exception e) {
                si.loadable = false;
                si.ship = null;
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            si.loadable = false;
            si.ship = null;
            e.printStackTrace();
        }
        ShipHelperWidget shipHelperWidget = this;
        synchronized (shipHelperWidget) {
            this.___ships.put(shipPath, si);
            this.___loadQueue.remove(shipPath);
        }
        return ship;
    }

    @Override
    public synchronized void clearCacheFor(List<String> path) {
        this.___loadQueue.remove(FileScreen.joinPath(path));
        this.___loadQueue.add(0, FileScreen.joinPath(path));
        this.___ships.remove(FileScreen.joinPath(path));
    }

    public synchronized int cacheSize() {
        return this.___ships.size();
    }

    private synchronized void setLoadDirPath(ArrayList<String> path) {
        this.___loadDirPath = new ArrayList<String>(path);
    }

    static {
        TAGS.add("Small");
        TAGS.add("Corvette");
        TAGS.add("Frigate");
        TAGS.add("Destroyer");
        TAGS.add("Cruiser");
        TAGS.add("Battleship");
        TAGS.add("Flagship");
        TAGS.add("Aircraft Carrier");
        TAGS.add("Large");
        TAGS.add("Boarding");
        TAGS.add("Bomber");
        TAGS.add("Torpedo");
        TAGS.add("Tank");
        TAGS.add("Castle");
        TAGS.add("Pirate");
        TAGS.add("Star Wars");
        TAGS.add("Zeppelin");
        TAGS.add("America");
        TAGS.add("Steampunk");
        TAGS.add("UFO");
        TAGS.add("WW1");
        TAGS.add("WW2");
        TAGS.add("Cheap");
        TAGS.add("Expensive");
        COST_TIERS = new int[]{200, 500, 1000, 2000, 4000, 10000};
        forShipDir = new HashMap();
    }

    private strictfp class ShipLoadThread
    implements Runnable {
        public volatile boolean kill = false;

        private ShipLoadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ShipHelperWidget shipHelperWidget;
            ShipHelperWidget shw;
            Thread.currentThread().setName(ShipHelperWidget.this.st.name() + " loader thread");
            try {
                shipHelperWidget = shw = ShipHelperWidget.this.shw();
                synchronized (shipHelperWidget) {
                    shw.wait(120000L);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return;
            }
            while (!this.kill) {
                for (int i = 0; i < 20; ++i) {
                    ShipHelperWidget.this.loadTick();
                }
                try {
                    shipHelperWidget = shw = ShipHelperWidget.this.shw();
                    synchronized (shipHelperWidget) {
                        shw.wait(120000L);
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return;
                }
            }
        }
    }

    private strictfp class FF
    extends FileFilter {
        private FF() {
        }

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && (file.isDirectory() || file.getName().endsWith(".json"));
        }

        @Override
        public String getDescription() {
            return ".json";
        }
    }

    public strictfp static class ShipInfo {
        public String filename;
        public String name;
        public int cost;
        public int refitCost;
        public Airship refitCostFrom;
        public JSONArray usedMods;
        public HashSet<ModuleType> moduleTypes = new HashSet();
        public HashSet<ArmourType> armourTypes = new HashSet();
        public boolean loadable;
        public boolean buildable;
        private SoftReference<Airship> ship;
    }
}

