/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Img;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class ShipDrawer {
    public static final int BORDER = 80;

    public static void main(String[] args) throws IOException {
        Mod.overriddenEnabledModIds = new ArrayList();
        Loadable.load();
        Airship ship = new Airship(new JSONObject(FileUtils.readFileToString((File)new File(args[0]), (String)"UTF-8")));
        ImageIO.write((RenderedImage)ShipDrawer.drawShip(ship), "PNG", new File(args[1]));
    }

    public static BufferedImage drawShip(Airship ship) {
        int ih;
        int iw;
        int iy;
        Appearance app;
        int my;
        int mx;
        int ih2;
        int iw2;
        int iy2;
        int ix;
        BufferedImage img = new BufferedImage(ship.getWidth() * 16 + 160, ship.getHeight() * 16 + 160, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(new Color(AGame.SKY.r, AGame.SKY.g, AGame.SKY.b));
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.translate(80, 80);
        BufferedImage ss = SpriteUtils.loadBufferedImage("spritesheetDAY");
        for (Module m : ship.modules) {
            for (ExternalApp ea : m.type.getExternalApps(ship.currentBonuses, false, false)) {
                ix = ea.app.frames.get((int)0).srcX;
                iy2 = ea.app.frames.get((int)0).srcY;
                iw2 = ea.app.frames.get((int)0).srcWidth;
                ih2 = ea.app.frames.get((int)0).srcHeight;
                mx = (m.x + ea.dx) * 16;
                my = (m.y + ea.dy) * 16;
                g.drawImage(ss, mx, my, mx + iw2, my + ih2, ix, iy2, ix + iw2, iy2 + ih2, null);
            }
        }
        g.setColor(new Color(17, 15, 13, 180));
        for (Tile t : ship.tiles) {
            app = null;
            if (t.armour.window) {
                app = t.armour.type.windowApp.get(ship.currentBonuses);
            } else if (!t.armour.type.damagedApps.get(ship.currentBonuses).isEmpty()) {
                app = t.armour.type.damagedApps.get(ship.currentBonuses).get(0);
            }
            if (app == null) continue;
            int ix2 = app.frames.get((int)0).srcX;
            iy = app.frames.get((int)0).srcY;
            iw = app.frames.get((int)0).srcWidth;
            ih = app.frames.get((int)0).srcHeight;
            int tx = t.x * 16;
            int ty = t.y * 16;
            g.drawImage(ss, tx, ty, tx + iw, ty + ih, ix2, iy, ix2 + iw, iy + ih, null);
            g.fillRect(tx, ty, 16, 16);
        }
        for (Module m : ship.modules) {
            WeaponAppearance wa = m.type.weaponAppearance(ship.currentBonuses);
            if (wa == null || wa.barrel == null) continue;
            Img bi = wa.barrel;
            ix = bi.srcX;
            iy2 = bi.srcY;
            iw2 = bi.srcWidth;
            ih2 = bi.srcHeight;
            mx = m.x * 16 + (int)wa.barrelOffset.x;
            my = m.y * 16 + (int)wa.barrelOffset.y;
            g.drawImage(ss, mx, my, mx + iw2, my + ih2, ix, iy2, ix + iw2, iy2 + ih2, null);
        }
        for (Module m : ship.modules) {
            app = m.type.getApp(ship.currentBonuses);
            int ix3 = app.frames.get((int)0).srcX;
            iy = app.frames.get((int)0).srcY;
            iw = app.frames.get((int)0).srcWidth;
            ih = app.frames.get((int)0).srcHeight;
            int mx2 = m.x * 16;
            int my2 = m.y * 16;
            g.drawImage(ss, mx2, my2, mx2 + iw, my2 + ih, ix3, iy, ix3 + iw, iy + ih, null);
        }
        return img;
    }
}

