/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Server
implements Runnable {
    public static final int PORT = 29142;
    public static final int RECONNECT_PORT = 29143;
    public static final int HTTP_PORT = 8001;
    public static final int VERSION = 101301;
    public static final int SERVER_TICK = 64;
    public static final int MIN_SLEEP_AMT = 16;
    public static final int SLEEP_INACCURACY_EXPECTATION = 1;
    public static final int GC_INTERVAL = 300000;
    public final Random r = new Random();
    public int idCounter = 1;
    public ArrayList<Channel> channels = new ArrayList();
    public ArrayList<Client> clients = new ArrayList();
    public LinkedList<Reconnector> reconnectors = new LinkedList();
    public AsynchronousServerSocketChannel acceptor;
    public boolean close;
    public Thread startThread;
    public boolean autoGC;
    public volatile boolean setupOrCrashed = false;
    public volatile boolean bindSuccessful = false;
    public LinkedList<JSONObject> globalMessageHistory = new LinkedList();
    public LinkedList<JSONObject> globalMessageHistoryInfos = new LinkedList();
    public static final int GLOBAL_MSG_HISTORY_LENGTH = 8;
    public AsynchronousServerSocketChannel reAcceptor;
    public static int maxNetworkReceiveBytes = 50000;
    public static int maxClients = 40;
    public static int clientRetainTime = 75000;
    public static int clientReadTimeout = 60000;
    public static int clientWriteTimeout = 20000;
    private final ArrayList<String> tickLog = new ArrayList();
    private long activityStart = 0L;
    private String activity;
    volatile int lastNumClients;
    volatile int lastNumChannels;
    volatile int runningReadAvg;
    volatile int runningWriteAvg;
    volatile long lastCheckin;
    private final LinkedList<Integer> readTimeLog = new LinkedList();
    private final LinkedList<Integer> writeTimeLog = new LinkedList();

    public boolean start() {
        this.startThread = new Thread(this);
        this.startThread.start();
        int n = 0;
        while (!this.setupOrCrashed && n++ < 100) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.bindSuccessful;
    }

    public static void main(String[] args) throws Throwable {
        File f = new File("standalone_server_settings.json");
        try {
            if (f.exists()) {
                JSONObject o = new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8"));
                maxNetworkReceiveBytes = o.optInt("maxNetworkReceiveBytes", 50000);
                maxClients = o.optInt("maxClients", 40);
                clientRetainTime = o.optInt("clientRetainTime", 120000);
                clientReadTimeout = o.optInt("clientReadTimeout", 60000);
                clientWriteTimeout = o.optInt("clientWriteTimeout", 20000);
            }
        }
        catch (Exception e) {
            System.err.println(System.currentTimeMillis());
            e.printStackTrace();
        }
        System.out.println(maxClients + " " + maxNetworkReceiveBytes);
        HTTPReporter rep = new HTTPReporter();
        Thread repT = new Thread(rep);
        repT.setDaemon(true);
        repT.start();
        MemoryReporter memRep = new MemoryReporter();
        Thread mrT = new Thread(memRep);
        mrT.setDaemon(true);
        mrT.start();
        while (true) {
            System.out.println("Instancing Server");
            Server s = new Server();
            s.autoGC = true;
            rep.server = s;
            memRep.server = s;
            s.runInternal();
            Runtime.getRuntime().gc();
        }
    }

    public Server() {
        this(new JSONObject().put("name", "Chat").put("isMainChatChannel", true), 0);
    }

    public Server(JSONObject mainChannelInfo, int numPlayers) {
        this.channels.add(new Channel(mainChannelInfo, numPlayers));
    }

    public void log(String msg) {
        System.out.println(System.currentTimeMillis() + " " + msg);
    }

    public void close() {
        this.close = true;
    }

    private void startActivity(String activity) {
        this.activity = activity;
        this.activityStart = System.currentTimeMillis();
    }

    private void endActivity() {
        this.tickLog.add(this.activity + " " + (System.currentTimeMillis() - this.activityStart));
    }

    @Override
    public void run() {
        byte[] reserve = new byte[100000];
        try {
            reserve[0] = 3;
            this.runInternal();
        }
        catch (Throwable t) {
            reserve = null;
            Runtime.getRuntime().gc();
            t.printStackTrace();
            System.err.println("Clients: " + this.clients.size());
            System.err.println("Reconnectors: " + this.reconnectors.size());
        }
    }

    public void removeClient(Client c) {
        this.log("Removing client " + c.id + ".");
        JSONObject removePlayer = new JSONObject();
        removePlayer.put("type", "removePlayer");
        removePlayer.put("id", c.id);
        this.clients.remove(c);
        for (Client cl : this.clients) {
            cl.write(removePlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runInternal() throws Throwable {
        block54: {
            try {
                this.log("Setting up acceptor.");
                this.acceptor = AsynchronousServerSocketChannel.open();
                this.acceptor.bind(new InetSocketAddress(29142));
                this.log("Acceptor set up.");
                this.setupOrCrashed = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.setupOrCrashed = true;
                return;
            }
            try {
                this.log("Setting up reconnect acceptor.");
                this.reAcceptor = AsynchronousServerSocketChannel.open();
                this.reAcceptor.bind(new InetSocketAddress(29143));
                this.log("Reconnect acceptor set up.");
            }
            catch (IOException e) {
                this.log("Reconnect acceptor failed.");
                e.printStackTrace();
                this.reAcceptor = null;
            }
            this.bindSuccessful = true;
            try {
                clientIndex = 0;
                lastDigestSent = System.currentTimeMillis();
                lastTimeGCed = System.currentTimeMillis();
                acceptFuture = null;
                reAcceptFuture = null;
lbl31:
                // 3 sources

                while (!this.close) {
                    this.lastCheckin = System.currentTimeMillis();
                    this.lastNumClients = this.clients.size();
                    this.lastNumChannels = this.channels.size();
                    if (this.readTimeLog.isEmpty()) {
                        this.runningReadAvg = -1;
                    } else {
                        rtAcc = 0;
                        i$ = this.readTimeLog.iterator();
                        while (i$.hasNext()) {
                            rt = (Integer)i$.next();
                            rtAcc += rt;
                        }
                        this.runningReadAvg = rtAcc / this.readTimeLog.size();
                    }
                    if (this.writeTimeLog.isEmpty()) {
                        this.runningWriteAvg = -1;
                    } else {
                        wtAcc = 0;
                        i$ = this.writeTimeLog.iterator();
                        while (i$.hasNext()) {
                            wt = (Integer)i$.next();
                            wtAcc += wt;
                        }
                        this.runningWriteAvg = wtAcc / this.writeTimeLog.size();
                    }
                    if (this.reAcceptor != null) {
                        if (this.reconnectors.size() <= this.clients.size()) {
                            this.startActivity("Accepting reconnects");
                            if (reAcceptFuture == null) {
                                reAcceptFuture = this.reAcceptor.accept();
                            }
                            if (reAcceptFuture.isDone()) {
                                socketChannel = reAcceptFuture.get();
                                this.reconnectors.add(new Reconnector(socketChannel));
                                reAcceptFuture = this.reAcceptor.accept();
                            }
                            this.endActivity();
                        }
                        if (!this.reconnectors.isEmpty()) {
                            this.startActivity("Running reconnectors");
                            it = this.reconnectors.iterator();
                            while (it.hasNext()) {
                                if (!((Reconnector)it.next()).tick()) continue;
                                it.remove();
                            }
                            this.endActivity();
                        }
                    }
                    if (clientIndex < this.clients.size()) ** GOTO lbl135
                    this.startActivity("Accept new clients");
                    try {
                        if (acceptFuture == null) {
                            acceptFuture = this.acceptor.accept();
                        }
                        if (acceptFuture.isDone()) {
                            socketChannel = acceptFuture.get();
                            this.log("Adding new client from " + socketChannel.getRemoteAddress());
                            c = new Client(socketChannel, this.clients.size() + 1 <= Server.maxClients);
                            this.clients.add(c);
                            c.setChannel(this.channels.get(0));
                            acceptFuture = this.acceptor.accept();
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException e) {
                        System.err.println(System.currentTimeMillis());
                        e.printStackTrace();
                        try {
                            this.acceptor.close();
                        }
                        catch (Exception c) {
                            // empty catch block
                        }
                        i$ = this.clients.iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                System.err.println("Done.");
                                System.err.println("Clients: " + this.clients.size());
                                System.err.println("Reconnectors: " + this.reconnectors.size());
                                return;
                            }
                            cl = (Client)i$.next();
                            try {
                                cl.socketChannel.close();
                            }
                            catch (Exception var11_25) {}
                        }
                    }
                }
                break block54;
            }
            catch (Throwable var15_30) {
                try {
                    this.acceptor.close();
                }
                catch (Exception var16_31) {
                    // empty catch block
                }
                i$ = this.clients.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        System.err.println("Done.");
                        System.err.println("Clients: " + this.clients.size());
                        System.err.println("Reconnectors: " + this.reconnectors.size());
                        throw var15_30;
                    }
                    cl = i$.next();
                    try {
                        cl.socketChannel.close();
                    }
                    catch (Exception var18_34) {}
                }
            }
lbl-1000:
            // 1 sources

            {
                block55: {
                    this.endActivity();
                    clientIndex = 0;
                    timeUntilServerTick = lastDigestSent + 64L - System.currentTimeMillis();
                    if (timeUntilServerTick >= 16L) {
                        Thread.sleep(timeUntilServerTick - 1L);
                    }
                    break block55;
lbl135:
                    // 1 sources

                    rStart = System.nanoTime();
                    this.startActivity("Ticking client " + clientIndex);
                    try {
                        this.clients.get(clientIndex).tick();
                        ++clientIndex;
                    }
                    catch (Exception e) {
                        System.err.println(System.currentTimeMillis() + " " + this.clients.get((int)clientIndex).id + " " + this.clients.get((int)clientIndex).playerName);
                        e.printStackTrace();
                        this.removeClient(this.clients.get(clientIndex));
                    }
                    this.endActivity();
                    this.readTimeLog.add((int)(System.nanoTime() - rStart));
                    if (this.readTimeLog.size() > 100) {
                        this.readTimeLog.remove(0);
                    }
                }
                if (System.currentTimeMillis() >= lastDigestSent + 64L) {
                    realTickLength = System.currentTimeMillis() - lastDigestSent;
                    if (realTickLength > 256L) {
                        for (String s : this.tickLog) {
                            System.out.println(s);
                        }
                        System.out.flush();
                    }
                    this.tickLog.clear();
                    wStart = System.nanoTime();
                    it = this.channels.iterator();
                    while (it.hasNext()) {
                        ch = it.next();
                        if (ch.getNumberOfClients() == 0 && ch.id != 0) {
                            this.log("Removing channel " + ch.id + " due to no clients.");
                            it.remove();
                            continue;
                        }
                        this.startActivity("Sending digests to channel " + ch.id);
                        try {
                            ch.sendDigests();
                        }
                        catch (IOException e) {
                            this.log("Removing channel " + ch.id + " due to IO error.");
                            it.remove();
                        }
                        this.endActivity();
                    }
                    lastDigestSent += 64L;
                    this.writeTimeLog.add((int)(System.nanoTime() - wStart));
                    if (this.writeTimeLog.size() > 10) {
                        this.writeTimeLog.remove(0);
                    }
                }
                if (!this.autoGC || System.currentTimeMillis() < lastTimeGCed + 300000L) ** GOTO lbl31
                this.startActivity("GC");
                Runtime.getRuntime().gc();
                this.endActivity();
                lastTimeGCed += 300000L;
                ** GOTO lbl31
            }
        }
        try {
            this.acceptor.close();
        }
        catch (Exception clientIndex) {
            // empty catch block
        }
        i$ = this.clients.iterator();
        while (true) {
            if (!i$.hasNext()) {
                System.err.println("Done.");
                System.err.println("Clients: " + this.clients.size());
                System.err.println("Reconnectors: " + this.reconnectors.size());
                return;
            }
            cl = i$.next();
            try {
                cl.socketChannel.close();
            }
            catch (Exception var3_29) {
            }
        }
    }

    public int getFreeChannelID() {
        int id = 0;
        block0: while (true) {
            for (Channel c : this.channels) {
                if (c.id != id) continue;
                ++id;
                continue block0;
            }
            break;
        }
        return id;
    }

    public int getFreeClientID() {
        block0: while (true) {
            for (Client c : this.clients) {
                if (c.id != this.idCounter) continue;
                ++this.idCounter;
                if (this.idCounter >= 1) continue;
                this.idCounter = 1;
                continue block0;
            }
            break;
        }
        return this.idCounter;
    }

    public strictfp class Reconnector {
        public final AsynchronousSocketChannel socketChannel;
        private ByteBuffer readBuffer = ByteBuffer.allocate(4);
        private int nextMessageSize = -1;
        private Future<Integer> readFuture;
        public String uniqueID;

        public Reconnector(AsynchronousSocketChannel socketChannel) {
            this.socketChannel = socketChannel;
        }

        private boolean processMessage(JSONObject o) {
            if (!o.optString("type", "?").equals("fullReconnect")) {
                Server.this.log("Unexpected message from reconnect: " + o.toString());
                this.close();
                return true;
            }
            this.uniqueID = o.getString("uniqueID");
            Server.this.log("Full reconnector of " + this.uniqueID);
            return false;
        }

        public void close() {
            try {
                Server.this.log("Closing reconnect socket for " + this.socketChannel.getRemoteAddress());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean tick() {
            if (this.uniqueID != null) {
                for (Client c : Server.this.clients) {
                    if (!this.uniqueID.equals(c.uniqueID)) continue;
                    Server.this.log("Full reconnector found client " + c.id + " " + c.playerName);
                    c.fullReconnect(this.socketChannel);
                    return true;
                }
                this.close();
                Server.this.log("No client found for reconnector with " + this.uniqueID);
                return true;
            }
            try {
                if (this.readFuture == null) {
                    this.readBuffer.limit(4);
                    this.readFuture = this.socketChannel.read(this.readBuffer);
                }
                if (this.readFuture.isDone()) {
                    int readAmt = this.readFuture.get();
                    if (readAmt == -1) {
                        this.close();
                        return true;
                    }
                    this.readBuffer.flip();
                    if (this.nextMessageSize == -1 && this.readBuffer.remaining() >= 4) {
                        this.nextMessageSize = this.readBuffer.getInt();
                        if (this.nextMessageSize > maxNetworkReceiveBytes) {
                            throw new RuntimeException("Message size " + this.nextMessageSize + " exceeded limit of " + maxNetworkReceiveBytes + ".");
                        }
                        this.readBuffer = ByteBuffer.allocate(this.nextMessageSize);
                        this.readBuffer.limit(this.nextMessageSize);
                        this.readFuture = this.socketChannel.read(this.readBuffer);
                    } else if (this.nextMessageSize != -1 && this.readBuffer.remaining() >= this.nextMessageSize) {
                        byte[] msgBytes = new byte[this.nextMessageSize];
                        this.readBuffer.get(msgBytes);
                        return this.processMessage(new JSONObject(new String(msgBytes, "UTF-8")));
                    }
                }
            }
            catch (Exception e) {
                this.close();
                return true;
            }
            return false;
        }
    }

    public strictfp class Client {
        public AsynchronousSocketChannel socketChannel;
        private ByteBuffer readBuffer = ByteBuffer.allocate(4096);
        private ByteBuffer writeBuffer = ByteBuffer.allocate(4096);
        private int nextMessageSize = -1;
        private Future<Integer> readFuture;
        private Future<Integer> writeFuture;
        private long readFutureStarted;
        private long writeFutureStarted;
        public int id;
        public String uniqueID;
        public boolean flipped;
        public Channel channel;
        public JSONObject info;
        public boolean sentHistory = false;
        public boolean sentChannelHistory = false;
        private static final int MAX_QUEUE_SIZE = 1000;
        private static final int MIN_TIME_BEFORE_QUEUE_CRASH = 120000;
        private final LinkedList<Utils.Pair<Long, String>> writeMessageQueue = new LinkedList();
        private final LinkedList<Utils.Pair<Long, String>> unAcknowledgedMessages = new LinkedList();
        private boolean removeMe = false;
        private boolean allowed = true;
        private long messageIDCounter = 1L;
        private long mostRecentReceivedMessageID = -1L;
        public boolean retainMeIWillAckMessages;
        public String playerName = "?";
        public long retainTime;
        public Exception retainE;
        public long connectTime = System.currentTimeMillis();

        public void fullReconnect(AsynchronousSocketChannel socketChannel) {
            this.socketChannel = socketChannel;
            this.readBuffer = ByteBuffer.allocate(4096);
            this.writeBuffer = ByteBuffer.allocate(4096);
            this.nextMessageSize = -1;
            this.readFuture = null;
            this.writeFuture = null;
            this.removeMe = false;
            this.retainE = null;
            this.retainTime = 0L;
            this.writeMessageQueue.addAll(0, this.unAcknowledgedMessages);
            this.unAcknowledgedMessages.clear();
            this.connectTime = System.currentTimeMillis();
        }

        public Client(AsynchronousSocketChannel socketChannel, boolean allowed) throws IOException {
            try {
                this.socketChannel = socketChannel;
                this.allowed = allowed;
                this.id = Server.this.getFreeClientID();
                this.uniqueID = this.id + "_" + Server.this.r.nextLong();
                if (!allowed) {
                    this.write(new JSONObject().put("type", "serverReject").put("reason", "full"));
                } else {
                    JSONObject assignID = new JSONObject();
                    assignID.put("type", "assignID");
                    assignID.put("playerID", this.id);
                    assignID.put("uniqueID", this.uniqueID);
                    this.write(assignID);
                    for (Client c : Server.this.clients) {
                        if (c.info == null) continue;
                        JSONObject addPlayer = new JSONObject();
                        addPlayer.put("type", "addPlayer");
                        addPlayer.put("info", c.info);
                        this.write(addPlayer);
                    }
                }
            }
            catch (Exception e) {
                Server.this.log("Closing socket for " + socketChannel.getRemoteAddress());
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }

        public final void setChannel(Channel channel) throws IOException {
            Server.this.log(this.socketChannel.getRemoteAddress() + " changing to channel " + channel.id);
            if (channel.maxNumberOfPlayers != 0 && channel.getNumberOfClients() >= channel.maxNumberOfPlayers) {
                Server.this.log("Rejected because channel is full.");
                this.write(new JSONObject().put("type", "reject").put("channelID", channel.id));
                return;
            }
            if (channel.sealed) {
                Server.this.log("Rejected because channel is sealed.");
                this.write(new JSONObject().put("type", "reject").put("channelID", channel.id));
                return;
            }
            this.channel = channel;
            this.sentChannelHistory = false;
            JSONObject welcome = new JSONObject();
            welcome.put("type", "welcome");
            ArrayList<Client> clients = channel.getClients();
            if (clients.isEmpty()) {
                Server.this.log("Channel without clients during setChannel!");
                this.flipped = false;
            } else if (clients.size() == 1) {
                this.flipped = false;
            } else if (clients.size() >= 2) {
                for (Client c : clients) {
                    if (c == this) continue;
                    this.flipped = !c.flipped;
                }
            }
            welcome.put("flipped", this.flipped);
            welcome.put("version", 101301);
            welcome.put("channelID", channel.id);
            welcome.put("seed", channel.seed);
            welcome.put("info", channel.info);
            welcome.put("playerID", this.id);
            Server.this.log("Sending welcome");
            this.write(welcome);
            Server.this.log("Welcome sent");
        }

        public void write(JSONObject o) {
            long mid = this.messageIDCounter++;
            o.put("###", mid);
            this.writeMessageQueue.add((Utils.Pair<Long, String>)new Utils.Pair((Object)mid, (Object)o.toString()));
        }

        private void processMessage(JSONObject msg) throws IOException {
            long mid;
            String type = msg.optString("type", "-");
            if (msg.has("###")) {
                mid = msg.getLong("###");
                this.writeMessageQueue.add((Utils.Pair<Long, String>)new Utils.Pair(null, (Object)new JSONObject().put("type", "ack").put("mid", mid).toString()));
                if (this.mostRecentReceivedMessageID >= mid) {
                    Server.this.log("Skip");
                    return;
                }
                this.mostRecentReceivedMessageID = mid;
            }
            if (type.equals("changeChannel")) {
                Server.this.log(this.socketChannel.getRemoteAddress() + " changing to channel " + msg.optInt("id", -1));
                for (Channel c : Server.this.channels) {
                    if (c.id != msg.optInt("id", -1)) continue;
                    this.setChannel(c);
                    break;
                }
            } else if (type.equals("hello")) {
                this.info = msg.getJSONObject("info");
                this.info.put("id", this.id);
                JSONObject addPlayer = new JSONObject();
                addPlayer.put("type", "addPlayer");
                addPlayer.put("info", this.info);
                for (Client c : Server.this.clients) {
                    c.write(addPlayer);
                }
            } else if (type.equals("createChannel")) {
                Channel newChannel = new Channel(msg.getJSONObject("info"), msg.optInt("numPlayers", 2));
                Server.this.channels.add(newChannel);
                Server.this.log(this.socketChannel.getRemoteAddress() + " creating channel " + newChannel.id);
                this.setChannel(newChannel);
            } else if (type.equals("listChannels")) {
                JSONObject o = new JSONObject();
                o.put("type", "channelList");
                JSONArray a = new JSONArray();
                o.put("channels", a);
                for (Channel ch : Server.this.channels) {
                    JSONObject info = new JSONObject().put("id", ch.id).put("info", ch.info).put("players", ch.getNumberOfClients()).put("sealed", ch.sealed);
                    a.put(info);
                }
                this.write(o);
            } else if (type.equals("sealChannel")) {
                if (!this.channel.info.optBoolean("isMainChatChannel", false)) {
                    this.channel.sealed = true;
                    Server.this.log(this.socketChannel.getRemoteAddress() + " sealing channel " + this.channel.id);
                }
            } else if (type.equals("ack")) {
                mid = msg.getLong("mid");
                for (int i = 0; i < this.unAcknowledgedMessages.size(); ++i) {
                    if ((Long)this.unAcknowledgedMessages.get((int)i).a > mid) continue;
                    this.unAcknowledgedMessages.remove(i);
                }
            } else if (type.equals("retainMeIWillAckMessages")) {
                this.retainMeIWillAckMessages = true;
                this.playerName = msg.optString("playerName", "?");
            } else if (type.equals("bye")) {
                Server.this.log("Bye received from " + this.id + " " + this.playerName);
                this.retainMeIWillAckMessages = false;
                this.removeMe = true;
            } else if (msg.optBoolean("global", false)) {
                for (Channel c : Server.this.channels) {
                    c.messages.put(msg);
                }
                Server.this.globalMessageHistory.add(msg);
                Server.this.globalMessageHistoryInfos.add(this.info);
                if (Server.this.globalMessageHistory.size() > 8) {
                    Server.this.globalMessageHistory.remove(0);
                    Server.this.globalMessageHistoryInfos.remove(0);
                }
            } else {
                this.channel.messages.put(msg);
                if (msg.optBoolean("storeAsHistory", false)) {
                    this.channel.newMessageHistory.put(msg);
                }
            }
        }

        public void tick() throws Exception {
            if (this.retainE != null) {
                if (this.retainTime + (long)clientRetainTime < System.currentTimeMillis()) {
                    throw this.retainE;
                }
                return;
            }
            try {
                long now = System.currentTimeMillis();
                if (!this.retainMeIWillAckMessages) {
                    this.unAcknowledgedMessages.clear();
                } else if (this.connectTime + 120000L < now && this.unAcknowledgedMessages.size() > 1000) {
                    throw new RuntimeException("Unacknowledged message queue size of " + this.unAcknowledgedMessages.size() + " exceeds max of " + 1000);
                }
                if (this.connectTime + 120000L < now && this.writeMessageQueue.size() > 1000) {
                    throw new RuntimeException("Write message queue size of " + this.writeMessageQueue.size() + " exceeds max of " + 1000);
                }
                if (this.removeMe) {
                    throw new RuntimeException("Remove me!");
                }
                if (this.writeFuture != null) {
                    if (this.writeFuture.isDone()) {
                        this.writeFuture.get();
                        this.writeFuture = null;
                        if (this.writeBuffer.hasRemaining()) {
                            this.socketChannel.write(this.writeBuffer);
                        } else {
                            if (!this.allowed) {
                                this.retainMeIWillAckMessages = false;
                                throw new RuntimeException("Disallowed");
                            }
                            if (this.writeBuffer.capacity() > 4096) {
                                this.writeBuffer = ByteBuffer.allocate(4096);
                            }
                        }
                    } else if (this.writeFutureStarted + (long)clientWriteTimeout < now && this.retainMeIWillAckMessages) {
                        throw new RuntimeException("Write timeout.");
                    }
                }
                if (this.writeFuture == null && !this.writeMessageQueue.isEmpty()) {
                    Utils.Pair<Long, String> mp = this.writeMessageQueue.pollFirst();
                    if (this.retainMeIWillAckMessages && mp.a != null) {
                        this.unAcknowledgedMessages.add(mp);
                    }
                    byte[] msg = ((String)mp.b).getBytes("UTF-8");
                    if (this.writeBuffer.capacity() < msg.length + 4) {
                        this.writeBuffer = ByteBuffer.allocate(msg.length + 4 + 128);
                    }
                    this.writeBuffer.clear();
                    this.writeBuffer.putInt(msg.length);
                    this.writeBuffer.put(msg);
                    this.writeBuffer.flip();
                    this.writeFuture = this.socketChannel.write(this.writeBuffer);
                    this.writeFutureStarted = now;
                }
                if (this.readFuture == null) {
                    this.readFuture = this.socketChannel.read(this.readBuffer);
                    this.readFutureStarted = now;
                }
                if (this.readFuture != null) {
                    if (this.readFuture.isDone()) {
                        ByteBuffer rb2;
                        int readAmt = this.readFuture.get();
                        if (readAmt == -1) {
                            this.removeMe = true;
                        }
                        this.readBuffer.flip();
                        boolean progress = true;
                        while (progress) {
                            progress = false;
                            if (this.nextMessageSize == -1 && this.readBuffer.remaining() >= 4) {
                                progress = true;
                                this.nextMessageSize = this.readBuffer.getInt();
                                if (this.nextMessageSize > maxNetworkReceiveBytes) {
                                    throw new RuntimeException("Message size " + this.nextMessageSize + " exceeded limit of " + maxNetworkReceiveBytes + ".");
                                }
                                if (this.nextMessageSize > this.readBuffer.capacity()) {
                                    rb2 = ByteBuffer.allocate(this.nextMessageSize + 8);
                                    rb2.put(this.readBuffer);
                                    this.readBuffer = rb2;
                                    this.readBuffer.flip();
                                }
                            }
                            if (this.nextMessageSize == -1 || this.readBuffer.remaining() < this.nextMessageSize) continue;
                            progress = true;
                            byte[] msgBytes = new byte[this.nextMessageSize];
                            this.readBuffer.get(msgBytes);
                            this.processMessage(new JSONObject(new String(msgBytes, "UTF-8")));
                            this.nextMessageSize = -1;
                            if (this.readBuffer.remaining() < 4) continue;
                            this.nextMessageSize = this.readBuffer.getInt();
                            if (this.nextMessageSize <= this.readBuffer.capacity()) continue;
                            ByteBuffer rb22 = ByteBuffer.allocate(this.nextMessageSize + 8);
                            rb22.put(this.readBuffer);
                            this.readBuffer = rb22;
                            this.readBuffer.flip();
                        }
                        if (this.readBuffer.capacity() > 4096 && this.nextMessageSize <= 4096) {
                            rb2 = ByteBuffer.allocate(4096);
                            rb2.put(this.readBuffer);
                            this.readBuffer = rb2;
                            this.readBuffer.flip();
                        }
                        this.readBuffer.compact();
                        if (this.nextMessageSize != -1) {
                            this.readBuffer.limit(this.nextMessageSize);
                        } else {
                            this.readBuffer.limit(4);
                        }
                        this.readFuture = this.socketChannel.read(this.readBuffer);
                        this.readFutureStarted = now;
                    } else if (this.readFutureStarted + (long)clientReadTimeout < now && this.retainMeIWillAckMessages) {
                        throw new RuntimeException("Read timeout.");
                    }
                }
            }
            catch (Exception e) {
                Server.this.log("Closing socket for " + this.socketChannel.getRemoteAddress() + " " + this.id + " " + this.playerName);
                try {
                    this.socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.retainMeIWillAckMessages) {
                    this.retainE = e;
                    Server.this.log("Retaining client " + this.id + " " + this.playerName);
                    this.retainTime = System.currentTimeMillis();
                }
                throw e;
            }
        }
    }

    public strictfp class Channel {
        public final int id;
        public final JSONObject info;
        public final int maxNumberOfPlayers;
        public int frameNumber = 0;
        public final long seed;
        public final JSONArray messages;
        public final JSONArray newMessageHistory;
        public final JSONArray messageHistory;
        public boolean sealed;

        public Channel(JSONObject info, int maxNumberOfPlayers) {
            this.seed = Server.this.r.nextLong();
            this.messages = new JSONArray();
            this.newMessageHistory = new JSONArray();
            this.messageHistory = new JSONArray();
            this.sealed = false;
            this.id = Server.this.getFreeChannelID();
            this.info = info;
            this.maxNumberOfPlayers = maxNumberOfPlayers;
        }

        public int getNumberOfClients() {
            int n = 0;
            for (Client cl : Server.this.clients) {
                if (cl.channel != this) continue;
                ++n;
            }
            return n;
        }

        public ArrayList<Client> getClients() {
            ArrayList<Client> myClients = new ArrayList<Client>();
            for (Client cl : Server.this.clients) {
                if (cl.channel != this) continue;
                myClients.add(cl);
            }
            return myClients;
        }

        public void sendDigests() throws IOException {
            JSONObject frame = new JSONObject();
            frame.put("type", "frame");
            frame.put("channelID", this.id);
            frame.put("frameNumber", this.frameNumber);
            frame.put("messages", this.messages);
            JSONArray members = new JSONArray();
            frame.put("members", members);
            ArrayList<Client> myClients = this.getClients();
            for (Client c : myClients) {
                members.put(c.id);
            }
            JSONObject globalHistoryFrame = null;
            JSONObject channelHistoryFrame = null;
            JSONObject bothHistoryFrame = null;
            for (Client c : myClients) {
                JSONObject h;
                int i;
                JSONArray historyMessages;
                if (!c.sentHistory && !c.sentChannelHistory && bothHistoryFrame == null) {
                    bothHistoryFrame = new JSONObject();
                    bothHistoryFrame.put("type", "frame");
                    bothHistoryFrame.put("historyFrame", "both");
                    bothHistoryFrame.put("channelID", this.id);
                    bothHistoryFrame.put("frameNumber", this.frameNumber);
                    historyMessages = new JSONArray();
                    for (i = 0; i < Server.this.globalMessageHistory.size(); ++i) {
                        h = Server.this.globalMessageHistory.get(i);
                        h.put("historyInfo", Server.this.globalMessageHistoryInfos.get(i));
                        historyMessages.put(h);
                    }
                    for (i = 0; i < this.messageHistory.length(); ++i) {
                        historyMessages.put(this.messageHistory.get(i));
                    }
                    for (i = 0; i < this.messages.length(); ++i) {
                        historyMessages.put(this.messages.get(i));
                    }
                    bothHistoryFrame.put("messages", historyMessages);
                    bothHistoryFrame.put("members", members);
                } else if (!c.sentHistory && c.sentChannelHistory && globalHistoryFrame == null) {
                    globalHistoryFrame = new JSONObject();
                    globalHistoryFrame.put("type", "frame");
                    globalHistoryFrame.put("historyFrame", "global");
                    globalHistoryFrame.put("channelID", this.id);
                    globalHistoryFrame.put("frameNumber", this.frameNumber);
                    historyMessages = new JSONArray();
                    for (i = 0; i < Server.this.globalMessageHistory.size(); ++i) {
                        h = Server.this.globalMessageHistory.get(i);
                        h.put("historyInfo", Server.this.globalMessageHistoryInfos.get(i));
                        historyMessages.put(h);
                    }
                    for (i = 0; i < this.messages.length(); ++i) {
                        historyMessages.put(this.messages.get(i));
                    }
                    globalHistoryFrame.put("messages", historyMessages);
                    globalHistoryFrame.put("members", members);
                } else if (c.sentHistory && !c.sentChannelHistory && channelHistoryFrame == null) {
                    channelHistoryFrame = new JSONObject();
                    channelHistoryFrame.put("type", "frame");
                    channelHistoryFrame.put("historyFrame", "channel");
                    channelHistoryFrame.put("channelID", this.id);
                    channelHistoryFrame.put("frameNumber", this.frameNumber);
                    historyMessages = new JSONArray();
                    for (i = 0; i < this.messageHistory.length(); ++i) {
                        historyMessages.put(this.messageHistory.get(i));
                    }
                    for (i = 0; i < this.messages.length(); ++i) {
                        historyMessages.put(this.messages.get(i));
                    }
                    channelHistoryFrame.put("messages", historyMessages);
                    channelHistoryFrame.put("members", members);
                }
                if (!c.sentHistory && !c.sentChannelHistory) {
                    c.write(bothHistoryFrame);
                } else if (!c.sentHistory && c.sentChannelHistory) {
                    c.write(globalHistoryFrame);
                } else if (c.sentHistory && !c.sentChannelHistory) {
                    c.write(channelHistoryFrame);
                } else {
                    c.write(frame);
                }
                c.sentHistory = true;
                c.sentChannelHistory = true;
            }
            while (this.messages.length() > 0) {
                this.messages.remove(this.messages.length() - 1);
            }
            while (this.newMessageHistory.length() > 0) {
                this.messageHistory.put(this.newMessageHistory.get(0));
                this.newMessageHistory.remove(0);
            }
            ++this.frameNumber;
        }
    }

    private strictfp static class HTTPReporter
    implements Runnable {
        public Server server;

        private HTTPReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ServerSocket httpSock = null;
                try {
                    try {
                        httpSock = new ServerSocket(8001);
                        while (true) {
                            Socket s = httpSock.accept();
                            String info = this.server == null ? "{}" : new JSONObject().put("version", 101301).put("clients", this.server.lastNumClients).put("channels", this.server.lastNumChannels).put("readAvgNs", this.server.runningReadAvg).put("writeAvgNs", this.server.runningWriteAvg).put("alive", System.currentTimeMillis() - this.server.lastCheckin < 5000L).toString();
                            PrintWriter w = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), "UTF-8"));
                            w.println("HTTP/1.0 200");
                            w.println("Content-type: application/json");
                            w.println("Server-name: Airships MP Server v101301");
                            w.println("Content-length: " + info.length());
                            w.println();
                            w.println(info);
                            w.flush();
                            w.close();
                            s.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println(System.currentTimeMillis());
                        e.printStackTrace();
                        try {
                            httpSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        httpSock.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private strictfp static class MemoryReporter
    implements Runnable {
        public Server server;

        private MemoryReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                PrintStream ps = null;
                try {
                    int histories = 0;
                    if (this.server != null) {
                        for (Channel c : this.server.channels) {
                            histories += c.messageHistory.length() + c.newMessageHistory.length();
                        }
                    }
                    ps = new PrintStream((OutputStream)new FileOutputStream(new File("memlog.txt"), true), true, "UTF-8");
                    ps.println(System.currentTimeMillis() + ", " + 101301 + ", free, " + Runtime.getRuntime().freeMemory() + ", max, " + Runtime.getRuntime().maxMemory() + ", total, " + Runtime.getRuntime().totalMemory() + ", clients, " + (this.server == null ? 0 : this.server.clients.size()) + ", channels, " + (this.server == null ? 0 : this.server.channels.size()) + ", reconnectors, " + (this.server == null ? 0 : this.server.reconnectors.size()) + ", histories, " + histories);
                }
                catch (Exception e) {
                    System.err.println(System.currentTimeMillis());
                    e.printStackTrace();
                }
                finally {
                    try {
                        ps.flush();
                        ps.close();
                    }
                    catch (Exception e) {
                        System.err.println(System.currentTimeMillis());
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(System.currentTimeMillis());
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

