/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ViewCityIntent;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class SelectionGroupsFloat
implements UniScreen.InfoPanel {
    private final ArrayList<ArrayList<Airship>> selectionGroups = new ArrayList();
    public static final int N_GROUPS = 5;
    private boolean highlightGroups = false;
    private int highlightGroupNumber = 0;
    private int highlightTime = 0;

    public SelectionGroupsFloat() {
        for (int i = 0; i < 5; ++i) {
            this.selectionGroups.add(new ArrayList());
        }
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (us.intent instanceof DefencesIntent || us.intent instanceof EspionageIntent || us.intent instanceof ViewCityIntent || us.intent instanceof EditShipIntent || us.intent instanceof EditMissionIntent) {
            return;
        }
        if (us.tool != UniScreen.NAVIGATE || !this.highlightGroups && this.highlightTime <= 0) {
            return;
        }
        if (us.mySide == null) {
            return;
        }
        int totalW = sm.width - MyDraw.SIDE_CLEARANCE * 2 - MyDraw.UI_SPACING * 4;
        int groupW = totalW / 5;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int x = MyDraw.SIDE_CLEARANCE;
        d.heavilyBorderedText(Lang._t("Selection_groups_info", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.WHITE, Clr.BLACK, x, y, sm.width);
        y += AGame.FOUNT.height + MyDraw.UI_SPACING;
        for (int i = 0; i < 5; ++i) {
            if (this.highlightGroups || this.highlightGroupNumber == i && this.highlightTime > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(Lang._t("Group_x", i + 1)).append("\n");
                boolean empty = true;
                for (Airship s : this.selectionGroups.get(i)) {
                    if (!us.mySide.ships.contains(s)) continue;
                    sb.append("\n").append(s.getName());
                    empty = false;
                }
                if (empty) {
                    sb.append("\n").append(Lang._t("_empty_", new Object[0]));
                }
                int innerW = groupW - 2 * MyDraw.PANEL_INSET;
                int innerH = (int)d.textSize((String)sb.toString(), (Fount)AGame.FOUNT, (double)((double)x), (double)((double)y), (int)innerW).height;
                int groupH = innerH + 2 * MyDraw.PANEL_INSET;
                d.drawPanel(x, y, groupW, groupH);
                d.text(sb.toString(), AGame.FOUNT, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, innerW);
            }
            x += groupW + MyDraw.UI_SPACING;
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.highlightGroups = false;
        this.highlightTime -= ms;
        if (us.intent instanceof DefencesIntent || us.intent instanceof EspionageIntent || us.intent instanceof ViewCityIntent || us.intent instanceof EditShipIntent || us.intent instanceof EditMissionIntent) {
            return;
        }
        if (us.mySide == null) {
            return;
        }
        if (us.tool == UniScreen.NAVIGATE && !us.textInputOccurring()) {
            this.highlightGroups = in.keyDown("LCONTROL") || in.keyDown("RCONTROL");
            for (int i = 0; i < 5; ++i) {
                if (in.keyPressed("" + (i + 1))) {
                    ArrayList<Airship> group = this.selectionGroups.get(i);
                    this.highlightGroupNumber = i;
                    this.highlightTime = 1000;
                    if (this.highlightGroups) {
                        group.clear();
                        if (us.selectedShip != null) {
                            group.add(us.selectedShip);
                        } else {
                            group.addAll(us.selectedShips);
                        }
                        in.play("ready", 0.8, us.g.volume, 0.0, 0.0);
                    } else if (!group.isEmpty()) {
                        ArrayList<Airship> available = new ArrayList<Airship>();
                        for (Airship s : group) {
                            if (!us.mySide.ships.contains(s)) continue;
                            available.add(s);
                        }
                        if (!available.isEmpty()) {
                            us.selectedShip = null;
                            us.selectedShips.clear();
                            us.selectedLF = null;
                            if (available.size() == 1) {
                                us.selectedShip = (Airship)available.get(0);
                            } else {
                                us.selectedShips.addAll(available);
                            }
                            in.play("ready", 1.2, us.g.volume, 0.0, 0.0);
                        }
                    }
                }
                if (!in.keyDown("" + (i + 1))) continue;
                this.highlightGroupNumber = i;
                this.highlightTime = StrictMath.max(this.highlightTime, 50);
            }
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

