/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class ScrapShipButton
extends UniScreen.ShipButton {
    @Override
    public boolean visible(Airship ship, Combat.Side side, UniScreen us) {
        return us.intent instanceof DefencesIntent && (!us.city.isTown || !ship.type.mobile);
    }

    @Override
    public String text(Airship ship, Combat.Side side, UniScreen us) {
        return Lang._t("Scrap", new Object[0]);
    }

    @Override
    public void click(Input in, Airship ship, Combat.Side side, UniScreen us) {
        us.confirmDialog = new ScrapConfirmDialog(ship);
    }

    public strictfp static class ScrapConfirmDialog
    implements ConfirmDialog {
        public Airship ship;

        public ScrapConfirmDialog(Airship ship) {
            this.ship = ship;
        }

        public int getValue() {
            return this.ship.getCost() / 8;
        }

        @Override
        public String text() {
            return Lang._t("Scrap_x_for_y_gold", this.ship.getName(), this.getValue());
        }

        @Override
        public String okText() {
            return Lang._t("OK", new Object[0]);
        }

        @Override
        public String cancelText() {
            return Lang._t("Cancel", new Object[0]);
        }

        @Override
        public void ok(UniScreen us) {
            us.cw.giveCommand(us.cw.shipMsg("scrapShip", this.ship).put("empire", us.cw.player.id));
            us.confirmDialog = null;
        }

        @Override
        public void cancel(UniScreen us) {
            us.confirmDialog = null;
        }
    }
}

