/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.JSONFileBackend;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionCombatIntent;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SaveCombatButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.combat != null && !AGame.isDemo() && !(us.intent instanceof PlaybackIntent) && !(us.intent instanceof EditMissionIntent) && !(us.intent instanceof MissionCombatIntent) && !(us.intent instanceof MultiplayerCombatIntent) && !(us.intent instanceof MultiplayerSetupIntent) && !(us.intent instanceof ChallengeCombatIntent);
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Save", new Object[0]);
    }

    @Override
    public void click(Input in, final UniScreen us) {
        final JSONFileBackend jfb = new JSONFileBackend(new File(AGame.getGameDirectory(), "combats"));
        us.g.s = new FileScreen(jfb, new FileScreen.Mission(){

            @Override
            public FileScreen.Mode mode() {
                return FileScreen.Mode.SAVE;
            }

            @Override
            public String text() {
                return Lang._t("Save_combat", new Object[0]);
            }

            @Override
            public String initialInput() {
                String side0 = "Ships";
                if (us.combat.sides.get((int)0).ships.size() == 1) {
                    side0 = us.combat.sides.get((int)0).ships.get(0).getName();
                } else if (us.combat.sides.get((int)0).ships.size() == 2) {
                    side0 = us.combat.sides.get((int)0).ships.get(0).getName() + " + " + us.combat.sides.get((int)0).ships.get(1).getName();
                } else if (us.combat.sides.get((int)0).ships.size() > 0) {
                    side0 = us.combat.sides.get((int)0).ships.get(0).getName() + " etc.";
                }
                String side1 = "Ships";
                if (us.combat.sides.get((int)1).ships.size() == 1) {
                    side1 = us.combat.sides.get((int)1).ships.get(0).getName();
                } else if (us.combat.sides.get((int)1).ships.size() == 2) {
                    side1 = us.combat.sides.get((int)1).ships.get(0).getName() + " + " + us.combat.sides.get((int)1).ships.get(1).getName();
                } else if (us.combat.sides.get((int)1).ships.size() > 0) {
                    side1 = us.combat.sides.get((int)1).ships.get(0).getName() + " etc.";
                }
                return side0 + " vs " + side1;
            }

            @Override
            public String fileSelectionText() {
                return Lang._t("Save", new Object[0]);
            }

            @Override
            public void fileSelected(String path) {
                File f = jfb.getFile(FileScreen.splitPath(path));
                f.getParentFile().mkdirs();
                try {
                    JSONObject combatJSON = us.combat.toJSON();
                    if (us.intent instanceof SingleCombatSetupIntent) {
                        combatJSON.put("_setup_inSetup", true);
                        combatJSON.put("_setup_aiQuality", ((SingleCombatSetupIntent)us.intent).ai.name());
                    }
                    JSONArray mods = new JSONArray();
                    for (Mod m : Mod.getEnabledMods()) {
                        mods.put(new JSONObject().put("id", m.id).put("name", m.getName()));
                    }
                    combatJSON.put("mods", mods);
                    FileUtils.writeStringToFile((File)f, (String)combatJSON.toString(4), (String)"UTF-8");
                }
                catch (Exception e) {
                    long space = -1L;
                    try {
                        space = FileSystemUtils.freeSpaceKb((String)f.getAbsolutePath(), (long)3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (space != -1L && space < 10240L) {
                        us.g.showError(Lang._t("Insufficient_space_on_disk", new Object[0]));
                    }
                    us.g.showError(Lang._t("Unable_to_save_combat", new Object[0]));
                }
                us.g.s = us;
            }

            @Override
            public void cancelled() {
                us.g.s = us;
            }
        }, null, new FileScreen.NoInfo(jfb), "combats");
    }
}

