/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class RotatingColoringShader {
    private static ShaderProgram lsp;
    public static boolean shaderLoadFailed;
    public static boolean shaderLocked;

    public static void lockShader(SpritesheetBundle ssb, Draw d, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (ssb.bumpTex == null) {
            light = null;
        }
        if (ssb.getTex(Appearance.currentPostfix) == null) {
            return;
        }
        if (shaderLoadFailed || light == null || Appearance.useSimpleGraphics) {
            return;
        }
        if (lsp == null) {
            try {
                lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/rotated_sub_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/rotated_sub_litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        lsp.bind();
        lsp.setUniform1f("strength", lightStrength);
        lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
        lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
        lsp.setUniform4f("ambient", ambient);
        lsp.setUniform1f("ambientSaturation", ambientSaturation);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)ssb.bumpTex.getTextureID());
        lsp.setUniform1i("bump", 1);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
        lsp.setUniform1i("lightFromLeft", 2);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
        lsp.setUniform1i("lightFromTop", 3);
        GL13.glActiveTexture((int)33988);
        GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
        lsp.setUniform1i("lightFromRight", 4);
        GL13.glActiveTexture((int)33989);
        GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
        lsp.setUniform1i("lightFromBottom", 5);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ssb.getTex(Appearance.currentPostfix).getTextureID());
        lsp.setUniform1i("tex", 0);
        lsp.enableVertexAttribute("flipped");
        lsp.enableVertexAttribute("angle");
        lsp.enableVertexAttribute("srcA");
        lsp.enableVertexAttribute("trgA");
        lsp.enableVertexAttribute("srcB");
        lsp.enableVertexAttribute("trgB");
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        shaderLocked = true;
    }

    public static void unlockShader() {
        if (shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            lsp.unbind();
            TextureImpl.bindNone();
            shaderLocked = false;
        }
    }

    public static void draw(SpritesheetBundle ssb, Img img, Draw d, double x, double y, double angle, double scale, boolean flipped, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint, float[] srcA, float[] trgA, float[] srcB, float[] trgB) {
        if (Appearance.shaderLocked || Appearance.subShaderLocked || Appearance.bevelledLocked || RotatingShader.shaderLocked) {
            AirshipGame.instance.reportError("RotatingColoringShader.draw mis-lock Appearance.shaderLocked=" + Appearance.shaderLocked + " Appearance.subShaderLocked=" + Appearance.subShaderLocked + " Appearance.bevelledLocked=" + Appearance.bevelledLocked + " RotatingShader.shaderLocked=" + RotatingShader.shaderLocked + " RotatingColoringShader.shaderLocked=" + shaderLocked, null, null, false, true);
        }
        if (ssb.bumpTex == null) {
            light = null;
        }
        if (shaderLoadFailed || Appearance.useSimpleGraphics || light == null || ssb.getTex(Appearance.currentPostfix) == null) {
            if (ssb.getTex(Appearance.currentPostfix) != null) {
                img = new Img(img.src + Appearance.currentPostfix, img.srcX, img.srcY, img.srcWidth, img.srcHeight, img.flipped);
            }
            d.blit(img, ambientTint, x, y, (double)img.srcWidth * scale, (double)img.srcHeight * scale, angle);
            if (img.machineImgCache != null) {
                ((Image)img.machineImgCache).setFilter(9728);
            }
            return;
        }
        if (lsp == null) {
            try {
                lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/rotated_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/rotated_litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        if (!shaderLocked) {
            lsp.bind();
            lsp.setUniform1f("strength", lightStrength);
            lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            lsp.setUniform4f("ambient", ambient);
            lsp.setUniform1f("ambientSaturation", ambientSaturation);
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)ssb.bumpTex.getTextureID());
            lsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            lsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            lsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            lsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            lsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(Appearance.currentPostfix).getTextureID());
            lsp.setUniform1i("tex", 0);
            lsp.enableVertexAttribute("flipped");
            lsp.enableVertexAttribute("angle");
            lsp.enableVertexAttribute("srcA");
            lsp.enableVertexAttribute("trgA");
            lsp.enableVertexAttribute("srcB");
            lsp.enableVertexAttribute("trgB");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        double w = (double)img.srcWidth * scale;
        double h = (double)img.srcHeight * scale;
        GL20.glVertexAttrib1f((int)lsp.getAttributeID("flipped"), (float)(flipped ? 1.0f : 0.0f));
        GL20.glVertexAttrib1f((int)lsp.getAttributeID("angle"), (float)((float)angle));
        GL20.glVertexAttrib3f((int)lsp.getAttributeID("srcA"), (float)srcA[0], (float)srcA[1], (float)srcA[2]);
        GL20.glVertexAttrib3f((int)lsp.getAttributeID("trgA"), (float)trgA[0], (float)trgA[1], (float)trgA[2]);
        GL20.glVertexAttrib3f((int)lsp.getAttributeID("srcB"), (float)srcB[0], (float)srcB[1], (float)srcB[2]);
        GL20.glVertexAttrib3f((int)lsp.getAttributeID("trgB"), (float)trgB[0], (float)trgB[1], (float)trgB[2]);
        if (!shaderLocked) {
            GL11.glBegin((int)7);
        }
        double cos = StrictMath.cos(angle);
        double sin = StrictMath.sin(angle);
        double w2 = w * 0.5;
        double h2 = h * 0.5;
        double x2 = x + w2;
        double y2 = y + h2;
        double topLeftX = x2 - w2 * cos + h2 * sin;
        double topLeftY = y2 - w2 * sin - h2 * cos;
        double bottomLeftX = x2 - w2 * cos - h2 * sin;
        double bottomLeftY = y2 - w2 * sin + h2 * cos;
        double bottomRightX = x2 + w2 * cos - h2 * sin;
        double bottomRightY = y2 + w2 * sin + h2 * cos;
        double topRightX = x2 + w2 * cos + h2 * sin;
        double topRightY = y2 + w2 * sin - h2 * cos;
        if (img.flipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)topRightX, (double)topRightY);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomRightX, (double)bottomRightY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomLeftX, (double)bottomLeftY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)topLeftX, (double)topLeftY);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)topLeftX, (double)topLeftY);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomLeftX, (double)bottomLeftY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomRightX, (double)bottomRightY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)topRightX, (double)topRightY);
        }
        if (!shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            lsp.unbind();
            TextureImpl.bindNone();
        }
    }

    static {
        shaderLoadFailed = false;
        shaderLocked = false;
    }
}

