/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.FBOGraphicsFactory;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LaunchSettings;
import com.zarkonnen.airships.LoadingScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.lwjgl.opengl.Display;

public strictfp class ResChooserScreen
implements Screen,
ScrollBar.ScrollElementAdapter<ScreenMode> {
    private final AirshipGame g;
    private ScreenMode preferred;
    private boolean autoChoosePreferred;
    private boolean autoChoosePreferredStartup;
    private int autoChooseTimeout = 1200;
    private final ScrollBar modeSB = new ScrollBar();
    private final ArrayList<ScreenMode> modes = new ArrayList();
    private int tickN;
    private int drawN = 0;
    private boolean modesScrolledTo = false;

    private void log(String text) {
        if (this.tickN < 3 || this.drawN < 3) {
            System.err.println("rcs t " + this.tickN + " d " + this.drawN + ": " + text);
        }
    }

    public ResChooserScreen(AirshipGame g) {
        this.g = g;
        System.err.println("Init ResChooserScreen");
    }

    private void checkForFBO() {
        try {
            if (!FBOGraphicsFactory.init()) {
                Appearance.canUseLighting = false;
                Appearance.useLighting = false;
            }
        }
        catch (Throwable e) {
            this.g.reportError("Can't check for FBO", new RuntimeException(e), null, false);
            Appearance.canUseLighting = false;
            Appearance.useLighting = false;
        }
    }

    public static Utils.Pair<ScreenMode, ArrayList<ScreenMode>> getModes(Input in) {
        ScreenMode preferred = null;
        ArrayList<ScreenMode> modes = new ArrayList<ScreenMode>();
        try {
            preferred = new ScreenMode(AirshipGame.PREFS.getInt("screenModeW", 800), AirshipGame.PREFS.getInt("screenModeH", 600), AirshipGame.PREFS.getBoolean("screenModeF", false), AirshipGame.PREFS.getBoolean("screenModeFW", false));
        }
        catch (Exception e) {
            AirshipGame.instance.reportError(Lang._t("Unable_to_load_prefs", new Object[0]), e, null, false);
        }
        ArrayList cands = in.modes();
        ScreenMode biggest = null;
        boolean preferredAllowed = preferred != null && !preferred.fullscreen;
        for (ScreenMode c : cands) {
            if (preferred != null && c.width == preferred.width && c.height == preferred.height && c.fullscreen == preferred.fullscreen) {
                preferredAllowed = true;
            }
            if (!c.fullscreen || c.width < 800 || c.height < 480 || modes.contains(c)) continue;
            modes.add(c);
            if (biggest != null && biggest.width * biggest.height >= c.width * c.height) continue;
            biggest = c;
        }
        if (!preferredAllowed) {
            preferred = null;
        }
        Collections.sort(modes, new Comparator<ScreenMode>(){

            @Override
            public int compare(ScreenMode t, ScreenMode t1) {
                if (t.width == t1.width) {
                    return t1.height - t.height;
                }
                return t1.width - t.width;
            }
        });
        if (biggest != null) {
            modes.add(0, new ScreenMode(biggest.width, biggest.height, false, true));
        }
        modes.add(0, new ScreenMode(800, 600, false));
        modes.add(0, new ScreenMode(1024, 768, false));
        if (biggest != null && preferred == null) {
            preferred = biggest;
        }
        return new Utils.Pair((Object)preferred, modes);
    }

    private void pickPreferred(Input in, MyDraw.State drawState) {
        this.conditionalFBOCHeck();
        System.err.println("Setting new mode " + this.preferred);
        in.setMode(this.preferred);
        System.err.println("Mode set complete");
        AirshipGame.PREFS.putBoolean("autoChoosePreferredScreenMode", this.autoChoosePreferred);
        try {
            AirshipGame.PREFS.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.g.s = new LoadingScreen(this.g);
        drawState.hasClicked();
        System.err.println("Loading screen inited");
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (LaunchSettings.useCustomWindow) {
            this.log("Using custom window.");
            Appearance.useSimpleGraphics = LaunchSettings.customWindowUseSimpleGraphics;
            this.conditionalFBOCHeck();
            ScreenMode sm = new ScreenMode(LaunchSettings.customWindowW, LaunchSettings.customWindowH, LaunchSettings.customWindowFullscreen);
            this.log("Setting new mode " + sm);
            in.setMode(sm);
            this.log("Mode set complete. Setting window location.");
            Display.setLocation((int)LaunchSettings.customWindowX, (int)LaunchSettings.customWindowY);
            this.log("Window position set complete.");
            this.g.s = new LoadingScreen(this.g);
            drawState.hasClicked();
            System.err.println("Loading screen inited");
            return;
        }
        if (this.modes.isEmpty()) {
            this.log("Getting modes.");
            Utils.Pair<ScreenMode, ArrayList<ScreenMode>> pms = ResChooserScreen.getModes(in);
            this.preferred = (ScreenMode)pms.a;
            this.modes.addAll((Collection)pms.b);
            this.autoChoosePreferredStartup = this.autoChoosePreferred = AirshipGame.PREFS.getBoolean("autoChoosePreferredScreenMode", false);
            this.log("Got modes.");
        }
        if (this.autoChoosePreferredStartup && this.preferred != null) {
            this.autoChooseTimeout -= ms;
            if (this.autoChooseTimeout <= 0) {
                this.pickPreferred(in, drawState);
                return;
            }
            if (in.lastKeyPressed() != null || in.mouseDown() != null) {
                this.autoChoosePreferredStartup = false;
            }
            return;
        }
        if (in.keyDown("ENTER") && this.preferred != null) {
            this.log("Enter pressed.");
            this.pickPreferred(in, drawState);
            return;
        }
        if (in.keyPressed("Q") || in.keyPressed("ESCAPE")) {
            this.g.exit = true;
            this.log("Exiting");
        }
        int y = MyDraw.SIDE_CLEARANCE + 64 + AGame.BIG_FOUNT.lineHeight + MyDraw.UI_SPACING;
        int x = in.mode().width / 2 - 110;
        this.modeSB.tick(in, x, y, 250, 250);
        this.log("Done ticking.");
        ++this.tickN;
    }

    public static String mToString(ScreenMode m) {
        return m.fullscreen ? Lang._t("resolution_format_fullscreen", m.width, m.height) : (m.fullscreenWindow ? Lang._t("resolution_format_fullscreen_window", m.width, m.height) : Lang._t("resolution_format", m.width, m.height));
    }

    private void conditionalFBOCHeck() {
        if (!Appearance.useSimpleGraphics) {
            System.err.println("Checking for FBO");
            this.checkForFBO();
            System.err.println("Done checking for FBO");
        } else {
            System.err.println("Disabling FBO");
            Appearance.canUseLighting = false;
            Appearance.useLighting = false;
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        this.log("Done drawBG");
        int x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.SIDE_CLEARANCE;
        d.text(MyDraw.TITLE_C + "AIRSHIPS", AGame.HUGE_FOUNT, x, y);
        d.text(MyDraw.TITLE_C + Lang._t("a_game_by_david_stark", new Object[0]) + "\nv" + "1.0.13.1", AGame.BIG_FOUNT, x, y += 64);
        y += AGame.BIG_FOUNT.lineHeight;
        y += MyDraw.UI_SPACING;
        if (this.autoChoosePreferredStartup && this.preferred != null) {
            d.text(MyDraw.TITLE_C + Lang._t("auto_choose_notice", new Object[0]), AGame.FOUNT, sm.width / 2 - (int)d.textSize((String)Lang._t((String)"auto_choose_notice", (Object[])new Object[0]), (Fount)AGame.FOUNT).x / 2, sm.height / 3);
            return;
        }
        int w = 0;
        for (ScreenMode m : this.modes) {
            w = StrictMath.max(w, d.bw(ResChooserScreen.mToString(m), "ENTER"));
        }
        w += ScrollBar.SCROLL_BAR_W + MyDraw.PANEL_INSET * 2;
        w = StrictMath.max(w, d.tw(Lang._t("Graphics_compatibility_mode", new Object[0])));
        w = StrictMath.max(w, d.tw(Lang._t("Load_without_mods", new Object[0])));
        w = StrictMath.max(w, d.bw(Lang._t("Quit", new Object[0])));
        x = sm.width / 2 - w / 2;
        this.log("Drawing SMs");
        if (!this.modesScrolledTo && this.preferred != null) {
            this.modeSB.scrollTo(false, d, x, y, w, 220, this.modes, this, this.preferred);
            this.modesScrolledTo = true;
        }
        this.modeSB.draw(d, x, y, w, 220, this.modes, this);
        this.log("Drawing buttons.");
        d.toggle(x, y += 220 + MyDraw.UI_SPACING, w, Lang._t("Auto_choose_res", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ResChooserScreen.this.autoChoosePreferred = !ResChooserScreen.this.autoChoosePreferred;
            }
        }, this.autoChoosePreferred, true);
        d.tooltip((double)x, (double)y, (double)w, (double)MyDraw.BUTTON_H, Lang._t("auto_choose_res_tooltip", new Object[0]));
        d.toggle(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, w, Lang._t("Start_without_mods", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ((ResChooserScreen)ResChooserScreen.this).g.disableAllModsOnStartup = !((ResChooserScreen)ResChooserScreen.this).g.disableAllModsOnStartup;
            }
        }, this.g.disableAllModsOnStartup, true);
        d.tooltip((double)x, (double)y, (double)w, (double)MyDraw.BUTTON_H, Lang._t("start_without_mods_tooltip", new Object[0]));
        d.toggle(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, w, Lang._t("Graphics_compatibility_mode", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useSimpleGraphics = !Appearance.useSimpleGraphics;
            }
        }, Appearance.useSimpleGraphics, true);
        d.tooltip((double)x, (double)y, (double)w, (double)MyDraw.BUTTON_H, Lang._t("gfx_compat_tooltip", new Object[0]));
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.UI_SPACING, w, Lang._t("Quit", new Object[0]), "Q", new InputRunnable(){

            @Override
            public void run(Input in) {
                System.err.println("RCS quit");
                ((ResChooserScreen)ResChooserScreen.this).g.exit = true;
            }
        });
        this.log("Done drawing.");
        ++this.drawN;
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    @Override
    public int getHeight(ScreenMode t, MyDraw d, int availableWidth) {
        return MyDraw.BUTTON_H + MyDraw.SCROLL_EL_SPACING;
    }

    @Override
    public void draw(final ScreenMode m, MyDraw d, int x, int y, int width) {
        d.button(x, y, width, ResChooserScreen.mToString(m), this.preferred.equals((Object)m) ? "ENTER" : null, new InputRunnable(){

            @Override
            public void run(Input in) {
                System.err.println("RCS choose");
                try {
                    AirshipGame.PREFS.putInt("screenModeW", m.width);
                    AirshipGame.PREFS.putInt("screenModeH", m.height);
                    AirshipGame.PREFS.putBoolean("screenModeF", m.fullscreen);
                    AirshipGame.PREFS.putBoolean("screenModeFW", m.fullscreenWindow);
                    AirshipGame.PREFS.putBoolean("autoChoosePreferredScreenMode", ResChooserScreen.this.autoChoosePreferred);
                    AirshipGame.PREFS.flush();
                }
                catch (Exception e) {
                    ResChooserScreen.this.g.reportError("Unable to save prefs", e, null, false);
                }
                ResChooserScreen.this.conditionalFBOCHeck();
                System.err.println("Setting new mode " + m);
                in.setMode(m);
                System.err.println("Mode set complete");
                ((ResChooserScreen)ResChooserScreen.this).g.s = new LoadingScreen(ResChooserScreen.this.g);
                System.err.println("Loading screen inited");
            }
        });
    }
}

