/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.JSONFileBackend;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONObject;

public strictfp class RecordingHelperWidget
implements FileScreen.HelperWidget,
FileScreen.Filter {
    public final JSONFileBackend backend;
    public List<String> selectedFile;
    public Recording.Header selectedHeader;
    public final HashMap<String, Recording.Header> headerCache = new HashMap();
    private boolean updateNeeded = true;

    public RecordingHelperWidget(JSONFileBackend backend) {
        this.backend = backend;
    }

    @Override
    public void setSelectedFile(List<String> path) {
        this.selectedFile = path;
        this.selectedHeader = null;
        this.selectedHeader = this.headerCache.get(FileScreen.joinPath(path));
    }

    @Override
    public void clearCacheFor(List<String> path) {
        this.headerCache.remove(FileScreen.joinPath(path));
        if (path.equals(this.selectedFile)) {
            this.selectedHeader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms, ArrayList<String> dirPath) {
        List<String> toRead = null;
        if (this.selectedHeader == null && this.selectedFile != null) {
            toRead = this.selectedFile;
        } else {
            List<String> children = this.backend.list(dirPath);
            for (String c : children) {
                List<String> cp;
                if (this.headerCache.containsKey(c) || this.backend.isDirectory(cp = FileScreen.splitPath(c))) continue;
                toRead = cp;
                break;
            }
        }
        if (toRead == null) {
            return;
        }
        File f = this.backend.getRawFile(toRead);
        if (f == null || !f.exists()) {
            return;
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            Recording.Header h = new Recording.Header(new JSONObject(r.readLine()));
            if (toRead.equals(this.selectedFile)) {
                this.selectedHeader = h;
            }
            this.headerCache.put(FileScreen.joinPath(toRead), h);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
        if (this.selectedHeader == null) {
            return;
        }
        d.drawPanel(x, y, w, h);
        h -= MyDraw.PANEL_INSET * 2;
        int top = y += MyDraw.PANEL_INSET;
        Rect sz = d.textSize(this.selectedHeader.getName(), AGame.BIGGER_FOUNT, x += MyDraw.PANEL_INSET, y, w -= MyDraw.PANEL_INSET * 2);
        d.text(this.selectedHeader.getName(), AGame.BIGGER_FOUNT, x, y, w);
        y = (int)((double)y + (sz.height + (double)MyDraw.UI_SPACING));
        if (this.selectedHeader.version != 101301) {
            sz = d.textSize(Lang._t("Recording_outdated", this.selectedHeader.gameVersion), AGame.FOUNT, x, y, w);
            d.text(MyDraw.ERROR_C + Lang._t("Recording_outdated", this.selectedHeader.gameVersion), AGame.FOUNT, x, y, w);
            y = (int)((double)y + (sz.height + (double)MyDraw.UI_SPACING));
        }
        d.text(this.selectedHeader.timestamp.toString(DateTimeFormat.patternForStyle((String)"MS", (Locale)Lang.currentLocale)), AGame.FOUNT, x, y);
        String timeS = Recording.ticksToTime(this.selectedHeader.numTicks);
        d.text(timeS, AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.UI_SPACING);
        y += AGame.FOUNT.height + MyDraw.UI_SPACING;
        final Recording.Header hdr = this.selectedHeader;
        y = top + h - MyDraw.BUTTON_H;
        int bw = d.bw(Lang._t("Export", new Object[0]));
        d.button(x, y, bw, Lang._t("Export", new Object[0]), new InputRunnable(){

            @Override
            public void run(Input in) {
                RecordingHelperWidget.this.doExportRecording(in, RecordingHelperWidget.this.backend.getRawFile(RecordingHelperWidget.this.selectedFile), hdr);
            }
        });
        x += bw + MyDraw.BUTTON_SPACING;
        bw = d.bw(Lang._t("Import", new Object[0]));
        d.button(x, y, bw, Lang._t("Import", new Object[0]), new InputRunnable(){

            @Override
            public void run(Input in) {
                RecordingHelperWidget.this.doImportRecording(in);
            }
        });
    }

    @Override
    public void close() {
    }

    @Override
    public boolean blocking() {
        return false;
    }

    @Override
    public boolean popUpdateNeeded() {
        if (this.updateNeeded) {
            this.updateNeeded = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean retain(String path) {
        Recording.Header h = this.headerCache.get(path);
        return h != null && h.version == 101301;
    }

    private void doImportRecording(Input in) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_recording_to_import", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Import", new Object[0]));
        jfc.setFileFilter(new FF());
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
        }
        if (jfc.showOpenDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            try {
                File dst = new File(new File(AGame.getGameDirectory(), "recordings"), f.getName());
                if (dst.exists() && JOptionPane.showConfirmDialog(null, Lang._t("confirm_overwrite_x", f.getName()), Lang._t("confirm_overwrite", new Object[0]), 0) == 1) {
                    return;
                }
                FileUtils.copyFile((File)f, (File)dst);
                this.updateNeeded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private void doExportRecording(Input in, File srcF, Recording.Header srcH) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_file_to_export_to", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Export", new Object[0]));
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
            String name = AGame.makeFileSafe(srcH.getName());
            name = name.isEmpty() ? srcF.getName() : name + ".json";
            jfc.setSelectedFile(new File(desktopF, name));
        }
        if (jfc.showSaveDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            try {
                FileUtils.copyFile((File)srcF, (File)f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private strictfp class FF
    extends FileFilter {
        private FF() {
        }

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && (file.isDirectory() || file.getName().endsWith(".json"));
        }

        @Override
        public String getDescription() {
            return ".json";
        }
    }
}

