/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import org.joda.time.LocalDateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Recording
implements JSONAble {
    public int version = 0;
    public JSONObject initialCombat;
    public ArrayList<Utils.Pair<Long, JSONArray>> tickCommands = new ArrayList();
    public ArrayList<String> tickCombats = new ArrayList();
    public HashMap<Integer, Integer> tickHashes = new HashMap();
    public Header header = new Header();

    public static String ticksToTime(int numTicks) {
        int lengthHours = numTicks / 216000;
        int lengthMinutes = numTicks % 216000 / 3600;
        int lengthSeconds = numTicks % 3600 / 60;
        String timeS = "" + lengthSeconds;
        if (timeS.length() == 1) {
            timeS = "0" + timeS;
        }
        if ((timeS = lengthMinutes + ":" + timeS).length() == 4) {
            timeS = "0" + timeS;
        }
        if (lengthHours > 0) {
            timeS = lengthHours + ":" + timeS;
        }
        return timeS;
    }

    public boolean compatible() {
        return this.version == 101301;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("formatVersion", 1).put("version", this.version).put("combat", this.initialCombat);
        JSONArray a = new JSONArray();
        for (Utils.Pair<Long, JSONArray> t : this.tickCommands) {
            a.put(new JSONObject().put("mid", t.a).put("commands", t.b));
        }
        o.put("tickCommands", a);
        JSONArray th = new JSONArray();
        for (Integer key : this.tickHashes.keySet()) {
            th.put(key);
            th.put(this.tickHashes.get(key).longValue());
        }
        o.put("tickHashes", th);
        JSONArray cs = new JSONArray();
        for (String tc : this.tickCombats) {
            cs.put(tc);
        }
        o.put("tickCombats", cs);
        return o;
    }

    public Recording() {
        this.version = 101301;
    }

    public Recording(JSONObject headerO, JSONObject o) {
        this.header = new Header(headerO);
        if (o.getInt("formatVersion") == 1) {
            this.version = o.getInt("version");
            if (this.version == 101301) {
                this.initialCombat = o.getJSONObject("combat");
                JSONArray a = o.getJSONArray("tickCommands");
                for (int i = 0; i < a.length(); ++i) {
                    JSONObject entry = a.getJSONObject(i);
                    this.tickCommands.add((Utils.Pair<Long, JSONArray>)new Utils.Pair((Object)entry.getLong("mid"), (Object)entry.getJSONArray("commands")));
                }
                JSONArray th = o.getJSONArray("tickHashes");
                for (int i = 0; i < th.length(); i += 2) {
                    this.tickHashes.put(th.getInt(i), th.getInt(i + 1));
                }
                JSONArray cs = o.getJSONArray("tickCombats");
                for (int i = 0; i < cs.length(); ++i) {
                    this.tickCombats.add(cs.getString(i));
                }
            }
        }
    }

    public strictfp static class Header {
        public Type type = Type.SINGLE_COMBAT;
        public String placeName;
        public int numTicks = 0;
        public ArrayList<SideInfo> sides = new ArrayList();
        public LocalDateTime timestamp = LocalDateTime.now();
        public int version = 101301;
        public String gameVersion = "1.0.13.1";

        public JSONObject toJSON() {
            JSONObject o = new JSONObject().put("type", this.type.name()).put("numTicks", this.numTicks).put("headerVersion", 1).put("timestamp", this.timestamp.toString()).put("version", this.version).put("gameVersion", this.gameVersion);
            if (this.placeName != null) {
                o.put("placeName", this.placeName);
            }
            JSONArray sa = new JSONArray();
            o.put("sides", sa);
            for (SideInfo si : this.sides) {
                JSONObject so = new JSONObject();
                so.put("name", si.name);
                JSONArray na = new JSONArray();
                so.put("shipNames", na);
                for (String n : si.shipNames) {
                    na.put(n);
                }
                sa.put(so);
            }
            return o;
        }

        public String getName() {
            String n;
            if (this.type == Type.STRATEGIC && this.placeName != null) {
                n = this.sides.get((int)0).name + " vs " + this.sides.get((int)1).name + ", " + this.placeName;
            } else if (this.placeName != null) {
                n = this.placeName;
            } else if (this.type == Type.MULTIPLAYER) {
                n = this.sides.get((int)0).name + " vs " + this.sides.get((int)1).name;
            } else {
                String side0 = "Ships";
                if (this.sides.get((int)0).shipNames.size() == 1) {
                    side0 = this.sides.get((int)0).shipNames.get(0);
                } else if (this.sides.get((int)0).shipNames.size() == 2) {
                    side0 = this.sides.get((int)0).shipNames.get(0) + " + " + this.sides.get((int)0).shipNames.get(1);
                } else if (this.sides.get((int)0).shipNames.size() > 0) {
                    side0 = this.sides.get((int)0).shipNames.get(0) + " etc.";
                }
                String side1 = "Ships";
                if (this.sides.get((int)1).shipNames.size() == 1) {
                    side1 = this.sides.get((int)1).shipNames.get(0);
                } else if (this.sides.get((int)1).shipNames.size() == 2) {
                    side1 = this.sides.get((int)1).shipNames.get(0) + " + " + this.sides.get((int)1).shipNames.get(1);
                } else if (this.sides.get((int)1).shipNames.size() > 0) {
                    side1 = this.sides.get((int)1).shipNames.get(0) + " etc.";
                }
                n = side0 + " vs " + side1;
            }
            return n;
        }

        public Header() {
        }

        public void extractSideInfo(Combat c) {
            for (Combat.Side s : c.sides) {
                SideInfo si = new SideInfo();
                si.name = s.getName();
                this.sides.add(si);
                for (Airship as : s.ships) {
                    si.shipNames.add(as.getName());
                }
            }
        }

        public Header(JSONObject o) {
            if (o.optInt("headerVersion", -1) != 1) {
                throw new RuntimeException("Unknown recording header version: " + (o.has("version") ? Integer.valueOf(o.getInt("version")) : "?"));
            }
            this.type = Type.valueOf(o.getString("type"));
            this.numTicks = o.getInt("numTicks");
            this.placeName = o.optString("placeName", null);
            this.timestamp = LocalDateTime.parse((String)o.getString("timestamp"));
            this.version = o.optInt("version", 0);
            this.gameVersion = o.optString("gameVersion", "?");
            JSONArray sa = o.getJSONArray("sides");
            for (int i = 0; i < sa.length(); ++i) {
                JSONObject so = sa.getJSONObject(i);
                SideInfo si = new SideInfo();
                this.sides.add(si);
                si.name = so.getString("name");
                JSONArray na = so.getJSONArray("shipNames");
                for (int j = 0; j < na.length(); ++j) {
                    si.shipNames.add(na.getString(j));
                }
            }
        }

        public strictfp static enum Type {
            SINGLE_COMBAT,
            STRATEGIC,
            MULTIPLAYER,
            MISSION,
            TUTORIAL;

        }

        public strictfp static class SideInfo {
            public String name;
            public ArrayList<String> shipNames = new ArrayList();
        }
    }
}

