/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.ShipHelperWidget;
import java.util.List;

public strictfp class PriceInlineInfo
implements FileScreen.InlineInfo {
    private final ShipHelperWidget shw;
    private final Airship refittingFrom;

    public PriceInlineInfo(ShipHelperWidget shw, Airship refittingFrom) {
        this.shw = shw;
        this.refittingFrom = refittingFrom;
    }

    @Override
    public int width() {
        return 6;
    }

    @Override
    public String info(String filename) {
        ShipHelperWidget.ShipInfo si = this.shw.getInfo(filename);
        if (si == null || !si.loadable) {
            return "";
        }
        if (this.refittingFrom == null) {
            return "$" + si.cost;
        }
        return "$" + si.refitCost;
    }

    @Override
    public String displayName(String path) {
        List<String> pathBits = FileScreen.splitPath(path);
        String base = pathBits.get(0);
        String name = pathBits.get(pathBits.size() - 1);
        if (name.endsWith(".json")) {
            name = name.substring(0, name.length() - ".json".length());
        }
        if (path.equals("Steam:")) {
            return "Steam";
        }
        if (path.startsWith("Steam:")) {
            return name.split("-", 3)[2];
        }
        if (base.contains(":") && pathBits.size() == 1) {
            String modID = base.substring(0, base.length() - 1);
            Mod m = Mod.getById(modID);
            String modName = m == null ? modID : m.getName();
            return modName;
        }
        PublishedItemsManager.Entry e = PublishedItemsManager.get(this.shw.st.publishedItemType, path.split("[.]json")[0]);
        if (e != null) {
            return name + " [65c0f9]" + Lang._t("Published", new Object[0]);
        }
        return name;
    }
}

