/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.elliotkroo.GifSequenceWriter;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.LaunchSettings;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.ScreenMode;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.filechooser.FileSystemView;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class PlaybackIntent
extends CombatIntent {
    public int fastForwardTo = -1;
    public double originalVolume = 0.0;
    public static final int FAST_FORWARD_TICK_TICKS = 100;
    public int takeGifUntil = -1;
    public GifSequenceWriter gsw = null;
    public ByteArrayOutputStream baos = new ByteArrayOutputStream();
    public MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(this.baos);
    public File gf;
    public MyDraw mostRecentDraw;
    public ScreenMode mostRecentScreenMode;
    public Image frameImg;
    public BufferedImage frameBufferedImage;
    public BufferedImage frameBufferedImageScaledDown;
    private boolean firstFrameDrawn = false;
    public int drawUpdates = 0;
    public static final int GIF_TICK_MS = 32;
    public boolean slowMo = false;
    public boolean scaledown = false;
    public String savedTo = "";
    public int savedToCooldown = 0;
    public int desyncFrom = -1;

    public boolean hasDiverged(UniScreen us) {
        int currentHash;
        int originalHash;
        if (this.desyncFrom != -1 && us.combat.playbackIndex >= this.desyncFrom) {
            return true;
        }
        if (us.combat.playback.tickHashes.containsKey(us.combat.time) && (originalHash = us.combat.playback.tickHashes.get(us.combat.time).intValue()) != (currentHash = us.combat.cheapHash())) {
            this.desyncFrom = us.combat.playbackIndex;
            return true;
        }
        return false;
    }

    public void skipTo(UniScreen us, int playbackIndex) {
        if (us.combat.playbackIndex > playbackIndex) {
            Recording p = us.combat.playback;
            us.combat = new Combat(us.g, p.initialCombat);
            us.combat.recording = null;
            us.combat.playback = p;
            us.selectedShip = null;
            us.selectedShips.clear();
            us.combat.resetMoveTos = true;
            us.combat.physics = null;
            us.combat.repairAllShips();
            us.combat.initWheelsLegsTentaclesAndBarrels();
            us.mySide = us.combat.sides.get(0);
        }
        this.originalVolume = us.g.volume;
        us.g.volume = 0.0;
        this.fastForwardTo = playbackIndex;
    }

    public void takeGif(UniScreen us, boolean slowMo, boolean scaledown) {
        this.slowMo = slowMo;
        this.scaledown = scaledown;
        this.savedToCooldown = 0;
        File f = null;
        if (LaunchSettings.customGIFSaveDirectoryLocation != null && !(f = new File(LaunchSettings.customGIFSaveDirectoryLocation)).exists()) {
            f.mkdirs();
        }
        try {
            if (f == null || !f.exists() || !f.isDirectory()) {
                f = new File(FileSystemView.getFileSystemView().getHomeDirectory(), "Desktop");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (f == null || !f.exists() || !f.isDirectory()) {
                f = FileSystemView.getFileSystemView().getHomeDirectory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (f == null || !f.exists() || !f.isDirectory()) {
                f = new File(AGame.getStaticGameDirectory(), "gifs");
                f.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        try {
            String name = AGame.makeFileSafe(us.combat.playback.header.getName() + " " + Recording.ticksToTime(us.combat.playbackIndex).replace(":", "_"));
            this.gf = new File(f, name + ".gif");
            if (this.gf.exists()) {
                int n = 2;
                do {
                    this.gf = new File(f, name + " " + n++ + ".gif");
                } while (this.gf.exists());
            }
            this.savedTo = this.gf.getAbsolutePath().replace("\\", "/");
            this.baos = new ByteArrayOutputStream();
            this.mcios = new MemoryCacheImageOutputStream(this.baos);
            this.gsw = new GifSequenceWriter(this.mcios, 1, slowMo ? 64 : 32, true);
            us.hideUI = true;
            this.takeGifUntil = us.combat.playback.tickCommands.size();
            this.frameImg = new Image(this.mostRecentScreenMode.width, this.mostRecentScreenMode.height);
            this.frameBufferedImage = new BufferedImage(this.mostRecentScreenMode.width, this.mostRecentScreenMode.height, 1);
            if (scaledown) {
                this.frameBufferedImageScaledDown = new BufferedImage(this.mostRecentScreenMode.width / 2, this.mostRecentScreenMode.height / 2, 1);
            }
            this.drawUpdates = 0;
            this.firstFrameDrawn = false;
        }
        catch (Exception e) {
            try {
                this.mcios.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mcios = null;
            this.gsw = null;
        }
    }

    private boolean addGifImage(UniScreen us) {
        try {
            int wStride;
            ((Graphics)this.mostRecentDraw.frame().nativeRenderer()).copyArea(this.frameImg, 0, 0);
            byte[] rawImgData = this.frameImg.getTexture().getTextureData();
            ByteBuffer bb = ByteBuffer.allocate(rawImgData.length);
            bb.put(rawImgData);
            bb.rewind();
            IntBuffer ib = bb.asIntBuffer();
            int w = this.frameImg.getWidth();
            int h = this.frameImg.getHeight();
            for (wStride = 64; wStride < w; wStride *= 2) {
            }
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int off = y * wStride + x;
                    int clr = ib.get(off) >> 8;
                    this.frameBufferedImage.setRGB(x, h - 1 - y, clr);
                }
            }
            int prevSize = this.baos.size();
            if (this.scaledown) {
                Graphics2D g = this.frameBufferedImageScaledDown.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(this.frameBufferedImage, 0, 0, this.frameBufferedImageScaledDown.getWidth(), this.frameBufferedImageScaledDown.getHeight(), null);
                this.gsw.writeToSequence(this.frameBufferedImageScaledDown);
            } else {
                this.gsw.writeToSequence(this.frameBufferedImage);
            }
            this.mcios.flush();
            int newSize = this.baos.size();
            int frameSize = newSize - prevSize;
            return newSize + frameSize * 2 < (LaunchSettings.maxGIFSizeMB - 1) * 1024 * 1024;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.savedToCooldown = StrictMath.max(0, this.savedToCooldown - ms);
        if (this.fastForwardTo != -1) {
            int ffTick = 0;
            while (us.combat.playbackIndex < this.fastForwardTo && ffTick++ < 100) {
                us.combat.tick(16, us.mySide, us.getTimeOfDay().effect.lightning, 1);
            }
            if (us.combat.playbackIndex >= this.fastForwardTo) {
                this.fastForwardTo = -1;
                us.g.volume = this.originalVolume;
            }
        }
        if (this.takeGifUntil != -1 && this.drawUpdates > (this.firstFrameDrawn ? 0 : 1)) {
            this.firstFrameDrawn = true;
            this.drawUpdates = 0;
            boolean imageAdded = this.addGifImage(us);
            if (imageAdded) {
                this.accumulatedTime += this.slowMo ? 16 : 32;
                while (this.accumulatedTime >= 16) {
                    us.combat.tick(16, us.mySide, us.getTimeOfDay().effect.lightning, 1);
                    this.accumulatedTime -= 16;
                }
            }
            if (!imageAdded || us.combat.playbackIndex >= this.takeGifUntil || in.keyPressed("ESCAPE")) {
                us.hideUI = false;
                this.takeGifUntil = -1;
                FileOutputStream fos = null;
                try {
                    this.gsw.close();
                    this.mcios.flush();
                    this.mcios.close();
                    fos = new FileOutputStream(this.gf);
                    fos.write(this.baos.toByteArray());
                    fos.flush();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                this.gsw = null;
                this.mcios = null;
                try {
                    this.frameImg.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.frameImg = null;
                this.frameBufferedImage = null;
                this.frameBufferedImageScaledDown = null;
                this.savedToCooldown = 15000;
            }
            return;
        }
        if (us.combat.playbackIndex >= us.combat.playback.tickCommands.size()) {
            return;
        }
        for (int iter = 0; iter < us.combat.speed.mult; ++iter) {
            this.time += ms / us.combat.speed.div;
            this.accumulatedTime += ms / us.combat.speed.div;
            while (this.accumulatedTime >= 16) {
                us.combat.tick(16, us.mySide, us.getTimeOfDay().effect.lightning, us.combat.speed.mult);
                this.hasDiverged(us);
                this.accumulatedTime -= 16;
            }
        }
    }

    @Override
    public void doLeave(UniScreen us) {
        us.g.s = new MainMenu(us.g, MainMenu.Submenu.DESIGN_AND_FIGHT);
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }
}

