/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.InitCombatProcess;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class PlaybackControlsPanel
implements UniScreen.InfoPanel {
    public int panelW = 0;
    public static final Img GIF_ICON = new Img("ui", 512, 416, 16, 16, false);
    public static final Img SCALEDOWN_ICON = new Img("ui", 608, 416, 16, 16, false);
    public boolean gifSetup = false;
    public boolean gifSlowMo = false;
    public boolean gifScaledown = false;
    public boolean takeControlSetup = false;

    private void takeOver(UniScreen us, int sideIndex) {
        SingleCombatIntent sci = new SingleCombatIntent();
        Combat.Side mySide = us.combat.sides.get(sideIndex);
        us.hideUI = false;
        us.allOutside = false;
        us.mySide = mySide;
        us.selectedShip = null;
        us.selectedShips.clear();
        Combat.Side enemySide = us.combat.otherSide(mySide);
        for (Airship s : enemySide.ships) {
            s.ai = new TacticalAI(s, us.combat, enemySide, mySide);
        }
        sci.initCombatProcess = new InitCombatProcess(us.combat);
        us.combat.playback = null;
        us.intent = sci;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        int h;
        int w;
        this.panelW = 0;
        if (!(us.intent instanceof PlaybackIntent)) {
            return;
        }
        final PlaybackIntent pi = (PlaybackIntent)us.intent;
        pi.mostRecentDraw = d;
        pi.mostRecentScreenMode = sm;
        if (us.hideUI) {
            ++pi.drawUpdates;
            return;
        }
        Combat c = us.combat;
        if (pi.hasDiverged(us)) {
            int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
            int x = sm.width / 2 - (int)d.textSize((String)Lang._t((String)"playback_diverged", (Object[])new Object[0]), (Fount)AGame.FOUNT).x / 2;
            d.text(Lang._t("playback_diverged", new Object[0]), AGame.FOUNT, x, y);
        }
        if (this.takeControlSetup) {
            w = (128 + MyDraw.PANEL_INSET * 2) * 2 + MyDraw.UI_SPACING + MyDraw.WINDOW_INSET * 2;
            this.panelW = 2;
            h = 128 + MyDraw.PANEL_INSET * 2 + MyDraw.UI_SPACING + AGame.BIG_FOUNT.height + MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.SIDE_CLEARANCE;
            int x = sm.width / 2 - w / 2;
            int y = sm.height - h;
            d.drawWindow(x, y, w, h + MyDraw.WINDOW_INSET * 2);
            w -= MyDraw.WINDOW_INSET * 2;
            int y2 = y += MyDraw.WINDOW_INSET;
            d.drawPanel(x += MyDraw.WINDOW_INSET, y, 128 + MyDraw.PANEL_INSET * 2, 128 + MyDraw.PANEL_INSET * 2);
            Combat.Side s = us.combat.sides.get(0);
            s.arms.draw(d, x + MyDraw.PANEL_INSET, y2 += MyDraw.PANEL_INSET, 128);
            d.text(s.getName(), AGame.BIG_FOUNT, x, y2 += 128 + MyDraw.PANEL_INSET + MyDraw.BUTTON_SPACING);
            d.button(x, y2 += AGame.BIG_FOUNT.height + MyDraw.UI_SPACING, 128 + MyDraw.PANEL_INSET * 2, Lang._t("Take_Control", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.takeOver(us, 0);
                }
            });
            y2 = y;
            d.drawPanel(x += 128 + MyDraw.PANEL_INSET * 2 + MyDraw.UI_SPACING, y, 128 + MyDraw.PANEL_INSET * 2, 128 + MyDraw.PANEL_INSET * 2);
            s = us.combat.sides.get(1);
            s.arms.draw(d, x + MyDraw.PANEL_INSET, y2 += MyDraw.PANEL_INSET, 128);
            d.text(s.getName(), AGame.BIG_FOUNT, x, y2 += 128 + MyDraw.PANEL_INSET + MyDraw.BUTTON_SPACING);
            d.button(x, y2 += AGame.BIG_FOUNT.height + MyDraw.UI_SPACING, 128 + MyDraw.PANEL_INSET * 2, Lang._t("Take_Control", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.takeOver(us, 1);
                }
            });
            x -= 128 + MyDraw.PANEL_INSET * 2 + MyDraw.UI_SPACING;
            int bw = d.bw(Lang._t("Cancel", new Object[0]));
            d.button(x += w / 2 - bw / 2, y2 += MyDraw.BUTTON_H + MyDraw.UI_SPACING, bw, Lang._t("Cancel", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.takeControlSetup = false;
                }
            });
            return;
        }
        w = this.panelW = sm.width * 3 / 5;
        h = MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET + MyDraw.SIDE_CLEARANCE;
        int x = sm.width / 2 - w / 2;
        int y = sm.height - h;
        if (pi.savedToCooldown > 0) {
            Rect r = d.textSize(pi.savedTo, AGame.FOUNT, 0.0, 0.0);
            d.text(pi.savedTo, AGame.FOUNT, sm.width / 2 - (int)(r.width / 2.0), y - AGame.FOUNT.height - MyDraw.UI_SPACING);
        }
        d.drawWindow(x, y, w, h + MyDraw.WINDOW_INSET * 2);
        d.progressBar(x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, w -= MyDraw.WINDOW_INSET * 2, 1.0 * (double)c.playbackIndex / (double)(c.playback.tickCommands.size() + 1));
        if (this.gifSetup) {
            int x2 = x;
            d.iconToggle(x2, y += MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING, CombatSpeed.QUARTER_SPEED.icon, new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.gifSlowMo = !PlaybackControlsPanel.this.gifSlowMo;
                }
            }, this.gifSlowMo, true);
            d.tooltip((double)x2, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("gif_slowmo", new Object[0]));
            d.iconToggle(x2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, SCALEDOWN_ICON, new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.gifScaledown = !PlaybackControlsPanel.this.gifScaledown;
                }
            }, this.gifScaledown, true);
            d.tooltip((double)x2, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("gif_scaledown", new Object[0]));
            d.text(Lang._t("Press_escape_to_stop_recording", new Object[0]), AGame.FOUNT, x2 += MyDraw.BUTTON_H + MyDraw.UI_SPACING, y);
            x2 = x + w;
            int bw = d.bw(Lang._t("OK", new Object[0]));
            d.button(x2 - bw, y, bw, Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.gifSetup = false;
                    pi.takeGif(us, PlaybackControlsPanel.this.gifSlowMo, PlaybackControlsPanel.this.gifScaledown);
                }
            });
            x2 -= bw + MyDraw.BUTTON_SPACING;
            bw = d.bw(Lang._t("Cancel", new Object[0]));
            d.button(x2 - bw, y, bw, Lang._t("Cancel", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    PlaybackControlsPanel.this.gifSetup = false;
                }
            });
            return;
        }
        double hoverPosition = -1.0;
        if (cursor.y >= (double)y && cursor.y <= (double)(y + MyDraw.PROGRESS_BAR_H) && cursor.x >= (double)x && cursor.x <= (double)(x + w)) {
            hoverPosition = StrictMath.max(0.0, StrictMath.min(1.0, (cursor.x - (double)x) * 1.0 / (double)w));
            d.rect(Clr.WHITE, cursor.x, y + MyDraw.PANEL_INSET, 1.0, MyDraw.PROGRESS_BAR_H - MyDraw.PANEL_INSET * 2);
        }
        final int pw = w;
        if (pi.fastForwardTo == -1 && pi.takeGifUntil == -1) {
            d.hook(x, y, w, MyDraw.PROGRESS_BAR_H, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    int skipTo = StrictMath.max(0, StrictMath.min(us.combat.playback.tickCommands.size(), (int)(p.x * (double)us.combat.playback.tickCommands.size() / (double)pw)));
                    pi.skipTo(us, skipTo);
                }
            });
        }
        y += MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING;
        int x2 = x;
        for (int csi = 0; csi < CombatSpeed.values().length; ++csi) {
            final CombatSpeed cs = CombatSpeed.values()[csi];
            d.iconToggle(x2, y, cs.icon, new Runnable(){

                @Override
                public void run() {
                    us.combat.speed = cs;
                }
            }, cs == us.combat.speed, true);
            x2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.iconButton(x2 += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING, y, GIF_ICON, new Runnable(){

            @Override
            public void run() {
                PlaybackControlsPanel.this.gifSetup = true;
                us.combat.speed = CombatSpeed.STOP;
            }
        }, pi.fastForwardTo == -1 && pi.takeGifUntil == -1);
        d.tooltip((double)x2, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("record_gif", new Object[0]));
        d.button(x2 += MyDraw.BUTTON_H + MyDraw.UI_SPACING, y, d.bw(Lang._t("Take_Control", new Object[0])), Lang._t("Take_Control", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                PlaybackControlsPanel.this.takeControlSetup = true;
            }
        }, pi.fastForwardTo == -1 && pi.takeGifUntil == -1);
        d.tooltip((double)x2, (double)y, (double)d.bw(Lang._t("Take_Control", new Object[0])), (double)MyDraw.BUTTON_H, Lang._t("take_control_tooltip", new Object[0]));
        String time = Recording.ticksToTime(hoverPosition == -1.0 ? c.playbackIndex : (int)((double)c.playback.tickCommands.size() * hoverPosition)) + " / " + Recording.ticksToTime(c.playback.tickCommands.size());
        d.text(time, AGame.FOUNT, x + w - (int)d.textSize((String)time, (Fount)AGame.FOUNT).x, y);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof PlaybackIntent)) {
            return;
        }
        PlaybackIntent pi = (PlaybackIntent)us.intent;
        if (this.gifSetup) {
            if (in.keyPressed("ENTER")) {
                this.gifSetup = false;
                pi.takeGif(us, this.gifSlowMo, this.gifScaledown);
            } else if (in.keyPressed("ESCAPE")) {
                this.gifSetup = false;
            }
            return;
        }
        if (this.takeControlSetup && in.keyPressed("ESCAPE")) {
            this.takeControlSetup = false;
            return;
        }
        if (in.keyPressed(Keys.get("combat_pause", "SPACE"))) {
            us.combat.speed = us.combat.speed == CombatSpeed.STOP ? CombatSpeed.NORMAL : CombatSpeed.STOP;
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

