/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class PlaceArmourTool
extends PlaceTool {
    public ArmourType at;

    @Override
    public String getLabel() {
        return Lang._t("Armour", new Object[0]);
    }

    public PlaceArmourTool(ArmourType at) {
        this.at = at;
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int gridX, int gridY, UniScreen us) {
        if (!this.at.damagedApps.get(this.ship((UniScreen)us).currentBonuses).isEmpty()) {
            this.at.damagedApps.get(this.ship((UniScreen)us).currentBonuses).get(0).draw(d, x, y, 0, false);
        }
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        if (AirshipGame.metaLobbyOverlay != null && click.x >= (double)(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.x <= (double)(sm.width - MyDraw.SIDE_CLEARANCE + 2) && click.y >= (double)(sm.height - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.y <= (double)(sm.height - MyDraw.SIDE_CLEARANCE + 2)) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null && !t.module.type.isExternal() && t.module.type.getArmourType() == null && t.armour.type != this.at) {
            t.armour.setType(this.at);
            ship.updateWeight();
            if (this.at.placeSound != null) {
                in.play(this.at.placeSound, this.at.placePitch, us.g.volume, 0.0, 0.0);
            }
            this.modified(us, false);
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                if (!esi.hasPlacedArmour) {
                    Analytics.report("hasPlacedArmour");
                    esi.hasPlacedArmour = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null && !t.module.type.isExternal() && t.module.type.getArmourType() == null) {
            this.at = t.armour.type;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (in.mouseDownButton() == 1) {
            return this.click(in, click, sm, us);
        }
        return super.mouseDown(in, click, sm, us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            if (!esi.hasSelectedArmour) {
                Analytics.report("hasSelectedArmour");
                esi.hasSelectedArmour = true;
            }
        }
    }
}

