/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.EditorOverlayType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.util.Clr;

public class PathingOverlay
implements EditorOverlayType {
    public static final Clr DARKEN = new Clr(0, 0, 0, 0);

    @Override
    public String name() {
        return Lang._t("Pathing", new Object[0]);
    }

    @Override
    public String explanation() {
        return Lang._t("Pathing_explanation", new Object[0]);
    }

    @Override
    public void update(Airship ship, boolean forced) {
    }

    @Override
    public Clr overlayColor(Tile t) {
        return DARKEN;
    }

    @Override
    public String tooltip(Tile t) {
        return null;
    }

    @Override
    public void draw(MyDraw d, Tile t, Airship ship, int tx, int ty, double zoom, int pass) {
        this.draw(d, t, ship, tx, ty, zoom, pass, Clr.BLACK);
    }

    public void draw(MyDraw d, Tile t, Airship ship, int tx, int ty, double zoom, int pass, Clr outerC) {
        Tile dt;
        if (!t.canOccupy) {
            return;
        }
        int lineWidth = 2;
        switch (AirshipGame.instance.currentGUIScale) {
            case SMALL: {
                lineWidth = 1;
                break;
            }
            case MEDIUM: {
                lineWidth = 2;
                break;
            }
            case LARGE: {
                lineWidth = 4;
            }
        }
        double w = pass == 0 ? 3.0 * (double)lineWidth / zoom : 1.0 * (double)lineWidth / zoom;
        Clr c = pass == 0 ? outerC : Clr.WHITE;
        Tile rt = ship.tileAt(t.x + 1, t.y);
        if (rt != null && rt.canOccupy && (rt.module == t.module || t.module.type.getRightDoors()[t.y - t.module.y] && rt.module.type.getLeftDoors()[rt.y - rt.module.y])) {
            int offset = ship.flipped ? -16 : 0;
            d.rect(c, (double)(tx + 8) - w / 2.0 + (double)offset, (double)(ty + 8) - w / 2.0, 16.0 + w, w);
        }
        if ((dt = ship.tileAt(t.x, t.y + 1)) != null && dt.canOccupy && (dt.module == t.module || dt.module.type.getUpDoors()[dt.x - dt.module.x])) {
            d.rect(c, (double)(tx + 8) - w / 2.0, (double)(ty + 8) - w / 2.0, w, 16.0 + w);
        }
    }
}

