/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public strictfp class PathingLayer
implements UniScreen.VisualLayer {
    private CrewType ct = null;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        ArrayList<CrewType> cts;
        if (us.combat != null) {
            us.combat.bodyPathing.update(us.combat);
        }
        if ((cts = Loadable.all(CrewType.class)).isEmpty()) {
            this.ct = null;
            return;
        }
        if (!cts.contains(this.ct)) {
            this.ct = cts.get(0);
        }
        if (in.keyPressed("X")) {
            this.ct = cts.get((cts.indexOf(this.ct) + 1) % cts.size());
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        if (this.ct == null) {
            return;
        }
        int jumpDist = this.ct.assumedJumpDist;
        int hookDist = this.ct.hasHook ? this.ct.hookRopeLength : -1;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        if (us.combat.physics == null) {
            return;
        }
        g.setColor(Color.black);
        int bsz = us.combat.physics.bodies.size();
        for (int srcBi = 0; srcBi < bsz; ++srcBi) {
            Body srcB = us.combat.physics.bodies.get(srcBi);
            for (int dstBi = 0; dstBi < bsz; ++dstBi) {
                Body dstB = us.combat.physics.bodies.get(dstBi);
                int jumpAmt = us.combat.bodyPathing.jumpMatrix[srcBi][dstBi];
                int hookAmt = us.combat.bodyPathing.hookMatrix[srcBi][dstBi];
                if (jumpAmt > jumpDist && hookAmt > hookDist) continue;
                g.setColor(Color.black);
                int srcX = (int)(srcB.getX() + srcB.getBBWidth() / 2.0);
                int srcY = (int)(srcB.getY() + srcB.getBBHeight() / 2.0) - 16;
                int dstX = (int)(dstB.getX() + dstB.getBBWidth() / 2.0);
                int dstY = (int)(dstB.getY() + dstB.getBBHeight() / 2.0) + 16;
                g.setLineWidth(12.0f);
                g.drawLine((float)srcX, (float)srcY, (float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2));
                g.setLineWidth(6.0f);
                g.drawLine((float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2), (float)dstX, (float)dstY);
                g.setColor(jumpAmt <= jumpDist ? Color.green : Color.yellow);
                g.setLineWidth(6.0f);
                g.drawLine((float)srcX, (float)srcY, (float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2));
                g.setLineWidth(3.0f);
                g.drawLine((float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2), (float)dstX, (float)dstY);
            }
        }
        if (!us.combat.sides.get((int)0).ships.isEmpty() && !us.combat.sides.get((int)1).ships.isEmpty()) {
            boolean needsGrappling = false;
            ArrayList<GridBody> path = us.combat.bodyPathing.getPath(us.combat.sides.get((int)0).ships.get(0), us.combat.sides.get((int)1).ships.get(0), jumpDist, -1, us.combat);
            if (path == null) {
                path = us.combat.bodyPathing.getPath(us.combat.sides.get((int)0).ships.get(0), us.combat.sides.get((int)1).ships.get(0), jumpDist, hookDist, us.combat);
                needsGrappling = true;
            }
            if (path != null) {
                path.add(0, us.combat.sides.get((int)0).ships.get(0));
                for (int pi = 0; pi < path.size() - 1; ++pi) {
                    GridBody srcB = path.get(pi);
                    GridBody dstB = path.get(pi + 1);
                    int srcX = (int)(srcB.getX() + srcB.getBBWidth() / 2.0);
                    int srcY = (int)(srcB.getY() + srcB.getBBHeight() / 2.0);
                    int dstX = (int)(dstB.getX() + dstB.getBBWidth() / 2.0);
                    int dstY = (int)(dstB.getY() + dstB.getBBHeight() / 2.0);
                    g.setColor(Color.black);
                    g.setLineWidth(6.0f);
                    g.drawLine((float)srcX, (float)srcY, (float)dstX, (float)dstY);
                    g.setColor(needsGrappling ? Color.red : Color.blue);
                    g.setLineWidth(3.0f);
                    g.drawLine((float)srcX, (float)srcY, (float)dstX, (float)dstY);
                }
            }
        }
        g.setLineWidth(1.0f);
        g.setColor(Color.white);
        d.resetTransforms();
        d.text(this.ct.getName(), AGame.FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING);
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
    }
}

