/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class ParticleVisualLayer
implements UniScreen.VisualLayer {
    public static Texture particles;
    public static Texture bump;
    private static String currentPostfix;
    private static final HashMap<String, Texture> postfixToTex;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        if (!Appearance.currentPostfix.equals(currentPostfix) || particles == null || particles.getTextureID() == 0) {
            currentPostfix = Appearance.currentPostfix;
            if (!postfixToTex.containsKey(currentPostfix) || postfixToTex.get(currentPostfix).getTextureID() == 0) {
                particles = SpriteUtils.loadTexture("particles" + currentPostfix);
                if (particles != null) {
                    particles.setTextureFilter(9728);
                    postfixToTex.put(currentPostfix, particles);
                }
            } else {
                particles = postfixToTex.get(currentPostfix);
            }
        }
        if (particles == null || particles.getTextureID() == 0) {
            particles = SpriteUtils.loadTexture("particles");
            particles.setTextureFilter(9728);
        }
        TextureImpl.bindNone();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        float ambientR = tod.ambient.r;
        float ambientG = tod.ambient.g;
        float ambientB = tod.ambient.b;
        if (us.combat.physics != null) {
            for (Body b : us.combat.physics.bodies) {
                if (b instanceof Airship && !((Airship)b).showingOutside) continue;
                for (Particle p : b.stuckParticles) {
                    double px = (double)((int)b.getX()) + p.x;
                    double py = (double)((int)b.getY()) + p.y;
                    if (p.type.pt != null || !Rect2D.intersects(cropX, cropY, cropW, cropH, px, py, p.type.maxSize, p.type.maxSize)) continue;
                    if (p.life > p.lifespan) {
                        p.life = p.lifespan;
                    }
                    double sz = (p.startSize + 1.0 * (p.endSize - p.startSize) * (double)(p.lifespan - p.life) / (double)p.lifespan) / 2.0;
                    int index = Math.min((p.type.gradient.length - 1) * (p.lifespan - p.life) / p.lifespan, p.type.gradient.length);
                    float[] c = p.type.gradient[index];
                    if (p.type.lightClr == null) {
                        GL11.glColor4f((float)(c[0] * ambientR), (float)(c[1] * ambientG), (float)(c[2] * ambientB), (float)c[3]);
                    } else {
                        GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
                    }
                    GL11.glVertex2d((double)(px + sz), (double)(py - sz));
                    GL11.glVertex2d((double)(px + sz), (double)(py + sz));
                    GL11.glVertex2d((double)(px - sz), (double)(py + sz));
                    GL11.glVertex2d((double)(px - sz), (double)(py - sz));
                }
            }
        }
        for (Particle p : us.combat.particles) {
            if (p.type.pt != null || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            if (p.life > p.lifespan) {
                p.life = p.lifespan;
            }
            double sz = (p.startSize + 1.0 * (p.endSize - p.startSize) * (double)(p.lifespan - p.life) / (double)p.lifespan) / 2.0;
            int index = Math.min((p.type.gradient.length - 1) * (p.lifespan - p.life) / p.lifespan, p.type.gradient.length - 1);
            float[] c = p.type.gradient[index];
            if (p.type.lightClr == null) {
                GL11.glColor4f((float)(c[0] * ambientR), (float)(c[1] * ambientG), (float)(c[2] * ambientB), (float)c[3]);
            } else {
                GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
            }
            GL11.glVertex2d((double)(p.x + sz), (double)(p.y - sz));
            GL11.glVertex2d((double)(p.x + sz), (double)(p.y + sz));
            GL11.glVertex2d((double)(p.x - sz), (double)(p.y + sz));
            GL11.glVertex2d((double)(p.x - sz), (double)(p.y - sz));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)particles.getTextureID());
        GL11.glBegin((int)7);
        for (Particle p : us.combat.particles) {
            if (p.type.pt == null || p.type.lit && Appearance.useLighting && !Appearance.useSimpleGraphics && !Appearance.shaderLoadFailed || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            p.drawAsPicture(d, 0.0, 0.0);
        }
        GL11.glEnd();
        TextureImpl.bindNone();
        if (!Appearance.useLighting || Appearance.useSimpleGraphics || Appearance.shaderLoadFailed) {
            return;
        }
        Image[] light = us.lightingMap;
        float lightStrength = us.getTimeOfDay().lightStrength;
        if (bump == null || bump.getTextureID() == 0) {
            bump = SpriteUtils.loadTexture("particles_bump");
            bump.setTextureFilter(9728);
        }
        if (Appearance.lsp == null) {
            try {
                Appearance.lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Appearance.shaderLoadFailed = true;
                return;
            }
        }
        Appearance.lsp.bind();
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)bump.getTextureID());
        Appearance.lsp.setUniform1i("bump", 1);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromLeft", 2);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromTop", 3);
        GL13.glActiveTexture((int)33988);
        GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromRight", 4);
        GL13.glActiveTexture((int)33989);
        GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromBottom", 5);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)particles.getTextureID());
        Appearance.lsp.setUniform1i("tex", 0);
        Appearance.lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
        Appearance.lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
        Appearance.lsp.setUniform4f("ambient", tod.ambient);
        Appearance.lsp.setUniform1f("ambientSaturation", tod.ambientSaturation);
        Appearance.lsp.enableVertexAttribute("flipped");
        Appearance.lsp.enableVertexAttribute("strength");
        Appearance.lsp.enableVertexAttribute("tint");
        GL11.glBegin((int)7);
        GL20.glVertexAttrib1f((int)Appearance.lsp.getAttributeID("flipped"), (float)0.0f);
        GL20.glVertexAttrib1f((int)Appearance.lsp.getAttributeID("strength"), (float)lightStrength);
        for (Particle p : us.combat.particles) {
            if (p.type.pt == null || !p.type.lit || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            p.drawAsShadedPicture(d);
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Appearance.lsp.unbind();
        TextureImpl.bindNone();
    }

    static {
        currentPostfix = "NULL";
        postfixToTex = new HashMap();
    }
}

