/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.util.Clr;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public strictfp class Particle {
    public ParticleType type;
    public double x;
    public double y;
    public double dx;
    public double dy;
    public double direction;
    public int life;
    public int lifespan;
    public final int variant;
    public double startSize;
    public double endSize;
    public double scale = 1.0;

    public Particle(ParticleType type, double x, double y) {
        this(type, x, y, 1.0);
    }

    public Particle(ParticleType type, double x, double y, double scale) {
        this.type = type;
        this.scale = scale;
        this.direction = AGame.ANIM_R.nextDouble() * Math.PI * 2.0;
        double dirDist = AGame.ANIM_R.nextDouble();
        this.x = x + StrictMath.cos(this.direction) * type.offset * dirDist * scale;
        this.y = y + StrictMath.sin(this.direction) * type.offset * dirDist * scale;
        if (type.directional) {
            double speed = (AGame.ANIM_R.nextDouble() * 0.4 + 0.8) * type.maxDx;
            this.dx = StrictMath.cos(this.direction) * speed;
            this.dy = StrictMath.sin(this.direction) * speed;
        } else {
            this.dx = type.minDx + AGame.ANIM_R.nextDouble() * (type.maxDx - type.minDx);
            this.dy = type.minDy + AGame.ANIM_R.nextDouble() * (type.maxDy - type.minDy);
        }
        this.lifespan = type.minLifespan;
        if (type.maxLifespan > type.minLifespan) {
            this.lifespan += AGame.ANIM_R.nextInt(type.maxLifespan - type.minLifespan);
        }
        this.life = this.lifespan;
        this.variant = type.pt == null ? 0 : AGame.ANIM_R.nextInt(type.pt.numVariants);
        this.startSize = (double)type.startSize * 1.0 * (0.8 + AGame.ANIM_R.nextDouble() * 0.5) * scale;
        this.endSize = (double)type.endSize * scale;
    }

    public Particle(ParticleType type, double x, double y, double dx, double dy) {
        this(type, x, y, dx, dy, 1.0);
    }

    public Particle(ParticleType type, double x, double y, double dx, double dy, double scale) {
        this.direction = Direction.radiansFromTo(0.0, 0.0, dx, dy);
        this.type = type;
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.scale = scale;
        this.lifespan = type.minLifespan;
        if (type.maxLifespan > type.minLifespan) {
            this.lifespan += AGame.ANIM_R.nextInt(type.maxLifespan - type.minLifespan);
        }
        this.life = this.lifespan;
        this.variant = type.pt == null ? 0 : AGame.ANIM_R.nextInt(type.pt.numVariants);
        this.startSize = (double)type.startSize * 1.0 * (0.8 + AGame.ANIM_R.nextDouble() * 0.5) * scale;
        this.endSize = (double)type.endSize * scale;
    }

    public boolean tick(int ms, double wind, Combat c) {
        if (this.y < -300.0 && this.life < 1500 && this.type.accumulates) {
            this.dy *= 1.0 + (this.y + 300.0) * 1.0E-4;
            this.dx *= 0.9995 + StrictMath.abs(this.dy) * 0.01;
            if (this.endSize < 80.0) {
                this.endSize *= 1.0006;
            }
            this.life = this.variant % 4 == 1 ? (this.life -= AGame.ANIM_R.nextInt(9) == 1 ? 1 : 0) : (this.life -= ms);
        } else {
            this.dy += this.type.grav;
            this.life -= ms;
        }
        this.dx += wind * this.type.windMult;
        this.y += this.dy;
        this.x += this.dx;
        if (this.life > 0 && this.type.stickSpeed > 0.0 && this.dx * this.dx + this.dy * this.dy < this.type.stickSpeed * this.type.stickSpeed) {
            int bsz = c.physics.bodies.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Body b = c.physics.bodies.get(bi);
                if (b == c.landFormations.get(0) || !b.canParticleStick(this.x, this.y)) continue;
                b.stuckParticles.add(this);
                this.x -= b.getX();
                this.y -= b.getY();
                this.lifespan = this.type.maxLifespan * 64;
                this.life *= 64;
                return true;
            }
        }
        return this.life <= 0;
    }

    public void drawAsPicture(Draw d, double xShift, double yShift) {
        double sz = this.startSize + 1.0 * (this.endSize - this.startSize) * (double)(this.lifespan - this.life) / (double)this.lifespan;
        int index = Math.min((this.type.gradient.length - 1) * (this.lifespan - this.life) / this.lifespan, this.type.gradient.length);
        float[] c = this.type.gradient[index];
        GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
        double srcX = this.type.pt.xOffsets[this.variant];
        double srcY = this.type.pt.yOffsets[this.variant];
        double srcX2 = srcX + this.type.pt.size;
        double srcY2 = srcY + this.type.pt.size;
        if (this.type.directional) {
            double cos = StrictMath.cos(this.direction);
            double sin = StrictMath.sin(this.direction);
            double w2 = sz * 0.5;
            double h2 = sz * 0.5;
            double x2 = this.x;
            double y2 = this.y;
            double topLeftX = x2 - w2 * cos + h2 * sin;
            double topLeftY = y2 - w2 * sin - h2 * cos;
            double bottomLeftX = x2 - w2 * cos - h2 * sin;
            double bottomLeftY = y2 - w2 * sin + h2 * cos;
            double bottomRightX = x2 + w2 * cos - h2 * sin;
            double bottomRightY = y2 + w2 * sin + h2 * cos;
            double topRightX = x2 + w2 * cos + h2 * sin;
            double topRightY = y2 + w2 * sin - h2 * cos;
            GL11.glTexCoord2d((double)srcX, (double)srcY);
            GL11.glVertex2d((double)topLeftX, (double)topLeftY);
            GL11.glTexCoord2d((double)srcX, (double)srcY2);
            GL11.glVertex2d((double)bottomLeftX, (double)bottomLeftY);
            GL11.glTexCoord2d((double)srcX2, (double)srcY2);
            GL11.glVertex2d((double)bottomRightX, (double)bottomRightY);
            GL11.glTexCoord2d((double)srcX2, (double)srcY);
            GL11.glVertex2d((double)topRightX, (double)topRightY);
        } else {
            GL11.glTexCoord2d((double)srcX, (double)srcY);
            GL11.glVertex2d((double)(this.x + xShift - sz / 2.0), (double)(this.y + yShift - sz / 2.0));
            GL11.glTexCoord2d((double)srcX, (double)srcY2);
            GL11.glVertex2d((double)(this.x + xShift - sz / 2.0), (double)(this.y + yShift + sz / 2.0));
            GL11.glTexCoord2d((double)srcX2, (double)srcY2);
            GL11.glVertex2d((double)(this.x + xShift + sz / 2.0), (double)(this.y + yShift + sz / 2.0));
            GL11.glTexCoord2d((double)srcX2, (double)srcY);
            GL11.glVertex2d((double)(this.x + xShift + sz / 2.0), (double)(this.y + yShift - sz / 2.0));
        }
    }

    public void drawAsShadedPicture(Draw d) {
        double sz = this.startSize + 1.0 * (this.endSize - this.startSize) * (double)(this.lifespan - this.life) / (double)this.lifespan;
        Clr c = this.type.tintGradient[(this.type.tintGradient.length - 1) * (this.lifespan - this.life) / this.lifespan];
        GL20.glVertexAttrib4f((int)Appearance.lsp.getAttributeID("tint"), (float)((float)c.r / 255.0f), (float)((float)c.g / 255.0f), (float)((float)c.b / 255.0f), (float)((float)c.a / 255.0f));
        double srcX = this.type.pt.xOffsets[this.variant] * 1024.0;
        double srcY = this.type.pt.yOffsets[this.variant] * 1024.0;
        double srcX2 = srcX + this.type.pt.size * 1024.0;
        double srcY2 = srcY + this.type.pt.size * 1024.0;
        GL11.glTexCoord2d((double)srcX, (double)srcY);
        GL11.glVertex2d((double)(this.x - sz / 2.0), (double)(this.y - sz / 2.0));
        GL11.glTexCoord2d((double)srcX, (double)srcY2);
        GL11.glVertex2d((double)(this.x - sz / 2.0), (double)(this.y + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY2);
        GL11.glVertex2d((double)(this.x + sz / 2.0), (double)(this.y + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY);
        GL11.glVertex2d((double)(this.x + sz / 2.0), (double)(this.y - sz / 2.0));
    }

    public strictfp static enum PictureType {
        FLASH(0, 9),
        SHOCKWAVE(9, 1),
        EXPLOSION(10, 9),
        PUFF(18, 23),
        SMOKE(41, 23);

        public final double[] xOffsets;
        public final double[] yOffsets;
        public final double size = 0.125;
        public final int numVariants;

        private PictureType(int start, int numVariants) {
            this.numVariants = numVariants;
            this.xOffsets = new double[numVariants];
            this.yOffsets = new double[numVariants];
            for (int i = start; i < start + numVariants; ++i) {
                int x = i % 8 * 128;
                int y = i / 8 * 128;
                this.xOffsets[i - start] = (double)x * 1.0 / 1024.0;
                this.yOffsets[i - start] = (double)y * 1.0 / 1024.0;
            }
        }
    }

    public strictfp static class Emitter {
        public ParticleType t;
        public double emitProbability;
        public int numParticles;
        public SoundEffect soundEffect;

        public Emitter(ParticleType t, double emitProbability, int numParticles, SoundEffect soundEffect) {
            this.t = t;
            this.emitProbability = emitProbability;
            this.numParticles = numParticles;
            this.soundEffect = soundEffect;
        }
    }
}

