/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.HasName;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import org.json.JSONObject;

public strictfp class PaintType
extends Loadable
implements HasName {
    public final Clr tint;
    public final boolean metal;
    public final Tincture tinc;
    public final int armsTincIndex;

    public PaintType(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        if (o.has("tincture")) {
            this.tinc = Tincture.valueOf(o.getString("tincture"));
            if (this.tinc.paintType != null) {
                throw new RuntimeException("Tincture " + this.tinc.name + " already referenced by a paint type.");
            }
            this.tinc.paintType = this;
            if (o.has("tint")) {
                JSONObject t = o.getJSONObject("tint");
                this.tint = new Clr(t.getInt("r"), t.getInt("g"), t.getInt("b"), t.optInt("a", 200));
            } else {
                this.tint = null;
            }
            this.armsTincIndex = 0;
            this.metal = this.tinc.metal;
        } else if (o.has("tint")) {
            JSONObject t = o.getJSONObject("tint");
            this.tint = new Clr(t.getInt("r"), t.getInt("g"), t.getInt("b"), t.optInt("a", 200));
            this.tinc = null;
            this.armsTincIndex = 0;
            this.metal = o.optBoolean("metal", false);
        } else {
            this.tint = null;
            this.tinc = null;
            this.armsTincIndex = o.getInt("armsTinctureIndex");
            this.metal = false;
        }
    }

    public float shinyOrPassthrough() {
        return this.tinc == null ? (this.metal ? 0.5f : 0.36f) : -1.0f;
    }

    public float shiny() {
        return this.metal ? 0.5f : 0.36f;
    }

    public PaintType getPaintType(CoatOfArms shipArms) {
        if (this.tint != null || this.tinc != null) {
            return this;
        }
        return shipArms.getTincture((int)this.armsTincIndex).paintType;
    }

    public Clr getTint(CoatOfArms shipArms) {
        if (this.tint != null) {
            return this.tint;
        }
        if (this.tinc != null) {
            return this.tinc.nicePaintTint;
        }
        return shipArms.getTincture((int)this.armsTincIndex).nicePaintTint;
    }

    public Clr getBaseTint() {
        if (this.tint != null) {
            return this.tint;
        }
        if (this.tinc != null) {
            return this.tinc.nicePaintTint;
        }
        return Clr.RED;
    }

    @Override
    public String getName() {
        if (this.tinc != null) {
            return this.tinc.getName();
        }
        return Lang._t(this.name, new Object[0]);
    }

    public static PaintType valueOf(String name) {
        return Loadable.ofName(PaintType.class, name);
    }

    public static ArrayList<PaintType> values() {
        return Loadable.all(PaintType.class);
    }

    public int ordinal() {
        return PaintType.values().indexOf(this);
    }

    public boolean isArmsBased() {
        return this.tinc == null && this.tint == null;
    }
}

