/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import org.newdawn.slick.Image;

public strictfp class PaintArmourTool
extends PlaceTool {
    public PaintType pt;

    @Override
    public String getLabel() {
        return Lang._t("Paint", new Object[0]);
    }

    public PaintArmourTool(PaintType pt) {
        this.pt = pt;
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int gridX, int gridY, UniScreen us) {
        if (this.pt == null) {
            if (PlaceModuleTool.REMOVE.machineImgCache != null) {
                ((Image)PlaceModuleTool.REMOVE.machineImgCache).setFilter(9728);
            }
            d.blit(PlaceModuleTool.REMOVE, x, y);
        } else {
            d.rect(this.pt.getTint(us.getBestOverallCOA()), x, y, 16.0, 16.0);
        }
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        if (AirshipGame.metaLobbyOverlay != null && click.x >= (double)(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.x <= (double)(sm.width - MyDraw.SIDE_CLEARANCE + 2) && click.y >= (double)(sm.height - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.y <= (double)(sm.height - MyDraw.SIDE_CLEARANCE + 2)) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null && t.armour.type != ArmourType.ofName("NONE")) {
            t.armour.paint = this.pt;
            this.modified(us, false);
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                if (!esi.hasPlacedPaint) {
                    Analytics.report("hasPlacedPaint");
                    esi.hasPlacedPaint = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null) {
            this.pt = t.armour.paint;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDown(Input in, Pt mouseDown, ScreenMode sm, UniScreen us) {
        if (in.mouseDownButton() == 1) {
            return this.click(in, mouseDown, sm, us);
        }
        return super.mouseDown(in, mouseDown, sm, us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            if (!esi.hasSelectedPaint) {
                Analytics.report("hasSelectedPaint");
                esi.hasSelectedPaint = true;
            }
        }
    }
}

