/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.imageio.ImageIO;

public strictfp class OutlineRenderer {
    public static void main(String[] args) throws IOException {
        BufferedImage srcImg = ImageIO.read(new File(args[0]));
        Fount srcFount = Fount.fromStream(null, (InputStream)new FileInputStream(args[1]));
        int newSz = srcImg.getWidth() < 2048 ? srcImg.getWidth() * 2 : 2048;
        BufferedImage trgImg = new BufferedImage(newSz, newSz, 2);
        HashMap<String, Object> letters = new HashMap<String, Object>();
        for (int i = 0; i < srcFount.imgs.length; ++i) {
            if (srcFount.imgs[i] == null) continue;
            letters.put(new String(new char[]{(char)i}), srcFount.imgs[i]);
        }
        for (Integer k : srcFount.extended.keySet()) {
            letters.put(new String(new char[]{(char)k.intValue()}), srcFount.extended.get(k));
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(args[3])), "UTF-8"));
        out.println("letterSpacing " + (srcFount.letterSpacing - 5));
        out.println("letterXOffset " + (srcFount.letterOffset - 2));
        Graphics2D g = trgImg.createGraphics();
        int x = 4;
        int y = 4;
        int lineH = srcFount.lineHeight + 6;
        for (String letter : letters.keySet()) {
            Img img = (Img)letters.get(letter);
            if (x + img.srcWidth + 4 > newSz) {
                x = 4;
                y += lineH;
            }
            out.println(letter);
            out.println(x + " " + y + " " + (img.srcWidth + 5) + " " + (img.srcHeight + 5));
            for (int dy = 0; dy < 5; ++dy) {
                for (int dx = 0; dx < 5; ++dx) {
                    g.drawImage(srcImg, x + dx, y + dy, x + dx + img.srcWidth, y + dy + img.srcHeight, img.srcX, img.srcY, img.srcX + img.srcWidth, img.srcY + img.srcHeight, null);
                }
            }
            x += img.srcWidth + 10;
        }
        out.close();
        ImageIO.write((RenderedImage)trgImg, "PNG", new File(args[2]));
    }
}

