/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.StrategicScreen;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class OpenGameMission
implements FileScreen.Mission {
    private final AirshipGame g;
    private final StrategicScreen ss;
    private final boolean returnToMainMenu;
    private final FileScreen.Backend backend;

    public OpenGameMission(AirshipGame g, StrategicScreen ss, boolean returnToMainMenu, FileScreen.Backend backend) {
        this.g = g;
        this.ss = ss;
        this.returnToMainMenu = returnToMainMenu;
        this.backend = backend;
    }

    @Override
    public FileScreen.Mode mode() {
        return FileScreen.Mode.OPEN;
    }

    @Override
    public String text() {
        return Lang._t("Open_save_", new Object[0]);
    }

    @Override
    public String fileSelectionText() {
        return Lang._t("Open", new Object[0]);
    }

    @Override
    public String initialInput() {
        return "";
    }

    @Override
    public void fileSelected(String path) {
        block20: {
            this.g.s = this.ss;
            int retry = 0;
            while (true) {
                try {
                    JSONObject o = new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8"));
                    int version = o.optInt("version", 0);
                    if (!CampaignWorld.READABLE_VERSIONS.contains(version)) {
                        this.g.showError(Lang._t("Save_out_of_date", new Object[0]));
                        if (this.returnToMainMenu) {
                            this.ss.leave();
                        }
                        return;
                    }
                    this.ss.gameToLoad = o;
                }
                catch (Exception e) {
                    String data;
                    if (retry++ < 3) continue;
                    this.g.showError(Lang._t("Unable_to_load_game", new Object[0]));
                    if (this.returnToMainMenu) {
                        this.ss.leave();
                    }
                    try {
                        data = FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8");
                    }
                    catch (Exception e2) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e2.printStackTrace(pw);
                        pw.flush();
                        data = "exception: " + e2 + "\n" + sw.toString();
                    }
                    this.g.reportError("Unable to load game file", e, data, false, true);
                    return;
                }
                break;
            }
            try {
                final ArrayList<Mod> modsToLoad = new ArrayList<Mod>();
                boolean modsFailed = false;
                if (this.ss.gameToLoad.has("mods")) {
                    JSONArray mods = this.ss.gameToLoad.getJSONArray("mods");
                    for (int i = 0; i < mods.length(); ++i) {
                        Mod m = Mod.getById(mods.getJSONObject(i).getString("id"));
                        if (m == null) {
                            modsFailed = true;
                            break;
                        }
                        modsToLoad.add(m);
                    }
                }
                if (modsFailed) {
                    StringBuilder modsList = new StringBuilder();
                    JSONArray mods = this.ss.gameToLoad.getJSONArray("mods");
                    for (int i = 0; i < mods.length(); ++i) {
                        modsList.append(mods.getJSONObject(i).getString("id"));
                        if (i == mods.length() - 1) continue;
                        modsList.append(", ");
                    }
                    this.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]) + "\n" + modsList.toString());
                    if (this.returnToMainMenu) {
                        this.ss.leave();
                    }
                    return;
                }
                boolean modsCongruent = true;
                for (Mod m : Mod.getAvailableMods()) {
                    if (m.isCurrentlyEnabled() == modsToLoad.contains(m)) continue;
                    modsCongruent = false;
                }
                if (!modsCongruent) {
                    Mod.overriddenEnabledModIds = new ArrayList();
                    for (Mod m : modsToLoad) {
                        Mod.overriddenEnabledModIds.add(m.id);
                    }
                    this.ss.mrpd = new ModReloadProgressDialog(new Runnable(){

                        @Override
                        public void run() {
                            for (Mod m : modsToLoad) {
                                if (m.isCurrentlyEnabled()) continue;
                                ((OpenGameMission)OpenGameMission.this).ss.menu = false;
                                ((OpenGameMission)OpenGameMission.this).ss.gameToLoad = null;
                                ((OpenGameMission)OpenGameMission.this).ss.mrpd = null;
                                OpenGameMission.this.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]));
                                if (OpenGameMission.this.returnToMainMenu) {
                                    OpenGameMission.this.ss.leave();
                                }
                                return;
                            }
                            try {
                                StrategicScreen ss2 = new StrategicScreen(OpenGameMission.this.g, new CampaignWorld(((OpenGameMission)OpenGameMission.this).ss.gameToLoad, OpenGameMission.this.g, false));
                                ss2.w.speed = CampaignWorld.Speed.STOP;
                                ((OpenGameMission)OpenGameMission.this).g.s = ss2;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                OpenGameMission.this.g.reportError(Lang._t("Unable_to_load_game", new Object[0]), e, null, true);
                                return;
                            }
                            OpenGameMission.this.ss.updateBackgrounds();
                            ((OpenGameMission)OpenGameMission.this).ss.menu = false;
                            ((OpenGameMission)OpenGameMission.this).ss.gameToLoad = null;
                            ((OpenGameMission)OpenGameMission.this).ss.mrpd = null;
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            ((OpenGameMission)OpenGameMission.this).ss.menu = false;
                            ((OpenGameMission)OpenGameMission.this).ss.gameToLoad = null;
                            ((OpenGameMission)OpenGameMission.this).ss.mrpd = null;
                            OpenGameMission.this.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]));
                            if (OpenGameMission.this.returnToMainMenu) {
                                OpenGameMission.this.ss.leave();
                            }
                        }
                    });
                } else {
                    StrategicScreen ss2 = new StrategicScreen(this.g, new CampaignWorld(this.ss.gameToLoad, this.g, false));
                    ss2.w.speed = CampaignWorld.Speed.STOP;
                    this.g.s = ss2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.g.reportError(Lang._t("Unable_to_load_game", new Object[0]), e, null, true);
                if (!this.returnToMainMenu) break block20;
                this.ss.leave();
            }
        }
    }

    @Override
    public void cancelled() {
        if (this.returnToMainMenu) {
            this.ss.leave();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.CONQUEST);
        } else {
            this.g.s = this.ss;
        }
    }
}

