/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.LoadableFilter;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class OpenDesignButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof EditShipIntent && !(us.intent instanceof ChallengeEditShipIntent);
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Open_design", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        EditShipIntent esi = (EditShipIntent)us.intent;
        Empire e = esi.getPlayerEmpire();
        if (e == null) {
            ShipHelperWidget shw = ShipHelperWidget.get(esi.type(us), us.g.getBestCOA(), Tech.getStandardBonuses(), esi.getOriginal(us), 0);
            ConstructionBackend cbe = ShipEditorUtils.shipsList(esi.type(us), shw);
            FileScreen fs = new FileScreen(cbe, new OpenShipMission(us.g, us, cbe), shw, new PriceInlineInfo(shw, esi.getOriginal(us)), esi.type(us).name());
            us.g.s = fs;
            fs.enabledFilter = new LoadableFilter(shw);
        } else {
            ShipHelperWidget shw = ShipHelperWidget.get(esi.type(us), e.arms, e.bonuses(), esi.getOriginal(us), e.money);
            ConstructionBackend cbe = ShipEditorUtils.shipsList(esi.type(us), shw);
            FileScreen fs = new FileScreen(cbe, new OpenShipMission(us.g, us, cbe), shw, new PriceInlineInfo(shw, esi.getOriginal(us)), esi.type(us).name());
            fs.enabledFilter = new AffordableFilter(e.money, shw, esi.getOriginal(us));
            fs.allowOpeningDisabledItems = true;
            us.g.s = fs;
        }
    }

    @Override
    public String hotkey(UniScreen us) {
        return "O";
    }

    private strictfp static class OpenShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final ConstructionBackend backend;

        public OpenShipMission(AirshipGame g, UniScreen us, ConstructionBackend backend) {
            this.g = g;
            this.us = us;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Open_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Open", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        @Override
        public void fileSelected(String path) {
            this.g.s = this.us;
            EditShipIntent esi = (EditShipIntent)this.us.intent;
            try {
                Airship ship = new Airship(new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8")));
                BonusSet bonuses = Tech.getStandardBonuses();
                if (esi.getPlayerEmpire() != null) {
                    bonuses = esi.getPlayerEmpire().bonuses();
                }
                ship.constructionBonuses.clear();
                ship.constructionBonuses.addAll(bonuses);
                ship.currentBonuses.clear();
                ship.currentBonuses.addAll(bonuses);
                ship.repair();
                Airship prevShip = esi.getShip(this.us);
                ship.setX(prevShip.getX());
                if (ship.type.onGround) {
                    ship.setY(PlaceShipTool.getPlacement((Airship)ship, (double)ship.getX(), (double)ship.getY(), (boolean)ship.flipped, (UniScreen)this.us, (boolean)false).y);
                } else {
                    ship.setY(prevShip.getY());
                    if (ship.getY() < (double)(512 - ship.serviceCeiling())) {
                        ship.setY(512 - ship.serviceCeiling());
                    }
                }
                esi.setShip(this.us, ship);
                esi.centerShip(this.us);
                esi.justSaved = true;
            }
            catch (Loadable.NotFoundException e) {
                this.g.showError(e.getMessage());
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, null, false);
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

