/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.UniscreenModLoadUI;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class MultiplayerSetupIntent
implements UniScreen.Intent,
RestrictsShipPlacement {
    public final boolean flipped;
    public AirshipGame g;
    public Server server;
    public int channelID;
    public boolean leaveToMetaLobby;
    public long seed;
    public ArrayList<ChatMsg> chat = new ArrayList();
    public boolean welcomeReceived = false;
    public boolean helloSent = false;
    public boolean readySent = false;
    public HashMap<Integer, PlayerInfo> channelPlayers = new HashMap();
    public boolean instantCommandRegeneration;
    public int costLimit;
    public int techTier;
    public boolean oneShipOnly;
    public EnumSet<ShipType> shipTypes;
    public boolean first = true;
    public boolean loadModsFromHandshake;
    public ModReloadProgressDialog mrpd;
    public boolean unableToLoadCorrectMods;
    public int landscapingCost = 0;
    public LandFormation originalGround;
    public final boolean fromMetaLobby;

    public MultiplayerSetupIntent(boolean flipped, AirshipGame g, Server server, int costLimit, boolean oneShipOnly, EnumSet<ShipType> shipTypes, int techTier, boolean instantCommandRegeneration, boolean fromMetaLobby) {
        this.flipped = flipped;
        this.g = g;
        this.server = server;
        this.costLimit = costLimit;
        this.oneShipOnly = oneShipOnly;
        this.shipTypes = shipTypes;
        this.techTier = techTier;
        this.instantCommandRegeneration = instantCommandRegeneration;
        this.fromMetaLobby = fromMetaLobby;
    }

    private boolean pollMessageAndProcess(final UniScreen us) {
        try {
            JSONObject msg;
            if (this.g.lanClient == null) {
                Iterator<PlayerInfo> it = this.channelPlayers.values().iterator();
                while (it.hasNext()) {
                    PlayerInfo pi = it.next();
                    if (this.g.players.containsKey(pi.id)) continue;
                    this.chat.add(new ChatMsg(pi, Lang._t("xxx_LEFT_xxx", pi.name), DateTime.now()));
                    it.remove();
                    if (pi.id != 0) continue;
                    this.leave(us, false);
                    return false;
                }
            }
            if ((msg = this.g.pollMessage()) != null) {
                if (msg.getString("type").equals("serverReject")) {
                    this.g.showError(Lang._t("server_rejected_" + msg.getString("reason"), new Object[0]));
                    this.leave(us, true);
                    return false;
                }
                if (msg.getString("type").equals("assignID")) {
                    this.g.lanID = msg.getInt("playerID");
                } else if (msg.getString("type").equals("welcome")) {
                    if (msg.has("info") && msg.getJSONObject("info").has("initiatorID")) {
                        this.leave(us, true);
                        this.g.showError(Lang._t("attempting_to_connect_to_conquest", new Object[0]));
                        return false;
                    }
                    this.seed = msg.getLong("seed");
                    this.channelID = msg.getInt("channelID");
                    this.welcomeReceived = true;
                    int version = msg.optInt("version", 0);
                    if (version != 101301) {
                        this.leave(us, true);
                        us.g.showError(Lang._t("host_version_incompatible", version, 101301));
                        return false;
                    }
                    if (this.loadModsFromHandshake && msg.has("info") && msg.getJSONObject("info").has("mods")) {
                        JSONObject m;
                        int i;
                        final JSONArray mods = msg.getJSONObject("info").getJSONArray("mods");
                        for (i = 0; i < mods.length(); ++i) {
                            m = mods.getJSONObject(i);
                            if (Mod.isAvailable(m.getString("id"), m.getLong("checksum"))) continue;
                            this.unableToLoadCorrectMods = true;
                            return false;
                        }
                        Mod.overriddenEnabledModIds = new ArrayList();
                        for (i = 0; i < mods.length(); ++i) {
                            m = mods.getJSONObject(i);
                            Mod.overriddenEnabledModIds.add(m.getString("id"));
                        }
                        UniscreenModLoadUI msmlu = us.findFloat(UniscreenModLoadUI.class);
                        us.clearComponents();
                        us.floats.add(msmlu);
                        this.mrpd = new ModReloadProgressDialog(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < mods.length(); ++i) {
                                    JSONObject m = mods.getJSONObject(i);
                                    if (Mod.getById(m.getString("id")).isCurrentlyEnabled()) continue;
                                    MultiplayerSetupIntent.this.unableToLoadCorrectMods = true;
                                    return;
                                }
                                us.reloadComponents();
                                MultiplayerSetupIntent.this.genGround(us);
                            }
                        }, new Runnable(){

                            @Override
                            public void run() {
                                MultiplayerSetupIntent.this.leave(us, false);
                                us.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]));
                            }
                        });
                    } else {
                        this.genGround(us);
                    }
                }
                if (msg.getString("type").equals("frame")) {
                    JSONArray frameMessages = msg.getJSONArray("messages");
                    for (int i = 0; i < frameMessages.length(); ++i) {
                        PlayerInfo pi;
                        JSONObject fm = frameMessages.getJSONObject(i);
                        if (fm.getString("type").equals("helloCombat")) {
                            this.processHello(us, fm);
                            if (!fm.has("version") || fm.getInt("version") != 101301) {
                                this.g.sendMessage(Client.msg("chat").put("text", "!!! Your version of the game is not compatible with the other player's. Please make sure you have both updated to the newest version of the game.").put("id", this.g.playerID()));
                                this.leave(us, false);
                                us.g.showError(Lang._t("game_version_incompatible", new Object[0]));
                                return false;
                            }
                            if (fm.optInt("costLimit", 0) != 0 && this.costLimit == 0) {
                                this.instantCommandRegeneration = fm.getBoolean("instantCommandRegeneration");
                                this.costLimit = fm.getInt("costLimit");
                                this.oneShipOnly = fm.optBoolean("oneShipOnly", false);
                                if (fm.has("shipTypes")) {
                                    JSONArray a = fm.getJSONArray("shipTypes");
                                    this.shipTypes = EnumSet.noneOf(ShipType.class);
                                    for (int j = 0; j < a.length(); ++j) {
                                        this.shipTypes.add(ShipType.valueOf(a.getString(j)));
                                    }
                                } else if (this.shipTypes.isEmpty()) {
                                    this.shipTypes.addAll(EnumSet.allOf(ShipType.class));
                                }
                                this.techTier = fm.getInt("techTier");
                            }
                        }
                        if (fm.getString("type").equals("chat") && (pi = this.channelPlayers.get(fm.getInt("id"))) != null) {
                            this.chat.add(new ChatMsg(pi, pi.name + ": " + fm.getString("text"), new DateTime(fm.getLong("t"), DateTimeZone.UTC)));
                        }
                        if (!fm.getString("type").equals("ready")) continue;
                        pi = this.channelPlayers.get(fm.getInt("id"));
                        if (pi == null) {
                            this.processHello(us, fm);
                        }
                        pi = this.channelPlayers.get(fm.getInt("id"));
                        if (pi.fleet == null) {
                            this.chat.add(new ChatMsg(pi, Lang._t("xxx_READY_xxx", pi.name), DateTime.now()));
                            ArrayList<Airship> fl = new ArrayList<Airship>();
                            pi.fleet = fl;
                            JSONArray fla = new JSONArray(Compression.decompressFromString(fm.getString("fleet")));
                            for (int j = 0; j < fla.length(); ++j) {
                                fl.add(new Airship(fla.getJSONObject(j)));
                            }
                        }
                        pi.groundDelta = new ArrayList();
                        JSONArray gd = new JSONArray(Compression.decompressFromString(fm.getString("groundDelta")));
                        for (int j = 0; j < gd.length(); ++j) {
                            pi.groundDelta.add(new LandFormation.BlockDelta(gd.getJSONObject(j)));
                        }
                        return false;
                    }
                    JSONArray frameMembers = msg.getJSONArray("members");
                    HashSet<Integer> serverMemberIDs = new HashSet<Integer>();
                    for (int i = 0; i < frameMembers.length(); ++i) {
                        serverMemberIDs.add(frameMembers.getInt(i));
                    }
                    ArrayList<Integer> existingMemberIDs = new ArrayList<Integer>(this.channelPlayers.keySet());
                    Collections.sort(existingMemberIDs);
                    for (int id : existingMemberIDs) {
                        PlayerInfo pi;
                        if (serverMemberIDs.contains(id) || (pi = this.channelPlayers.get(id)) == null) continue;
                        this.chat.add(new ChatMsg(pi, Lang._t("xxx_LEFT_xxx", pi.name), DateTime.now()));
                        this.channelPlayers.remove(id);
                        if (pi.id != 0) continue;
                        this.leave(us, false);
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.leave(us, true);
            us.g.reportError(Lang._t("setup_failed", new Object[0]) + "\n" + e.getMessage(), e, null, false, false);
            return false;
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        Client client;
        Client client2 = client = this.g.lanClient == null ? this.g.client : this.g.lanClient;
        if (client == null || client.isDisconnected()) {
            if (this.g.lanClient == null) {
                this.g.client = null;
            } else {
                this.g.lanClient = null;
            }
            this.leave(us, true);
            this.g.showError(Lang._t("Connection_lost", new Object[0]));
            return;
        }
        if (this.first) {
            ZoomToFitButton.zoomOut(in, us);
            this.first = false;
        }
        if (this.welcomeReceived && !this.helloSent) {
            JSONArray sts = new JSONArray();
            for (ShipType t : this.shipTypes) {
                sts.put(t.name());
            }
            this.g.sendMessage(Client.msg("helloCombat").put("name", this.g.playerName()).put("id", this.g.playerID()).put("arms", this.g.playerArms()).put("costLimit", this.costLimit).put("techTier", this.techTier).put("oneShipOnly", this.oneShipOnly).put("shipTypes", sts).put("instantCommandRegeneration", this.instantCommandRegeneration).put("version", 101301));
            this.helloSent = true;
            if (this.readySent) {
                this.sendReady(us);
            }
        }
        while (this.pollMessageAndProcess(us)) {
        }
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (this.unableToLoadCorrectMods) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.leave(us, false);
            }
            return;
        }
        if (this.canStart(us)) {
            this.startGame(us);
        }
    }

    public void genGround(UniScreen us) {
        if (us.setupGround == null) {
            Random r = new Random(this.seed);
            us.setupBG = Loadable.all(CombatBackgroundFlavor.class).get(r.nextInt(Loadable.all(CombatBackgroundFlavor.class).size()));
            Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(r, true, us.setupBG.getLandscapeType(r));
            us.setupGround = (LandFormation)p.a;
            HashMap[] mappingRef = new HashMap[]{LandBlockType.CURRENT_MAPPING};
            this.originalGround = new LandFormation(us.setupGround.toJSON(), mappingRef);
            us.setupFloaters = new ArrayList((Collection)p.b);
            us.setupTime = TimeOfDay.getRandomForTournament(r);
        }
    }

    private boolean canStart(UniScreen us) {
        if (this.channelPlayers.size() != 2) {
            return false;
        }
        for (PlayerInfo pi : this.channelPlayers.values()) {
            if (pi.fleet != null) continue;
            return false;
        }
        return true;
    }

    private void processHello(UniScreen us, JSONObject fm) {
        if (!this.channelPlayers.containsKey(fm.getInt("id"))) {
            PlayerInfo pi = new PlayerInfo(fm.getInt("id"), fm.getString("name"));
            pi.armsJSON = fm.getJSONObject("arms");
            this.channelPlayers.put(pi.id, pi);
            this.chat.add(new ChatMsg(pi, Lang._t("xxx_JOINED_xxx", pi.name), DateTime.now()));
            if (pi.id != this.g.playerID()) {
                this.helloSent = false;
            }
        }
    }

    private void startGame(UniScreen us) {
        this.g.sendMessage(Client.msg("sealChannel"));
        ArrayList<PlayerInfo> ps = new ArrayList<PlayerInfo>();
        if (this.flipped) {
            for (PlayerInfo pi : this.channelPlayers.values()) {
                if (pi.id == this.g.playerID()) continue;
                ps.add(pi);
            }
            ps.add(this.channelPlayers.get(this.g.playerID()));
        } else {
            ps.add(this.channelPlayers.get(this.g.playerID()));
            for (PlayerInfo pi : this.channelPlayers.values()) {
                if (pi.id == this.g.playerID()) continue;
                ps.add(pi);
            }
        }
        Combat c = new Combat(us.g, this.g.lanClient != null ? this.g.lanClient : this.g.client, this.server, this.seed, ps, this.costLimit, us.setupTime, this.techTier, this.instantCommandRegeneration);
        c.speedVoters = new HashMap();
        for (PlayerInfo pi : ps) {
            c.speedVoters.put(pi.id, CombatSpeed.NORMAL);
        }
        c.recording.header.type = Recording.Header.Type.MULTIPLAYER;
        c.startCountdown = 3072;
        ArrayList<ArrayList<LandFormation.BlockDelta>> deltas = new ArrayList<ArrayList<LandFormation.BlockDelta>>();
        for (PlayerInfo pi : ps) {
            deltas.add(pi.groundDelta);
        }
        this.originalGround.applyDeltas(deltas);
        c.landFormations.add(this.originalGround);
        c.landFormations.addAll(us.setupFloaters);
        c.backgroundFlavor = us.setupBG;
        c.initWheelsLegsTentaclesAndBarrels();
        us.setupGround = null;
        us.setupFloaters = null;
        us.setupBG = null;
        us.combat = c;
        us.mySide = c.getSideForID(this.g.playerID());
        us.setupFleet = null;
        us.intent = new MultiplayerCombatIntent(this.fromMetaLobby);
        c.repairAllShips();
    }

    public void leave(UniScreen us, boolean fully) {
        if (this.leaveToMetaLobby) {
            if (fully) {
                us.g.disconnectClient();
                us.g.s = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            } else {
                us.g.s = new MetaLobbyScreen(us.g, this.server);
                this.g.sendMessage(Client.msg("changeChannel").put("id", 0));
                us.g.helloSent = false;
            }
        } else {
            if (this.g.lanClient != null) {
                this.g.lanClient.close();
                this.g.lanClient = null;
            }
            if (this.server != null) {
                this.server.close();
                this.g.lanServer = null;
            }
            us.g.s = new MainMenu(us.g, MainMenu.Submenu.MULTIPLAYER);
        }
    }

    public void sendReady(UniScreen us) {
        this.readySent = true;
        JSONArray fla = new JSONArray();
        int netID = 1;
        for (Airship s : us.setupFleet) {
            s.networkID = (this.flipped ? "right." : "left.") + netID++;
            s.chunkSubIDCounter = 1;
            fla.put(s.toJSON(null));
        }
        JSONArray groundDelta = new JSONArray();
        for (LandFormation.BlockDelta d : this.originalGround.getDeltaTo(us.setupGround)) {
            groundDelta.put(d.toJSON());
        }
        if (!this.g.sendMessageWithSizeCheck(Client.msg("ready").put("id", this.g.playerID()).put("fleet", Compression.compressToString(fla.toString())).put("name", this.g.playerName()).put("arms", this.g.playerArms()).put("groundDelta", Compression.compressToString(groundDelta.toString())).put("costLimit", this.costLimit).put("instantCommandRegeneration", this.instantCommandRegeneration).put("techTier", this.techTier))) {
            this.readySent = false;
            this.g.showError(Lang._t("sent_fleet_too_large", new Object[0]));
        }
    }

    @Override
    public Rect2D placementLimits(int sideIndex, UniScreen us) {
        return this.flipped ? SingleCombatSetupIntent.RIGHT_RECT : SingleCombatSetupIntent.LEFT_RECT;
    }

    public int remainingBudget(UniScreen us) {
        int b = this.costLimit;
        for (Airship ship : us.setupFleet) {
            b -= ship.getCost();
        }
        return b;
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }

    @Override
    public boolean allowMultiSelect() {
        return false;
    }
}

