/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class MultiplayerEditShipIntent
extends EditShipIntent {
    public final StrategicScreen ss;

    public MultiplayerEditShipIntent(StrategicScreen ss) {
        this.ss = ss;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        super.tick(in, ms, us);
        if (this.ss.w.isMultiplayer()) {
            this.ss.backgroundTick(ms);
            if (this.ss.w.combatInfo != null && this.ss.w.combatInfo.defendingLoc == us.city && this.ss.combatUniScreen != null) {
                this.autosave(us);
                this.ss.g.s = this.ss.combatUniScreen;
            }
        }
        if (this.ss.w.isMultiplayer() && !this.ss.g.isConnected()) {
            this.autosave(us);
            this.ss.emergencySave("disconnected");
            this.ss.g.showError(Lang._t("Connection_lost", new Object[0]));
            this.ss.g.s = new MainMenu(this.ss.g, MainMenu.Submenu.MULTIPLAYER);
        }
    }

    @Override
    public Empire getPlayerEmpire() {
        return this.ss.w.player;
    }

    @Override
    public Airship getShip(UniScreen us) {
        return us.standaloneEditShip;
    }

    @Override
    public void doSetShip(UniScreen us, Airship ship) {
        us.standaloneEditShip = ship;
    }
}

