/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class MoveShipButton
extends UniScreen.ShipButton {
    @Override
    public boolean visible(Airship ship, Combat.Side side, UniScreen us) {
        if (ship.modules.isEmpty()) {
            return false;
        }
        if (us.intent instanceof MultiplayerSetupIntent && ((MultiplayerSetupIntent)us.intent).readySent) {
            return false;
        }
        if ((us.intent instanceof SingleCombatSetupIntent || us.intent instanceof MultiplayerSetupIntent || us.intent instanceof DefencesIntent || us.intent instanceof EditShipIntent || us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof MissionSetupIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) && !(us.tool instanceof PlaceShipTool)) {
            if ((us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) && side != us.mySide) {
                return false;
            }
            if ((us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) && !ship.type.mobile) {
                return false;
            }
            if (us.intent instanceof EditShipIntent && us.city == null) {
                return false;
            }
            if (us.intent instanceof MissionSetupIntent) {
                MissionSetupIntent pmsi = (MissionSetupIntent)us.intent;
                if (pmsi.playerBaseFleet.contains(ship)) {
                    return false;
                }
                return side == us.mySide;
            }
            return true;
        }
        return false;
    }

    @Override
    public String text(Airship ship, Combat.Side side, UniScreen us) {
        return Lang._t("Move", new Object[0]);
    }

    @Override
    public void click(Input in, Airship ship, Combat.Side side, UniScreen us) {
        int sideIndex = -1;
        if ((us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) && side != us.mySide) {
            return;
        }
        if (us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            sideIndex = us.combat.sides.indexOf(side);
        }
        if (us.intent instanceof MultiplayerSetupIntent) {
            int n = sideIndex = ((MultiplayerSetupIntent)us.intent).flipped ? 1 : 0;
        }
        if (us.intent instanceof DefencesIntent) {
            sideIndex = 1;
        }
        us.tool = new PlaceShipTool(ship, true, sideIndex, us.intent instanceof EditShipIntent);
    }

    @Override
    public boolean acceptsTool(UniScreen.Tool t) {
        return !(t instanceof PlaceShipTool);
    }
}

