/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class MoveLFTool
extends UniScreen.Tool {
    public final LandFormation lf;

    public MoveLFTool(LandFormation lf) {
        this.lf = lf;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        double wy;
        double wx = us.screenToWorldX(cursor.x);
        Clr c = this.canPlace(wx, wy = us.screenToWorldY(cursor.y), us.combat) ? Clr.WHITE : Clr.RED;
        for (int gy = 0; gy < this.lf.grid.length; ++gy) {
            for (int gx = 0; gx < this.lf.grid[0].length; ++gx) {
                if (!this.lf.grid[gy][gx].solid) continue;
                double x = cursor.x + (double)(gx * 16) * us.zoom;
                double y = cursor.y + (double)(gy * 16) * us.zoom;
                d.rect(c, x, y, 16.0 * us.zoom, 16.0 * us.zoom);
            }
        }
    }

    public boolean canPlace(double x, double y, Combat c) {
        double origX = this.lf.getX();
        double origY = this.lf.getY();
        this.lf.setX(x);
        this.lf.setY(y);
        boolean collides = false;
        for (LandFormation lf2 : c.landFormations) {
            if (this.lf == lf2 || !this.lf.collidesWith(lf2)) continue;
            collides = true;
            break;
        }
        if (!collides) {
            block1: for (Combat.Side side : c.sides) {
                for (Airship ship : side.ships) {
                    if (!this.lf.collidesWith(ship)) continue;
                    collides = true;
                    break block1;
                }
            }
        }
        this.lf.setX(origX);
        this.lf.setY(origY);
        return !collides;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double y;
        double x = us.screenToWorldX(click.x);
        if (this.canPlace(x, y = us.screenToWorldY(click.y), us.combat)) {
            this.lf.setX(x);
            this.lf.setY(y);
            us.tool = UniScreen.NAVIGATE;
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ESCAPE") || !(us.intent instanceof EditMissionIntent) && !(us.intent instanceof SingleCombatSetupIntent)) {
            us.tool = UniScreen.NAVIGATE;
        }
    }

    @Override
    public String getLabel() {
        return Lang._t("Move", new Object[0]);
    }
}

