/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNestType;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class MonsterNest
extends MapLocation
implements FleetOwner {
    public static final int MIN_TIME_EMPTY = 300000;
    public static final int MS_PER_INCOME = 7500;
    public MonsterNestType type;
    public int money;
    public int moneyMs = 7500;
    public int timeEmpty = 600000;
    public int minAttackFleetStrength = 0;
    private final ArrayList<Fleet> fleets = new ArrayList();
    private CoatOfArms arms;
    public int timeUntilNextRaid;
    public int upgradeTimer;
    public int upgradeAccumulator;
    public boolean upgrading;
    public boolean nearingCompletionMessageSent;
    public transient boolean showUpgradeStartDialog;
    public transient boolean showUpgradeNearingCompletionDialog;
    public transient boolean showUpgradeCompleteDialog;
    public int shipIDCounter = 1;
    private transient String name;
    private final transient HashMap<String, Integer> baseConstructionsCount = new HashMap();
    private final transient ArrayList<String> tNames = new ArrayList();
    public LandscapeType landscapeType;

    public String getNextShipID() {
        return "mn" + this.id + "#" + this.shipIDCounter++;
    }

    @Override
    public ArrayList<Fleet> getFleets() {
        return this.fleets;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public BonusSet bonuses() {
        return new BonusSet();
    }

    @Override
    public CoatOfArms getArms() {
        if (this.arms != null) {
            return this.arms;
        }
        CoatOfArms coa = new CoatOfArms();
        coa.setLayout(CoatOfArms.Layout.BARRY);
        coa.setTincture(Tincture.valueOf("OR"), CoatOfArms.TinctureSlot.TINCTURE0);
        coa.setTincture(Tincture.valueOf("GULES"), CoatOfArms.TinctureSlot.TINCTURE1);
        return coa;
    }

    @Override
    public AIQuality getAIQuality(WorldMap m) {
        return this.type.aiQuality;
    }

    public MonsterNest(int id, int x, int y) {
        super(id, x, y);
    }

    public void occupy(MonsterNestType type, WorldMap wm) {
        this.landscapeType = type.landscapeTypes != null ? type.getLandscapeType(wm.r) : wm.getBackground(this.x, this.y).getLandscapeType(wm.r);
        this.generateLand(wm.r, this.landscapeType);
        this.type = type;
        this.name = null;
        this.upgrading = false;
        this.nearingCompletionMessageSent = false;
        this.showUpgradeStartDialog = false;
        this.showUpgradeNearingCompletionDialog = false;
        this.showUpgradeCompleteDialog = false;
        this.upgradeAccumulator = wm.r.nextInt(type.msUntilUpgrade / 2 + 1);
        this.upgradeTimer = 0;
        if (type.heraldicStyle == null) {
            this.arms = null;
        } else if (this.arms == null) {
            this.arms = CoatOfArms.getRandom(wm.r, type.heraldicStyle);
        }
        this.minAttackFleetStrength = type.minAttackFleetStrength;
        this.timeUntilNextRaid = type.minTimeBetweenRaids;
        this.clearDefences();
        Fleet f = wm.getGarrison(this);
        for (Airship s : type.baseConstructions) {
            Airship s2 = s.clone();
            s2.networkID = this.getNextShipID();
            s2.updateOriginalDesign();
            if (s.type.mobile) {
                if (f == null) {
                    f = new Fleet(this, wm);
                    this.fleets.add(f);
                }
                f.actives.add(s2);
                continue;
            }
            if (!this.placeShip(s2, f)) continue;
            this.addDefence(s2);
        }
    }

    public void clear(WorldMap wm) {
        for (Fleet f : this.getFleets()) {
            f.broadcastDestroyed(wm);
        }
        this.getFleets().clear();
        this.clearDefences();
        this.money = 0;
        this.minAttackFleetStrength = 0;
        this.type = null;
        this.arms = null;
        this.name = null;
    }

    @Override
    public String getDisplayName() {
        if (this.name == null) {
            this.name = this.type == null ? Lang._t("empty_monster_nest", new Object[0]) : Lang._t(this.type.name + "_displayName", new Object[0]);
        }
        return this.name;
    }

    @Override
    public String getNameOrTranslationKey() {
        return this.type == null ? "empty_monster_nest" : this.type.name + "_displayName";
    }

    @Override
    public boolean nameIsTranslationKey() {
        return true;
    }

    public MonsterNest(JSONObject o, WorldMap wm, HashMap<Integer, LandBlockType>[] mappingRef) {
        super(o, mappingRef);
        this.type = o.has("type") ? MonsterNestType.ofName(o.getString("type")) : null;
        this.arms = o.has("arms") ? new CoatOfArms(o.getJSONObject("arms")) : null;
        this.money = o.getInt("money");
        this.moneyMs = o.getInt("moneyMs");
        this.timeEmpty = o.getInt("timeEmpty");
        this.minAttackFleetStrength = o.optInt("minAttackFleetStrength", this.type == null ? 0 : this.type.minAttackFleetStrength);
        this.timeUntilNextRaid = o.optInt("timeUntilNextRaid", 60000);
        this.upgradeAccumulator = o.optInt("upgradeAccumulator", 0);
        this.upgradeTimer = o.optInt("upgradeTimer", this.upgradeAccumulator / wm.difficulty.minimalNestUpgradeTimeDivider);
        this.upgrading = o.optBoolean("upgrading", false);
        this.nearingCompletionMessageSent = o.optBoolean("nearingCompletionMessageSent", false);
        this.shipIDCounter = o.optInt("shipIDCounter", 1);
        JSONArray a = o.getJSONArray("fleets");
        for (int i = 0; i < a.length(); ++i) {
            this.fleets.add(new Fleet(a.getJSONObject(i), wm));
        }
        this.landscapeType = LandscapeType.ofName(o.optString("landscapeType", "GRASSLAND"));
    }

    public void finishFleets(JSONObject o, WorldMap m) {
        JSONArray a = o.getJSONArray("fleets");
        for (int i = 0; i < a.length(); ++i) {
            this.getFleets().get(i).finish(a.getJSONObject(i), m, new BonusSet());
        }
    }

    public JSONObject toJSON(WorldMap m) {
        JSONObject o = super.toJSON();
        if (this.type != null) {
            o.put("type", this.type.name);
        }
        if (this.arms != null) {
            o.put("arms", this.arms.toJSON());
        }
        o.put("money", this.money);
        o.put("moneyMs", this.moneyMs);
        o.put("timeEmpty", this.timeEmpty);
        o.put("minAttackFleetStrength", this.minAttackFleetStrength);
        o.put("timeUntilNextRaid", this.timeUntilNextRaid);
        o.put("upgradeAccumulator", this.upgradeAccumulator);
        o.put("upgradeTimer", this.upgradeTimer);
        o.put("upgrading", this.upgrading);
        o.put("nearingCompletionMessageSent", this.nearingCompletionMessageSent);
        o.put("shipIDCounter", this.shipIDCounter);
        JSONArray a = new JSONArray();
        o.put("fleets", a);
        for (Fleet f : this.getFleets()) {
            a.put(f.toJSON(m));
        }
        return o;
    }

    public boolean showUpgradeStartDialog() {
        return this.type != null && this.showUpgradeStartDialog;
    }

    public boolean showUpgradeNearingCompletionDialog() {
        return this.type != null && this.upgrading && !this.showUpgradeNearingCompletionDialog && this.type.upgradeNearingCompletionMessage;
    }

    public boolean showUpgradeCompleteDialog() {
        return this.type != null && this.showUpgradeCompleteDialog;
    }

    public int incomeBalance(WorldMap wm) {
        int income = this.type.income;
        for (Airship s : this.getDefences()) {
            income -= s.maintenanceCost();
        }
        for (Fleet f : this.fleets) {
            for (Airship s : f.actives) {
                income -= s.maintenanceCost();
            }
            for (Airship s : f.reserve) {
                income -= s.maintenanceCost();
            }
        }
        return (int)((double)income * wm.difficulty.monsterNestIncomeMult(wm.monsterity));
    }

    private boolean currentlyRaiding() {
        for (Fleet f : this.fleets) {
            if (f.location == this) continue;
            return true;
        }
        return false;
    }

    public void repairAll(WorldMap map) {
        Fleet garrison = map.getGarrison(this);
        ListIterator<Airship> it = this.defences.listIterator();
        while (it.hasNext()) {
            Airship s = (Airship)it.next();
            s.repair();
            if (s.getOriginalDesign() == null || s.getCost() == s.getOriginalDesign().getCost()) continue;
            Airship s2 = s.getOriginalDesign();
            s2.updateOriginalDesign();
            it.set(s2);
            this.placeShip(s2, garrison);
        }
        ListIterator<Fleet> fit = this.fleets.listIterator();
        while (fit.hasNext()) {
            Airship s2;
            Airship s;
            Fleet f = fit.next();
            ListIterator<Airship> it2 = f.actives.listIterator();
            while (it2.hasNext()) {
                s = it2.next();
                s.repair();
                if (s.getOriginalDesign() == null || s.getCost() == s.getOriginalDesign().getCost()) continue;
                s2 = s.getOriginalDesign();
                s2.updateOriginalDesign();
                it2.set(s2);
            }
            it2 = f.reserve.listIterator();
            while (it2.hasNext()) {
                s = it2.next();
                s.repair();
                if (s.getOriginalDesign() == null || s.getCost() == s.getOriginalDesign().getCost()) continue;
                s2 = s.getOriginalDesign();
                s2.updateOriginalDesign();
                it2.set(s2);
            }
        }
    }

    public void tick(int ms, WorldMap map, boolean smart, boolean isMultiplayer) {
        this.tickMessages();
        if (this.type == null) {
            this.timeEmpty += ms;
            if (this.timeEmpty > 300000) {
                int currentFilledNests = 0;
                for (MonsterNest mn : map.nests) {
                    if (mn.type == null) continue;
                    ++currentFilledNests;
                }
                double currentNestProportion = (double)currentFilledNests * 1.0 / (double)map.nests.size();
                double proportionDiff = map.difficulty.monsterNestDensity(map.monsterity) - currentNestProportion;
                double chance = StrictMath.min(1.2E-6, (double)(this.timeEmpty - 300000) * 3.0E-12) * (double)ms * proportionDiff;
                if (map.r.nextDouble() < chance) {
                    ArrayList<MonsterNestType> types = Loadable.all(MonsterNestType.class);
                    Iterator<MonsterNestType> it = types.iterator();
                    while (it.hasNext()) {
                        MonsterNestType mnt = it.next();
                        if (mnt.respawns && (!mnt.oneOnly || !MonsterNest.hasType(map, mnt))) continue;
                        it.remove();
                    }
                    int totalWeight = 0;
                    for (MonsterNestType mnt : types) {
                        totalWeight += mnt.spawnWeight;
                    }
                    int typeIndex = 0;
                    for (int roll = map.r.nextInt(totalWeight); roll >= types.get((int)typeIndex).spawnWeight; roll -= types.get((int)typeIndex++).spawnWeight) {
                    }
                    MonsterNestType t = types.get(typeIndex);
                    this.occupy(t, map);
                    HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                    for (Empire e : map.empires) {
                        String bs = this.type.bonusSuffix(e);
                        if (bs.isEmpty()) continue;
                        altTexts.put(e, Lang._t(this.type.name + "_occupation" + bs, new Object[0]));
                    }
                    this.addMessage(MapLocation.MessageType.MONSTER_OCCUPATION, Lang._t(this.type.name + "_occupation", new Object[0]), altTexts);
                }
            }
            return;
        }
        this.timeEmpty = 0;
        this.moneyMs += ms;
        this.timeUntilNextRaid -= ms;
        if (this.moneyMs >= 7500) {
            this.moneyMs -= 7500;
            this.money += this.incomeBalance(map);
        }
        if (this.money < 0) {
            this.money = 0;
        }
        this.baseConstructionsCount.clear();
        int bcsz = this.type.baseConstructions.size();
        for (int bci = 0; bci < bcsz; ++bci) {
            Airship s = this.type.baseConstructions.get(bci);
            if (!this.baseConstructionsCount.containsKey(s.getName())) {
                this.baseConstructionsCount.put(s.getName(), 1);
                continue;
            }
            this.baseConstructionsCount.put(s.getName(), this.baseConstructionsCount.get(s.getName()) + 1);
        }
        int dsz = this.defences.size();
        for (int di = 0; di < dsz; ++di) {
            Airship s = (Airship)this.defences.get(di);
            if (!this.baseConstructionsCount.containsKey(s.getName())) continue;
            if (this.baseConstructionsCount.get(s.getName()) == 1) {
                this.baseConstructionsCount.remove(s.getName());
                continue;
            }
            this.baseConstructionsCount.put(s.getName(), this.baseConstructionsCount.get(s.getName()) - 1);
        }
        int fsz = this.fleets.size();
        for (int fi = 0; fi < fsz; ++fi) {
            Fleet fleet = this.fleets.get(fi);
            int asz = fleet.actives.size();
            for (int ai = 0; ai < asz; ++ai) {
                Airship s = fleet.actives.get(ai);
                if (!this.baseConstructionsCount.containsKey(s.getName())) continue;
                if (this.baseConstructionsCount.get(s.getName()) == 1) {
                    this.baseConstructionsCount.remove(s.getName());
                    continue;
                }
                this.baseConstructionsCount.put(s.getName(), this.baseConstructionsCount.get(s.getName()) - 1);
            }
            int rsz = fleet.reserve.size();
            for (int ri = 0; ri < rsz; ++ri) {
                Airship s = fleet.reserve.get(ri);
                if (!this.baseConstructionsCount.containsKey(s.getName())) continue;
                if (this.baseConstructionsCount.get(s.getName()) == 1) {
                    this.baseConstructionsCount.remove(s.getName());
                    continue;
                }
                this.baseConstructionsCount.put(s.getName(), this.baseConstructionsCount.get(s.getName()) - 1);
            }
        }
        if (!this.baseConstructionsCount.isEmpty()) {
            this.tNames.clear();
            this.tNames.addAll(this.baseConstructionsCount.keySet());
            Collections.sort(this.tNames);
            String constructionTName = this.tNames.get(0);
            if (this.constructionTarget == null || !this.constructionTarget.getName().equals(constructionTName)) {
                for (int bci = 0; bci < bcsz; ++bci) {
                    Airship s = this.type.baseConstructions.get(bci);
                    if (!s.getName().equals(constructionTName)) continue;
                    this.constructionTarget = s.clone();
                    break;
                }
            }
        }
        if (this.constructionTarget == null && !this.type.additionalConstructions.isEmpty()) {
            this.constructionTarget = this.type.additionalConstructions.get(map.r.nextInt(this.type.additionalConstructions.size())).clone();
        }
        if (this.constructionTarget != null && this.incomeBalance(map) > 0 && this.money >= this.constructionTarget.getCost()) {
            this.constructionTarget.networkID = this.getNextShipID();
            if (this.constructionTarget.type.mobile) {
                Fleet homeFleet = map.getGarrison(this);
                if (homeFleet == null) {
                    homeFleet = new Fleet(this, map);
                    this.fleets.add(homeFleet);
                }
                homeFleet.actives.add(this.constructionTarget);
                this.money -= this.constructionTarget.getCost();
                this.constructionTarget.updateOriginalDesign();
                this.constructionTarget = null;
            } else {
                if (this.placeShip(this.constructionTarget, map.getGarrison(this))) {
                    this.money -= this.constructionTarget.getCost();
                    this.constructionTarget.updateOriginalDesign();
                }
                this.constructionTarget = null;
            }
        }
        if (this.upgrading) {
            this.upgradeAccumulator += ms;
            if (this.type.upgradeNearingCompletionMessage && !this.nearingCompletionMessageSent && this.upgradeAccumulator >= this.type.msForUpgrade * 3 / 4) {
                HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                for (Empire e : map.empires) {
                    String bs = this.type.bonusSuffix(e);
                    if (bs.isEmpty()) continue;
                    altTexts.put(e, Lang._t(this.type.name + "_upgradeNearingCompletion" + bs, new Object[0]));
                }
                this.addMessage(MapLocation.MessageType.MONSTER_OCCUPATION, Lang._t(this.type.name + "_upgradeNearingCompletion", new Object[0]), altTexts);
                this.showUpgradeNearingCompletionDialog = true;
            }
            if (this.upgradeAccumulator >= this.type.msForUpgrade && this.type.upgradeTo() != null) {
                HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                for (Empire e : map.empires) {
                    String bs = this.type.bonusSuffix(e);
                    if (bs.isEmpty()) continue;
                    altTexts.put(e, Lang._t(this.type.name + "_upgradeDone" + bs, new Object[0]));
                }
                this.addMessage(MapLocation.MessageType.MONSTER_OCCUPATION, Lang._t(this.type.name + "_upgradeDone", new Object[0]), altTexts);
                this.upgradeAccumulator -= this.type.msForUpgrade;
                this.occupy(this.type.upgradeTo(), map);
                this.showUpgradeCompleteDialog = true;
                return;
            }
        } else if (!this.alreadyHasOneOnlyUpgradeNest(map)) {
            this.upgradeAccumulator += ms;
            this.upgradeTimer += ms;
            if (this.upgradeAccumulator >= this.type.msUntilUpgrade && this.upgradeTimer >= this.type.msUntilUpgrade / map.difficulty.minimalNestUpgradeTimeDivider && this.type.upgradeTo() != null && !this.currentlyRaiding()) {
                HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                for (Empire e : map.empires) {
                    String bs = this.type.bonusSuffix(e);
                    if (bs.isEmpty()) continue;
                    altTexts.put(e, Lang._t(this.type.name + "_upgrading" + bs, new Object[0]));
                }
                this.addMessage(MapLocation.MessageType.MONSTER_OCCUPATION, Lang._t(this.type.name + "_upgrading", new Object[0]), altTexts);
                this.upgrading = true;
                this.showUpgradeStartDialog = true;
                this.upgradeAccumulator -= this.type.msUntilUpgrade;
            }
        }
        if (!this.upgrading && smart && this.timeUntilNextRaid <= 0 && this.fleets.size() == 1 && this.type.minAttackFleetStrength > 0 && this.fleets.get((int)0).location == this) {
            Fleet homeFleet = this.fleets.get(0);
            ArrayList<Airship> attackShips = new ArrayList<Airship>();
            ArrayList<String> homeFleetNames = new ArrayList<String>(this.type.homeFleet);
            int strength = 0;
            boolean hasLandships = false;
            for (Airship s : homeFleet.getAllShips()) {
                if (!s.type.mobile) continue;
                if (homeFleetNames.contains(s.getName())) {
                    homeFleetNames.remove(s.getName());
                    continue;
                }
                if (!this.type.needsRoad && s.type.onGround) continue;
                attackShips.add(s);
                hasLandships |= s.type.onGround;
                strength += s.getCost();
            }
            if (strength >= this.minAttackFleetStrength) {
                ArrayList<City> candidates = new ArrayList<City>();
                for (Empire e : map.empires) {
                    if (e.timeSinceRaided < this.type.minTimeBetweenCityRaids) continue;
                    for (City c : e.cities) {
                        double ratio;
                        int waitTime;
                        int dsq;
                        if (hasLandships && !map.connectedByLand(this, c) || (dsq = (this.x - c.x) * (this.x - c.x) + (this.y - c.y) * (this.y - c.y)) > this.type.attackRadius * this.type.attackRadius / 8 / 8) continue;
                        int defendingStrength = 100;
                        Fleet garrison = map.getGarrison(c);
                        if (garrison != null) {
                            defendingStrength += WorldMap.cost(garrison);
                        }
                        for (Airship b : c.getDefences()) {
                            defendingStrength = (int)((double)defendingStrength + (double)b.getCost() * 0.6);
                        }
                        if (isMultiplayer && e.playerControlled && map.timeSinceAIAttackVsHuman < (waitTime = map.difficulty.playerAttackInterval + (int)((double)map.difficulty.playerAttackInterval / (ratio = (double)strength * 3.0 / (double)defendingStrength))) || c.economicDamage >= 3 || strength <= defendingStrength / 3) continue;
                        candidates.add(c);
                    }
                }
                Collections.shuffle(candidates, map.r);
                if (!candidates.isEmpty()) {
                    City target = (City)candidates.get(0);
                    if (attackShips.size() == homeFleet.size()) {
                        homeFleet.travelTo(target, map);
                    } else {
                        Fleet f2 = new Fleet(homeFleet, map);
                        f2.actives.retainAll(attackShips);
                        f2.reserve.retainAll(attackShips);
                        homeFleet.actives.removeAll(attackShips);
                        homeFleet.reserve.removeAll(attackShips);
                        this.fleets.add(f2);
                        f2.travelTo(target, map);
                    }
                    this.timeUntilNextRaid = this.type.minTimeBetweenRaids;
                    map.owner((City)target).timeSinceRaided = 0;
                    if (map.owner((City)target).playerControlled && isMultiplayer) {
                        map.timeSinceAIAttackVsHuman = 0;
                    }
                }
            }
        }
        Iterator<Fleet> it = this.fleets.iterator();
        while (it.hasNext()) {
            if (!it.next().tick(ms, this, map)) continue;
            it.remove();
        }
    }

    private boolean alreadyHasOneOnlyUpgradeNest(WorldMap map) {
        if (this.type.upgradeTo() == null || !this.type.upgradeTo().oneOnly) {
            return false;
        }
        return MonsterNest.hasType(map, this.type.upgradeTo());
    }

    public static boolean hasType(WorldMap map, MonsterNestType type) {
        int nsz = map.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            if (map.nests.get((int)ni).type != type) continue;
            return true;
        }
        return false;
    }
}

