/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ModuleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import org.json.JSONObject;

public strictfp class ModuleCategory
extends Loadable
implements Comparator<ModuleType> {
    private Locale sortLocale;
    private ArrayList<ModuleType> contents;

    public ModuleCategory(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
    }

    public String getName() {
        return Lang._t("modulecategory_" + this.name, new Object[0]);
    }

    public static ModuleCategory ofName(String name) {
        return Loadable.ofName(ModuleCategory.class, name);
    }

    public ArrayList<ModuleType> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList();
            for (ModuleType mt : Loadable.all(ModuleType.class)) {
                if (!mt.in(this)) continue;
                this.contents.add(mt);
            }
        }
        if (Lang.currentLocale != this.sortLocale) {
            Collections.sort(this.contents, this);
            this.sortLocale = Lang.currentLocale;
        }
        return this.contents;
    }

    @Override
    public int compare(ModuleType t, ModuleType t1) {
        if (t.sort == t1.sort) {
            return t.getName().compareToIgnoreCase(t1.getName());
        }
        return t.sort - t1.sort;
    }
}

