/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.DownloadPublishedZippedItemsProcess;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.StringAdapter;
import com.zarkonnen.airships.UploadModProcess;
import com.zarkonnen.airships.ZipUtils;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.apache.commons.io.FileUtils;

public strictfp class ModsScreen
implements Screen {
    public final AirshipGame g;
    public final ScrollBar modsSB = new ScrollBar();
    public final ScrollBar descSB = new ScrollBar();
    private Mod deleteConfirm = null;
    private Mod selected = null;
    private boolean doReload;
    private String installError = null;
    public ModReloadProgressDialog mrpd = null;
    public UploadModProcess ump = null;
    public UploadModProcess.Progress umpp = null;
    public int umpCompleteWait = 0;
    public DownloadPublishedZippedItemsProcess dmp = null;
    public DownloadPublishedZippedItemsProcess.Progress dmpp = null;
    private boolean needsManualWLA = false;
    private ArrayList<Mod> toBeEnabled = new ArrayList();
    private boolean leaveCheck;
    private static final Img REMOVE = new Img("ui", 144, 416, 16, 16, false);
    ScrollBar.ScrollElementAdapter<Mod> modAdapter = new ScrollBar.ScrollElementAdapter<Mod>(){

        @Override
        public int getHeight(Mod t, MyDraw d, int availableWidth) {
            return AGame.BIG_FOUNT.height + AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final Mod mod, MyDraw d, int x, int y, int width) {
            int H = AGame.BIG_FOUNT.height + AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
            int innerH = AGame.BIG_FOUNT.height + AGame.FOUNT.height;
            if (mod.logo != null) {
                ((org.newdawn.slick.Graphics)d.frame().nativeRenderer()).drawImage(mod.logo, (float)(x + 1), (float)(y + 1), (float)(x + innerH - 1), (float)(y + innerH - 1), 0.0f, 0.0f, 512.0f, 512.0f);
                d.drawPanelBorder(x, y, innerH, innerH);
            } else {
                d.drawPanel(x, y, innerH, innerH);
            }
            d.hook(x, y, width, H, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    ModsScreen.this.selected = mod;
                }
            });
            x += innerH + MyDraw.UI_SPACING;
            width -= innerH + MyDraw.UI_SPACING;
            String mn = mod.getName();
            if (mod == ModsScreen.this.selected) {
                mn = MyDraw.SELECTED_C + mn;
            } else if (!mod.isCurrentlyEnabled()) {
                mn = "[bbbbbb]" + mn;
            }
            if (mod.isLocal && PublishedItemsManager.get(PublishedItemsManager.Type.MOD, mod.getIdeallyEnglishName()) != null) {
                mn = mn + " [65c0f9]" + Lang._t("Published", new Object[0]);
            }
            if (!mod.isLocal) {
                mn = mn + " [65c0f9]Steam";
            }
            d.text(mn, AGame.BIG_FOUNT, x, y, width - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING - d.tw(Lang._t("Enabled", new Object[0])) - MyDraw.UI_SPACING, AGame.BIG_FOUNT.height, 0, true);
            if (mod.preemptedBy != null) {
                d.text("[bb421d]" + Lang._t("mod_preempted", mod.preemptedBy.getName()), AGame.FOUNT, x, y + AGame.BIG_FOUNT.height);
            } else if (mod.loadFailed) {
                d.text("[bb421d]" + Lang._t("mod_loading_failed", new Object[0]), AGame.FOUNT, x, y + AGame.BIG_FOUNT.height);
            } else {
                if (mod.isCurrentlyEnabled()) {
                    d.text(Lang._t("Enabled", new Object[0]), AGame.FOUNT, x, y + AGame.BIG_FOUNT.height);
                }
                if (mod.isLocal) {
                    d.iconButton(x + width - MyDraw.BUTTON_H, y, REMOVE, new Runnable(){

                        @Override
                        public void run() {
                            ModsScreen.this.deleteConfirm = mod;
                        }
                    }, true);
                    d.tooltip((double)(x + width - MyDraw.BUTTON_H), (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Delete_Mod", new Object[0]));
                }
                d.toggle(x + width - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING - d.tw(Lang._t("Enabled", new Object[0])), y, d.tw(Lang._t("Enabled", new Object[0])), Lang._t("Enabled", new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        if (ModsScreen.this.toBeEnabled.contains(mod)) {
                            ModsScreen.this.toBeEnabled.remove(mod);
                        } else {
                            ModsScreen.this.toBeEnabled.add(mod);
                        }
                    }
                }, ModsScreen.this.toBeEnabled.contains(mod), true);
            }
        }
    };
    private final StringAdapter sa = new StringAdapter(true);

    public ModsScreen(AirshipGame g) {
        this.g = g;
        this.selected = Mod.mods.isEmpty() ? null : Mod.mods.get(0);
        this.resetToBeEnabled();
    }

    private void resetToBeEnabled() {
        this.toBeEnabled.clear();
        this.toBeEnabled.addAll(Mod.getEnabledMods());
    }

    private boolean canApply() {
        return !this.toBeEnabled.containsAll(Mod.getEnabledMods()) || !Mod.getEnabledMods().containsAll(this.toBeEnabled);
    }

    private void disableAll() {
        this.toBeEnabled.clear();
    }

    private void apply(final boolean leaveOnSuccess) {
        final ArrayList<Mod> oldList = Mod.getEnabledMods();
        for (Mod m : Mod.getAvailableMods()) {
            m.setPermanentlyEnabled(this.toBeEnabled.contains(m));
        }
        final Runnable failRunnable = new Runnable(){

            @Override
            public void run() {
                for (Mod m : Mod.mods) {
                    m.setPermanentlyEnabled(oldList.contains(m));
                }
                ModsScreen.this.mrpd = new ModReloadProgressDialog(new Runnable(){

                    @Override
                    public void run() {
                        ModsScreen.this.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]));
                        if (!Mod.mods.contains(ModsScreen.this.selected)) {
                            ModsScreen.this.selected = Mod.mods.isEmpty() ? null : Mod.mods.get(0);
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        ModsScreen.this.g.s = new MainMenu(ModsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                        ModsScreen.this.g.showError(Lang._t("Unable_to_reload_mods", new Object[0]));
                    }
                });
            }
        };
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                if (ModsScreen.this.canApply()) {
                    failRunnable.run();
                } else if (leaveOnSuccess) {
                    ModsScreen.this.g.s = new MainMenu(ModsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                } else if (!Mod.mods.contains(ModsScreen.this.selected)) {
                    ModsScreen.this.selected = Mod.mods.isEmpty() ? null : Mod.mods.get(0);
                }
            }
        }, failRunnable);
    }

    private void leave() {
        if (this.canApply()) {
            this.leaveCheck = true;
        } else {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
    }

    private void reload() {
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                if (!Mod.mods.contains(ModsScreen.this.selected)) {
                    ModsScreen.this.selected = Mod.mods.isEmpty() ? null : Mod.mods.get(0);
                }
                ModsScreen.this.resetToBeEnabled();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ModsScreen.this.g.s = new MainMenu(ModsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                ModsScreen.this.g.showError(Lang._t("Unable_to_reload_mods", new Object[0]));
            }
        });
    }

    private void doDelete() {
        AGame.deleteDir(this.deleteConfirm.dir);
        if (this.deleteConfirm == this.selected) {
            Mod old = this.selected;
            this.selected = Mod.mods.get((Mod.mods.indexOf(this.selected) + Mod.mods.size() - 1) % Mod.mods.size());
            if (this.selected == old) {
                this.selected = null;
            }
        }
        this.doReload = true;
        this.deleteConfirm = null;
    }

    private void promptInstall(Input in) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_mod_to_install", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Install", new Object[0]));
        jfc.setFileView(new FV());
        jfc.setFileFilter(new FF());
        jfc.setFileSelectionMode(2);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
        }
        if (jfc.showOpenDialog(null) == 0) {
            this.doInstall(jfc.getSelectedFile(), in);
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private void doInstall(File f, Input in) {
        if (f == null || !f.exists()) {
            return;
        }
        File dst = null;
        if (f.isDirectory()) {
            dst = new File(new File(AGame.getGameDirectory(), "mods"), f.getName());
            if (dst.exists()) {
                this.installError = Lang._t("mod_already_installed", new Object[0]);
                return;
            }
            try {
                FileUtils.copyDirectory((File)f, (File)dst);
            }
            catch (Exception e) {
                this.installError = Lang._t("unable_to_copy_mod", new Object[0]);
                return;
            }
        }
        File tmpDst = new File(new File(new File(AGame.getGameDirectory(), "steam"), "tmp"), f.getName());
        FileInputStream fis = null;
        try {
            AGame.deleteDir(tmpDst);
            fis = new FileInputStream(f);
            ZipUtils.unzip(fis, tmpDst);
            boolean success = false;
            File[] fs = tmpDst.listFiles();
            if (fs != null) {
                for (File subDir : fs) {
                    if (!new File(subDir, "info.json").exists()) continue;
                    dst = new File(new File(AGame.getGameDirectory(), "mods"), subDir.getName());
                    if (dst.exists()) {
                        this.installError = Lang._t("mod_already_installed", new Object[0]);
                        return;
                    }
                    FileUtils.moveDirectory((File)subDir, (File)dst);
                    success = true;
                    break;
                }
            }
            if (!success) {
                this.installError = Lang._t("unable_to_install_mod", new Object[0]);
                return;
            }
        }
        catch (Exception e) {
            this.installError = Lang._t("unable_to_install_mod", new Object[0]);
            return;
        }
        this.reload();
        for (Mod m : Mod.mods) {
            if (!m.dir.equals(dst) || m.loadInfoFailed || m.isPermanentlyEnabled()) continue;
            this.reload();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCurrentMod(Input in) {
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_file_to_export_to", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Export", new Object[0]));
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
            jfc.setSelectedFile(new File(desktopF, this.selected.id + ".amod"));
        }
        if (jfc.showSaveDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            if (f.exists()) {
                f.delete();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                ZipUtils.enzip(this.selected.dir, fos);
                fos.flush();
            }
            catch (Exception e) {
                f.delete();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private void syncCurrentMod() {
        PublishedItemsManager.Entry e = PublishedItemsManager.get(PublishedItemsManager.Type.MOD, this.selected.getIdeallyEnglishName());
        ArrayList<PublishedItemsManager.Entry> downloadList = new ArrayList<PublishedItemsManager.Entry>();
        downloadList.add(e);
        this.dmp = new DownloadPublishedZippedItemsProcess(downloadList);
    }

    private boolean missingPublisheds() {
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            if (e.type != PublishedItemsManager.Type.MOD || Mod.isLocalPresentWithName(e.title)) continue;
            return true;
        }
        return false;
    }

    private void downloadMissingPublisheds() {
        ArrayList<PublishedItemsManager.Entry> downloadList = new ArrayList<PublishedItemsManager.Entry>();
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            if (e.type != PublishedItemsManager.Type.MOD || Mod.isLocalPresentWithName(e.title)) continue;
            downloadList.add(e);
        }
        if (!downloadList.isEmpty()) {
            this.dmp = new DownloadPublishedZippedItemsProcess(downloadList);
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (this.ump != null) {
            if (this.umpp == null || !this.umpp.done) {
                this.umpp = this.ump.tick(in);
            }
            if (this.umpp.done && !this.ump.needsWLA) {
                this.umpCompleteWait += ms;
                if (this.umpCompleteWait >= 2000) {
                    Analytics.modUpload(!this.umpp.failed);
                    this.ump = null;
                    this.umpp = null;
                    this.umpCompleteWait = 0;
                }
            }
            return;
        }
        if (this.dmp != null) {
            this.dmpp = this.dmp.tick();
            if (this.dmpp.done) {
                this.dmp = null;
                this.reload();
            }
            return;
        }
        if (this.doReload) {
            this.reload();
            this.doReload = false;
            return;
        }
        if (this.installError != null) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.installError = null;
            }
        } else {
            if (this.deleteConfirm != null) {
                if (in.keyPressed("ENTER")) {
                    this.doDelete();
                }
                if (in.keyPressed("ESCAPE")) {
                    this.deleteConfirm = null;
                }
                return;
            }
            if (this.leaveCheck) {
                if (in.keyPressed("ENTER")) {
                    this.apply(true);
                } else if (in.keyPressed("ESCAPE")) {
                    this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                }
                return;
            }
        }
        if (in.keyPressed(Keys.get("leave", "L")) || in.keyPressed("ESCAPE")) {
            this.leave();
            return;
        }
        if (in.keyPressed(Keys.get("mods_reload", "R"))) {
            this.reload();
            return;
        }
        if (in.keyPressed(Keys.get("mods_install", "I"))) {
            this.promptInstall(in);
            return;
        }
        if (this.canApply() && in.keyPressed("ENTER")) {
            this.apply(false);
            return;
        }
        if (in.keyPressed("UP")) {
            this.selected = this.selected == null || !Mod.mods.contains(this.selected) ? (Mod.mods.isEmpty() ? null : Mod.mods.get(Mod.mods.size() - 1)) : Mod.mods.get((Mod.mods.indexOf(this.selected) + Mod.mods.size() - 1) % Mod.mods.size());
        }
        if (in.keyPressed("DOWN")) {
            this.selected = this.selected == null || !Mod.mods.contains(this.selected) ? (Mod.mods.isEmpty() ? null : Mod.mods.get(0)) : Mod.mods.get((Mod.mods.indexOf(this.selected) + 1) % Mod.mods.size());
        }
        ScreenMode sm = in.mode();
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int x = MyDraw.SIDE_CLEARANCE;
        int w = (int)((double)sm.width * 0.5);
        int h = sm.height - y - MyDraw.SIDE_CLEARANCE;
        this.modsSB.tick(in, x, y, w, h);
        x += w + MyDraw.UI_SPACING;
        h = sm.height - (y += 300 + MyDraw.WINDOW_INSET * 2 + MyDraw.UI_SPACING) - MyDraw.SIDE_CLEARANCE;
        w = sm.width - x - MyDraw.SIDE_CLEARANCE;
        this.descSB.tick(in, x, y, w, h);
    }

    public static String clean(String s) {
        return s.replace("{", "(").replace("}", ")").replace("[", "(").replace("]", ")");
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.drawTopBar(sm);
        if (this.mrpd != null) {
            this.mrpd.render(d, sm, hs, cursor);
            return;
        }
        if (this.ump != null && this.umpp != null && this.umpp.done && this.ump.needsWLA) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - 150, sm.height / 3, 300, Lang._t("Sign_WLA_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.ump = null;
                    ModsScreen.this.umpp = null;
                    try {
                        SteamBackend.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + ModsScreen.this.ump.needsWLAId);
                    }
                    catch (Throwable t) {
                        ModsScreen.this.needsManualWLA = true;
                    }
                }
            });
            return;
        }
        if (this.needsManualWLA) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - 250, sm.height / 3, 500, Lang._t("Manual_WLA_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.needsManualWLA = false;
                }
            });
            return;
        }
        if (this.ump != null) {
            hs.list.clear();
            int w = 300 + MyDraw.WINDOW_INSET * 2;
            int h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            int x = sm.width / 2 - w / 2;
            int y = sm.height / 2 - h / 2;
            d.drawShadowedPanel(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            if (this.umpp != null) {
                d.text(this.umpp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.umpp == null ? 0.0 : 1.0 * (double)this.umpp.progress / (double)StrictMath.max(1, this.umpp.total));
            return;
        }
        if (this.dmp != null) {
            hs.list.clear();
            int w = 300 + MyDraw.WINDOW_INSET * 2;
            int h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            int x = sm.width / 2 - w / 2;
            int y = sm.height / 2 - h / 2;
            d.drawShadowedPanel(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            if (this.dmpp != null) {
                d.text(this.dmpp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.dmpp == null ? 0.0 : 1.0 * (double)this.dmpp.progress / (double)StrictMath.max(1, this.dmpp.total));
            return;
        }
        int bw = d.bw(Lang._t("Leave", new Object[0]));
        int x = sm.width - MyDraw.SIDE_CLEARANCE - bw;
        d.button(x, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

            @Override
            public void run() {
                ModsScreen.this.leave();
            }
        });
        bw = d.bw("Apply", "ENTER");
        d.goldbutton(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Apply", new Object[0]), "ENTER", new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.apply(false);
            }
        }, this.canApply());
        bw = d.bw(Lang._t("Reset", new Object[0]));
        d.button(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Reset", new Object[0]), new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.resetToBeEnabled();
            }
        });
        bw = d.bw(Lang._t("Disable_All", new Object[0]));
        d.button(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Disable_All", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.disableAll();
            }
        });
        bw = d.bw(Lang._t("Reload", new Object[0]));
        d.button(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Reload", new Object[0]), Keys.get("mods_reload", "R"), new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.reload();
            }
        });
        bw = d.bw(Lang._t("Install_Mod", new Object[0]));
        d.button(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Install_Mod", new Object[0]), Keys.get("mods_install", "I"), new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.promptInstall(in);
            }
        });
        bw = d.bw(Lang._t("Download_published_items", new Object[0]));
        x -= bw + MyDraw.BUTTON_SPACING;
        if (SteamBackend.isEnabled() && this.missingPublisheds()) {
            d.button(x, MyDraw.TOP_BAR_INSET, bw, Lang._t("Download_published_items", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.downloadMissingPublisheds();
                }
            });
        }
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        x = MyDraw.SIDE_CLEARANCE;
        int w = (int)((double)sm.width * 0.5);
        int h = sm.height - y - MyDraw.SIDE_CLEARANCE;
        if (Mod.getAvailableMods().isEmpty()) {
            String t = SteamBackend.isEnabled() ? Lang._t("no_mods_hint_steam", new Object[0]) : Lang._t("no_mods_hint", new Object[0]);
            d.text(t, AGame.FOUNT, sm.width / 2 - (int)d.textSize((String)t, (Fount)AGame.FOUNT).x / 2, y, 10000);
            if (SteamBackend.isEnabled()) {
                bw = d.bw(Lang._t("Link", new Object[0]));
                d.button(sm.width / 2 - bw / 2, y + AGame.FOUNT.lineHeight + MyDraw.UI_SPACING, bw, Lang._t("Link", new Object[0]), new InputRunnable(){

                    @Override
                    public void run(final Input in) {
                        try {
                            Analytics.newsLink();
                            Desktop.getDesktop().browse(new URI("https://steamcommunity.com/app/342560/workshop/"));
                            Analytics.flushSync(new Runnable(){

                                @Override
                                public void run() {
                                    in.quit();
                                    System.exit(0);
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        } else {
            this.modsSB.draw(d, x, y, w, h, Mod.mods, this.modAdapter);
        }
        if (this.selected == null) {
            return;
        }
        int frameSize = sm.height < 1000 ? 256 : 512;
        d.drawWindow(x += w + MyDraw.UI_SPACING, y, frameSize + MyDraw.WINDOW_INSET * 2, frameSize + MyDraw.WINDOW_INSET * 2);
        if (this.selected.logo != null) {
            ((org.newdawn.slick.Graphics)d.frame().nativeRenderer()).drawImage(this.selected.logo, (float)(x + MyDraw.WINDOW_INSET), (float)(y + MyDraw.WINDOW_INSET), (float)(x + MyDraw.WINDOW_INSET + frameSize), (float)(y + MyDraw.WINDOW_INSET + frameSize), 0.0f, 0.0f, 512.0f, 512.0f);
        }
        bw = d.bw(Lang._t("Export_to_file", new Object[0]));
        d.button(x, y += frameSize + MyDraw.WINDOW_INSET * 2 + MyDraw.UI_SPACING, bw, Lang._t("Export_to_file", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ModsScreen.this.exportCurrentMod(in);
            }
        });
        int x2 = x + bw + MyDraw.BUTTON_SPACING;
        if (SteamBackend.isEnabled() && this.selected.isLocal) {
            final PublishedItemsManager.Entry e = PublishedItemsManager.get(PublishedItemsManager.Type.MOD, this.selected.getIdeallyEnglishName());
            if (e == null) {
                bw = d.bw(Lang._t("Publish_to_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Publish_to_Steam", new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        ModsScreen.this.ump = new UploadModProcess(ModsScreen.this.selected, null);
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
            } else {
                bw = d.bw(Lang._t("Update_on_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Update_on_Steam", new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        ModsScreen.this.ump = new UploadModProcess(ModsScreen.this.selected, e);
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
                bw = d.bw(Lang._t("Sync_from_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Sync_from_Steam", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ModsScreen.this.syncCurrentMod();
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
            }
        }
        h = sm.height - (y += MyDraw.BUTTON_H + MyDraw.UI_SPACING) - MyDraw.SIDE_CLEARANCE;
        w = sm.width - x - MyDraw.SIDE_CLEARANCE;
        ArrayList<String> info = new ArrayList<String>();
        if (this.selected.buildLog != null && SimplePref.EDITOR_TOOLS.get()) {
            info.add((this.selected.buildFailed ? "[bb421d]" : "") + ModsScreen.clean(this.selected.buildLog));
        }
        if (this.selected.description.containsKey(Lang.currentLocale)) {
            info.add(ModsScreen.clean(this.selected.description.get(Lang.currentLocale)));
        } else if (this.selected.description.containsKey(Locale.ENGLISH)) {
            info.add(ModsScreen.clean(this.selected.description.get(Locale.ENGLISH)));
        }
        if (this.selected.loadInfoFailed || this.selected.loadFailed) {
            if (this.selected.infoLog != null) {
                info.add("[bb421d]" + ModsScreen.clean(this.selected.infoLog));
            }
            if (this.selected.loadLog != null) {
                info.add("[bb421d]" + ModsScreen.clean(this.selected.loadLog));
            }
        }
        info.add("[bb421d]" + ModsScreen.clean(this.selected.getWarnings()));
        this.descSB.draw(d, x, y, w, h, info, this.sa);
        if (this.installError != null) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, this.installError, new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.installError = null;
                }
            });
        } else if (this.deleteConfirm != null) {
            hs.list.clear();
            d.confirmDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, Lang._t("Delete_mod_x", this.deleteConfirm.getName()), new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.doDelete();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.deleteConfirm = null;
                }
            });
        } else if (this.leaveCheck) {
            hs.list.clear();
            d.confirmDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, Lang._t("Apply_changes_before_leaving_", new Object[0]), Lang._t("Apply", new Object[0]), Lang._t("Leave", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.apply(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ModsScreen.this.g.s = new MainMenu(ModsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private strictfp class FF
    extends FileFilter {
        private FF() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".amod");
        }

        @Override
        public String getDescription() {
            return Lang._t("Mods", new Object[0]);
        }
    }

    private strictfp class FV
    extends FileView {
        private FV() {
        }

        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && new File(f, "info.json").exists() || f.getName().endsWith(".amod")) {
                return new PI();
            }
            return super.getIcon(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            if (f.isDirectory() && new File(f, "info.json").exists()) {
                return Boolean.FALSE;
            }
            return super.isTraversable(f);
        }

        @Override
        public String getName(File f) {
            return f.getName();
        }
    }

    private strictfp class PI
    implements Icon {
        private PI() {
        }

        @Override
        public void paintIcon(Component cmpnt, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.YELLOW);
            g.fillRect(x + 1, y + 1, 14, 14);
            g.setColor(Color.BLACK);
            g.fillRect(x + 7, y + 2, 2, 12);
            g.fillRect(x + 2, y + 7, 12, 2);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

