/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class ModReloadProgressDialog {
    private final Mod.LoadProcess process = new Mod.LoadProcess();
    private Mod.LoadProgress progress = null;
    private final Runnable postReload;
    private final Runnable onFail;

    public ModReloadProgressDialog(Runnable postReload, Runnable onFail) {
        this.postReload = postReload;
        this.onFail = onFail;
    }

    public boolean tick(Input in) {
        if (this.progress != null && this.progress.complete) {
            return true;
        }
        this.progress = this.process.doLoad(in);
        if (this.progress.complete && this.postReload != null) {
            if (this.progress.failed && this.onFail != null) {
                this.onFail.run();
            }
            if (!this.progress.failed && this.postReload != null) {
                this.postReload.run();
            }
        }
        return this.progress.complete;
    }

    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        hs.list.clear();
        int w = 300 + MyDraw.WINDOW_INSET * 2;
        int h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedPanel(x, y, w, h);
        x += MyDraw.WINDOW_INSET;
        y += MyDraw.WINDOW_INSET;
        if (this.progress != null) {
            d.text(this.progress.desc, AGame.FOUNT, x, y);
        }
        d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.progress == null ? 0.0 : 1.0 * (double)this.progress.progress / (double)StrictMath.max(1, this.progress.totalSteps));
    }
}

