/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.DownloadPublishedZippedItemsProcess;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MissionBackend;
import com.zarkonnen.airships.MissionInlineInfo;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.ModsScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlayMissionCombatIntent;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.UploadMissionProcess;
import com.zarkonnen.airships.ZipUtils;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.apache.commons.io.FileUtils;

public strictfp class MissionsScreen
implements Screen {
    public final AirshipGame g;
    public final ScrollBar sequencesSB = new ScrollBar();
    private String deleteConfirm = null;
    private String selected = null;
    private static final Img REMOVE = new Img("ui", 144, 416, 16, 16, false);
    private final MissionBackend missionBackend;
    final MissionInlineInfo mii = new MissionInlineInfo();
    private final HashMap<String, MissionSequence> seqCache = new HashMap();
    private ModReloadProgressDialog mrpd;
    private UploadMissionProcess ump;
    private UploadMissionProcess.Progress umpp;
    private DownloadPublishedZippedItemsProcess dmp;
    private DownloadPublishedZippedItemsProcess.Progress dmpp;
    private boolean needsManualWLA;
    private int umpCompleteWait;
    private List<String> l;
    private final Img instructor = new Img("instructor300");
    private final ArrayList<String> dir = new ArrayList();
    ScrollBar.ScrollElementAdapter<String> sequenceAdapter = new ScrollBar.ScrollElementAdapter<String>(){
        final int innerH;
        final int H;
        {
            this.innerH = StrictMath.max(AGame.BIG_FOUNT.height, MyDraw.BUTTON_H);
            this.H = StrictMath.max(AGame.BIG_FOUNT.height, MyDraw.BUTTON_H) + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public int getHeight(String t, MyDraw d, int availableWidth) {
            return this.H;
        }

        @Override
        public void draw(final String path, MyDraw d, int x, int y, int width) {
            d.hook(x, y, width, this.H, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    MissionsScreen.this.selected = path;
                }
            });
            String displayName = MissionsScreen.this.mii.displayName(path);
            MissionSequence seq = MissionsScreen.this.getSeq(path);
            if (seq != null && seq.loaded) {
                displayName = seq.getName() + MissionsScreen.this.mii.getSuffix(path);
            }
            boolean sel = path.equals(MissionsScreen.this.selected);
            d.text((sel ? MyDraw.SELECTED_C : "") + displayName, AGame.BIG_FOUNT, x, y);
            if (!AGame.isDemo() && !MissionsScreen.this.missionBackend.isLocked(FileScreen.splitPath(path))) {
                d.iconButton(x + width - MyDraw.BUTTON_H, y, REMOVE, new Runnable(){

                    @Override
                    public void run() {
                        MissionsScreen.this.deleteConfirm = path;
                    }
                }, true);
            }
        }
    };

    public MissionsScreen(AirshipGame g) {
        this.g = g;
        this.missionBackend = new MissionBackend(g, false);
        this.selected = this.missionBackend.list(this.dir).isEmpty() ? null : this.missionBackend.list(this.dir).get(0);
    }

    private MissionSequence getSeq(String filename) {
        if (!this.seqCache.containsKey(filename)) {
            File seqFile = this.missionBackend.getFile(FileScreen.splitPath(filename));
            if (seqFile == null || !seqFile.exists()) {
                this.seqCache.put(filename, null);
            } else {
                MissionSequence seq = new MissionSequence(this.missionBackend.isLocal(FileScreen.splitPath(filename)), seqFile);
                seq.loadMetadata();
                this.seqCache.put(filename, seq);
            }
        }
        return this.seqCache.get(filename);
    }

    private boolean missingPublisheds() {
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            File f;
            if (e.type != PublishedItemsManager.Type.MISSIONSEQ || (f = this.missionBackend.getFile(Collections.singletonList(e.title))) != null && f.exists()) continue;
            return true;
        }
        return false;
    }

    private void downloadMissingPublisheds() {
        ArrayList<PublishedItemsManager.Entry> downloadList = new ArrayList<PublishedItemsManager.Entry>();
        for (PublishedItemsManager.Entry e : PublishedItemsManager.getAllEntries()) {
            File f;
            if (e.type != PublishedItemsManager.Type.MISSIONSEQ || (f = this.missionBackend.getFile(Collections.singletonList(e.title))) != null && f.exists()) continue;
            downloadList.add(e);
        }
        if (!downloadList.isEmpty()) {
            this.dmp = new DownloadPublishedZippedItemsProcess(downloadList);
        }
    }

    private void syncCurrentMission() {
        PublishedItemsManager.Entry e = PublishedItemsManager.get(PublishedItemsManager.Type.MISSIONSEQ, this.missionBackend.getFile(FileScreen.splitPath(this.selected)).getName());
        ArrayList<PublishedItemsManager.Entry> downloadList = new ArrayList<PublishedItemsManager.Entry>();
        downloadList.add(e);
        this.dmp = new DownloadPublishedZippedItemsProcess(downloadList);
    }

    private void promptInstall(Input in) {
        String msg;
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_mission_to_add", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Add", new Object[0]));
        jfc.setFileView(new FV());
        jfc.setFileFilter(new FF());
        jfc.setFileSelectionMode(2);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
        }
        if (jfc.showOpenDialog(null) == 0 && (msg = this.doInstall(jfc.getSelectedFile(), in)) != null) {
            this.g.showError(msg);
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
        this.l = this.missionBackend.list(this.dir);
    }

    private String doInstall(File f, Input in) {
        if (f == null || !f.exists()) {
            return Lang._t("file_does_not_exist", new Object[0]);
        }
        File dst = null;
        if (f.isDirectory()) {
            dst = new File(new File(AGame.getGameDirectory(), "missions"), f.getName());
            int n = 2;
            while (dst.exists()) {
                dst = new File(new File(AGame.getGameDirectory(), "missions"), f.getName() + " " + n);
            }
            try {
                FileUtils.copyDirectory((File)f, (File)dst);
            }
            catch (Exception e) {
                return Lang._t("unable_to_copy_file", new Object[0]);
            }
        }
        File tmpDst = new File(new File(AGame.getGameDirectory(), "tmp"), f.getName());
        try {
            AGame.deleteDir(tmpDst);
            FileInputStream fis = new FileInputStream(f);
            ZipUtils.unzip(fis, tmpDst);
            boolean success = false;
            File[] fs = tmpDst.listFiles();
            if (fs != null) {
                for (File subDir : fs) {
                    if (!new File(subDir, "missions_info.json").exists()) continue;
                    String name = f.getName().replace(".amission", "");
                    dst = new File(new File(AGame.getGameDirectory(), "missions"), name);
                    int n = 2;
                    while (dst.exists()) {
                        dst = new File(new File(AGame.getGameDirectory(), "missions"), name + " " + n);
                    }
                    FileUtils.moveDirectory((File)subDir, (File)dst);
                    success = true;
                    break;
                }
            }
            if (!success) {
                return Lang._t("unable_to_add_mission", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Lang._t("unable_to_add_mission", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCurrentMission(Input in) {
        String exportName = this.missionBackend.getFile(FileScreen.splitPath(this.selected)).getName();
        ScreenMode sm = in.mode();
        in.setMode(new ScreenMode(800, 600, false));
        boolean cursorVisible = in.isCursorVisible();
        in.setCursorVisible(true);
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle(Lang._t("Choose_file_to_export_to", new Object[0]));
        jfc.setApproveButtonText(Lang._t("Export", new Object[0]));
        jfc.setFileSelectionMode(0);
        File desktopF = new File(System.getProperty("user.home") + "/Desktop");
        if (desktopF.exists()) {
            jfc.setCurrentDirectory(desktopF);
            jfc.setSelectedFile(new File(desktopF, exportName + ".amission"));
        }
        if (jfc.showSaveDialog(null) == 0) {
            File f = jfc.getSelectedFile();
            if (f.exists()) {
                f.delete();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                ZipUtils.enzip(this.missionBackend.getFile(FileScreen.splitPath(this.selected)), fos);
                fos.flush();
            }
            catch (Exception e) {
                this.g.showError("unable_to_export_mission");
                f.delete();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        in.setMode(sm);
        in.setCursorVisible(cursorVisible);
    }

    private void resetModState() {
        if (Mod.overriddenEnabledModIds != null) {
            Mod.overriddenEnabledModIds = null;
            this.mrpd = new ModReloadProgressDialog(null, new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_reset_mods", new Object[0]));
                }
            });
        }
    }

    private void editMission() {
        if (this.selected == null) {
            return;
        }
        final MissionSequence seq = this.getSeq(this.selected);
        if (seq == null || !seq.loaded) {
            return;
        }
        if (!seq.missions.get(0).loadMetadata()) {
            this.g.showError(Lang._t("Unable_to_load_mission", new Object[0]));
            return;
        }
        if (!seq.modsAreAvailable()) {
            this.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
            return;
        }
        Runnable editRunnable = new Runnable(){

            @Override
            public void run() {
                if (seq.requiresModReload()) {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
                    MissionsScreen.this.resetModState();
                } else if (!seq.missions.get(0).loadMetadata() || !seq.missions.get(0).loadCombat(MissionsScreen.this.g)) {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_load_mission", new Object[0]));
                    MissionsScreen.this.resetModState();
                } else {
                    UniScreen us = new UniScreen(MissionsScreen.this.g, new EditMissionIntent(seq, seq.missions.get(0)));
                    us.combat = seq.missions.get((int)0).combat;
                    us.mySide = seq.missions.get((int)0).combat.sides.get(seq.missions.get((int)0).playerSideIndex);
                    us.combat.initWheelsLegsTentaclesAndBarrels();
                    MissionsScreen.this.g.s = us;
                }
            }
        };
        if (seq.requiresModReload()) {
            Mod.overriddenEnabledModIds = new ArrayList<String>(seq.modIDs);
            this.mrpd = new ModReloadProgressDialog(editRunnable, new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_load_mods", new Object[0]));
                    MissionsScreen.this.resetModState();
                }
            });
        } else {
            editRunnable.run();
        }
    }

    private void playMission(final Input in) {
        if (this.selected == null) {
            return;
        }
        final MissionSequence seq = this.getSeq(this.selected);
        if (seq == null || !seq.loaded) {
            return;
        }
        if (!seq.missions.get(0).loadMetadata()) {
            this.g.showError(Lang._t("Unable_to_load_mission", new Object[0]));
            return;
        }
        if (!seq.modsAreAvailable()) {
            this.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
            return;
        }
        Runnable playRunnable = new Runnable(){

            @Override
            public void run() {
                if (seq.requiresModReload()) {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
                    MissionsScreen.this.resetModState();
                } else if (!seq.missions.get(0).loadMetadata() || !seq.missions.get(0).loadCombat(MissionsScreen.this.g)) {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_load_mission", new Object[0]));
                    MissionsScreen.this.resetModState();
                } else {
                    UniScreen.Intent intent = seq.missions.get((int)0).playerBudget > 0 ? new MissionSetupIntent(false, seq, seq.missions.get(0)) : new PlayMissionCombatIntent(false, seq, seq.missions.get(0));
                    UniScreen us = new UniScreen(MissionsScreen.this.g, intent);
                    us.combat = seq.missions.get((int)0).combat.clone(MissionsScreen.this.g);
                    us.combat.resetMoveTos = true;
                    us.combat.physics = null;
                    us.combat.repairAllShips();
                    us.combat.recording.header.placeName = seq.getName();
                    us.mySide = us.combat.sides.get(seq.missions.get((int)0).playerSideIndex);
                    int sideI = 0;
                    for (Combat.Side side : us.combat.sides) {
                        if (side != us.mySide) {
                            side.usingAI = true;
                        }
                        int shipI = 0;
                        for (Airship ship : side.ships) {
                            ship.networkID = "s" + sideI + "." + shipI++;
                            if (side != us.mySide) {
                                ship.ai = new TacticalAI(ship, us.combat, side, us.mySide);
                                ship.ai.quality = seq.missions.get((int)0).enemyAIQuality;
                            }
                            ship.initWheelsLegsAndTentacles(null, us.combat.landFormations, us.combat);
                        }
                        ++sideI;
                    }
                    ZoomToFitButton.zoomToFit(in, us, 1.0);
                    MissionsScreen.this.g.s = us;
                }
            }
        };
        if (seq.requiresModReload()) {
            Mod.overriddenEnabledModIds = new ArrayList<String>(seq.modIDs);
            this.mrpd = new ModReloadProgressDialog(playRunnable, new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_load_mods", new Object[0]));
                    MissionsScreen.this.resetModState();
                }
            });
        } else {
            playRunnable.run();
        }
    }

    private void createMission(final Input in) {
        Runnable doCreateRunnable = new Runnable(){

            @Override
            public void run() {
                CombatBackgroundFlavor cbf = Loadable.all(CombatBackgroundFlavor.class).get(AGame.ANIM_R.nextInt(Loadable.all(CombatBackgroundFlavor.class).size()));
                LandscapeType lt = cbf.getLandscapeType(AGame.ANIM_R);
                TimeOfDay tod = TimeOfDay.getRandom(AGame.ANIM_R, lt);
                if (!Appearance.useLighting || Appearance.useSimpleGraphics) {
                    tod = TimeOfDay.ofName("DAY");
                }
                Combat c = new Combat(MissionsScreen.this.g, tod);
                c.backgroundFlavor = cbf;
                Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(AGame.ANIM_R, false, lt);
                c.landFormations.add((LandFormation)p.a);
                c.landFormations.addAll((Collection)p.b);
                c.sides.get((int)0).arms = MissionsScreen.this.g.getBestCOA();
                MissionSequence seq = new MissionSequence(true, null);
                seq.loaded = true;
                MissionSequence.Mission m = new MissionSequence.Mission();
                m.combat = c;
                m.combatLoaded = true;
                m.metaLoaded = true;
                seq.missions.add(m);
                UniScreen us = new UniScreen(MissionsScreen.this.g, new EditMissionIntent(seq, m));
                us.combat = c;
                us.mySide = c.sides.get(0);
                ZoomToFitButton.zoomToFit(in, us, 1.0);
                MissionsScreen.this.g.s = us;
            }
        };
        if (Mod.overriddenEnabledModIds != null) {
            Mod.overriddenEnabledModIds = null;
            this.mrpd = new ModReloadProgressDialog(doCreateRunnable, new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.g.showError(Lang._t("Unable_to_reset_mods", new Object[0]));
                }
            });
        } else {
            doCreateRunnable.run();
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        MissionSequence seq;
        if (this.l == null) {
            this.l = this.missionBackend.list(this.dir);
        }
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (this.ump != null) {
            if (this.umpp == null || !this.umpp.done) {
                this.umpp = this.ump.tick();
            }
            System.out.println(this.umpp.done);
            if (this.umpp.done && !this.ump.needsWLA) {
                if (this.umpCompleteWait == 0) {
                    Analytics.missionUpload(!this.umpp.failed);
                }
                this.umpCompleteWait += ms;
                if (this.umpCompleteWait >= 2000) {
                    this.ump = null;
                    this.umpp = null;
                    this.umpCompleteWait = 0;
                }
            }
            return;
        }
        if (this.dmp != null) {
            this.dmpp = this.dmp.tick();
            if (this.dmpp.done) {
                this.dmp = null;
                this.l = this.missionBackend.list(this.dir);
            }
            return;
        }
        if (this.deleteConfirm != null) {
            if (in.keyPressed("ENTER")) {
                this.missionBackend.delete(FileScreen.splitPath(this.deleteConfirm));
                this.deleteConfirm = null;
            }
            if (in.keyPressed("ESCAPE")) {
                this.deleteConfirm = null;
            }
            return;
        }
        if (in.keyPressed(Keys.get("leave", "L")) || in.keyPressed("ESCAPE")) {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            return;
        }
        if (!AGame.isDemo()) {
            if (in.keyPressed(Keys.get("mission_add_from_file", "I"))) {
                this.promptInstall(in);
                return;
            }
            if (in.keyPressed(Keys.get("mission_create", "C"))) {
                this.createMission(in);
                return;
            }
        }
        List<String> l = this.missionBackend.list(this.dir);
        if (in.keyPressed("UP")) {
            this.selected = this.selected == null || !l.contains(this.selected) ? (l.isEmpty() ? null : l.get(l.size() - 1)) : l.get((l.indexOf(this.selected) + l.size() - 1) % l.size());
        }
        if (in.keyPressed("DOWN")) {
            this.selected = this.selected == null || !l.contains(this.selected) ? (l.isEmpty() ? null : l.get(0)) : l.get((l.indexOf(this.selected) + 1) % l.size());
        }
        if (!l.contains(this.selected)) {
            this.selected = null;
        }
        if (this.selected != null && (seq = this.getSeq(this.selected)) != null && seq.loaded) {
            if (in.keyPressed(Keys.get("mission_play", "P"))) {
                this.playMission(in);
                return;
            }
            if (!AGame.isDemo() && in.keyPressed(Keys.get("mission_edit", "E"))) {
                this.editMission();
            }
        }
        ScreenMode sm = in.mode();
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int x = MyDraw.SIDE_CLEARANCE;
        int w = 400;
        int h = sm.height - y - MyDraw.SIDE_CLEARANCE;
        this.sequencesSB.tick(in, x, y, w, h);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        if (this.l == null) {
            this.l = this.missionBackend.list(this.dir);
        }
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.drawTopBar(sm);
        d.text(Lang._t("Missions", new Object[0]), AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.SIDE_CLEARANCE + 2);
        int bw = d.bw(Lang._t("Leave", new Object[0]));
        int x = sm.width - MyDraw.SIDE_CLEARANCE - bw;
        d.button(x, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

            @Override
            public void run() {
                MissionsScreen.this.g.s = new MainMenu(MissionsScreen.this.g, MainMenu.Submenu.MAIN);
            }
        });
        bw = d.bw(Lang._t("Add_Mission_from_File", new Object[0]));
        x -= bw + MyDraw.BUTTON_SPACING;
        if (!AGame.isDemo()) {
            d.button(x, MyDraw.TOP_BAR_INSET, bw, Lang._t("Add_Mission_from_File", new Object[0]), Keys.get("mission_add_from_file", "I"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    MissionsScreen.this.promptInstall(in);
                }
            });
            bw = d.bw(Lang._t("Create_Mission", new Object[0]));
            d.button(x -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Create_Mission", new Object[0]), Keys.get("mission_create", "C"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    MissionsScreen.this.createMission(in);
                }
            });
            bw = d.bw(Lang._t("Download_published_items", new Object[0]));
            x -= bw + MyDraw.BUTTON_SPACING;
            if (SteamBackend.isEnabled() && this.missingPublisheds()) {
                d.button(x, MyDraw.TOP_BAR_INSET, bw, Lang._t("Download_published_items", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        MissionsScreen.this.downloadMissingPublisheds();
                    }
                });
            }
        }
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        x = MyDraw.SIDE_CLEARANCE;
        int w = sm.width * 2 / 5;
        int h = sm.height - y - MyDraw.SIDE_CLEARANCE;
        this.sequencesSB.draw(d, x, y, w, h, this.l, this.sequenceAdapter);
        if (this.selected == null) {
            return;
        }
        x += w + MyDraw.UI_SPACING;
        w = sm.width - MyDraw.SIDE_CLEARANCE * 2 - w - MyDraw.UI_SPACING;
        final MissionSequence seq = this.getSeq(this.selected);
        if (seq == null) {
            return;
        }
        if (!seq.loaded) {
            d.text(MyDraw.ERROR_C + ModsScreen.clean(seq.loadError.getMessage()), AGame.FOUNT, x, y, w);
            return;
        }
        bw = StrictMath.max((int)d.textSize((String)new StringBuilder().append((String)Lang._t((String)"Play", (Object[])new Object[0])).append((String)"WW").toString(), (Fount)AGame.BIGGER_FOUNT).x + MyDraw.BUTTON_EXTRA_W * 2, d.bw(Lang._t("Edit", new Object[0])));
        int infoW = w - bw - MyDraw.UI_SPACING;
        d.text(MyDraw.TITLE_C + seq.getName(), AGame.BIGGER_FOUNT, x, y, w);
        int titleH = (int)d.textSize((String)seq.getName(), (Fount)AGame.BIGGER_FOUNT, (double)((double)x), (double)((double)y), (int)w).height;
        d.text(seq.getDescriptionAndMods(), AGame.FOUNT, x, y += titleH + MyDraw.UI_SPACING, infoW);
        if (seq.modsAreAvailable() && seq.playableHeader) {
            d.bigButton(x + infoW + MyDraw.UI_SPACING, y, bw, Lang._t("Play", new Object[0]), Keys.get("mission_play", "P"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    MissionsScreen.this.playMission(in);
                }
            });
        }
        if (!AGame.isDemo()) {
            d.button(x + infoW + MyDraw.UI_SPACING, y + MyDraw.BIG_BUTTON_H + MyDraw.BUTTON_SPACING, bw, Lang._t("Edit", new Object[0]), Keys.get("mission_edit", "E"), new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.editMission();
                }
            }, seq.modsAreAvailable());
        }
        y = (int)((double)y + ((double)MyDraw.BUTTON_SPACING + StrictMath.max(StrictMath.ceil(d.textSize((String)seq.getDescriptionAndMods(), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)infoW).height), (double)(MyDraw.BIG_BUTTON_H + MyDraw.UI_SPACING + MyDraw.BUTTON_H))));
        int x2 = x;
        if (seq.isLocal && !AGame.isDemo()) {
            bw = d.bw(Lang._t("Export_to_file", new Object[0]));
            d.button(x2, y, bw, Lang._t("Export_to_file", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    MissionsScreen.this.exportCurrentMission(in);
                }
            });
            x2 += bw + MyDraw.BUTTON_SPACING;
        }
        if (SteamBackend.isEnabled() && seq.isLocal && !AGame.isDemo()) {
            final PublishedItemsManager.Entry e = PublishedItemsManager.get(PublishedItemsManager.Type.MISSIONSEQ, seq.getIdeallyEnglishName());
            if (e == null) {
                bw = d.bw(Lang._t("Publish_to_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Publish_to_Steam", new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        MissionsScreen.this.ump = new UploadMissionProcess(seq, null);
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
            } else {
                bw = d.bw(Lang._t("Update_on_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Update_on_Steam", new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        MissionsScreen.this.ump = new UploadMissionProcess(seq, e);
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
                bw = d.bw(Lang._t("Sync_from_Steam", new Object[0]));
                d.button(x2, y, bw, Lang._t("Sync_from_Steam", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        MissionsScreen.this.syncCurrentMission();
                    }
                });
                x2 += bw + MyDraw.BUTTON_SPACING;
            }
        }
        if (AGame.isDemo()) {
            int sideX = 389 + (sm.width - 139 - 250) / 2 - 150;
            int sideY = y;
            d.blit(this.instructor, sideX, sideY);
            d.drawPanelBorder(sideX, sideY, 300, 300);
            d.text(Lang._t("instructor_menu_MISSIONS", new Object[0]), AGame.FOUNT, sideX, sideY += 300 + MyDraw.UI_SPACING, 300);
        }
        if (this.deleteConfirm != null) {
            hs.list.clear();
            d.confirmDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, Lang._t("Delete_mission_x", this.mii.displayName(this.deleteConfirm)), new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.missionBackend.delete(FileScreen.splitPath(MissionsScreen.this.deleteConfirm));
                    MissionsScreen.this.deleteConfirm = null;
                    MissionsScreen.this.l = MissionsScreen.this.missionBackend.list(MissionsScreen.this.dir);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.deleteConfirm = null;
                }
            });
        }
        if (this.mrpd != null) {
            hs.list.clear();
            this.mrpd.render(d, sm, hs, cursor);
            return;
        }
        if (this.ump != null && this.umpp != null && this.umpp.done && this.ump.needsWLA) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - 150, sm.height / 3, 300, Lang._t("Sign_WLA_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.ump = null;
                    MissionsScreen.this.umpp = null;
                    try {
                        SteamBackend.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + ((MissionsScreen)MissionsScreen.this).ump.needsWLAId);
                    }
                    catch (Throwable t) {
                        MissionsScreen.this.needsManualWLA = true;
                    }
                }
            });
            return;
        }
        if (this.needsManualWLA) {
            hs.list.clear();
            d.messageDialog(sm.width / 2 - 250, sm.height / 3, 500, Lang._t("Manual_WLA_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MissionsScreen.this.needsManualWLA = false;
                }
            });
            return;
        }
        if (this.ump != null) {
            this.ump.d = d;
            hs.list.clear();
            w = 300 + MyDraw.WINDOW_INSET * 2;
            h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - w / 2;
            y = sm.height / 2 - h / 2;
            d.drawShadowedPanel(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            if (this.umpp != null) {
                d.text(this.umpp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.umpp == null ? 0.0 : 1.0 * (double)this.umpp.progress / (double)StrictMath.max(1, this.umpp.total));
            return;
        }
        if (this.dmp != null) {
            hs.list.clear();
            w = 300 + MyDraw.WINDOW_INSET * 2;
            h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - w / 2;
            y = sm.height / 2 - h / 2;
            d.drawShadowedPanel(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            if (this.dmpp != null) {
                d.text(this.dmpp.desc, AGame.FOUNT, x, y);
            }
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, this.dmpp == null ? 0.0 : 1.0 * (double)this.dmpp.progress / (double)StrictMath.max(1, this.dmpp.total));
            return;
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private strictfp class FF
    extends FileFilter {
        private FF() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".amission");
        }

        @Override
        public String getDescription() {
            return Lang._t("Missions", new Object[0]);
        }
    }

    private strictfp class FV
    extends FileView {
        private FV() {
        }

        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && new File(f, "missions_info.json").exists() || f.getName().endsWith(".amission")) {
                return new PI();
            }
            return super.getIcon(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            if (f.isDirectory() && new File(f, "missions_info.json").exists()) {
                return Boolean.FALSE;
            }
            return super.isTraversable(f);
        }

        @Override
        public String getName(File f) {
            return f.getName();
        }
    }

    private strictfp class PI
    implements Icon {
        private PI() {
        }

        @Override
        public void paintIcon(Component cmpnt, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.YELLOW);
            g.fillRect(x + 1, y + 1, 14, 14);
            g.setColor(Color.BLACK);
            g.fillRect(x + 7, y + 2, 2, 12);
            g.fillRect(x + 2, y + 7, 12, 2);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

