/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public class MissionSetupIntent
implements UniScreen.Intent,
RestrictsShipPlacement {
    private boolean first = true;
    public final MissionSequence seq;
    public final MissionSequence.Mission mission;
    public final boolean tryOnly;
    public boolean startMessageShown = false;
    public ArrayList<Airship> playerBaseFleet = new ArrayList();

    public MissionSetupIntent(boolean tryOnly, MissionSequence seq, MissionSequence.Mission mission) {
        this.tryOnly = tryOnly;
        this.seq = seq;
        this.mission = mission;
    }

    public int getBudgetSpent(UniScreen us) {
        int b = 0;
        for (Airship s : us.combat.sides.get((int)this.mission.playerSideIndex).ships) {
            if (this.playerBaseFleet.contains(s)) continue;
            b += s.getCost();
        }
        return b;
    }

    public int getBudgetLeft(UniScreen us) {
        return this.mission.playerBudget - this.getBudgetSpent(us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.first) {
            this.playerBaseFleet = new ArrayList<Airship>(us.combat.sides.get((int)this.mission.playerSideIndex).ships);
            ZoomToFitButton.zoomOut(in, us);
            this.first = false;
            for (Combat.Side s : us.combat.sides) {
                for (Airship ship : s.ships) {
                    ship.resetTentaclesForFlipped();
                }
            }
        }
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }

    @Override
    public boolean allowMultiSelect() {
        return false;
    }

    @Override
    public Rect2D placementLimits(int sideIndex, UniScreen us) {
        switch (sideIndex) {
            case 0: {
                return SingleCombatSetupIntent.LEFT_RECT;
            }
            case 1: {
                return SingleCombatSetupIntent.RIGHT_RECT;
            }
        }
        return null;
    }
}

