/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionCombatIntent;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;

public class MissionInfoPanels
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        String msg;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        if (us.intent instanceof MissionCombatIntent) {
            final MissionCombatIntent mci = (MissionCombatIntent)us.intent;
            if (!mci.startMessageShown) {
                msg = mci.m.getText(MissionSequence.Mission.TextSlot.intro);
                if (msg != null && !msg.isEmpty()) {
                    d.text(mci.seq.getName(), AGame.HUGE_FOUNT, sm.width / 2 - (int)d.textSize((String)mci.seq.getName(), (Fount)AGame.HUGE_FOUNT).x / 2, y);
                    Rect msgSize = d.textSize(msg, AGame.FOUNT, 0.0, 0.0, 300 - MyDraw.WINDOW_INSET * 2);
                    int msgW = (int)StrictMath.ceil(msgSize.width);
                    int msgH = (int)StrictMath.ceil(msgSize.height);
                    int x = sm.width / 2 - msgW / 2;
                    d.drawWindow(x, y += AGame.HUGE_FOUNT.height + MyDraw.UI_SPACING, msgW + MyDraw.WINDOW_INSET * 2, msgH + MyDraw.WINDOW_INSET * 2 + MyDraw.BUTTON_H + MyDraw.UI_SPACING);
                    d.text(msg, AGame.FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, 300 - MyDraw.WINDOW_INSET * 2);
                    d.button(x, y += msgH + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            mci.startMessageShown = true;
                        }
                    });
                    return;
                }
                mci.startMessageShown = true;
            }
        }
        if (us.intent instanceof MissionSetupIntent) {
            final MissionSetupIntent msi = (MissionSetupIntent)us.intent;
            if (!msi.startMessageShown) {
                msg = msi.mission.getText(MissionSequence.Mission.TextSlot.intro);
                if (msg != null && !msg.isEmpty()) {
                    d.text(msi.seq.getName(), AGame.HUGE_FOUNT, sm.width / 2 - (int)d.textSize((String)msi.seq.getName(), (Fount)AGame.HUGE_FOUNT).x / 2, y);
                    Rect msgSize = d.textSize(msg, AGame.FOUNT, 0.0, 0.0, 300 - MyDraw.WINDOW_INSET * 2);
                    int msgW = (int)StrictMath.ceil(msgSize.width);
                    int msgH = (int)StrictMath.ceil(msgSize.height);
                    int x = sm.width / 2 - msgW / 2;
                    d.drawWindow(x, y += AGame.HUGE_FOUNT.height + MyDraw.UI_SPACING, msgW + MyDraw.WINDOW_INSET * 2, msgH + MyDraw.WINDOW_INSET * 2 + MyDraw.BUTTON_H + MyDraw.UI_SPACING);
                    d.text(msg, AGame.FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, 300 - MyDraw.WINDOW_INSET * 2);
                    d.button(x, y += msgH + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            msi.startMessageShown = true;
                        }
                    });
                    return;
                }
                msi.startMessageShown = true;
            }
            if (msi.mission.playerBudget > 0 && msi.startMessageShown) {
                d.text(Lang._t("Set_up_your_forces", new Object[0]), AGame.HUGE_FOUNT, sm.width / 2 - (int)d.textSize((String)Lang._t((String)"Set_up_your_forces", (Object[])new Object[0]), (Fount)AGame.HUGE_FOUNT).x / 2, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING);
                String budgetText = Lang._t("Budget", new Object[0]) + ": " + msi.getBudgetSpent(us) + "/" + msi.mission.playerBudget;
                d.borderedText(budgetText, AGame.BIG_FOUNT, Clr.BLACK, msi.getBudgetSpent(us) > msi.mission.playerBudget ? new Clr(255, 153, 153) : Clr.WHITE, sm.width / 2 - (int)d.textSize((String)budgetText, (Fount)AGame.BIG_FOUNT_OUTLINE).x / 2, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + AGame.HUGE_FOUNT.height);
            }
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof MissionCombatIntent) {
            MissionCombatIntent mci = (MissionCombatIntent)us.intent;
            if (!mci.startMessageShown && in.keyPressed("ENTER")) {
                mci.startMessageShown = true;
            }
        }
        if (us.intent instanceof MissionSetupIntent) {
            MissionSetupIntent msi = (MissionSetupIntent)us.intent;
            if (!msi.startMessageShown && in.keyPressed("ENTER")) {
                msi.startMessageShown = true;
            }
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

