/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public strictfp class MissingTranslationFinder {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        HashMap knownLangKeys = new HashMap();
        for (String lc : new String[]{"en", "fr", "de", "ru"}) {
            HashSet<String> ks = new HashSet<String>();
            knownLangKeys.put(lc, ks);
            BufferedReader r = new BufferedReader(new FileReader(new File("data/lang/" + lc + ".properties")));
            String l = null;
            while ((l = r.readLine()) != null) {
                String k = l.split("=", 2)[0];
                if (k.isEmpty()) continue;
                ks.add(k);
            }
            r.close();
        }
        for (String lc : knownLangKeys.keySet()) {
            System.out.println(lc);
            MissingTranslationFinder.visit(new File("src"), (HashSet)knownLangKeys.get(lc));
            System.out.println();
        }
    }

    public static final String pad(String s) {
        while (s.length() < 50) {
            s = s + " ";
        }
        return s;
    }

    public static void visit(File f, HashSet<String> knownLangKeys) throws FileNotFoundException, IOException {
        if (f.isDirectory()) {
            for (File f2 : f.listFiles()) {
                MissingTranslationFinder.visit(f2, knownLangKeys);
            }
            return;
        }
        if (!f.getName().endsWith(".java")) {
            return;
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        String l = null;
        Pattern p = Pattern.compile("_t\\(\"([^\"]+)");
        while ((l = r.readLine()) != null) {
            Matcher m = p.matcher(l);
            while (m.find()) {
                if (knownLangKeys.contains(m.group(1))) continue;
                System.out.println(MissingTranslationFinder.pad(m.group(1)) + l.trim());
            }
        }
        r.close();
    }
}

