/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.util.Clr;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;

public strictfp class Marshalling {
    static BufferedImage render(Field f) {
        BufferedImage img = new BufferedImage(64, 64, 1);
        Graphics2D g = img.createGraphics();
        Marshalling.render(g, f);
        return img;
    }

    static void render(Graphics2D g, Field f) {
        if (f.subdivision != null) {
            g.scale(0.5, 0.5);
            Marshalling.render(g, f.subdivision[0]);
            g.translate(64, 0);
            Marshalling.render(g, f.subdivision[1]);
            g.translate(-64, 64);
            Marshalling.render(g, f.subdivision[2]);
            g.translate(64, 0);
            Marshalling.render(g, f.subdivision[3]);
            g.translate(-64, -64);
            g.scale(2.0, 2.0);
        } else {
            if (f.filled != null) {
                g.setColor(new Color(AGame.ANIM_R.nextInt(255), AGame.ANIM_R.nextInt(255), AGame.ANIM_R.nextInt(255)));
            } else {
                g.setColor(Color.DARK_GRAY);
            }
            g.fillRect(0, 0, 64, 64);
        }
    }

    public static void main(String[] args) {
        for (int i = 2; i < 30; ++i) {
            Field f = new Field();
            for (int j = 0; j < i; ++j) {
                f.addArms(CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("city")));
            }
            try {
                ImageIO.write((RenderedImage)Marshalling.render(f), "PNG", new File("/home/zar/Desktop/marsh/" + i + ".png"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void marshal(List<CoatOfArms> arms, MyDraw d, int x, int y, int sz, Clr borderColor) {
        Field f = new Field();
        for (CoatOfArms coa : arms) {
            f.addArms(coa);
        }
        Marshalling.draw(f, null, d, x, y, sz, borderColor, false);
    }

    private static void draw(Field f, Field parent, MyDraw d, int x, int y, int sz, Clr borderColor, boolean odd) {
        if (f.filled != null) {
            f.filled.draw(d, x, y, sz);
        } else if (f.subdivision == null) {
            CoatOfArms coa = parent.subdivision[2] == f ? parent.subdivision[1].filled : parent.subdivision[0].filled;
            coa.draw(d, x, y, sz);
        } else {
            Marshalling.draw(f.subdivision[0], f, d, x, y, sz / 2, borderColor, !odd);
            Marshalling.draw(f.subdivision[1], f, d, x + sz / 2, y, sz / 2, borderColor, !odd);
            Marshalling.draw(f.subdivision[2], f, d, x, y + sz / 2, sz / 2, borderColor, !odd);
            Marshalling.draw(f.subdivision[3], f, d, x + sz / 2, y + sz / 2, sz / 2, borderColor, !odd);
            if (borderColor != null) {
                d.rect(borderColor, x + sz / 2 - (odd ? 1 : 0), y, 1.0, sz);
                d.rect(borderColor, x, y + sz / 2 - (odd ? 1 : 0), sz, 1.0);
            }
        }
    }

    private strictfp static class Field {
        public Field[] subdivision = null;
        public CoatOfArms filled = null;

        private Field() {
        }

        public boolean allFilled() {
            if (this.filled != null) {
                return true;
            }
            if (this.subdivision == null) {
                return false;
            }
            int minDepth = 100000;
            int maxDepth = 0;
            for (Field sub : this.subdivision) {
                minDepth = StrictMath.min(minDepth, sub.depth());
                maxDepth = StrictMath.max(maxDepth, sub.depth());
            }
            if (minDepth != maxDepth) {
                return false;
            }
            for (Field sub : this.subdivision) {
                if (sub.allFilled()) continue;
                return false;
            }
            return true;
        }

        public int depth() {
            if (this.subdivision == null) {
                return 1;
            }
            int d = 1;
            for (Field sub : this.subdivision) {
                d = StrictMath.max(d, 1 + sub.depth());
            }
            return d;
        }

        public void addArms(CoatOfArms arms) {
            if (this.filled == null && this.subdivision == null) {
                this.filled = arms;
                return;
            }
            if (this.filled != null && this.subdivision == null) {
                this.subdivision = new Field[]{new Field(), new Field(), new Field(), new Field()};
                this.subdivision[0].filled = this.filled;
                this.subdivision[1].filled = arms;
                this.filled = null;
                return;
            }
            for (int i = 3; i >= 0; --i) {
                Field sub = this.subdivision[i];
                if (sub.allFilled()) continue;
                sub.addArms(arms);
                return;
            }
            Field leastDeepSub = null;
            int leastDepth = 0;
            for (Field sub : this.subdivision) {
                int d = sub.depth();
                if (leastDeepSub != null && d > leastDepth) continue;
                leastDeepSub = sub;
                leastDepth = d;
            }
            leastDeepSub.addArms(arms);
        }
    }
}

