/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp abstract class MapLocation {
    public int id;
    public int constructionEntryIDCounter = 1;
    public int x;
    public int y;
    public final ArrayList<ConstructionEntry> constructing = new ArrayList();
    public int constructionProgress;
    public Airship constructionTarget;
    public int constructionTargetCost;
    protected ArrayList<Airship> defences = new ArrayList();
    public transient LinkedList<Message> messages = new LinkedList();
    public LandFormation ground;
    public ArrayList<LandFormation> floaters = new ArrayList();
    public transient boolean probablyCoastal = true;
    public transient WorldMap.NavNode navNode = null;
    public transient int roadDistanceToEnemy;
    protected static final int MAP_MSG_H = 120;
    protected static final int MAP_MSG_TICK_LIFE = 800;

    public MapLocation(int id, int x, int y) {
        this.id = id;
        this.x = x;
        this.y = y;
    }

    public MapLocation(JSONObject o, HashMap<Integer, LandBlockType>[] mappingRef) {
        JSONArray a;
        int i;
        JSONArray l;
        this.id = o.getInt("id");
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.constructionProgress = o.getInt("constructionProgress");
        this.constructionEntryIDCounter = o.optInt("constructionEntryIDCounter", 1);
        if (o.has("_constructingList")) {
            l = o.getJSONArray("_constructingList");
            for (i = 0; i < l.length(); ++i) {
                this.constructing.add(new ConstructionEntry(new JSONObject(Compression.decompressFromString(l.getString(i)))));
            }
        } else if (o.has("constructingList")) {
            l = o.getJSONArray("constructingList");
            for (i = 0; i < l.length(); ++i) {
                this.constructing.add(new ConstructionEntry(l.getJSONObject(i)));
            }
        } else if (o.has("constructing")) {
            this.constructing.add(new ConstructionEntry(new Airship(o.getJSONObject("constructing")), o.getInt("constructionCost"), this.constructionEntryIDCounter++));
        }
        if (o.has("_constructionTarget")) {
            this.constructionTarget = new Airship(new JSONObject(Compression.decompressFromString(o.getString("_constructionTarget"))));
            this.constructionTargetCost = o.optInt("constructionTargetCost", this.constructionTarget.getCost());
        } else if (o.has("constructionTarget")) {
            this.constructionTarget = new Airship(o.getJSONObject("constructionTarget"));
            this.constructionTargetCost = o.optInt("constructionTargetCost", this.constructionTarget.getCost());
        }
        if (o.has("_defences")) {
            a = o.getJSONArray("_defences");
            for (i = 0; i < a.length(); ++i) {
                this.defences.add(new Airship(new JSONObject(Compression.decompressFromString(a.getString(i)))));
            }
        } else {
            a = o.getJSONArray("defences");
            for (i = 0; i < a.length(); ++i) {
                this.defences.add(new Airship(a.getJSONObject(i)));
            }
        }
        if (o.has("_ground")) {
            a = o.getJSONArray("_floaters");
            for (i = 0; i < a.length(); ++i) {
                this.floaters.add(new LandFormation(new JSONObject(Compression.decompressFromString(a.getString(i))), mappingRef));
            }
            this.ground = new LandFormation(new JSONObject(Compression.decompressFromString(o.getString("_ground"))), mappingRef);
        } else if (o.has("ground")) {
            a = o.getJSONArray("floaters");
            for (i = 0; i < a.length(); ++i) {
                this.floaters.add(new LandFormation(a.getJSONObject(i), mappingRef));
            }
            this.ground = new LandFormation(o.getJSONObject("ground"), mappingRef);
        } else {
            this.generateLand(new Random(this.id * 120821 + 1928), Loadable.all(CombatBackgroundFlavor.class).get(0));
        }
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("id", this.id).put("x", this.x).put("y", this.y).put("constructionProgress", this.constructionProgress).put("constructionEntryIDCounter", this.constructionEntryIDCounter).put("_ground", Compression.compressToString(this.ground.toJSON().toString()));
        JSONArray constructingList = new JSONArray();
        for (ConstructionEntry c : this.constructing) {
            constructingList.put(Compression.compressToString(c.toJSON().toString()));
        }
        o.put("_constructingList", constructingList);
        if (this.constructionTarget != null) {
            o.put("_constructionTarget", Compression.compressToString(this.constructionTarget.toJSON(null).toString()));
            o.put("constructionTargetCost", this.constructionTargetCost);
        }
        JSONArray a = new JSONArray();
        o.put("_defences", a);
        for (Airship ship : this.defences) {
            a.put(Compression.compressToString(ship.toJSON(null).toString()));
        }
        a = new JSONArray();
        o.put("_floaters", a);
        for (LandFormation f : this.floaters) {
            a.put(Compression.compressToString(f.toJSON().toString()));
        }
        return o;
    }

    public abstract String getDisplayName();

    public void addDefence(Airship building) {
        if (building.type.mobile) {
            throw new RuntimeException("The defence construction " + building.getName() + " is mobile!");
        }
        this.defences.add(building);
    }

    public void removeDefence(Airship s) {
        this.defences.remove(s);
    }

    public ArrayList<Airship> getDefences() {
        return new ArrayList<Airship>(this.defences);
    }

    public void clearDefences() {
        this.defences.clear();
    }

    public boolean hasDefence(Airship ship) {
        return this.defences.contains(ship);
    }

    public void replaceDefence(Airship original, Airship newShip) {
        this.defences.set(this.defences.indexOf(original), newShip);
    }

    public final void generateLand(Random r, LandscapeType lt) {
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(r, false, lt);
        this.ground = (LandFormation)p.a;
        this.floaters.clear();
        this.floaters.addAll((Collection)p.b);
    }

    public final void generateLand(Random r, CombatBackgroundFlavor cbf) {
        this.generateLand(r, cbf.getLandscapeType(r));
    }

    public void addMessage(MessageType type, String text) {
        this.messages.add(0, new Message(type, text, 0, new HashMap<Empire, String>()));
        this.pushMessages();
    }

    public void addMessage(MessageType type, String text, HashMap<Empire, String> altTexts) {
        this.messages.add(0, new Message(type, text, 0, altTexts));
        this.pushMessages();
    }

    protected void pushMessages() {
        if (this.messages == null) {
            return;
        }
        for (int i = 1; i < this.messages.size(); ++i) {
            if (this.messages.get((int)i).offset >= this.messages.get((int)(i - 1)).offset + 120) continue;
            this.messages.get((int)i).offset = this.messages.get((int)(i - 1)).offset + 120;
        }
    }

    protected void tickMessages() {
        int msz = this.messages.size();
        for (int mi = 0; mi < msz; ++mi) {
            Message mm = this.messages.get(mi);
            ++mm.offset;
            if (mm.offset < 800) continue;
            this.messages.remove(mi);
            --mi;
            --msz;
        }
    }

    public ShipList shipList(WorldMap wm) {
        return new ShipArrayList(this.defences);
    }

    public void layoutGarrison(WorldMap wm) {
        Fleet fl = wm.getGarrison(this);
        if (fl == null) {
            return;
        }
        this.layoutGarrison(fl);
    }

    public void layoutGarrison(Fleet fl) {
        ArrayList<Airship> ships = new ArrayList<Airship>(fl.actives);
        fl.actives.clear();
        for (Airship ship : ships) {
            if (this.canPlace(ship, ship.getIntX(), ship.getIntY(), 32, fl, null) || this.placeShip(ship, fl)) {
                fl.actives.add(ship);
                continue;
            }
            fl.reserve.add(ship);
        }
        ships = new ArrayList<Airship>(fl.reserve);
        fl.reserve.clear();
        for (Airship ship : ships) {
            if (this.canPlace(ship, ship.getIntX(), ship.getIntY(), 32, fl, null) || this.placeShip(ship, fl)) {
                fl.actives.add(ship);
                continue;
            }
            fl.reserve.add(ship);
        }
    }

    public boolean placeShip(Airship ship, Fleet garrison) {
        if (ship.type.onGround) {
            if (ship.type.mobile) {
                for (int sx = 100; sx < 3200; sx += 32) {
                    PlaceShipTool.Placement pl = PlaceShipTool.getPlacement(ship, sx, 512.0 - ship.getBBHeight() - ship.groundOffset(), ship.flipped, this.ground, new ShipArrayList(this.defences), false, 1);
                    if (!pl.succeeded || !this.canPlace(ship, sx, (int)pl.y, 32, garrison, pl.landscapeTarget)) continue;
                    ship.setX(sx);
                    ship.setY((int)pl.y);
                    return true;
                }
            } else {
                PlaceShipTool.Placement pl;
                int sx;
                for (sx = 1600; sx < 3200; sx += 32) {
                    pl = PlaceShipTool.getPlacement(ship, sx, 512.0 - ship.getBBHeight() - ship.groundOffset(), ship.flipped, this.ground, new ShipArrayList(this.defences), false, 1);
                    if (!pl.succeeded || !this.canPlace(ship, sx, (int)pl.y, 32, garrison, pl.landscapeTarget)) continue;
                    if (pl.landscapeTarget != null) {
                        pl.landscapeTarget.doLandscapingForBuilding(ship, pl.x, pl.landscapeGY, ship.flipped);
                    }
                    ship.setX(sx);
                    ship.setY((int)pl.y);
                    return true;
                }
                for (sx = 1600; sx >= 100; sx -= 32) {
                    pl = PlaceShipTool.getPlacement(ship, sx, 512.0 - ship.getBBHeight() - ship.groundOffset(), ship.flipped, this.ground, new ShipArrayList(this.defences), false, 1);
                    if (!pl.succeeded || !this.canPlace(ship, sx, (int)pl.y, 32, garrison, pl.landscapeTarget)) continue;
                    if (pl.landscapeTarget != null) {
                        pl.landscapeTarget.doLandscapingForBuilding(ship, pl.x, pl.landscapeGY, ship.flipped);
                    }
                    ship.setX(sx);
                    ship.setY((int)pl.y);
                    return true;
                }
            }
        } else {
            for (int sy = 512 - ship.serviceCeiling(); sy < 512; ++sy) {
                for (int sx = 100; sx < 3200; sx += 32) {
                    if (!this.canPlace(ship, sx, sy, 32, garrison, null)) continue;
                    ship.setX(sx);
                    ship.setY(sy);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canPlace(Airship ship, int x, int y, int spacing, Fleet garrison, LandFormation landscaped) {
        int h2;
        int y2;
        int w2;
        if (x < 100) {
            return false;
        }
        if (y < -1088) {
            return false;
        }
        int w = ship.getWidth() * 16;
        if (x + w > 2800) {
            return false;
        }
        int h = ship.getHeight() * 16;
        if (y + h > 512) {
            return false;
        }
        for (ConstructionEntry ce : this.constructing) {
            Airship c = ce.ship;
            int x2 = c.getIntX();
            int w22 = c.getWidth() * 16;
            int y22 = c.getIntY();
            int h22 = c.getHeight() * 16;
            if (x2 + w22 + spacing <= x || x + w + spacing <= x2 || y22 + h22 + spacing <= y || y + h + spacing <= y22) continue;
            return false;
        }
        for (Airship s2 : this.defences) {
            int x2 = s2.getIntX();
            w2 = s2.getWidth() * 16;
            y2 = s2.getIntY();
            h2 = s2.getHeight() * 16;
            if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
            return false;
        }
        if (garrison != null) {
            for (Airship s2 : garrison.actives) {
                int x2 = s2.getIntX();
                w2 = s2.getWidth() * 16;
                y2 = s2.getIntY();
                h2 = s2.getHeight() * 16;
                if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
                return false;
            }
        }
        double ox = ship.getX();
        double oy = ship.getY();
        ship.setX(x);
        ship.setY(y);
        if (this.ground != landscaped && ship.overlapsWith(this.ground, false)) {
            ship.setX(ox);
            ship.setY(oy);
            return false;
        }
        for (LandFormation lf : this.floaters) {
            if (!ship.overlapsWith(lf, false)) continue;
            ship.setX(ox);
            ship.setY(oy);
            return false;
        }
        return true;
    }

    public strictfp static class Message {
        MessageType type;
        String text;
        int offset;
        HashMap<Empire, String> altTexts;

        public Message(MessageType type, String text, int offset, HashMap<Empire, String> altTexts) {
            this.type = type;
            this.text = text;
            this.offset = offset;
            this.altTexts = altTexts;
        }

        public String getText(Empire e) {
            return this.altTexts.containsKey(e) ? this.altTexts.get(e) : this.text;
        }
    }

    public strictfp static enum MessageType {
        LOST_SHIP,
        COMBAT,
        REVOLT,
        ECON_RECOVERY,
        MONSTER_OCCUPATION;

    }

    public strictfp static class ConstructionEntry {
        public final Airship ship;
        public final Airship original;
        public final int cost;
        public final Type type;
        public final int id;

        public ConstructionEntry(Airship ship, int cost, int id) {
            this.ship = ship;
            this.original = null;
            this.cost = cost;
            this.type = Type.CONSTRUCTION;
            this.id = id;
        }

        public ConstructionEntry(Airship ship, Airship original, int cost, Type type, int id) {
            this.ship = ship;
            this.original = original;
            this.cost = cost;
            this.type = type;
            this.id = id;
        }

        public ConstructionEntry(JSONObject o) {
            this.ship = new Airship(o.getJSONObject("ship"));
            this.original = o.has("original") ? new Airship(o.getJSONObject("original")) : null;
            this.cost = o.getInt("cost");
            this.type = Type.valueOf(o.getString("type"));
            this.id = o.optInt("id");
        }

        public JSONObject toJSON() {
            JSONObject o = new JSONObject().put("ship", this.ship.toJSON(null)).put("cost", this.cost).put("type", this.type.name()).put("id", this.id);
            if (this.original != null) {
                o.put("original", this.original.toJSON(null));
            }
            return o;
        }

        public String desc() {
            switch (this.type) {
                case REFIT: {
                    return this.ship.getName() + " " + Lang._t("Refit", new Object[0]);
                }
                case REPAIR: {
                    return this.ship.getName() + " " + Lang._t("Repair", new Object[0]);
                }
            }
            return this.ship.getName();
        }

        public strictfp static enum Type {
            CONSTRUCTION,
            REFIT,
            REPAIR;

        }
    }
}

