/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Errstream;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.LaunchSettings;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.WebIntegrationBackend;
import com.zarkonnen.catengine.Condition;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.SlickEngine;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.opengl.ImageIOImageData;

public strictfp class Main {
    public static void main(String[] args) {
        if (System.getProperty("os.name", "NONE").toLowerCase(Locale.ENGLISH).contains("win")) {
            System.setProperty("org.lwjgl.librarypath", AGame.getStaticGameDirectory().getAbsolutePath() + "\\lib\\native\\");
        }
        if (!SimplePref.WINDOW_BORDER.get() || LaunchSettings.useCustomWindow && LaunchSettings.customWindowBorderless) {
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
        }
        try {
            Errstream.install();
            System.err.println("");
            System.err.println("Booting v 1.0.13.1 @ " + new Date());
            System.err.println("OS: " + System.getProperty("os.name", "NONE"));
            System.err.println("static: " + AGame.getStaticGameDirectory().getAbsolutePath() + " exists " + AGame.getStaticGameDirectory().exists());
            System.err.println("gamedir: " + AGame.getGameDirectory().getAbsolutePath() + " exists " + AGame.getGameDirectory().exists());
            SlickEngine e = new SlickEngine("Airships", "/com/zarkonnen/airships/images/", "/com/zarkonnen/airships/sounds/", Integer.valueOf(60));
            final AirshipGame g = new AirshipGame();
            e.setExceptionHandler(new ExceptionHandler(){

                public void handle(Exception e, boolean fatal) {
                    g.reportError("OpenGL Crash", e, null, false, true);
                    JOptionPane.showMessageDialog(null, "Unable to create OpenGL window.\nPlease check that your drivers are up to date and that your graphics card supports OpenGL.");
                    System.exit(1);
                }
            });
            try {
                e.setup((Game)g);
            }
            catch (ExceptionInInitializerError eiie) {
                if (eiie.getCause() instanceof ArrayIndexOutOfBoundsException || eiie.getCause() instanceof LWJGLException && eiie.getCause().getMessage().contains("modes") || eiie.getCause().getCause() instanceof LWJGLException && eiie.getCause().getCause().getMessage().contains("modes")) {
                    JOptionPane.showMessageDialog(null, "Unable to find screen resolution information.\nIf you are on Linux, you may need to edit xorg.conf to not include refresh rates in the mode lines.\nIf you are not, or those words made no sense to you, contact the developer.");
                    System.exit(1);
                }
                throw eiie;
            }
            e.setExceptionHandler((ExceptionHandler)g);
            e.reportHandler = g;
            File imagesDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "images");
            Display.setIcon((ByteBuffer[])new ByteBuffer[]{new ImageIOImageData().imageToByteBuffer(ImageIO.read(new File(imagesDir, "16x16.png")), false, false, null), new ImageIOImageData().imageToByteBuffer(ImageIO.read(new File(imagesDir, "32x32.png")), false, false, null)});
            e.setRunInBackground(true);
            try {
                e.runUntil(Condition.ALWAYS);
            }
            catch (IllegalStateException ise) {
                int id = AGame.ANIM_R.nextInt();
                ise.printStackTrace();
                StringWriter sw = new StringWriter();
                ise.printStackTrace(new PrintWriter(sw));
                Main.reportError("IllegalStateException " + id + " Display.isCreated " + Display.isCreated() + " " + sw.toString() + "\n" + Main.pathReport());
                if (!Display.isCreated()) {
                    try {
                        Main.reportError("Destroying display " + id);
                        Display.destroy();
                        Main.reportError("Display destroyed " + id);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        Main.reportError("Creating display " + id);
                        Display.create();
                        Main.reportError("Display created " + id);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.runUntil(Condition.ALWAYS);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            Main.reportError(sw.toString() + "\n" + Main.pathReport());
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "Fatal error. Please report this to the developer.\n" + t.toString() + "\n" + sw.toString());
        }
    }

    public static String pathReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("os.name = ").append(System.getProperty("os.name", "NONE")).append("\n");
        sb.append("java.version = ").append(System.getProperty("java.version", "NONE")).append("\n");
        sb.append("java.library.path = ").append(System.getProperty("java.library.path", "NONE")).append("\n");
        sb.append(". = ").append(new File("").getAbsolutePath()).append("\n");
        sb.append("new home path = ").append(AGame.getStaticGameDirectory().getAbsolutePath()).append("\n");
        if (System.getProperty("java.library.path") != null) {
            File f = new File("").getAbsoluteFile();
            for (String s : System.getProperty("java.library.path").split("[/]")) {
                f = new File(f, s);
            }
            sb.append(f.getAbsolutePath()).append(" exists = ").append(f.exists()).append("\n");
            if (f.exists()) {
                for (File f2 : f.listFiles()) {
                    sb.append(" - ").append(f2.getName()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public static void reportError(String text) {
        Integration integration = new Integration(new WebIntegrationBackend("https://airships.zarkonnen.com/api/", "https://airships.zarkonnen.com/static/media/", "https://airships.zarkonnen.com", "https://airships.zarkonnen.com/multiplayer_calendar"));
        integration.sendFeedback("MAJOR ERROR: " + text);
    }
}

