/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.IntRect;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class LobbyChat
implements UniScreen.InfoPanel {
    public static final Clr ALT = new Clr(44, 44, 44);
    public TextField chatFieldLocal = new TextField();
    public TextField chatFieldGlobal = new TextField();
    private final ChatAdapter chatAdapter = new ChatAdapter();
    private final ScrollBar chatScrollBarLocal = new ScrollBar();
    private final ScrollBar chatScrollBarGlobal = new ScrollBar();
    private final IntRect localR = new IntRect();
    private final IntRect globalR = new IntRect();

    private boolean showGlobalChat(MultiplayerSetupIntent msi) {
        return msi.fromMetaLobby || AirshipGame.metaLobbyOverlay != null;
    }

    public LobbyChat() {
        this.chatScrollBarLocal.offset = 100000;
        this.chatScrollBarGlobal.offset = 100000;
        this.chatScrollBarLocal.stickToBottom = true;
        this.chatScrollBarGlobal.stickToBottom = true;
        this.chatFieldGlobal.canMoveInsertionPoint = false;
        this.chatFieldLocal.canMoveInsertionPoint = false;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return;
        }
        final MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        int w = StrictMath.max(400, sm.width / 3);
        int x = msi.flipped ? MyDraw.SIDE_CLEARANCE : sm.width - w - MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int h = !this.showGlobalChat(msi) ? sm.height - y - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_SPACING - MyDraw.BUTTON_H : (sm.height - y - MyDraw.SIDE_CLEARANCE - MyDraw.UI_SPACING) / 2 - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING;
        this.chatScrollBarLocal.draw(d, x, y, w, h -= AGame.FOUNT.lineHeight + MyDraw.UI_SPACING, msi.chat, this.chatAdapter);
        d.hook(x, y, w, h, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                LobbyChat.this.chatFieldLocal.focus = true;
                LobbyChat.this.chatFieldGlobal.focus = false;
            }
        });
        this.localR.x = x;
        this.localR.y = y;
        this.localR.w = w;
        this.localR.h = h;
        int sendW = d.bw(Lang._t("Send", new Object[0]));
        this.chatFieldLocal.render(x, y += h + MyDraw.BUTTON_SPACING, w - sendW - MyDraw.BUTTON_SPACING, d, sm, null, cursor);
        d.hook(x, y, w - sendW, MyDraw.textFieldH(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                LobbyChat.this.chatFieldLocal.focus = true;
                LobbyChat.this.chatFieldGlobal.focus = false;
            }
        });
        d.button(x + w - sendW, y, sendW, Lang._t("Send", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                LobbyChat.this.sendChatLocal(msi);
            }
        }, msi.g.isConnected() && !this.chatFieldLocal.getText().isEmpty());
        if (this.showGlobalChat(msi)) {
            this.chatScrollBarGlobal.draw(d, x, y += MyDraw.BUTTON_H + MyDraw.UI_SPACING, w, h, msi.g.chat, this.chatAdapter);
            d.hook(x, y, w, h, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    LobbyChat.this.chatFieldLocal.focus = false;
                    LobbyChat.this.chatFieldGlobal.focus = true;
                }
            });
            this.globalR.x = x;
            this.globalR.y = y;
            this.globalR.w = w;
            this.globalR.h = h;
            this.chatFieldGlobal.render(x, y += h + MyDraw.BUTTON_SPACING, w - sendW - MyDraw.BUTTON_SPACING, d, sm, null, cursor);
            d.hook(x, y, w - sendW, MyDraw.textFieldH(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    LobbyChat.this.chatFieldLocal.focus = false;
                    LobbyChat.this.chatFieldGlobal.focus = true;
                }
            });
            d.button(x + w - sendW, y, sendW, Lang._t("Send", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    LobbyChat.this.sendChatGlobal(msi);
                }
            }, msi.g.client != null && msi.g.client.isConnectedRaw() && !this.chatFieldGlobal.getText().isEmpty());
        }
    }

    private void sendChatLocal(MultiplayerSetupIntent msi) {
        if (msi.g.isConnected()) {
            msi.g.sendMessage(Client.msg("chat").put("id", msi.g.playerID()).put("text", this.chatFieldLocal.getText()));
            this.chatFieldLocal.setText("");
        }
    }

    private void sendChatGlobal(MultiplayerSetupIntent msi) {
        if (msi.g.client != null && msi.g.client.isConnectedRaw()) {
            msi.g.client.sendMessageRaw(Client.gmsg("globalChat").put("id", msi.g.myID).put("text", this.chatFieldGlobal.getText()));
            this.chatFieldGlobal.setText("");
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return;
        }
        this.chatScrollBarLocal.stickToBottom = true;
        this.chatScrollBarGlobal.stickToBottom = true;
        MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        if (this.chatFieldLocal.focus && this.chatFieldGlobal.focus) {
            this.chatFieldGlobal.focus = false;
        }
        if (!(this.chatFieldLocal.focus || this.chatFieldGlobal.focus && this.showGlobalChat(msi))) {
            this.chatFieldGlobal.focus = false;
            this.chatFieldLocal.focus = false;
        }
        this.chatFieldLocal.input(in, null, null, null, ms);
        this.chatScrollBarLocal.tick(in, this.localR.x, this.localR.y, this.localR.w, this.localR.h);
        if (this.showGlobalChat(msi)) {
            this.chatFieldGlobal.input(in, null, null, null, ms);
            this.chatScrollBarGlobal.tick(in, this.globalR.x, this.globalR.y, this.globalR.w, this.globalR.h);
        }
        if (in.keyPressed("ENTER")) {
            if (!this.chatFieldLocal.getText().isEmpty() && this.chatFieldLocal.focus) {
                this.sendChatLocal(msi);
            } else if (!this.chatFieldGlobal.getText().isEmpty() && this.chatFieldGlobal.focus && this.showGlobalChat(msi)) {
                this.sendChatGlobal(msi);
            }
        }
        if (in.keyPressed("TAB") && msi.fromMetaLobby) {
            if (this.chatFieldLocal.focus) {
                this.chatFieldLocal.focus = false;
                this.chatFieldGlobal.focus = true;
            } else {
                this.chatFieldLocal.focus = true;
                this.chatFieldGlobal.focus = false;
            }
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return us.intent instanceof MultiplayerSetupIntent;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return false;
        }
        MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        int w = StrictMath.max(400, sm.width / 3);
        int x = msi.flipped ? MyDraw.SIDE_CLEARANCE : sm.width - w - MyDraw.SIDE_CLEARANCE;
        return cursor.x >= (double)x && cursor.x <= (double)(x + w);
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

