/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.TimeOfDay;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public strictfp class LightmapBakery {
    public static BufferedImage bakeBlueprint(String name) throws IOException {
        BufferedImage spritesheet = SpriteUtils.loadBufferedImage(name);
        BufferedImage out = new BufferedImage(spritesheet.getWidth(), spritesheet.getHeight(), 2);
        for (int y = 0; y < spritesheet.getHeight(); ++y) {
            for (int x = 0; x < spritesheet.getWidth(); ++x) {
                Color originalC = new Color(spritesheet.getRGB(x, y));
                Color newC = LightmapBakery.blueprintify(originalC, spritesheet.getAlphaRaster().getSample(x, y, 0));
                out.setRGB(x, y, newC.getRGB());
            }
        }
        return out;
    }

    public static Color blueprintify(Color c, int alpha) {
        int amt = (int)StrictMath.min(255.0, (double)(c.getRed() / 2 + c.getGreen() / 2 + c.getBlue() / 2 + alpha / 4) * 0.3);
        return new Color(255, 255, 255, amt);
    }

    public static BufferedImage bake(String name, String bumpName, TimeOfDay tod) throws IOException {
        BufferedImage spritesheet = SpriteUtils.loadBufferedImage(name);
        BufferedImage bump = SpriteUtils.loadBufferedImage(bumpName);
        if (spritesheet == null) {
            throw new IOException("Unable to load spritesheet image " + name + ".");
        }
        if (bump == null) {
            throw new IOException("Unable to load spritesheet bump image " + bumpName + ".");
        }
        return LightmapBakery.bake(spritesheet, bump, tod);
    }

    public static BufferedImage bake(BufferedImage spritesheet, BufferedImage bump, TimeOfDay tod) {
        BufferedImage out = new BufferedImage(spritesheet.getWidth(), spritesheet.getHeight(), 2);
        WritableRaster alpha = spritesheet.getAlphaRaster();
        if (alpha == null) {
            throw new RuntimeException("Unable to process sprite sheet. Check the file is saved as a RGB PNG, and not using indexed colour.");
        }
        for (int y = 0; y < spritesheet.getHeight(); ++y) {
            for (int x = 0; x < spritesheet.getWidth(); ++x) {
                Color originalC = new Color(spritesheet.getRGB(x, y));
                Color bumpC = new Color(bump.getRGB(x, y));
                Color newC = LightmapBakery.bake(originalC, bumpC, tod);
                newC = new Color(newC.getRed(), newC.getGreen(), newC.getBlue(), alpha.getSample(x, y, 0));
                out.setRGB(x, y, newC.getRGB());
            }
        }
        return out;
    }

    public static Color bake(Color original, Color bump, TimeOfDay tod) {
        double r = (double)original.getRed() / 255.0 * (double)tod.ambient.r;
        double g = (double)original.getGreen() / 255.0 * (double)tod.ambient.g;
        double b = (double)original.getBlue() / 255.0 * (double)tod.ambient.b;
        double bx = (double)bump.getRed() / 255.0;
        double by = (double)bump.getGreen() / 255.0;
        double bz = (double)bump.getBlue() / 255.0;
        double leftM = StrictMath.max(by - 0.3, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double rightM = StrictMath.max(0.7 - by, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double topM = StrictMath.max(bx - 0.3, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double sideM = StrictMath.max(leftM, rightM);
        double topR = (double)tod.light[1].r * 1.0;
        double topG = (double)tod.light[1].g * 1.0;
        double topB = (double)tod.light[1].b * 1.0;
        double sideR = (double)StrictMath.max(tod.light[0].r, tod.light[2].r) * 1.0;
        double sideG = (double)StrictMath.max(tod.light[0].g, tod.light[2].g) * 1.0;
        double sideB = (double)StrictMath.max(tod.light[0].b, tod.light[2].b) * 1.0;
        r = r + topM * topR + sideM * sideR;
        g = g + topM * topG + sideM * sideG;
        b = b + topM * topB + sideM * sideB;
        return new Color(LightmapBakery.clint(r), LightmapBakery.clint(g), LightmapBakery.clint(b));
    }

    public static int clint(double x) {
        return StrictMath.max(0, StrictMath.min(255, (int)(x * 255.0)));
    }
}

